/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class FilterInterface
implements GwtRpcResponse,
Serializable {
    private static final long serialVersionUID = 0L;
    private List<FilterParameterInterface> iParameters;

    public boolean hasParameters() {
        return this.iParameters != null && !this.iParameters.isEmpty();
    }

    public List<FilterParameterInterface> getParameters() {
        return this.iParameters;
    }

    public void addParameter(FilterParameterInterface parameter) {
        if (this.iParameters == null) {
            this.iParameters = new ArrayList<FilterParameterInterface>();
        }
        this.iParameters.add(parameter);
    }

    public FilterParameterInterface getParameter(String name) {
        if (this.iParameters == null) {
            return null;
        }
        for (FilterParameterInterface param : this.iParameters) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    public String getParameterValue(String name) {
        FilterParameterInterface param = this.getParameter(name);
        return param == null ? null : (param.getValue() == null ? param.getDefaultValue() : param.getValue());
    }

    public String getParameterValue(String name, String defaultValue) {
        String value = this.getParameterValue(name);
        return value == null ? defaultValue : value;
    }

    public static class FilterParameterInterface
    implements IsSerializable,
    Comparable<FilterParameterInterface> {
        private String iName;
        private String iLabel;
        private String iType;
        private String iValue;
        private String iDefault;
        private String iSuffix;
        private List<ListItem> iOptions = null;
        private boolean iMultiSelect = false;
        private boolean iCollapsible = true;
        private Long iSessionId;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean hasSuffix() {
            return this.iSuffix != null && !this.iSuffix.isEmpty();
        }

        public String getSuffix() {
            return this.iSuffix;
        }

        public void setSuffix(String suffix) {
            this.iSuffix = suffix;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public boolean isSelectedItem(ListItem item) {
            if (this.iValue == null) {
                return false;
            }
            if (this.isMultiSelect()) {
                for (String val : this.iValue.split(",")) {
                    if (!val.equalsIgnoreCase(item.getValue())) continue;
                    return true;
                }
                return false;
            }
            return this.iValue.equalsIgnoreCase(item.getValue());
        }

        public boolean hasValue() {
            return this.iValue != null;
        }

        public String getDefaultValue() {
            return this.iDefault;
        }

        public void setDefaultValue(String defaultValue) {
            this.iDefault = defaultValue;
            if (this.hasOptions() && defaultValue != null && !this.isMultiSelect()) {
                for (ListItem option : this.getOptions()) {
                    if (!defaultValue.equals(option.getValue())) continue;
                    return;
                }
                this.iDefault = this.getOptions().get(0).getValue();
            }
        }

        public boolean hasDefaultValue() {
            return this.iDefault != null;
        }

        public boolean isDefaultItem(ListItem item) {
            if (this.iDefault == null) {
                return false;
            }
            if (this.isMultiSelect()) {
                for (String val : this.iDefault.split(",")) {
                    if (!val.equalsIgnoreCase(item.getValue())) continue;
                    return true;
                }
                return false;
            }
            return this.iDefault.equalsIgnoreCase(item.getValue());
        }

        public boolean hasOptions() {
            return this.iOptions != null && !this.iOptions.isEmpty();
        }

        public void addOption(String value, String text) {
            if (this.iOptions == null) {
                this.iOptions = new ArrayList<ListItem>();
            }
            this.iOptions.add(new ListItem(value, text));
        }

        public List<ListItem> getOptions() {
            return this.iOptions;
        }

        public String getOptionText(String value) {
            if (this.iOptions == null) {
                return null;
            }
            for (ListItem option : this.getOptions()) {
                if (!value.equals(option.getValue())) continue;
                return option.getText();
            }
            return null;
        }

        public boolean isMultiSelect() {
            return this.iMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.iMultiSelect = multiSelect;
        }

        public boolean isCollapsible() {
            return this.iCollapsible;
        }

        public void setCollapsible(boolean collapsible) {
            this.iCollapsible = collapsible;
        }

        public String toString() {
            return this.getName() + "=" + (this.getValue() == null ? this.getDefaultValue() : this.getValue());
        }

        @Override
        public int compareTo(FilterParameterInterface o) {
            int cmp = this.getLabel().compareTo(o.getLabel());
            if (cmp != 0) {
                return cmp;
            }
            return this.getName().compareTo(o.getName());
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }
    }

    public static class ListItem
    implements IsSerializable,
    Comparable<ListItem> {
        private String iValue;
        private String iText;

        public ListItem() {
        }

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getText() {
            return this.iText;
        }

        @Override
        public int compareTo(ListItem item) {
            int cmp = this.getText().compareTo(item.getText());
            if (cmp != 0) {
                return cmp;
            }
            return this.getValue().compareTo(item.getValue());
        }

        public String toString() {
            return this.getValue() + ": " + this.getText();
        }
    }
}

