/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class AssignClassInstructorsInterface
implements IsSerializable,
GwtRpcResponse {
    private List<Record> iRecords = new ArrayList<Record>();
    private Field[] iFields = null;
    private boolean iEditable = true;
    private PageName iPageName = null;
    private Long iConfigId = null;
    private Long iOfferingId = null;
    private boolean iSaveSuccessful = true;
    private String iErrors = null;
    private Long iNextConfigId = null;
    private Long iPreviousConfigId = null;
    private String iCourseName = null;
    private String iCourseCoordinators = null;
    private boolean iShowTimeAndRoom = false;

    public AssignClassInstructorsInterface() {
    }

    public AssignClassInstructorsInterface(Field ... fields) {
        this.iFields = fields;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public void setConfigId(Long configId) {
        this.iConfigId = configId;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public void setOfferingId(Long offeringId) {
        this.iOfferingId = offeringId;
    }

    public boolean isSaveSuccessful() {
        return this.iSaveSuccessful;
    }

    public void setSaveSuccessful(boolean iSaveSuccessful) {
        this.iSaveSuccessful = iSaveSuccessful;
    }

    public String getErrors() {
        return this.iErrors;
    }

    public void setErrors(String errors) {
        this.iErrors = errors;
    }

    public Long getNextConfigId() {
        return this.iNextConfigId;
    }

    public void setNextConfigId(Long nextConfigId) {
        this.iNextConfigId = nextConfigId;
    }

    public Long getPreviousConfigId() {
        return this.iPreviousConfigId;
    }

    public void setPreviousConfigId(Long previousConfigId) {
        this.iPreviousConfigId = previousConfigId;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public void setCourseName(String courseName) {
        this.iCourseName = courseName;
    }

    public String getCourseCoordinators() {
        return this.iCourseCoordinators;
    }

    public void setCourseCoordinators(String courseCoordinators) {
        this.iCourseCoordinators = courseCoordinators;
    }

    public boolean isShowTimeAndRoom() {
        return this.iShowTimeAndRoom;
    }

    public void setShowTimeAndRoom(boolean showTimeAndRoom) {
        this.iShowTimeAndRoom = showTimeAndRoom;
    }

    public void setPageName(PageName name) {
        this.iPageName = name;
    }

    public boolean hasPageName() {
        return this.iPageName != null;
    }

    public PageName getPageName() {
        return this.iPageName;
    }

    public List<Record> getRecords() {
        return this.iRecords;
    }

    public Record addRecord(Long uniqueId, boolean deletable) {
        Record r = new Record(uniqueId, this.iFields.length, deletable);
        for (int i = 0; i < this.iFields.length; ++i) {
            if (this.iFields[i].isEditable()) continue;
            r.setField(i, (String)null, false);
        }
        this.iRecords.add(r);
        return r;
    }

    public Record addRecord(Long uniqueId) {
        return this.addRecord(uniqueId, true);
    }

    public Record insertEmptyRecord(int pos) {
        Record r = new Record(null, this.iFields.length);
        this.iRecords.add(pos, r);
        return r;
    }

    public void moveRecord(int row, int before) {
        Record r = this.iRecords.get(row);
        this.iRecords.remove(row);
        this.iRecords.add(before + (row < before ? -1 : 0), r);
    }

    public Record getRecord(Long uniqueId) {
        for (Record r : this.iRecords) {
            if (r.getUniqueId() == null || !r.getUniqueId().equals(uniqueId)) continue;
            return r;
        }
        return null;
    }

    public List<Record> getNewRecords() {
        ArrayList<Record> ret = new ArrayList<Record>();
        for (Record r : this.iRecords) {
            if (r.getUniqueId() != null || r.isEmpty()) continue;
            ret.add(r);
        }
        return ret;
    }

    public Field[] getFields() {
        return this.iFields;
    }

    public int indexOf(String name) {
        for (int i = 0; i < this.iFields.length; ++i) {
            if (!this.iFields[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isAllInstructorsDeletable() {
        for (Record r : this.getRecords()) {
            if (r.isEditable()) continue;
            return false;
        }
        return true;
    }

    public RecordComparator getComparator() {
        return new RecordComparator();
    }

    public static class Field
    implements IsSerializable {
        private String iName = null;
        private FieldType iType = null;
        private int iLength = 0;
        private int iWidth = 0;
        private int iHeight = 1;
        private int iFlags = 0;
        private List<ListItem> iValues = null;

        public Field() {
        }

        public Field(String name, FieldType type, int width, int height, int length, Flag ... flags) {
            this.iName = name;
            this.iType = type;
            this.iWidth = width;
            this.iHeight = height;
            this.iLength = length;
            this.iFlags = 0;
            for (Flag flag : flags) {
                if (flag == null) continue;
                this.iFlags |= flag.toInt();
            }
        }

        public Field(String name, FieldType type, int width, Flag ... flags) {
            this(name, type, width, 1, 0, flags);
        }

        public Field(String name, FieldType type, int width, int length, Flag ... flags) {
            this(name, type, width, 1, length, flags);
        }

        public Field(String name, FieldType type, int width, List<ListItem> values, Flag ... flags) {
            this(name, type, width, 0, flags);
            this.iValues = values;
        }

        public String getName() {
            return this.iName;
        }

        public FieldType getType() {
            return this.iType;
        }

        public int getLength() {
            return this.iLength;
        }

        public int getWidth() {
            return this.iWidth;
        }

        public int getHeight() {
            return this.iHeight;
        }

        public List<ListItem> getValues() {
            return this.iValues;
        }

        public void addValue(ListItem item) {
            if (this.iValues == null) {
                this.iValues = new ArrayList<ListItem>();
            }
            this.iValues.add(item);
        }

        public boolean isEditable() {
            return !Flag.READ_ONLY.has(this.iFlags);
        }

        public boolean isVisible() {
            return !Flag.HIDDEN.has(this.iFlags);
        }

        public boolean isUnique() {
            return Flag.UNIQUE.has(this.iFlags);
        }

        public boolean isUniqueIfSet() {
            return Flag.UNIQUE_IF_SET.has(this.iFlags);
        }

        public boolean isNotEmpty() {
            return Flag.NOT_EMPTY.has(this.iFlags);
        }

        public boolean isAllowFloatingPoint() {
            return Flag.FLOAT.has(this.iFlags);
        }

        public boolean isAllowNegative() {
            return Flag.NEGATIVE.has(this.iFlags);
        }

        public boolean isCheckedByDefault() {
            return Flag.DEFAULT_CHECKED.has(this.iFlags);
        }

        public boolean isHideLabel() {
            return Flag.HIDE_LABEL.has(this.iFlags);
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Field)) {
                return false;
            }
            return this.getName().equals(((Field)o).getName());
        }
    }

    public static class PageName
    implements IsSerializable,
    GwtRpcResponse {
        private String iSingular = null;
        private String iPlural = null;

        public PageName() {
        }

        public PageName(String name) {
            this.iSingular = name;
        }

        public PageName(String singularName, String pluralName) {
            this.iSingular = singularName;
            this.iPlural = pluralName;
        }

        public String singular() {
            return this.iSingular;
        }

        public String plural() {
            return this.iPlural == null ? this.iSingular + "s" : this.iPlural;
        }

        public String toString() {
            return this.plural();
        }
    }

    public static class Record
    implements IsSerializable,
    GwtRpcResponse {
        private Long iUniqueId = null;
        private String[] iValues = null;
        private boolean[] iEditable = null;
        private boolean[] iVisible = null;
        private boolean iDeletable = true;

        public Record() {
        }

        public Record(Long uniqueId, int nrFields, boolean deletable) {
            this.iUniqueId = uniqueId;
            this.iValues = new String[nrFields];
            this.iEditable = new boolean[nrFields];
            this.iVisible = new boolean[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                this.iValues[i] = null;
                this.iEditable[i] = true;
            }
            this.iDeletable = deletable;
        }

        public Record(Long uniqueId, int nrFields) {
            this(uniqueId, nrFields, true);
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public void setField(int index, String value, boolean editable) {
            this.iValues[index] = value;
            this.iEditable[index] = editable;
        }

        public void setField(int index, Record record) {
            this.iValues[index] = record.getField(index);
            this.iEditable[index] = record.isEditable(index);
            this.iVisible[index] = record.isVisible(index);
        }

        public void setField(int index, Record record, boolean visible) {
            this.iValues[index] = record.getField(index);
            this.iEditable[index] = record.isEditable(index);
            this.iVisible[index] = visible;
        }

        public void setField(int index, String value, boolean editable, boolean visible) {
            this.iValues[index] = value;
            this.iEditable[index] = editable;
            this.iVisible[index] = visible;
        }

        public void setField(int index, String value) {
            this.iValues[index] = value;
        }

        public String getField(int index) {
            return this.iValues[index];
        }

        public boolean isEditable(int index) {
            return this.iEditable[index];
        }

        public boolean isVisible(int index) {
            return this.iVisible[index];
        }

        public boolean isEditable() {
            for (boolean editable : this.iEditable) {
                if (!editable) continue;
                return true;
            }
            return false;
        }

        public void addToField(int index, String value) {
            if (this.iValues[index] == null) {
                this.iValues[index] = value;
            } else {
                int n = index;
                this.iValues[n] = this.iValues[n] + "|" + value;
            }
        }

        public String[] getValues(int index) {
            return this.iValues[index] == null ? new String[]{} : this.iValues[index].split("\\|");
        }

        public String[] getValues() {
            return this.iValues;
        }

        public void setValues(String[] values) {
            this.iValues = values;
        }

        public String getText(Field f, int index) {
            String value = this.getField(index);
            if (value == null) {
                return "";
            }
            if (f.getType() == FieldType.list) {
                for (ListItem item : f.getValues()) {
                    if (!item.getValue().equals(value)) continue;
                    return item.getText();
                }
            }
            return value;
        }

        public boolean isEmpty() {
            if (this.getUniqueId() != null) {
                return false;
            }
            for (String v : this.iValues) {
                if (v == null || v.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean isDeletable() {
            return this.iDeletable;
        }

        public void setDeletable(boolean deletable) {
            this.iDeletable = deletable;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Record)) {
                return false;
            }
            Record r = (Record)o;
            if (this.getUniqueId() != null) {
                return this.getUniqueId().equals(r.getUniqueId());
            }
            return r.getUniqueId() != null ? false : super.equals(o);
        }

        public void copyFrom(Record record) {
            this.iUniqueId = record.iUniqueId;
            this.iValues = record.iValues;
            this.iEditable = record.iEditable;
            this.iDeletable = record.iDeletable;
            this.iVisible = record.iVisible;
        }

        public void copyTo(Record record) {
            record.copyFrom(this);
        }

        public Record cloneRecord() {
            Record r = new Record(this.iUniqueId, this.iValues.length, this.iDeletable);
            for (int i = 0; i < this.iValues.length; ++i) {
                r.iValues[i] = this.iValues[i];
                r.iEditable[i] = this.iEditable[i];
                r.iVisible[i] = this.iVisible[i];
            }
            return r;
        }
    }

    public class RecordComparator
    implements Comparator<Record> {
        public int compare(int index, Record r1, Record r2) {
            if (index < 0) {
                return r1.getUniqueId() == null ? (r2.getUniqueId() == null ? 0 : 1) : (r1.getUniqueId() == null ? -1 : r1.getUniqueId().compareTo(r2.getUniqueId()));
            }
            Field field = AssignClassInstructorsInterface.this.getFields()[index];
            String s1 = r1.getText(field, index);
            String s2 = r2.getText(field, index);
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            if (s2 == null) {
                return -1;
            }
            switch (field.getType()) {
                default: 
            }
            try {
                Double d1 = Double.parseDouble(s1.isEmpty() ? "0" : s1);
                Double d2 = Double.parseDouble(s2.isEmpty() ? "0" : s2);
                return d1.compareTo(d2);
            }
            catch (NumberFormatException e) {
                return s1.compareTo(s2);
            }
        }

        @Override
        public int compare(Record r1, Record r2) {
            for (int i = 0; i < r1.getValues().length; ++i) {
                int cmp = this.compare(i, r1, r2);
                if (cmp == 0) continue;
                return cmp;
            }
            return this.compare(-1, r1, r2);
        }
    }

    public static class RemoveAllClassInstructorsDataRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<AssignClassInstructorsInterface> {
        private AssignClassInstructorsInterface iData;

        public AssignClassInstructorsInterface getData() {
            return this.iData;
        }

        public void setData(AssignClassInstructorsInterface data) {
            this.iData = data;
        }

        public static RemoveAllClassInstructorsDataRpcRequest removeInstructorData(AssignClassInstructorsInterface data) {
            RemoveAllClassInstructorsDataRpcRequest request = new RemoveAllClassInstructorsDataRpcRequest();
            request.setData(data);
            return request;
        }
    }

    public static class SaveDataGoToNextRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<AssignClassInstructorsInterface> {
        private AssignClassInstructorsInterface iData;

        public AssignClassInstructorsInterface getData() {
            return this.iData;
        }

        public void setData(AssignClassInstructorsInterface data) {
            this.iData = data;
        }

        public static SaveDataGoToNextRpcRequest saveDataAndNext(AssignClassInstructorsInterface data) {
            SaveDataGoToNextRpcRequest request = new SaveDataGoToNextRpcRequest();
            request.setData(data);
            return request;
        }
    }

    public static class SaveDataGoToPreviousRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<AssignClassInstructorsInterface> {
        private AssignClassInstructorsInterface iData;

        public AssignClassInstructorsInterface getData() {
            return this.iData;
        }

        public void setData(AssignClassInstructorsInterface data) {
            this.iData = data;
        }

        public static SaveDataGoToPreviousRpcRequest saveDataAndPrev(AssignClassInstructorsInterface data) {
            SaveDataGoToPreviousRpcRequest request = new SaveDataGoToPreviousRpcRequest();
            request.setData(data);
            return request;
        }
    }

    public static class SaveDataRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<AssignClassInstructorsInterface> {
        private AssignClassInstructorsInterface iData;

        public AssignClassInstructorsInterface getData() {
            return this.iData;
        }

        public void setData(AssignClassInstructorsInterface data) {
            this.iData = data;
        }

        public static SaveDataRpcRequest saveData(AssignClassInstructorsInterface data) {
            SaveDataRpcRequest request = new SaveDataRpcRequest();
            request.setData(data);
            return request;
        }
    }

    public static class LoadDataRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<AssignClassInstructorsInterface> {
        private String iConfigIdStr;

        public String getConfigIdStr() {
            return this.iConfigIdStr;
        }

        public void setConfigIdStr(String configIdStr) {
            this.iConfigIdStr = configIdStr;
        }

        public static LoadDataRpcRequest loadData(String configIdStr) {
            LoadDataRpcRequest request = new LoadDataRpcRequest();
            request.setConfigIdStr(configIdStr);
            return request;
        }
    }

    public static class GetPageNameRpcRequest
    extends SimpleEditRpcRequest
    implements GwtRpcRequest<PageName> {
        public static GetPageNameRpcRequest getPageName() {
            GetPageNameRpcRequest request = new GetPageNameRpcRequest();
            return request;
        }
    }

    public static abstract class SimpleEditRpcRequest
    implements IsSerializable {
    }

    public static class ListItem
    implements IsSerializable,
    Comparable<ListItem> {
        private String iValue;
        private String iText;

        public ListItem() {
        }

        public ListItem(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public String getText() {
            return this.iText;
        }

        @Override
        public int compareTo(ListItem o) {
            return this.getText().compareTo(o.getText());
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ListItem)) {
                return false;
            }
            ListItem i = (ListItem)o;
            return this.getValue().equals(i.getValue());
        }
    }

    public static enum DataColumn implements IsSerializable
    {
        CLASS_UID,
        CLASS_PARENT_UID,
        IS_FIRST_RECORD_FOR_CLASS,
        HAS_ERROR,
        CLASS_NAME,
        CLASS_EXTERNAL_UID,
        DELETE,
        ADD,
        INSTR_NAME,
        PCT_SHARE,
        CHECK_CONFICTS,
        RESPONSIBILITY,
        DISPLAY,
        TIME,
        ROOM,
        FUNDING_DEPT;

    }

    public static enum Flag implements IsSerializable
    {
        HIDDEN,
        READ_ONLY,
        UNIQUE,
        UNIQUE_IF_SET,
        NOT_EMPTY,
        FLOAT,
        NEGATIVE,
        DEFAULT_CHECKED,
        HIDE_LABEL;


        public int toInt() {
            return 1 << this.ordinal();
        }

        public boolean has(int flags) {
            return (flags & this.toInt()) == this.toInt();
        }
    }

    public static enum FieldType implements IsSerializable
    {
        textarea,
        number,
        toggle,
        list,
        add,
        delete,
        hasError;

    }
}

