/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.util.IdValue;

public class InstructionalOfferingModifyForm
implements UniTimeForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 5412595518174343486L;
    private String op;
    private Integer subjectAreaId;
    private Long instrOfferingId;
    private String instrOfferingName;
    private boolean instrOffrConfigUnlimited;
    private Integer instrOffrConfigLimit;
    private boolean instrOffrConfigUnlimitedReadOnly;
    private Long instrOffrConfigId;
    private String origSubparts;
    private Boolean displayMaxLimit;
    private Boolean displayOptionForMaxLimit;
    private Boolean displayEnrollment;
    private Boolean displaySnapshotLimit;
    private String enableAllClassesForStudentScheduling;
    private String displayAllClassesInstructors;
    private Boolean displayExternalId;
    private Boolean editExternalId;
    private Boolean displayDisplayInstructors;
    private Boolean displayEnabledForStudentScheduling;
    private Long instructionalMethod;
    private String instructionalMethodDefault;
    private boolean instructionalMethodEditable;
    private Boolean editSnapshotLimits;
    private Boolean displayLms;
    private List<String> classIds;
    private List<String> subpartIds;
    private List<String> itypes;
    private List<Boolean> mustHaveChildClasses;
    private List<String> parentClassIds;
    private List<String> readOnlyClasses;
    private List<String> readOnlyDatePatterns;
    private List<String> classLabels;
    private List<String> classLabelIndents;
    private List<String> enrollments;
    private List<String> snapshotLimits;
    private List<String> minClassLimits;
    private List<String> maxClassLimits;
    private List<String> roomRatios;
    private List<String> numberOfRooms;
    private List<String> departments;
    private List<String> datePatterns;
    private List<String> displayInstructors;
    private List<String> enabledForStudentScheduling;
    private List<Boolean> classCanMoveUp;
    private List<Boolean> classCanMoveDown;
    private List<Integer> subtotalIndexes;
    private List<String> subtotalLabels;
    private List<Integer> subtotalValues;
    private List<Integer> subtotalSnapValues;
    private List<Boolean> enableAllClassesForStudentSchedulingForSubpart;
    private List<Boolean> displayAllClassesInstructorsForSubpart;
    private List<Boolean> readOnlySubparts;
    private List<String> times;
    private List<String> rooms;
    private List<String> instructors;
    private List<String> externalIds;
    private List<Boolean> canDelete;
    private List<Boolean> canCancel;
    private List<Boolean> isCancelled;
    private List<String> lms;
    private List<Boolean> splitAttendance;
    private List<Boolean> classHasErrors;
    private static String CLASS_IDS_TOKEN = "classIds";
    private static String SUBPART_IDS_TOKEN = "subpartIds";
    private static String PARENT_CLASS_IDS_TOKEN = "parentClassIds";
    private static String ITYPES_TOKEN = "itypes";
    private static String MUST_HAVE_CHILD_CLASSES_TOKEN = "mustHaveChildClasses";
    private static String READ_ONLY_CLASSES_TOKEN = "readOnlyClasses";
    private static String READ_ONLY_DATE_PATTERNS_TOKEN = "readOnlyDatePatterns";
    private static String CLASS_LABELS_TOKEN = "classLabels";
    private static String CLASS_LABEL_INDENTS_TOKEN = "classLabelIndents";
    private static String ENROLLMENTS_TOKEN = "enrollments";
    private static String SNAPSHOT_LIMITS_TOKEN = "snapshotLimits";
    private static String MIN_CLASS_LIMITS_TOKEN = "minClassLimits";
    private static String MAX_CLASS_LIMITS_TOKEN = "maxClassLimits";
    private static String ROOM_RATIOS_TOKEN = "roomRatios";
    private static String NUMBER_OF_ROOMS_TOKEN = "numberOfRooms";
    private static String DEPARTMENTS_TOKEN = "departments";
    private static String DATE_PATTERNS_TOKEN = "datePatterns";
    private static String DISPLAY_INSTRUCTORS_TOKEN = "displayInstructors";
    private static String ENABLED_FOR_STUDENT_SCHEDULING_TOKEN = "enabledForStudentScheduling";
    private static String DIRECTION_UP = "up";
    private static String DIRECTION_DOWN = "down";
    private static String SUBTOTAL_INDEXES_TOKEN = "subtotalIndexes";
    private static String TIMES_TOKEN = "times";
    private static String ROOMS_TOKEN = "rooms";
    private static String INSTRUCTORS_TOKEN = "instructors";
    private static String EXTERNAL_IDS_TOKEN = "externalIds";
    private static String CAN_DELETE_TOKEN = "canDelete";
    private static String CAN_CANCEL_TOKEN = "canCancel";
    private static String IS_CANCELLED_TOKEN = "isCancelled";
    private static String DISPLAY_LMS_TOKEN = "displayLms";
    private static String LMS_TOKEN = "lms";
    private static String SPLIT_ATTENDANCE = "splitAttendance";

    public InstructionalOfferingModifyForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (MSG.actionUpdateMultipleClassSetup().equals(this.op)) {
            if (this.instrOffrConfigId == null || this.instrOffrConfigId.intValue() <= 0) {
                action.addFieldError("form.instrOffrConfigId", MSG.errorRequiredIOConfiguration());
            }
            this.validateChildClassExistence(action);
            this.validateClassLimits(action);
            this.validateAllSubpartsHaveAtLeastOneClass(action);
        }
    }

    private void validateChildClassExistence(UniTimeAction action) {
        for (int index = 0; index < this.getClassIds().size(); ++index) {
            if (!this.getMustHaveChildClasses().get(index).booleanValue()) continue;
            String classId = this.getClassIds().get(index);
            if (index + 1 == this.getClassIds().size()) {
                action.addFieldError("mustHaveChildClasses", MSG.errorClassMustHaveChildClasses(this.getClassLabels().get(index)));
                this.getClassHasErrors().set(index, true);
                continue;
            }
            String parentOfNextClass = this.getParentClassIds().get(index + 1);
            if (parentOfNextClass != null && parentOfNextClass.equals(classId)) continue;
            action.addFieldError("mustHaveChildClasses", MSG.errorClassMustHaveChildClasses(this.getClassLabels().get(index)));
            this.getClassHasErrors().set(index, true);
        }
    }

    private void validateAllSubpartsHaveAtLeastOneClass(UniTimeAction action) {
        String[] subparts = this.getOrigSubparts().split(",");
        for (int i = 0; i < subparts.length; ++i) {
            if (this.getSubpartIds().contains(subparts[i])) continue;
            action.addFieldError("allSubpartsMustHaveAClass", MSG.errorEachSubpartMustHaveClass());
            break;
        }
    }

    private void validateMinLessThanMaxClassLimits(UniTimeAction action) {
        Iterator<String> it1 = this.getMinClassLimits().iterator();
        Iterator<String> it2 = this.getMaxClassLimits().iterator();
        int index = 0;
        String minLimitStr = null;
        String maxLimitStr = null;
        while (it1.hasNext()) {
            int maxLimit;
            minLimitStr = it1.next();
            int minLimit = minLimitStr != null && minLimitStr.length() > 0 ? Integer.parseInt(minLimitStr) : 0;
            if (minLimit > (maxLimit = (maxLimitStr = it2.next()) != null && maxLimitStr.length() > 0 ? Integer.parseInt(maxLimitStr) : 0)) {
                action.addFieldError("minLimitGreaterThanMaxLimit", MSG.errorMaxLessThanMinLimit(this.getClassLabels().get(index)));
                this.getClassHasErrors().set(index, true);
            }
            ++index;
        }
    }

    private void validateMinOrMaxParentClassLimits(UniTimeAction action, List<String> limits, String errorName, String errorMessage) {
        HashMap<String, HashMap> childClassLimits = new HashMap<String, HashMap>();
        Iterator<String> it1 = this.getSubpartIds().iterator();
        Iterator<String> it2 = limits.iterator();
        Iterator<String> it3 = this.getParentClassIds().iterator();
        String subpartKey = null;
        String parentKey = null;
        String tmp = null;
        HashMap subpartLimits = null;
        while (it1.hasNext()) {
            int value2;
            subpartKey = it1.next();
            tmp = it2.next();
            int clsLimit = tmp != null && tmp.length() != 0 ? Integer.parseInt(tmp) : 0;
            parentKey = it3.next();
            if (parentKey == null || parentKey.length() <= 0) continue;
            if (childClassLimits.get(parentKey) == null) {
                subpartLimits = new HashMap();
                childClassLimits.put(parentKey, subpartLimits);
                value2 = 0;
            } else {
                subpartLimits = (HashMap)childClassLimits.get(parentKey);
                value2 = subpartLimits.get(subpartKey) == null ? 0 : (Integer)subpartLimits.get(subpartKey);
            }
            subpartLimits.put(subpartKey, value2 += clsLimit);
        }
        HashMap<String, String> childClassesUnderLimit = new HashMap<String, String>();
        String parentKey1 = null;
        Integer childLimit = null;
        Integer parentLimit = null;
        Iterator<String> it4 = this.getClassIds().iterator();
        Iterator<String> it5 = limits.iterator();
        String subpartKey22 = null;
        while (it4.hasNext()) {
            parentKey1 = it4.next();
            parentLimit = Integer.valueOf(it5.next());
            if (childClassLimits.get(parentKey1) == null) continue;
            subpartLimits = (HashMap)childClassLimits.get(parentKey1);
            for (String subpartKey22 : subpartLimits.keySet()) {
                childLimit = (Integer)subpartLimits.get(subpartKey22);
                if (parentLimit == null || childLimit >= parentLimit) continue;
                childClassesUnderLimit.put(parentKey1, subpartKey22);
            }
        }
        if (childClassesUnderLimit.size() > 0) {
            action.addFieldError(errorName, errorMessage);
        }
        if (childClassesUnderLimit.size() > 0) {
            Iterator<String> it6 = this.getParentClassIds().iterator();
            Iterator<String> it7 = this.getSubpartIds().iterator();
            String subpartId = null;
            String parentId = null;
            int index = 0;
            while (it6.hasNext()) {
                parentId = it6.next();
                subpartId = it7.next();
                if (!this.getClassHasErrors().get(index).booleanValue() && childClassesUnderLimit.keySet().contains(parentId) && subpartId.equals((String)childClassesUnderLimit.get(parentId))) {
                    this.getClassHasErrors().set(index, true);
                }
                ++index;
            }
        }
    }

    private void validateSubpartClassLimits(UniTimeAction action) {
        int limit = this.getInstrOffrConfigLimit();
        HashMap<String, Integer> subpartClassLimits = new HashMap<String, Integer>();
        Iterator<String> it1 = this.getSubpartIds().iterator();
        Iterator<String> it2 = this.getMaxClassLimits().iterator();
        Iterator<String> it3 = this.getParentClassIds().iterator();
        String subpartKey = null;
        String parentKey = null;
        String tmp = null;
        while (it1.hasNext()) {
            subpartKey = it1.next();
            tmp = it2.next();
            int clsLimit = tmp != null && tmp.length() != 0 ? Integer.parseInt(tmp) : 0;
            parentKey = it3.next();
            if (parentKey != null && parentKey.length() != 0) continue;
            int value1 = subpartClassLimits.get(subpartKey) == null ? 0 : (Integer)subpartClassLimits.get(subpartKey);
            subpartClassLimits.put(subpartKey, value1 += clsLimit);
        }
        HashSet<String> subpartsUnderLimit = new HashSet<String>();
        String subpartKey1 = null;
        Integer subpartLimit = null;
        Iterator it4 = subpartClassLimits.keySet().iterator();
        while (it4.hasNext()) {
            subpartKey1 = it4.next().toString();
            subpartLimit = (Integer)subpartClassLimits.get(subpartKey1);
            if (subpartLimit == null || subpartLimit >= limit) continue;
            subpartsUnderLimit.add(subpartKey1);
        }
        if (subpartsUnderLimit.size() > 0) {
            if (this.getDisplayMaxLimit().booleanValue()) {
                action.addFieldError("maxLimit", MSG.errorMaxLimitsTotalTooLow());
            } else {
                action.addFieldError("maxLimit", MSG.errorLimitsForTopLevelClassesTooLow());
            }
        }
        if (subpartsUnderLimit.size() > 0) {
            Iterator<String> it7 = this.getSubpartIds().iterator();
            String subpartId = null;
            int index = 0;
            while (it7.hasNext()) {
                subpartId = it7.next();
                if (!this.getClassHasErrors().get(index).booleanValue() && subpartsUnderLimit.contains(subpartId)) {
                    this.getClassHasErrors().set(index, true);
                }
                ++index;
            }
        }
    }

    private void initClassHasErrorsToFalse() {
        this.setClassHasErrors(new ArrayList<Boolean>());
        Iterator<String> it = this.getClassIds().iterator();
        while (it.hasNext()) {
            this.getClassHasErrors().add(false);
            it.next();
        }
    }

    private void initClassMoveDirections() {
        this.setClassCanMoveDown(new ArrayList<Boolean>());
        this.setClassCanMoveUp(new ArrayList<Boolean>());
        Iterator<String> it = this.getClassIds().iterator();
        while (it.hasNext()) {
            this.getClassCanMoveDown().add(false);
            this.getClassCanMoveUp().add(false);
            it.next();
        }
    }

    private void validateClassLimits(UniTimeAction action) {
        boolean unlimited = this.getInstrOffrConfigUnlimited();
        int limit = this.getInstrOffrConfigLimit();
        if (!unlimited && limit > 0) {
            this.initClassHasErrorsToFalse();
            this.validateMinLessThanMaxClassLimits(action);
            this.validateMinOrMaxParentClassLimits(action, this.getMaxClassLimits(), "maxLimit", this.getDisplayMaxLimit() != false ? MSG.errorTotalMaxChildrenAtLeastMaxParent() : MSG.errorLimitsChildClasses());
            if (ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                this.validateSubpartClassLimits(action);
            }
        }
    }

    @Override
    public void reset() {
        this.instrOfferingId = null;
        this.instrOffrConfigLimit = null;
        this.instrOffrConfigUnlimited = false;
        this.instrOffrConfigUnlimitedReadOnly = false;
        this.instrOffrConfigId = null;
        this.instrOfferingName = "";
        this.origSubparts = "";
        this.displayMaxLimit = false;
        this.displayOptionForMaxLimit = false;
        this.displayEnrollment = false;
        this.displaySnapshotLimit = false;
        this.displayDisplayInstructors = false;
        this.displayEnabledForStudentScheduling = false;
        this.displayExternalId = false;
        this.editExternalId = false;
        this.editSnapshotLimits = false;
        this.enableAllClassesForStudentScheduling = "";
        this.displayAllClassesInstructors = "";
        this.instructionalMethod = null;
        this.instructionalMethodDefault = null;
        this.instructionalMethodEditable = false;
        this.displayLms = false;
        this.resetLists();
    }

    private void resetLists() {
        this.classIds = new ArrayList<String>();
        this.subpartIds = new ArrayList<String>();
        this.itypes = new ArrayList<String>();
        this.mustHaveChildClasses = new ArrayList<Boolean>();
        this.parentClassIds = new ArrayList<String>();
        this.readOnlyClasses = new ArrayList<String>();
        this.readOnlyDatePatterns = new ArrayList<String>();
        this.classHasErrors = new ArrayList<Boolean>();
        this.classLabels = new ArrayList<String>();
        this.classLabelIndents = new ArrayList<String>();
        this.enrollments = new ArrayList<String>();
        this.snapshotLimits = new ArrayList<String>();
        this.minClassLimits = new ArrayList<String>();
        this.maxClassLimits = new ArrayList<String>();
        this.roomRatios = new ArrayList<String>();
        this.numberOfRooms = new ArrayList<String>();
        this.departments = new ArrayList<String>();
        this.datePatterns = new ArrayList<String>();
        this.displayInstructors = new ArrayList<String>();
        this.enabledForStudentScheduling = new ArrayList<String>();
        this.subtotalIndexes = new ArrayList<Integer>();
        this.subtotalLabels = new ArrayList<String>();
        this.subtotalValues = new ArrayList<Integer>();
        this.subtotalSnapValues = new ArrayList<Integer>();
        this.enableAllClassesForStudentSchedulingForSubpart = new ArrayList<Boolean>();
        this.displayAllClassesInstructorsForSubpart = new ArrayList<Boolean>();
        this.classCanMoveUp = new ArrayList<Boolean>();
        this.classCanMoveDown = new ArrayList<Boolean>();
        this.readOnlySubparts = new ArrayList<Boolean>();
        this.times = new ArrayList<String>();
        this.rooms = new ArrayList<String>();
        this.instructors = new ArrayList<String>();
        this.externalIds = new ArrayList<String>();
        this.canDelete = new ArrayList<Boolean>();
        this.canCancel = new ArrayList<Boolean>();
        this.isCancelled = new ArrayList<Boolean>();
        this.lms = new ArrayList<String>();
        this.splitAttendance = new ArrayList<Boolean>();
    }

    private void setClassCannotMove(int classIndex) {
        this.getClassCanMoveDown().set(classIndex, false);
        this.getClassCanMoveUp().set(classIndex, false);
    }

    public void setDirectionsClassesCanMove() {
        String parentClassId = null;
        String classItype = null;
        String parentSubpartId = null;
        String parentClassItype = null;
        this.initClassMoveDirections();
        for (int classIndex = 0; classIndex < this.getClassIds().size(); ++classIndex) {
            int highestParentSubpartIdIndex;
            parentClassId = this.getParentClassIds().get(classIndex);
            if (parentClassId == null || parentClassId.length() == 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            int parentClassIndex = this.getClassIds().indexOf(parentClassId);
            if (parentClassIndex < 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            classItype = this.getItypes().get(classIndex);
            parentClassItype = this.getItypes().get(parentClassIndex);
            if (classItype != null && parentClassItype != null && classItype.equals(parentClassItype)) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            parentSubpartId = this.getSubpartIds().get(parentClassIndex);
            if (parentSubpartId == null || parentSubpartId.length() == 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            int lowestParentSubpartIdIndex = this.getSubpartIds().indexOf(parentSubpartId);
            if (lowestParentSubpartIdIndex < parentClassIndex) {
                this.getClassCanMoveUp().set(classIndex, true);
            }
            if ((highestParentSubpartIdIndex = this.getSubpartIds().lastIndexOf(parentSubpartId)) <= parentClassIndex) continue;
            this.getClassCanMoveDown().set(classIndex, true);
        }
    }

    public void initializeOrigSubparts() {
        TreeSet<String> ts = new TreeSet<String>();
        Iterator<String> it = this.getSubpartIds().iterator();
        while (it.hasNext()) {
            ts.add(it.next());
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it2 = ts.iterator();
        while (it2.hasNext()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append((String)it2.next());
        }
        this.setOrigSubparts(sb.toString());
    }

    public void initializeEnableAllClassesForStudentScheduling() {
        if (this.getClassLabels().size() > this.getEnabledForStudentScheduling().size()) {
            this.setEnableAllClassesForStudentScheduling("false");
            return;
        }
        String display = "true";
        for (String value : this.getEnabledForStudentScheduling()) {
            if (value != null && (value.equals("on") || Boolean.parseBoolean(value))) continue;
            display = "false";
            break;
        }
        this.setEnableAllClassesForStudentScheduling(display);
    }

    public void initializeDisplayAllClassInstructors() {
        if (this.getClassLabels().size() > this.getDisplayInstructors().size()) {
            this.setDisplayAllClassesInstructors("false");
            return;
        }
        String display = "true";
        for (String value : this.getDisplayInstructors()) {
            if (value != null && (value.equals("on") || Boolean.parseBoolean(value))) continue;
            display = "false";
            break;
        }
        this.setDisplayAllClassesInstructors(display);
    }

    public void initalizeSubpartSubtotalsAndDisplayFlags() {
        HashMap<Long, Integer> subpartToIndex = new HashMap<Long, Integer>();
        this.setSubtotalIndexes(new ArrayList<Integer>());
        this.setSubtotalLabels(new ArrayList<String>());
        this.setSubtotalValues(new ArrayList<Integer>());
        this.setSubtotalSnapValues(new ArrayList<Integer>());
        this.setEnableAllClassesForStudentSchedulingForSubpart(new ArrayList<Boolean>());
        this.setDisplayAllClassesInstructorsForSubpart(new ArrayList<Boolean>());
        this.setReadOnlySubparts(new ArrayList<Boolean>());
        SchedulingSubpartDAO ssDao = SchedulingSubpartDAO.getInstance();
        SchedulingSubpart ss = null;
        int i = 0;
        int cnt = 0;
        Iterator<String> ssIt = this.getSubpartIds().iterator();
        Iterator<String> limitIt = this.getMinClassLimits().iterator();
        Iterator<Boolean> cancelIt = this.getIsCancelled().iterator();
        Iterator<String> snapLimitIt = this.getEditSnapshotLimits() != false ? this.getSnapshotLimits().iterator() : null;
        Boolean enableForScheduling = null;
        Boolean displayInstructor = null;
        Boolean readOnlySubpart = null;
        while (ssIt.hasNext() && limitIt.hasNext() && cancelIt.hasNext()) {
            Long subpartId = Long.valueOf(ssIt.next());
            Integer limit = Integer.valueOf(limitIt.next());
            Integer snapshotLimit = null;
            try {
                snapshotLimit = snapLimitIt == null ? null : Integer.valueOf(snapLimitIt.next());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean cancelled = Boolean.TRUE.equals(cancelIt.next());
            enableForScheduling = this.determineBooleanValueAtIndex(this.getEnabledForStudentScheduling(), cnt);
            displayInstructor = this.determineBooleanValueAtIndex(this.getDisplayInstructors(), cnt);
            readOnlySubpart = this.determineBooleanValueAtIndex(this.getReadOnlyClasses(), cnt);
            int addLimit = limit == null || cancelled ? 0 : limit;
            int snapLimit = snapshotLimit == null || cancelled ? 0 : snapshotLimit;
            Integer subtotalIndex = null;
            if (!subpartToIndex.containsKey(subpartId)) {
                ss = (SchedulingSubpart)ssDao.get(subpartId);
                this.getSubtotalValues().add(addLimit);
                this.getSubtotalSnapValues().add(snapLimit);
                this.getEnableAllClassesForStudentSchedulingForSubpart().add(enableForScheduling);
                this.getDisplayAllClassesInstructorsForSubpart().add(displayInstructor);
                this.getReadOnlySubparts().add(readOnlySubpart);
                String label = ss.getItypeDesc() + ss.getSchedulingSubpartSuffix();
                this.getSubtotalLabels().add(label);
                subpartToIndex.put(subpartId, i);
                subtotalIndex = i;
                ++i;
            } else {
                subtotalIndex = (Integer)subpartToIndex.get(subpartId);
                int oldSubtotal = this.getSubtotalValues().get(subtotalIndex);
                int newSubtotal = oldSubtotal + addLimit;
                this.getSubtotalValues().set(subtotalIndex, newSubtotal);
                int oldSnapSubtotal = this.getSubtotalSnapValues().get(subtotalIndex);
                int newSnapSubtotal = oldSnapSubtotal + snapLimit;
                this.getSubtotalSnapValues().set(subtotalIndex, newSnapSubtotal);
                boolean oldEnableForScheduling = this.getEnableAllClassesForStudentSchedulingForSubpart().get(subtotalIndex);
                boolean newEnableForScheduling = oldEnableForScheduling && enableForScheduling != false;
                this.getEnableAllClassesForStudentSchedulingForSubpart().set(subtotalIndex, newEnableForScheduling);
                boolean oldDisplayInstructor = this.getDisplayAllClassesInstructorsForSubpart().get(subtotalIndex);
                boolean newDisplayInstructor = oldDisplayInstructor && displayInstructor != false;
                this.getDisplayAllClassesInstructorsForSubpart().set(subtotalIndex, newDisplayInstructor);
                boolean oldReadOnlySubpart = this.getReadOnlySubparts().get(subtotalIndex);
                boolean newReadOnlySubpart = oldReadOnlySubpart && readOnlySubpart != false;
                this.getReadOnlySubparts().set(subtotalIndex, newReadOnlySubpart);
            }
            this.getSubtotalIndexes().add(subtotalIndex);
            ++cnt;
        }
    }

    private boolean determineBooleanValueAtIndex(List<?> l, int index) {
        if (l == null) {
            return false;
        }
        if (l.size() == 0) {
            return false;
        }
        if (l.size() < index + 1) {
            return false;
        }
        if (l.get(index) == null) {
            return false;
        }
        if (l.get(index) instanceof Boolean) {
            Boolean value = (Boolean)l.get(index);
            return value;
        }
        if (l.get(index) instanceof String) {
            String str_value = (String)l.get(index);
            if (str_value.equals("on")) {
                return true;
            }
            if (str_value.equals("yes")) {
                return true;
            }
            return Boolean.parseBoolean(str_value);
        }
        return false;
    }

    public List<String> getClassIds() {
        return this.classIds;
    }

    public void setClassIds(List<String> classIds) {
        this.classIds = classIds;
    }

    public List<Boolean> getClassHasErrors() {
        return this.classHasErrors;
    }

    public void setClassHasErrors(List<Boolean> classHasErrors) {
        this.classHasErrors = classHasErrors;
    }

    public List<String> getClassLabels() {
        return this.classLabels;
    }

    public void setClassLabels(List<String> classLabels) {
        this.classLabels = classLabels;
    }

    public List<String> getMinClassLimits() {
        return this.minClassLimits;
    }

    public void setMinClassLimits(List<String> classLimits) {
        this.minClassLimits = classLimits;
    }

    public List<String> getDatePatterns() {
        return this.datePatterns;
    }

    public void setDatePatterns(List<String> datePatterns) {
        this.datePatterns = datePatterns;
    }

    public Long getInstrOffrConfigId() {
        return this.instrOffrConfigId;
    }

    public void setInstrOffrConfigId(Long instrOffrConfigId) {
        this.instrOffrConfigId = instrOffrConfigId;
    }

    public Integer getInstrOffrConfigLimit() {
        return this.instrOffrConfigLimit;
    }

    public void setInstrOffrConfigLimit(Integer instrOffrConfigLimit) {
        this.instrOffrConfigLimit = instrOffrConfigLimit;
    }

    public boolean getInstrOffrConfigUnlimited() {
        return this.instrOffrConfigUnlimited;
    }

    public void setInstrOffrConfigUnlimited(boolean instrOffrConfigUnlimited) {
        this.instrOffrConfigUnlimited = instrOffrConfigUnlimited;
    }

    public boolean getInstrOffrConfigUnlimitedReadOnly() {
        return this.instrOffrConfigUnlimitedReadOnly;
    }

    public void setInstrOffrConfigUnlimitedReadOnly(boolean instrOffrConfigUnlimitedReadOnly) {
        this.instrOffrConfigUnlimitedReadOnly = instrOffrConfigUnlimitedReadOnly;
    }

    public List<String> getDepartments() {
        return this.departments;
    }

    public void setDepartments(List<String> managers) {
        this.departments = managers;
    }

    public List<String> getNumberOfRooms() {
        return this.numberOfRooms;
    }

    public void setNumberOfRooms(List<String> numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List<String> getParentClassIds() {
        return this.parentClassIds;
    }

    public void setParentClassIds(List<String> parentClassIds) {
        this.parentClassIds = parentClassIds;
    }

    public List<String> getMaxClassLimits() {
        return this.maxClassLimits;
    }

    public void setMaxClassLimits(List<String> roomLimits) {
        this.maxClassLimits = roomLimits;
    }

    public List<String> getSubpartIds() {
        return this.subpartIds;
    }

    public void setSubpartIds(List<String> subpartIds) {
        this.subpartIds = subpartIds;
    }

    public List<String> getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    public void setReadOnlyClasses(List<String> readOnlyClasses) {
        this.readOnlyClasses = readOnlyClasses;
    }

    public List<String> getReadOnlyDatePatterns() {
        return this.readOnlyDatePatterns;
    }

    public void setReadOnlyDatePatterns(List<String> readOnlyDatePatterns) {
        this.readOnlyDatePatterns = readOnlyDatePatterns;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public void removeFromClasses(String classId) {
        this.removeClass(classId);
        this.initClassHasErrorsToFalse();
        this.setDirectionsClassesCanMove();
    }

    private void removeClass(String classId) {
        ArrayList<String> classesToDel = new ArrayList<String>();
        ListIterator<String> it1 = this.classIds.listIterator();
        ListIterator<String> it2 = this.subpartIds.listIterator();
        ListIterator<String> it3 = this.parentClassIds.listIterator();
        ListIterator<String> it4 = this.readOnlyClasses.listIterator();
        ListIterator<String> it5 = this.minClassLimits.listIterator();
        ListIterator<String> it6 = this.departments.listIterator();
        ListIterator<String> it7 = this.datePatterns.listIterator();
        ListIterator<String> it8 = this.numberOfRooms.listIterator();
        ListIterator<String> it9 = this.maxClassLimits.listIterator();
        ListIterator<String> it10 = this.roomRatios.listIterator();
        ListIterator<String> it11 = this.classLabels.listIterator();
        ListIterator<String> it12 = this.classLabelIndents.listIterator();
        ListIterator<String> it13 = this.displayInstructors.listIterator();
        ListIterator<String> it14 = this.enabledForStudentScheduling.listIterator();
        ListIterator<String> it15 = this.itypes.listIterator();
        ListIterator<Boolean> it16 = this.mustHaveChildClasses.listIterator();
        ListIterator<String> it17 = this.enrollments.listIterator();
        ListIterator<String> it18 = this.times.listIterator();
        ListIterator<String> it19 = this.rooms.listIterator();
        ListIterator<String> it20 = this.instructors.listIterator();
        ListIterator<String> it21 = this.externalIds.listIterator();
        ListIterator<Boolean> it22 = this.canDelete.listIterator();
        ListIterator<Boolean> it23 = this.canCancel.listIterator();
        ListIterator<Boolean> it24 = this.isCancelled.listIterator();
        ListIterator<String> it25 = this.snapshotLimits.listIterator();
        ListIterator<String> it26 = this.readOnlyDatePatterns.listIterator();
        ListIterator<Boolean> it27 = this.splitAttendance.listIterator();
        while (it1.hasNext()) {
            boolean canRemoveFromEnrollment;
            boolean canRemoveFromEnableForStudentScheduling;
            boolean canRemoveFromDisplayInstructors;
            String cls1 = it1.next().toString();
            it2.next();
            String pCls1 = it3.next().toString();
            it4.next();
            it5.next();
            it6.next();
            it7.next();
            it8.next();
            it9.next();
            it10.next();
            it11.next();
            it12.next();
            if (it13.hasNext()) {
                it13.next();
                canRemoveFromDisplayInstructors = true;
            } else {
                canRemoveFromDisplayInstructors = false;
            }
            if (it14.hasNext()) {
                it14.next();
                canRemoveFromEnableForStudentScheduling = true;
            } else {
                canRemoveFromEnableForStudentScheduling = false;
            }
            it15.next();
            it16.next();
            if (it17.hasNext()) {
                it17.next();
                canRemoveFromEnrollment = true;
            } else {
                canRemoveFromEnrollment = false;
            }
            it18.next();
            it19.next();
            it20.next();
            it21.next();
            it22.next();
            it23.next();
            it24.next();
            it25.next();
            it26.next();
            it27.next();
            if (cls1.equals(classId)) {
                it1.remove();
                it2.remove();
                it3.remove();
                it4.remove();
                it5.remove();
                it6.remove();
                it7.remove();
                it8.remove();
                it9.remove();
                it10.remove();
                it11.remove();
                it12.remove();
                if (canRemoveFromDisplayInstructors) {
                    it13.remove();
                }
                if (canRemoveFromEnableForStudentScheduling) {
                    it14.remove();
                }
                it15.remove();
                it16.remove();
                if (canRemoveFromEnrollment) {
                    it17.remove();
                }
                it18.remove();
                it19.remove();
                it20.remove();
                it21.remove();
                it22.remove();
                it23.remove();
                it24.remove();
                it25.remove();
                it26.remove();
                it27.remove();
                continue;
            }
            if (!pCls1.equals(classId)) continue;
            classesToDel.add(cls1);
        }
        if (classesToDel.size() > 0) {
            Iterator delIt = classesToDel.iterator();
            while (delIt.hasNext()) {
                this.removeFromClasses(delIt.next().toString());
            }
        }
    }

    public void addToClasses(Class_ cls, Boolean isReadOnly, String indent, ClassAssignmentProxy proxy, String nameFormat, boolean canDelete, boolean canCancel, Boolean isReadOnlyDatePattern) {
        this.classLabels.add(cls.htmlLabel());
        this.classLabelIndents.add(indent);
        this.classIds.add(cls.getUniqueId().toString());
        this.subpartIds.add(cls.getSchedulingSubpart().getUniqueId().toString());
        this.itypes.add(cls.getSchedulingSubpart().getItype().getItype().toString());
        if (cls.getSchedulingSubpart().getChildSubparts() != null && cls.getSchedulingSubpart().getChildSubparts().size() > 0) {
            this.mustHaveChildClasses.add(true);
        } else {
            this.mustHaveChildClasses.add(false);
        }
        this.readOnlyClasses.add(isReadOnly.toString());
        this.readOnlyDatePatterns.add(isReadOnlyDatePattern.toString());
        this.classHasErrors.add(false);
        this.enrollments.add(Boolean.TRUE.equals(this.displayEnrollment) ? (cls.getEnrollment() == null ? "0" : cls.getEnrollment().toString()) : "");
        if (this.getInstrOffrConfigUnlimited()) {
            this.snapshotLimits.add("0");
        } else {
            this.snapshotLimits.add(cls.getSnapshotLimit() == null ? "" : cls.getSnapshotLimit().toString());
        }
        if (this.getInstrOffrConfigUnlimited()) {
            this.minClassLimits.add("0");
        } else {
            this.minClassLimits.add(cls.getExpectedCapacity().toString());
        }
        if (this.getInstrOffrConfigUnlimited()) {
            this.numberOfRooms.add("1");
        } else {
            this.numberOfRooms.add(cls.getNbrRooms().toString());
        }
        this.displayInstructors.add(cls.isDisplayInstructor().toString());
        this.enabledForStudentScheduling.add(cls.isEnabledForStudentScheduling().toString());
        if (this.getInstrOffrConfigUnlimited()) {
            this.maxClassLimits.add("0");
        } else if (cls.getMaxExpectedCapacity() != null) {
            this.maxClassLimits.add(cls.getMaxExpectedCapacity().toString());
        } else {
            this.maxClassLimits.add("");
        }
        if (this.getInstrOffrConfigUnlimited()) {
            this.roomRatios.add("1.0");
        } else if (cls.getRoomRatio() != null) {
            this.roomRatios.add(cls.getRoomRatio().toString());
        } else {
            this.roomRatios.add("");
        }
        if (cls.getParentClass() != null) {
            this.parentClassIds.add(cls.getParentClass().getUniqueId().toString());
        } else {
            this.parentClassIds.add("");
        }
        if (cls.getManagingDept() != null) {
            if (cls.getManagingDept().getUniqueId().equals(cls.getControllingDept().getUniqueId())) {
                this.departments.add("-1");
            } else {
                this.departments.add(cls.getManagingDept().getUniqueId().toString());
            }
        } else {
            this.departments.add("-1");
        }
        if (cls.getDatePattern() != null) {
            this.datePatterns.add(cls.getDatePattern().getUniqueId().toString());
        } else {
            this.datePatterns.add("");
        }
        if (!(cls.getExpectedCapacity() != null && cls.getMaxExpectedCapacity() != null && cls.getExpectedCapacity().equals(cls.getMaxExpectedCapacity()) || cls.getExpectedCapacity() == null && cls.getMaxExpectedCapacity() == null)) {
            this.setDisplayMaxLimit(true);
        }
        if (this.getDisplayMaxLimit().booleanValue()) {
            this.setDisplayOptionForMaxLimit(true);
        }
        this.times.add(cls.buildAssignedTimeHtml(proxy));
        this.rooms.add(cls.buildAssignedRoomHtml(proxy));
        this.instructors.add(cls.buildInstructorHtml(nameFormat));
        this.externalIds.add(cls.getClassSuffix() == null ? "" : cls.getClassSuffix());
        this.canDelete.add(canDelete);
        this.canCancel.add(canCancel);
        this.isCancelled.add(cls.isCancelled());
        if (cls.getLms() != null) {
            this.lms.add(cls.getLms().getUniqueId().toString());
        } else {
            this.lms.add("");
        }
        if (this.getInstrOffrConfigUnlimited() || cls.getNbrRooms() <= 1) {
            this.splitAttendance.add(false);
        } else {
            this.splitAttendance.add(cls.isRoomsSplitAttendance());
        }
    }

    private int indexOfLastChildClass(String classId) {
        int index;
        int clsIndex = this.getClassIds().indexOf(classId);
        for (index = clsIndex + 1; index < this.getClassIds().size() && !this.getClassLabelIndents().get(index).toString().equals(this.getClassLabelIndents().get(clsIndex).toString()) && this.getClassLabelIndents().get(index).toString().length() >= this.getClassLabelIndents().get(clsIndex).toString().length(); ++index) {
        }
        return --index;
    }

    public void shiftClass(String clsId) {
    }

    private HashMap buildOriginalListValuesMap() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put(CLASS_IDS_TOKEN, this.getClassIds());
        hm.put(SUBPART_IDS_TOKEN, this.getSubpartIds());
        hm.put(ITYPES_TOKEN, this.getItypes());
        hm.put(MUST_HAVE_CHILD_CLASSES_TOKEN, this.getMustHaveChildClasses());
        hm.put(CLASS_LABELS_TOKEN, this.getClassLabels());
        hm.put(CLASS_LABEL_INDENTS_TOKEN, this.getClassLabelIndents());
        hm.put(PARENT_CLASS_IDS_TOKEN, this.getParentClassIds());
        hm.put(READ_ONLY_CLASSES_TOKEN, this.getReadOnlyClasses());
        hm.put(READ_ONLY_DATE_PATTERNS_TOKEN, this.getReadOnlyDatePatterns());
        hm.put(ENROLLMENTS_TOKEN, this.getEnrollments());
        hm.put(SNAPSHOT_LIMITS_TOKEN, this.getSnapshotLimits());
        hm.put(MIN_CLASS_LIMITS_TOKEN, this.getMinClassLimits());
        hm.put(MAX_CLASS_LIMITS_TOKEN, this.getMaxClassLimits());
        hm.put(ROOM_RATIOS_TOKEN, this.getRoomRatios());
        hm.put(NUMBER_OF_ROOMS_TOKEN, this.getNumberOfRooms());
        hm.put(DEPARTMENTS_TOKEN, this.getDepartments());
        hm.put(DATE_PATTERNS_TOKEN, this.getDatePatterns());
        hm.put(DISPLAY_INSTRUCTORS_TOKEN, this.getDisplayInstructors());
        hm.put(ENABLED_FOR_STUDENT_SCHEDULING_TOKEN, this.getEnabledForStudentScheduling());
        hm.put(SUBTOTAL_INDEXES_TOKEN, this.getSubtotalIndexes());
        hm.put(TIMES_TOKEN, this.getTimes());
        hm.put(ROOMS_TOKEN, this.getRooms());
        hm.put(INSTRUCTORS_TOKEN, this.getInstructors());
        hm.put(EXTERNAL_IDS_TOKEN, this.getExternalIds());
        hm.put(CAN_DELETE_TOKEN, this.getCanDelete());
        hm.put(CAN_CANCEL_TOKEN, this.getCanCancel());
        hm.put(IS_CANCELLED_TOKEN, this.getIsCancelled());
        hm.put(DISPLAY_LMS_TOKEN, this.getDisplayLms());
        hm.put(LMS_TOKEN, this.getLms());
        hm.put(SPLIT_ATTENDANCE, this.getSplitAttendance());
        return hm;
    }

    private Object getObjectFromListMapAtIndex(HashMap<String, List> hm, String key, int index) {
        if (hm == null || key == null || key.length() == 0 || index < 0) {
            return null;
        }
        List list = hm.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private void addToClassesFromOrigClassesIndex(HashMap<String, List> originalClassesMap, int classIndex) {
        this.getClassIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_IDS_TOKEN, classIndex));
        this.getSubpartIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, SUBPART_IDS_TOKEN, classIndex));
        this.getItypes().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ITYPES_TOKEN, classIndex));
        this.getMustHaveChildClasses().add((Boolean)this.getObjectFromListMapAtIndex(originalClassesMap, MUST_HAVE_CHILD_CLASSES_TOKEN, classIndex));
        this.getClassLabels().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_LABELS_TOKEN, classIndex));
        this.getClassLabelIndents().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_LABEL_INDENTS_TOKEN, classIndex));
        this.getParentClassIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, PARENT_CLASS_IDS_TOKEN, classIndex));
        this.getReadOnlyClasses().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, READ_ONLY_CLASSES_TOKEN, classIndex));
        this.getReadOnlyDatePatterns().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, READ_ONLY_DATE_PATTERNS_TOKEN, classIndex));
        this.getEnrollments().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ENROLLMENTS_TOKEN, classIndex));
        this.getSnapshotLimits().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, SNAPSHOT_LIMITS_TOKEN, classIndex));
        this.getMinClassLimits().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, MIN_CLASS_LIMITS_TOKEN, classIndex));
        this.getMaxClassLimits().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, MAX_CLASS_LIMITS_TOKEN, classIndex));
        this.getRoomRatios().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ROOM_RATIOS_TOKEN, classIndex));
        this.getNumberOfRooms().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, NUMBER_OF_ROOMS_TOKEN, classIndex));
        this.getDepartments().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DEPARTMENTS_TOKEN, classIndex));
        this.getDatePatterns().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DATE_PATTERNS_TOKEN, classIndex));
        this.getDisplayInstructors().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DISPLAY_INSTRUCTORS_TOKEN, classIndex));
        this.getEnabledForStudentScheduling().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ENABLED_FOR_STUDENT_SCHEDULING_TOKEN, classIndex));
        this.getSubtotalIndexes().add((Integer)this.getObjectFromListMapAtIndex(originalClassesMap, SUBTOTAL_INDEXES_TOKEN, classIndex));
        this.getTimes().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, TIMES_TOKEN, classIndex));
        this.getRooms().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ROOMS_TOKEN, classIndex));
        this.getInstructors().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, INSTRUCTORS_TOKEN, classIndex));
        this.getExternalIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, EXTERNAL_IDS_TOKEN, classIndex));
        this.getCanDelete().add((Boolean)this.getObjectFromListMapAtIndex(originalClassesMap, CAN_DELETE_TOKEN, classIndex));
        this.getCanCancel().add((Boolean)this.getObjectFromListMapAtIndex(originalClassesMap, CAN_CANCEL_TOKEN, classIndex));
        this.getIsCancelled().add((Boolean)this.getObjectFromListMapAtIndex(originalClassesMap, IS_CANCELLED_TOKEN, classIndex));
        this.getLms().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, LMS_TOKEN, classIndex));
        this.getSplitAttendance().add((Boolean)this.getObjectFromListMapAtIndex(originalClassesMap, SPLIT_ATTENDANCE, classIndex));
    }

    public void addNewClassesBasedOnTemplate(String clsId) {
        int addNewAfterIndex = this.indexOfLastChildClass(clsId);
        int originalListSize = this.getClassIds().size();
        HashMap origListsMap = this.buildOriginalListValuesMap();
        this.resetLists();
        for (int i = 0; i <= addNewAfterIndex; ++i) {
            this.addToClassesFromOrigClassesIndex(origListsMap, i);
        }
        String parentClassId = this.getParentClassIds().get(this.getClassIds().indexOf(clsId.toString())).toString();
        this.addNewClassesBasedOnTemplate(clsId, this.nextTmpClassId((List)origListsMap.get(CLASS_IDS_TOKEN)).toString(), parentClassId.length() == 0 ? null : parentClassId);
        for (int i = addNewAfterIndex + 1; i < originalListSize; ++i) {
            this.addToClassesFromOrigClassesIndex(origListsMap, i);
        }
        this.initClassHasErrorsToFalse();
        this.setDirectionsClassesCanMove();
    }

    public void moveClassUp(String clsId) {
        int indexOfFirstClassToMove = this.getClassIds().indexOf(clsId);
        int indexOfLastClassToMove = this.indexOfLastChildClass(clsId);
        String newParentClassId = this.findNewParentClassId(clsId, DIRECTION_UP);
        if (newParentClassId != null) {
            int i;
            int indexOfClassToMoveAfter = this.indexOfLastChildClass(newParentClassId);
            int origListSize = this.getClassIds().size();
            this.getParentClassIds().set(indexOfFirstClassToMove, newParentClassId);
            HashMap origLists = this.buildOriginalListValuesMap();
            this.resetLists();
            for (i = 0; i <= indexOfClassToMoveAfter; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfFirstClassToMove; i <= indexOfLastClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfClassToMoveAfter + 1; i < indexOfFirstClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfLastClassToMove + 1; i < origListSize; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            this.initClassHasErrorsToFalse();
            this.setDirectionsClassesCanMove();
        }
    }

    public void moveClassDown(String clsId) {
        int indexOfFirstClassToMove = this.getClassIds().indexOf(clsId);
        int indexOfLastClassToMove = this.indexOfLastChildClass(clsId);
        String newParentClassId = this.findNewParentClassId(clsId, DIRECTION_DOWN);
        if (newParentClassId != null) {
            int i;
            int indexOfClassToMoveAfter = this.indexOfLastChildClass(newParentClassId);
            int origListSize = this.getClassIds().size();
            this.getParentClassIds().set(indexOfFirstClassToMove, newParentClassId);
            HashMap origLists = this.buildOriginalListValuesMap();
            this.resetLists();
            for (i = 0; i < indexOfFirstClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfLastClassToMove + 1; i <= indexOfClassToMoveAfter; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfFirstClassToMove; i <= indexOfLastClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfClassToMoveAfter + 1; i < origListSize; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            this.initClassHasErrorsToFalse();
            this.setDirectionsClassesCanMove();
        }
    }

    private String findNewParentClassId(String clsId, String direction) {
        int clsIndex = this.getClassIds().indexOf(clsId);
        String clsParentId = this.getParentClassIds().get(clsIndex);
        if (clsParentId == null || clsParentId.length() == 0) {
            return null;
        }
        int parentClassIndex = this.getClassIds().indexOf(clsParentId);
        String parentClassSubpartId = this.getSubpartIds().get(parentClassIndex);
        if (parentClassSubpartId == null || parentClassSubpartId.length() == 0) {
            return null;
        }
        String subpartId = null;
        String parentId = null;
        if (direction.equals(DIRECTION_UP)) {
            int i;
            for (i = parentClassIndex - 1; i >= 0 && ((subpartId = this.getSubpartIds().get(i)) == null || subpartId.length() <= 0 || !subpartId.equals(parentClassSubpartId) || (parentId = this.getClassIds().get(i)) == null || parentId.length() <= 0 || parentId.equals(clsParentId)); --i) {
            }
            if (i >= 0) {
                return parentId;
            }
        } else if (direction.equals(DIRECTION_DOWN)) {
            int i;
            for (i = clsIndex + 1; i < this.getClassIds().size() && ((subpartId = this.getSubpartIds().get(i)) == null || subpartId.length() <= 0 || !subpartId.equals(parentClassSubpartId) || (parentId = this.getClassIds().get(i)) == null || parentId.length() <= 0 || parentId.equals(clsParentId)); ++i) {
            }
            if (i < this.getClassIds().size()) {
                return parentId;
            }
        }
        return null;
    }

    private void addNewClassesBasedOnTemplate(String clsId, String tmpClassId, String parentClassId) {
        int index = this.getClassIds().indexOf(clsId);
        String label = this.getClassLabels().get(index).toString();
        this.classLabels.add(label.substring(0, label.indexOf(" ")) + " New" + tmpClassId);
        this.classLabelIndents.add(this.getClassLabelIndents().get(index).toString());
        this.classIds.add(tmpClassId);
        this.subpartIds.add(this.getSubpartIds().get(index).toString());
        this.itypes.add(this.getItypes().get(index).toString());
        this.mustHaveChildClasses.add(this.getMustHaveChildClasses().get(index));
        this.parentClassIds.add(parentClassId != null ? parentClassId.toString() : "");
        this.readOnlyClasses.add(Boolean.valueOf(false).toString());
        this.readOnlyDatePatterns.add(Boolean.valueOf(false).toString());
        this.enrollments.add("");
        this.snapshotLimits.add("");
        this.minClassLimits.add(this.getMinClassLimits().get(index));
        this.departments.add(this.getDepartments().get(index));
        this.datePatterns.add(this.getDatePatterns().get(index));
        this.numberOfRooms.add(this.getNumberOfRooms().get(index));
        this.maxClassLimits.add(this.getMaxClassLimits().get(index));
        this.roomRatios.add(this.getRoomRatios().get(index));
        this.displayInstructors.add(this.getDisplayInstructors().get(index));
        this.enabledForStudentScheduling.add(this.getEnabledForStudentScheduling().get(index));
        this.subtotalIndexes.add(this.getSubtotalIndexes().get(index));
        this.times.add("");
        this.rooms.add("");
        this.instructors.add("");
        this.externalIds.add("");
        ArrayList<String> childClasses = new ArrayList<String>();
        for (int i = index + 1; i < this.getClassIds().size(); ++i) {
            if (!this.getParentClassIds().get(i).toString().equals(clsId)) continue;
            childClasses.add(this.getClassIds().get(i));
        }
        Iterator it = childClasses.iterator();
        while (it.hasNext()) {
            this.addNewClassesBasedOnTemplate((String)it.next(), this.nextTmpClassId(null).toString(), tmpClassId);
        }
        this.canDelete.add(true);
        this.canCancel.add(false);
        this.isCancelled.add(false);
        this.lms.add(this.getLms().get(index));
        this.splitAttendance.add(this.getSplitAttendance().get(index));
    }

    private Long nextTmpClassId(List<String> origClassIds) {
        long id;
        Iterator<String> it;
        long nextId = -1L;
        if (origClassIds != null) {
            it = origClassIds.iterator();
            while (it.hasNext()) {
                id = Long.parseLong(it.next().toString());
                if (nextId < id) continue;
                nextId = id - 1L;
            }
        }
        it = this.classIds.iterator();
        while (it.hasNext()) {
            id = Long.parseLong(it.next().toString());
            if (nextId < id) continue;
            nextId = id - 1L;
        }
        return nextId;
    }

    public Integer getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Integer subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public List<String> getClassLabelIndents() {
        return this.classLabelIndents;
    }

    public void setClassLabelIndents(List<String> classLabelIndents) {
        this.classLabelIndents = classLabelIndents;
    }

    public List<String> getRoomRatios() {
        return this.roomRatios;
    }

    public void setRoomRatios(List<String> roomRatios) {
        this.roomRatios = roomRatios;
    }

    public List<String> getEnabledForStudentScheduling() {
        return this.enabledForStudentScheduling;
    }

    public void setEnabledForStudentScheduling(List<String> enabledForStudentScheduling) {
        this.enabledForStudentScheduling = enabledForStudentScheduling;
    }

    public List<String> getDisplayInstructors() {
        return this.displayInstructors;
    }

    public void setDisplayInstructors(List<String> displayInstructors) {
        this.displayInstructors = displayInstructors;
    }

    public List<Boolean> getClassCanMoveDown() {
        return this.classCanMoveDown;
    }

    public void setClassCanMoveDown(List<Boolean> classCanMoveDown) {
        this.classCanMoveDown = classCanMoveDown;
    }

    public List<Boolean> getClassCanMoveUp() {
        return this.classCanMoveUp;
    }

    public void setClassCanMoveUp(List<Boolean> classCanMoveUp) {
        this.classCanMoveUp = classCanMoveUp;
    }

    public List<String> getItypes() {
        return this.itypes;
    }

    public void setItypes(List<String> itypes) {
        this.itypes = itypes;
    }

    public List<Boolean> getMustHaveChildClasses() {
        return this.mustHaveChildClasses;
    }

    public void setMustHaveChildClasses(List<Boolean> mustHaveChildClasses) {
        this.mustHaveChildClasses = mustHaveChildClasses;
    }

    public String getOrigSubparts() {
        return this.origSubparts;
    }

    public void setOrigSubparts(String origSubparts) {
        this.origSubparts = origSubparts;
    }

    public Boolean getDisplayMaxLimit() {
        return this.displayMaxLimit;
    }

    public void setDisplayMaxLimit(Boolean displayMaxLimit) {
        this.displayMaxLimit = displayMaxLimit;
    }

    public Boolean getDisplayOptionForMaxLimit() {
        return this.displayOptionForMaxLimit;
    }

    public void setDisplayOptionForMaxLimit(Boolean displayOptionForMaxLimit) {
        this.displayOptionForMaxLimit = displayOptionForMaxLimit;
    }

    public boolean maxLimitCanBeHidden() {
        Iterator<String> it1 = this.getMinClassLimits().iterator();
        Iterator<String> it2 = this.getMaxClassLimits().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String min = it1.next();
            String max = it2.next();
            if (min == null && max == null || min != null && max != null && min.equals(max)) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getSubtotalIndexes() {
        return this.subtotalIndexes;
    }

    public void setSubtotalIndexes(List<Integer> subtotalIndexes) {
        this.subtotalIndexes = subtotalIndexes;
    }

    public List<String> getSubtotalLabels() {
        return this.subtotalLabels;
    }

    public void setSubtotalLabels(List<String> subtotalLabels) {
        this.subtotalLabels = subtotalLabels;
    }

    public List<Integer> getSubtotalValues() {
        return this.subtotalValues;
    }

    public void setSubtotalValues(List<Integer> subtotalValues) {
        this.subtotalValues = subtotalValues;
    }

    public List<Integer> getSubtotalSnapValues() {
        return this.subtotalSnapValues;
    }

    public void setSubtotalSnapValues(List<Integer> subtotalSnapValues) {
        this.subtotalSnapValues = subtotalSnapValues;
    }

    public String getEnableAllClassesForStudentScheduling() {
        return this.enableAllClassesForStudentScheduling;
    }

    public void setEnableAllClassesForStudentScheduling(String enableAllClassesForStudentScheduling) {
        this.enableAllClassesForStudentScheduling = enableAllClassesForStudentScheduling;
    }

    public String getDisplayAllClassesInstructors() {
        return this.displayAllClassesInstructors;
    }

    public void setDisplayAllClassesInstructors(String displayAllClassesInstructors) {
        this.displayAllClassesInstructors = displayAllClassesInstructors;
    }

    public List<Boolean> getEnableAllClassesForStudentSchedulingForSubpart() {
        return this.enableAllClassesForStudentSchedulingForSubpart;
    }

    public void setEnableAllClassesForStudentSchedulingForSubpart(List<Boolean> enableAllClassesForStudentSchedulingForSubpart) {
        this.enableAllClassesForStudentSchedulingForSubpart = enableAllClassesForStudentSchedulingForSubpart;
    }

    public List<Boolean> getDisplayAllClassesInstructorsForSubpart() {
        return this.displayAllClassesInstructorsForSubpart;
    }

    public void setDisplayAllClassesInstructorsForSubpart(List<Boolean> displayAllClassesInstructorsForSubpart) {
        this.displayAllClassesInstructorsForSubpart = displayAllClassesInstructorsForSubpart;
    }

    public List<Boolean> getReadOnlySubparts() {
        return this.readOnlySubparts;
    }

    public void setReadOnlySubparts(List<Boolean> readOnlySubparts) {
        this.readOnlySubparts = readOnlySubparts;
    }

    public List<String> getEnrollments() {
        return this.enrollments;
    }

    public void setEnrollments(List<String> enrollments) {
        this.enrollments = enrollments;
    }

    public List<String> getSnapshotLimits() {
        return this.snapshotLimits;
    }

    public void setSnapshotLimits(List<String> snapshotLimits) {
        this.snapshotLimits = snapshotLimits;
    }

    public Boolean getDisplayEnrollment() {
        return this.displayEnrollment;
    }

    public void setDisplayEnrollment(Boolean displayEnrollment) {
        this.displayEnrollment = displayEnrollment;
    }

    public Boolean getDisplaySnapshotLimit() {
        return this.displaySnapshotLimit;
    }

    public void setDisplaySnapshotLimit(Boolean displaySnapshotLimit) {
        this.displaySnapshotLimit = displaySnapshotLimit;
    }

    public List<String> getTimes() {
        return this.times;
    }

    public void setTimes(List<String> times) {
        this.times = times;
    }

    public List<String> getRooms() {
        return this.rooms;
    }

    public void setRooms(List<String> rooms) {
        this.rooms = rooms;
    }

    public List<String> getInstructors() {
        return this.instructors;
    }

    public void setInstructors(List<String> instructors) {
        this.instructors = instructors;
    }

    public Boolean getDisplayExternalId() {
        return this.displayExternalId;
    }

    public void setDisplayExternalId(Boolean displayExternalId) {
        this.displayExternalId = displayExternalId;
    }

    public Boolean getEditExternalId() {
        return this.editExternalId;
    }

    public void setEditExternalId(Boolean editExternalId) {
        this.editExternalId = editExternalId;
    }

    public Boolean getEditSnapshotLimits() {
        return this.editSnapshotLimits;
    }

    public void setEditSnapshotLimits(Boolean editSnapshotLimits) {
        this.editSnapshotLimits = editSnapshotLimits;
    }

    public Boolean getDisplayDisplayInstructors() {
        return this.displayDisplayInstructors;
    }

    public void setDisplayDisplayInstructors(Boolean displayDisplayInstructors) {
        this.displayDisplayInstructors = displayDisplayInstructors;
    }

    public Boolean getDisplayEnabledForStudentScheduling() {
        return this.displayEnabledForStudentScheduling;
    }

    public void setDisplayEnabledForStudentScheduling(Boolean displayEnabledForStudentScheduling) {
        this.displayEnabledForStudentScheduling = displayEnabledForStudentScheduling;
    }

    public List<String> getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(List<String> externalIds) {
        this.externalIds = externalIds;
    }

    public Boolean getDisplayLms() {
        return this.displayLms;
    }

    public void setDisplayLms(Boolean displayLms) {
        this.displayLms = displayLms;
    }

    public List<String> getLms() {
        return this.lms;
    }

    public void setLms(List<String> lms) {
        this.lms = lms;
    }

    public List<Boolean> getSplitAttendance() {
        return this.splitAttendance;
    }

    public void setSplitAttendance(List<Boolean> splitAttendance) {
        this.splitAttendance = splitAttendance;
    }

    public List<Boolean> getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(List<Boolean> canDelete) {
        this.canDelete = canDelete;
    }

    public List<Boolean> getCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(List<Boolean> canCancel) {
        this.canCancel = canCancel;
    }

    public List<Boolean> getIsCancelled() {
        return this.isCancelled;
    }

    public void setIsCancelled(List<Boolean> isCancelled) {
        this.isCancelled = isCancelled;
    }

    public void setCancelled(String classId, boolean cancelled) {
        int i;
        if (classId == null || classId.isEmpty()) {
            return;
        }
        if (cancelled && Long.valueOf(classId) < 0L) {
            this.removeFromClasses(classId);
            return;
        }
        boolean wasCancelled = false;
        for (i = 0; i < this.classIds.size(); ++i) {
            if (!classId.equals(this.classIds.get(i))) continue;
            wasCancelled = this.isCancelled.get(i);
            this.isCancelled.set(i, cancelled);
            if (wasCancelled && !cancelled) {
                this.setCancelled(this.parentClassIds.get(i), false);
            }
            if (wasCancelled || !cancelled) continue;
            boolean allCancelled = true;
            for (int j = 0; j < this.subpartIds.size(); ++j) {
                if (i == j || !this.subpartIds.get(i).equals(this.subpartIds.get(j)) || !this.parentClassIds.get(i).equals(this.parentClassIds.get(j)) || Boolean.TRUE.equals(this.isCancelled.get(j))) continue;
                allCancelled = false;
                break;
            }
            if (!allCancelled) continue;
            this.setCancelled(this.parentClassIds.get(i), true);
        }
        if (wasCancelled != cancelled) {
            for (i = 0; i < this.parentClassIds.size(); ++i) {
                if (!classId.equals(this.parentClassIds.get(i))) continue;
                this.setCancelled(this.classIds.get(i), cancelled);
            }
        }
    }

    public Long getInstructionalMethod() {
        return this.instructionalMethod;
    }

    public void setInstructionalMethod(Long instructionalMethod) {
        this.instructionalMethod = instructionalMethod;
    }

    public String getInstructionalMethodDefault() {
        return this.instructionalMethodDefault;
    }

    public void setInstructionalMethodDefault(String instructionalMethodDefault) {
        this.instructionalMethodDefault = instructionalMethodDefault;
    }

    public List<IdValue> getInstructionalMethods() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (InstructionalMethod type : InstructionalMethod.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.instructionalMethod)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }

    public boolean getInstructionalMethodEditable() {
        return this.instructionalMethodEditable;
    }

    public void setInstructionalMethodEditable(boolean instructionalMethodEditable) {
        this.instructionalMethodEditable = instructionalMethodEditable;
    }

    public String getInstructionalMethodLabel() {
        if (this.instructionalMethod != null) {
            for (InstructionalMethod type : InstructionalMethod.findAll()) {
                if (!type.getUniqueId().equals(this.instructionalMethod)) continue;
                return type.getLabel();
            }
        }
        if (this.instructionalMethodDefault == null) {
            return MSG.selectNoInstructionalMethod();
        }
        return MSG.defaultInstructionalMethod(this.instructionalMethodDefault);
    }
}

