/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class DatePatternEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -929558620061783652L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private String iName;
    private Long iUniqueId;
    private String iType;
    private boolean iIsUsed;
    private boolean iIsDefault;
    private boolean iVisible;
    private List<Long> iDepartmentIds = new ArrayList<Long>();
    private Long iDepartmentId;
    private List<Long> iParentIds = new ArrayList<Long>();
    private Long iParentId;
    private Long iSessionId;
    private String iNumberOfWeeks;
    private Long iPreviousId;
    private Long iNextId;
    private List<Long> iChildrenIds = new ArrayList<Long>();
    private Long iChildId;

    public DatePatternEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iName == null || this.iName.trim().isEmpty()) {
            action.addFieldError("form.name", MSG.errorRequiredField(MSG.columnDatePatternName()));
        } else {
            try {
                DatePattern pat = DatePattern.findByName(this.iSessionId, this.iName);
                if (pat != null && !pat.getUniqueId().equals(this.iUniqueId)) {
                    action.addFieldError("form.name", MSG.errorAlreadyExists(this.iName));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.name", e.getMessage());
            }
        }
        if (this.getTypeInt() < 0) {
            action.addFieldError("form.type", MSG.errorRequiredField(MSG.columnDatePatternType()));
        }
        if (this.getTypeInt() != DatePattern.DatePatternType.Extended.ordinal() && !this.iDepartmentIds.isEmpty() && this.getTypeInt() != DatePattern.DatePatternType.PatternSet.ordinal()) {
            action.addFieldError("form.type", MSG.errorOnyExtDatePatternsHaveDepartments());
        }
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
            try {
                df.parse(this.getNumberOfWeeks());
            }
            catch (ParseException e) {
                action.addFieldError("form.numberOfWeeks", MSG.errorNumberOfWeeksIsNotNumber());
            }
        }
        try {
            DatePattern dp = this.getDatePattern(action.getRequest());
            if (this.getTypeInt() == DatePattern.DatePatternType.PatternSet.ordinal()) {
                if (dp.size() != 0) {
                    action.addFieldError("form.type", MSG.errorAltPatternSetCannotHaveDates());
                }
                if (this.getParentIds() != null && !this.getParentIds().isEmpty()) {
                    action.addFieldError("form.type", MSG.errorAltPatternSetCannotHavePatternSet());
                }
            } else if (dp.size() == 0) {
                action.addFieldError("form.pattern", MSG.errorRequiredField(MSG.columnDatePatternPattern()));
            }
            if (dp.getPattern().length() > 366) {
                action.addFieldError("form.pattern", MSG.errorDatePatternCannotContainMoreThanAYear());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iUniqueId = -1L;
        this.iType = DatePattern.DatePatternType.Standard.name();
        this.iIsUsed = false;
        this.iVisible = false;
        this.iName = "";
        this.iIsDefault = false;
        this.iNumberOfWeeks = null;
        this.iDepartmentId = null;
        this.iDepartmentIds.clear();
        this.iParentId = null;
        this.iParentIds.clear();
        this.iPreviousId = null;
        this.iNextId = null;
        this.iChildrenIds.clear();
        this.iChildId = null;
    }

    public void load(DatePattern dp) {
        if (dp == null) {
            this.reset();
            this.iOp = MSG.actionSaveDatePattern();
            this.iVisible = true;
            this.iIsUsed = false;
            this.iIsDefault = false;
        } else {
            this.setName(dp.getName());
            this.setVisible(dp.isVisible());
            this.setIsUsed(dp.isUsed());
            this.setTypeInt(dp.getType());
            this.setUniqueId(dp.getUniqueId());
            this.setIsDefault(dp.isDefault());
            this.setSessionId(dp.getSession().getUniqueId());
            DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
            this.setNumberOfWeeks(dp.getNumberOfWeeks() == null ? "" : df.format(dp.getNumberOfWeeks()));
            this.iParentIds.clear();
            TreeSet<DatePattern> parents = new TreeSet<DatePattern>(dp.getParents());
            for (DatePattern d : parents) {
                this.iParentIds.add(d.getUniqueId());
            }
            this.iDepartmentIds.clear();
            TreeSet<Department> depts = new TreeSet<Department>(dp.getDepartments());
            for (Department d : depts) {
                this.iDepartmentIds.add(d.getUniqueId());
            }
            this.iChildrenIds.clear();
            for (DatePattern ch : dp.getChildren()) {
                this.iChildrenIds.add(ch.getUniqueId());
            }
            this.iOp = MSG.actionUpdateDatePattern();
        }
    }

    public void update(DatePattern dp, HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        dp.setName(this.getName());
        dp.setVisible(this.getVisible());
        dp.setType(this.getTypeInt());
        dp.setPatternAndOffset(request);
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            try {
                DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
            }
            catch (ParseException e) {
                dp.setNumberOfWeeks(null);
            }
        } else {
            dp.setNumberOfWeeks(null);
        }
        HashSet<DatePattern> oldParents = new HashSet<DatePattern>(dp.getParents());
        for (Long l : this.iParentIds) {
            DatePattern datePattern = (DatePattern)DatePatternDAO.getInstance().get(l, hibSession);
            if (datePattern == null || oldParents.remove(datePattern)) continue;
            dp.getParents().add(datePattern);
            datePattern.getChildren().add(dp);
            hibSession.merge((Object)dp);
        }
        for (DatePattern datePattern : oldParents) {
            dp.getParents().remove(datePattern);
            datePattern.getChildren().remove(dp);
            hibSession.merge((Object)datePattern);
        }
        HashSet<Department> oldDepts = new HashSet<Department>(dp.getDepartments());
        for (Long l : this.iDepartmentIds) {
            Department department = (Department)DepartmentDAO.getInstance().get(l, hibSession);
            if (department == null || oldDepts.remove(department)) continue;
            dp.getDepartments().add(department);
            department.getDatePatterns().add(dp);
            hibSession.merge((Object)department);
        }
        for (Department department : oldDepts) {
            dp.getDepartments().remove(department);
            department.getDatePatterns().remove(dp);
            hibSession.merge((Object)department);
        }
        hibSession.merge((Object)dp);
        if (dp.isPatternSet()) {
            HashSet<DatePattern> hashSet = new HashSet<DatePattern>(dp.getChildren());
            for (Long l : this.iChildrenIds) {
                DatePattern d = (DatePattern)DatePatternDAO.getInstance().get(l, hibSession);
                if (d == null || hashSet.remove(d)) continue;
                d.getParents().add(dp);
                dp.getChildren().add(d);
                hibSession.merge((Object)d);
            }
            for (DatePattern datePattern : hashSet) {
                datePattern.getParents().remove(dp);
                dp.getChildren().remove(datePattern);
                hibSession.merge((Object)datePattern);
            }
        } else {
            HashSet<DatePattern> hashSet = new HashSet<DatePattern>(dp.getChildren());
            for (DatePattern datePattern : hashSet) {
                datePattern.getParents().remove(dp);
                dp.getChildren().remove(datePattern);
                hibSession.merge((Object)datePattern);
            }
        }
    }

    public DatePattern create(HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        DatePattern dp = new DatePattern();
        dp.setName(this.getName());
        dp.setSession((Session)SessionDAO.getInstance().get(this.getSessionId(), hibSession));
        dp.setVisible(this.getVisible());
        dp.setType(this.getTypeInt());
        dp.setPatternAndOffset(request);
        if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
            try {
                DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
            }
            catch (ParseException e) {
                dp.setNumberOfWeeks(null);
            }
        } else {
            dp.setNumberOfWeeks(null);
        }
        HashSet<DatePattern> newParents = new HashSet<DatePattern>();
        for (Long l : this.iParentIds) {
            DatePattern datePattern = (DatePattern)DatePatternDAO.getInstance().get(l, hibSession);
            if (datePattern == null) continue;
            newParents.add(datePattern);
            datePattern.getChildren().add(dp);
        }
        dp.setParents(newParents);
        HashSet<Department> newDepts = new HashSet<Department>();
        for (Long l : this.iDepartmentIds) {
            Department d = (Department)DepartmentDAO.getInstance().get(l, hibSession);
            if (d == null) continue;
            newDepts.add(d);
        }
        dp.setDepartments(newDepts);
        hibSession.persist((Object)dp);
        for (Department department : newDepts) {
            department.getDatePatterns().add(dp);
            hibSession.merge((Object)department);
        }
        this.setUniqueId(dp.getUniqueId());
        if (dp.isPatternSet()) {
            HashSet<DatePattern> hashSet = new HashSet<DatePattern>();
            for (Long childId : this.iChildrenIds) {
                DatePattern d = (DatePattern)DatePatternDAO.getInstance().get(childId, hibSession);
                if (d == null) continue;
                d.getParents().add(dp);
                hashSet.add(d);
                hibSession.merge((Object)d);
            }
            dp.setChildren(hashSet);
        }
        return dp;
    }

    public DatePattern saveOrUpdate(HttpServletRequest request, org.hibernate.Session hibSession) throws Exception {
        DatePattern dp = null;
        if (this.getUniqueId() >= 0L) {
            dp = (DatePattern)DatePatternDAO.getInstance().get(this.getUniqueId());
        }
        if (dp == null) {
            dp = this.create(request, hibSession);
        } else {
            this.update(dp, request, hibSession);
        }
        return dp;
    }

    public void delete(org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId() < 0L) {
            return;
        }
        if (this.getIsUsed()) {
            return;
        }
        DatePattern dp = (DatePattern)DatePatternDAO.getInstance().get(this.getUniqueId(), hibSession);
        for (Department department : dp.getDepartments()) {
            department.getDatePatterns().remove(dp);
            hibSession.merge((Object)department);
        }
        for (DatePattern datePattern : dp.getChildren()) {
            datePattern.getParents().remove(dp);
            hibSession.merge((Object)datePattern);
        }
        dp.getChildren().clear();
        for (DatePattern datePattern : dp.getParents()) {
            datePattern.getChildren().remove(dp);
            hibSession.merge((Object)datePattern);
        }
        dp.getParents().clear();
        hibSession.merge((Object)dp);
        hibSession.remove((Object)dp);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public List<ComboBoxLookup> getTypes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (DatePattern.DatePatternType t : DatePattern.DatePatternType.values()) {
            ret.add(new ComboBoxLookup(t.getLabel(), t.name()));
        }
        return ret;
    }

    public int getTypeInt() {
        for (int i = 0; i < DatePattern.DatePatternType.values().length; ++i) {
            if (!DatePattern.DatePatternType.values()[i].name().equals(this.iType)) continue;
            return i;
        }
        return -1;
    }

    public void setTypeInt(int type) {
        this.iType = type < 0 ? "" : DatePattern.DatePatternType.values()[type].name();
    }

    public boolean getIsUsed() {
        return this.iIsUsed;
    }

    public void setIsUsed(boolean isUsed) {
        this.iIsUsed = isUsed;
    }

    public boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(boolean visible) {
        this.iVisible = visible;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public boolean getIsDefault() {
        return this.iIsDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.iIsDefault = isDefault;
    }

    public List<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(List<Long> departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentIds(int idx) {
        return this.iDepartmentIds.get(idx);
    }

    public void setDepartmentIds(int idx, Long value) {
        this.iDepartmentIds.set(idx, value);
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long deptId) {
        this.iDepartmentId = deptId;
    }

    public Long getParentId() {
        return this.iParentId;
    }

    public void setParentId(Long parentId) {
        this.iParentId = parentId;
    }

    public List<Long> getParentIds() {
        return this.iParentIds;
    }

    public void setParentIds(List<Long> parentIds) {
        this.iParentIds = parentIds;
    }

    public Long getParentIds(int idx) {
        return this.iParentIds.get(idx);
    }

    public void setParentIds(int idx, Long value) {
        this.iParentIds.set(idx, value);
    }

    public String getNumberOfWeeks() {
        return this.iNumberOfWeeks;
    }

    public void setNumberOfWeeks(String numberOfWeeks) {
        this.iNumberOfWeeks = numberOfWeeks;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getNextId() {
        return this.iNextId;
    }

    public void setNextId(Long nextId) {
        this.iNextId = nextId;
    }

    public boolean getHasNext() {
        return this.iNextId != null && this.iNextId >= 0L;
    }

    public Long getPreviousId() {
        return this.iPreviousId;
    }

    public void setPreviousId(Long previousId) {
        this.iPreviousId = previousId;
    }

    public boolean getHasPrevious() {
        return this.iPreviousId != null && this.iPreviousId >= 0L;
    }

    public Long getChildId() {
        return this.iChildId;
    }

    public void setChildId(Long childId) {
        this.iChildId = childId;
    }

    public List<Long> getChildrenIds() {
        return this.iChildrenIds;
    }

    public void setChildrenIds(List<Long> ChildrenIds) {
        this.iChildrenIds = ChildrenIds;
    }

    public Long getChildrenIds(int idx) {
        return this.iChildrenIds.get(idx);
    }

    public void setChildrenIds(int idx, Long value) {
        this.iChildrenIds.set(idx, value);
    }

    public DatePattern getDatePattern(HttpServletRequest request) throws Exception {
        BaseDatePattern dp = null;
        if (this.getUniqueId() != null && (dp = (DatePattern)DatePatternDAO.getInstance().get(this.getUniqueId())) != null) {
            dp = (DatePattern)((DatePattern)dp).clone();
        }
        if (dp == null) {
            dp = new DatePattern();
        }
        if (dp.getSession() == null) {
            dp.setSession((Session)SessionDAO.getInstance().get(this.getSessionId()));
        }
        if (request.getParameter("cal_select") != null) {
            dp.setName(this.getName());
            dp.setVisible(this.getVisible());
            dp.setType(this.getTypeInt());
            ((DatePattern)dp).setPatternAndOffset(request);
            if (this.getNumberOfWeeks() != null && !this.getNumberOfWeeks().isEmpty()) {
                try {
                    DecimalFormat df = new DecimalFormat("0.##", new DecimalFormatSymbols(Localization.getJavaLocale()));
                    dp.setNumberOfWeeks(Float.valueOf(df.parse(this.getNumberOfWeeks()).floatValue()));
                }
                catch (ParseException e) {
                    dp.setNumberOfWeeks(null);
                }
            } else {
                dp.setNumberOfWeeks(null);
            }
        }
        return dp;
    }
}

