/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hibernate.Session;
import org.unitime.timetable.api.ApiToken;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class ExportServletHelper
implements ExportHelper {
    private SessionContext iContext;
    private Exporter.Params iParams;
    private HttpServletResponse iResponse;
    private PrintWriter iWriter = null;
    private OutputStream iOutputStream = null;

    public ExportServletHelper(HttpServletRequest request, HttpServletResponse response, SessionContext context) throws UnsupportedEncodingException {
        this.iResponse = response;
        this.iContext = context;
        String q = request.getParameter("q");
        String x = request.getParameter("x");
        this.iParams = q != null ? new QParams(q, false) : (x != null ? new QParams(x, true) : new HttpParams(request));
        if (!context.isAuthenticated() || context.getUser() instanceof AnonymousUserContext) {
            String user;
            UserContext uc = null;
            String token = this.getParameter("token");
            if (token != null && ApplicationProperty.ApiCanUseAPIToken.isTrue()) {
                uc = ((ApiToken)SpringApplicationContextHolder.getBean("apiToken")).getContext(this.getParameter("token"));
                if (uc != null) {
                    this.iContext = new CustomExportContext(request.getSession(), uc);
                }
            } else if (this.isRequestEncoded() && (user = this.getParameter("user")) != null) {
                uc = new UniTimeUserContext(user, null, null, null);
            }
            if (uc != null) {
                String role = this.getParameter("role");
                Long sessionId = this.getAcademicSessionId();
                if (role != null && sessionId != null) {
                    for (UserAuthority userAuthority : uc.getAuthorities()) {
                        if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(sessionId) || !role.equals(userAuthority.getRole())) continue;
                        uc.setCurrentAuthority(userAuthority);
                        break;
                    }
                }
                this.iContext = new CustomExportContext(request.getSession(), uc);
            }
        }
    }

    @Override
    public void setup(String content, String fileName, boolean binary) {
        this.iResponse.setContentType((String)("text/calendar".equalsIgnoreCase(content) ? content : content + "; charset=UTF-8"));
        this.iResponse.setCharacterEncoding("UTF-8");
        this.iResponse.setHeader("Pragma", "no-cache");
        this.iResponse.addHeader("Cache-Control", "must-revalidate");
        this.iResponse.addHeader("Cache-Control", "no-cache");
        this.iResponse.addHeader("Cache-Control", "no-store");
        this.iResponse.setDateHeader("Date", new Date().getTime());
        this.iResponse.setDateHeader("Expires", 0L);
        this.iResponse.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    @Override
    public String getParameter(String name) {
        return this.iParams.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.iParams.getParameterValues(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.iParams.getParameterNames();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.iWriter == null) {
            this.iWriter = this.iResponse.getWriter();
        }
        return this.iWriter;
    }

    public boolean hasWriter() {
        return this.iWriter != null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.iOutputStream == null) {
            this.iOutputStream = this.iResponse.getOutputStream();
        }
        return this.iOutputStream;
    }

    public boolean hasOutputStream() {
        return this.iOutputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getAcademicSessionId() {
        Long sessionId = null;
        sessionId = this.iParams.getParameter("sid") != null ? Long.valueOf(this.iParams.getParameter("sid")) : (this.iContext.isAuthenticated() ? (Long)(this.iContext.getUser().getCurrentAuthority() == null ? null : this.iContext.getUser().getCurrentAuthority().getAcademicSession().getQualifierId()) : (Long)this.iContext.getAttribute("sessionId"));
        if (this.iParams.getParameter("term") != null) {
            try (Session hibSession = SessionDAO.getInstance().getSession();){
                List sessions = hibSession.createQuery("select s.uniqueId from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term", Long.class).setParameter("term", (Object)this.iParams.getParameter("term")).list();
                if (!sessions.isEmpty()) {
                    sessionId = (Long)sessions.get(0);
                }
            }
        }
        return sessionId;
    }

    @Override
    public SessionContext getSessionContext() {
        return this.iContext;
    }

    @Override
    public boolean isRequestEncoded() {
        return this.iParams instanceof QParams;
    }

    public static class QParams
    implements Exporter.Params {
        private Map<String, List<String>> iParams = new HashMap<String, List<String>>();

        QParams(String q, boolean hash) throws UnsupportedEncodingException {
            for (String p : QueryEncoderBackend.decode(q, hash).split("&")) {
                String name = p.substring(0, p.indexOf(61));
                String value = URLDecoder.decode(p.substring(p.indexOf(61) + 1), "UTF-8");
                List<String> values = this.iParams.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.iParams.put(name, values);
                }
                values.add(value);
            }
        }

        @Override
        public String getParameter(String name) {
            List<String> values = this.iParams.get(name);
            return values == null || values.isEmpty() ? null : values.get(0);
        }

        @Override
        public String[] getParameterValues(String name) {
            List<String> values = this.iParams.get(name);
            if (values == null) {
                return null;
            }
            String[] ret = new String[values.size()];
            values.toArray(ret);
            return ret;
        }

        @Override
        public Enumeration<String> getParameterNames() {
            final Iterator<String> iterator = this.iParams.keySet().iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
    }

    public static class HttpParams
    implements Exporter.Params {
        HttpServletRequest iRequest;

        HttpParams(HttpServletRequest request) {
            this.iRequest = request;
        }

        @Override
        public String getParameter(String name) {
            return this.iRequest.getParameter(name);
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.iRequest.getParameterValues(name);
        }

        @Override
        public Enumeration<String> getParameterNames() {
            return this.iRequest.getParameterNames();
        }
    }

    public class CustomExportContext
    extends HttpSessionContext {
        private UserContext iUser;

        public CustomExportContext(HttpSession session, UserContext user) {
            super(session);
            this.iUser = user;
        }

        @Override
        public boolean isAuthenticated() {
            return this.iUser != null;
        }

        @Override
        public UserContext getUser() {
            return this.iUser;
        }
    }
}

