/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.widgets.WeekSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=WeekSelector.WeekSelectorRequest.class)
public class WeekSelectorBackend
implements GwtRpcImplementation<WeekSelector.WeekSelectorRequest, GwtRpcResponseList<EventInterface.WeekInterface>> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public GwtRpcResponseList<EventInterface.WeekInterface> execute(WeekSelector.WeekSelectorRequest command, SessionContext context) {
        GwtRpcResponseList<EventInterface.WeekInterface> ret = new GwtRpcResponseList<EventInterface.WeekInterface>();
        Session session = (Session)SessionDAO.getInstance().get(command.getSessionId());
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(session.getEventBeginDate());
        int firstDayOfWeek = ApplicationProperty.EventGridStartDay.intValue();
        int firstDay = 2;
        switch (firstDayOfWeek) {
            case 0: {
                firstDay = 2;
                break;
            }
            case 1: {
                firstDay = 3;
                break;
            }
            case 2: {
                firstDay = 4;
                break;
            }
            case 3: {
                firstDay = 5;
                break;
            }
            case 4: {
                firstDay = 6;
                break;
            }
            case 5: {
                firstDay = 7;
                break;
            }
            case 6: {
                firstDay = 1;
            }
        }
        while (c.get(7) != firstDay) {
            c.add(6, -1);
        }
        int sessionYear = session.getSessionStartYear();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
        while (!c.getTime().after(session.getEventEndDate())) {
            Calendar x;
            int dayOfYear = c.get(6);
            if (c.get(1) < sessionYear) {
                x = Calendar.getInstance(Locale.US);
                x.set(c.get(1), 11, 31, 0, 0, 0);
                x.clear(14);
                dayOfYear -= x.get(6);
            } else if (c.get(1) > sessionYear) {
                x = Calendar.getInstance(Locale.US);
                x.set(sessionYear, 11, 31, 0, 0, 0);
                x.clear(14);
                dayOfYear += x.get(6);
            }
            EventInterface.WeekInterface week = new EventInterface.WeekInterface();
            week.setDayOfYear(dayOfYear);
            for (int i = 0; i < 7; ++i) {
                week.addDayName(new EventInterface.DateInterface(df.format(c.getTime()), c.get(2) + 1, c.get(5)));
                c.add(6, 1);
            }
            ret.add(week);
        }
        return ret;
    }
}

