/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Service;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.util.queue.QueueMessage;

@Service(value="dataExchangeHelper")
public class DataExchangeIntegrationHelper {
    public Document file2document(File file) throws DocumentException {
        return new SAXReader().read(file);
    }

    public String exception2message(Exception exception) throws IOException {
        StringWriter out = new StringWriter();
        exception.printStackTrace(new PrintWriter(out));
        out.flush();
        out.close();
        return out.toString();
    }

    public String importDocument(Document document) throws Exception {
        final StringBuffer log = new StringBuffer("<html><header><title>XML Import Log</title></header><body>\n");
        Log logger = new Log(){

            protected void log(QueueMessage.Level level, Object message, Throwable t) {
                log.append(new QueueMessage(level, message, t).toHTML() + "<br>\n");
            }

            public void warn(Object message, Throwable t) {
                this.log(QueueMessage.Level.WARN, message, t);
            }

            public void warn(Object message) {
                this.log(QueueMessage.Level.WARN, message, null);
            }

            public void trace(Object message, Throwable t) {
                this.log(QueueMessage.Level.TRACE, message, t);
            }

            public void trace(Object message) {
                this.log(QueueMessage.Level.TRACE, message, null);
            }

            public boolean isWarnEnabled() {
                return true;
            }

            public boolean isTraceEnabled() {
                return false;
            }

            public boolean isInfoEnabled() {
                return true;
            }

            public boolean isFatalEnabled() {
                return true;
            }

            public boolean isErrorEnabled() {
                return true;
            }

            public boolean isDebugEnabled() {
                return false;
            }

            public void info(Object message, Throwable t) {
                this.log(QueueMessage.Level.INFO, message, t);
            }

            public void info(Object message) {
                this.log(QueueMessage.Level.INFO, message, null);
            }

            public void fatal(Object message, Throwable t) {
                this.log(QueueMessage.Level.FATAL, message, t);
            }

            public void fatal(Object message) {
                this.log(QueueMessage.Level.FATAL, message, null);
            }

            public void error(Object message, Throwable t) {
                this.log(QueueMessage.Level.ERROR, message, t);
            }

            public void error(Object message) {
                this.log(QueueMessage.Level.ERROR, message, null);
            }

            public void debug(Object message, Throwable t) {
                this.log(QueueMessage.Level.DEBUG, message, t);
            }

            public void debug(Object message) {
                this.log(QueueMessage.Level.DEBUG, message, null);
            }
        };
        String manager = document.getRootElement().attributeValue("manager", ApplicationProperty.DataExchangeXmlManager.value());
        DataExchangeHelper.importDocument(document, manager, logger);
        log.append("</body></html>");
        return log.toString();
    }
}

