/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.CrossListsModifyForm;
import org.unitime.timetable.interfaces.ExternalCourseCrosslistAction;
import org.unitime.timetable.interfaces.ExternalCourseOfferingRemoveAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingInCrosslistAddAction;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Action(value="crossListsModify", results={@Result(name={"crossListsModify"}, type="tiles", location="crossListsModify.tiles"), @Result(name={"instructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"io", "${form.instrOfferingId}", "op", "view"})})
@TilesDefinition(name="crossListsModify.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructional Offering Cross Lists"), @TilesPutAttribute(name="body", value="/user/crossListsModify.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})
public class CrossListsModifyAction
extends UniTimeAction<CrossListsModifyForm> {
    private static final long serialVersionUID = -6417943409851586772L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op2 = null;
    protected Long uid = null;
    protected Long deletedCourseOfferingId = null;

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Long getDeletedCourseOfferingId() {
        return this.deletedCourseOfferingId;
    }

    public void setDeletedCourseOfferingId(Long deletedCourseOfferingId) {
        this.deletedCourseOfferingId = deletedCourseOfferingId;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new CrossListsModifyForm();
        }
        if (this.op == null) {
            this.op = ((CrossListsModifyForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + this.op);
        }
        if (this.op.equals(MSG.actionBackToIODetail())) {
            return "instructionalOfferingDetail";
        }
        ((CrossListsModifyForm)this.form).setOp(this.op);
        LookupTables.setupCourseOfferings(this.request, this.sessionContext, new LookupTables.CourseFilter(){

            @Override
            public boolean accept(CourseOffering course) {
                return course.getInstructionalOffering().isNotOffered();
            }
        });
        if (this.op.equalsIgnoreCase(MSG.actionCrossLists())) {
            this.doLoad(this.uid);
        }
        if (this.op.equalsIgnoreCase(MSG.actionAddCourseToCrossList())) {
            ((CrossListsModifyForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                Long addedOffering = ((CrossListsModifyForm)this.form).getAddCourseOfferingId();
                CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
                CourseOffering co = (CourseOffering)cdao.get(addedOffering);
                ((CrossListsModifyForm)this.form).addToCourseOfferings(co, this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) || this.sessionContext.getUser().getCurrentAuthority().hasQualifier(co.getDepartment()), true);
                ((CrossListsModifyForm)this.form).setAddCourseOfferingId(null);
            }
        }
        if (this.op.equalsIgnoreCase("Delete") && this.deletedCourseOfferingId != null) {
            ((CrossListsModifyForm)this.form).removeFromCourseOfferings(this.deletedCourseOfferingId);
        }
        if (this.op.equalsIgnoreCase(MSG.actionUpdateCrossLists())) {
            ((CrossListsModifyForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate();
                return "instructionalOfferingDetail";
            }
        }
        this.setReadOnlyCourseId();
        this.filterCourseOfferingList();
        return "crossListsModify";
    }

    private void filterCourseOfferingList() {
        List<Long> existingOfferings = ((CrossListsModifyForm)this.form).getCourseOfferingIds();
        Collection offerings = (Collection)this.request.getAttribute("crsOfferingList");
        Iterator i = offerings.iterator();
        while (i.hasNext()) {
            CourseOffering co = (CourseOffering)i.next();
            if (!co.getInstructionalOffering().isNotOffered().booleanValue() && !co.getInstructionalOffering().getInstrOfferingConfigs().isEmpty() || co.getInstructionalOffering().getCourseOfferings().size() > 1) {
                i.remove();
                continue;
            }
            for (Long courseId : existingOfferings) {
                if (!courseId.equals(co.getUniqueId())) continue;
                i.remove();
            }
        }
        this.request.setAttribute("crsOfferingList", (Object)offerings);
    }

    private void setReadOnlyCourseId() {
        int ct = 0;
        List<Long> originalOfferings = ((CrossListsModifyForm)this.form).getOriginalOfferings();
        List<Long> courseOfferingIds = ((CrossListsModifyForm)this.form).getCourseOfferingIds();
        for (Long cid : courseOfferingIds) {
            if (originalOfferings.indexOf(cid) < 0) continue;
            if ((ct = (int)((short)(ct + 1))) > 1) {
                ((CrossListsModifyForm)this.form).setReadOnlyCrsOfferingId(null);
                break;
            }
            ((CrossListsModifyForm)this.form).setReadOnlyCrsOfferingId((long)cid);
        }
        Debug.debug("Read Only Ctr Course: " + ((CrossListsModifyForm)this.form).getReadOnlyCrsOfferingId());
    }

    /*
     * WARNING - void declaration
     */
    private void doUpdate() throws Exception {
        List<Long> courseIds = ((CrossListsModifyForm)this.form).getCourseOfferingIds();
        List<Long> origCourseIds = ((CrossListsModifyForm)this.form).getOriginalOfferings();
        CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
        InstructionalOfferingDAO idao = InstructionalOfferingDAO.getInstance();
        InstructionalOffering io = (InstructionalOffering)idao.get(((CrossListsModifyForm)this.form).getInstrOfferingId());
        Session hibSession = idao.getSession();
        hibSession.setHibernateFlushMode(FlushMode.MANUAL);
        Transaction tx = null;
        ArrayList<CurriculumCourse> cc = new ArrayList<CurriculumCourse>();
        ArrayList<CourseRequest> courseRequests = new ArrayList<CourseRequest>();
        HashMap<String, List> advCourseReqs = new HashMap<String, List>();
        try {
            List acrs;
            void var13_18;
            CourseOffering co1;
            tx = hibSession.beginTransaction();
            ArrayList<CourseOffering> deletedOfferings = new ArrayList<CourseOffering>();
            for (Long l : origCourseIds) {
                if (courseIds.indexOf(l) < 0) {
                    Object oldReq22;
                    Debug.debug("Course removed from offering: " + l);
                    InstructionalOffering instructionalOffering = new InstructionalOffering();
                    co1 = (CourseOffering)cdao.get(l);
                    SubjectArea sa1 = co1.getSubjectArea();
                    this.sessionContext.checkPermission(co1, Right.CourseOfferingDeleteFromCrossList);
                    instructionalOffering.setNotOffered(true);
                    instructionalOffering.setSession(io.getSession());
                    instructionalOffering.setByReservationOnly(io.getByReservationOnly());
                    CourseOffering co2 = (CourseOffering)co1.clone();
                    co2.setIsControl(true);
                    for (CurriculumCourse x : hibSession.createQuery("from CurriculumCourse where course.uniqueId = :courseId", CurriculumCourse.class).setParameter("courseId", (Object)co1.getUniqueId()).list()) {
                        cc.add(x.clone(co2));
                        x.getClassification().getCourses().remove(x);
                        hibSession.remove((Object)x);
                    }
                    if (ApplicationProperty.ModifyCrossListKeepCourseRequests.isTrue()) {
                        for (Object oldReq22 : hibSession.createQuery("from CourseRequest where courseOffering.uniqueId = :courseId", CourseRequest.class).setParameter("courseId", (Object)co1.getUniqueId()).list()) {
                            CourseRequest newReq = new CourseRequest();
                            newReq.setAllowOverlap(((BaseCourseRequest)oldReq22).getAllowOverlap());
                            newReq.setOrder(((BaseCourseRequest)oldReq22).getOrder());
                            newReq.setCredit(((BaseCourseRequest)oldReq22).getCredit());
                            newReq.setCourseOffering(co2);
                            newReq.setCourseDemand(((BaseCourseRequest)oldReq22).getCourseDemand());
                            ((BaseCourseRequest)oldReq22).getCourseDemand().getCourseRequests().remove(oldReq22);
                            courseRequests.add(newReq);
                            hibSession.remove(oldReq22);
                        }
                    }
                    List acrs2 = hibSession.createQuery("from AdvisorCourseRequest where courseOffering.uniqueId = :courseId", AdvisorCourseRequest.class).setParameter("courseId", (Object)co1.getUniqueId()).list();
                    advCourseReqs.put(co2.getCourseName(), acrs2);
                    oldReq22 = acrs2.iterator();
                    while (oldReq22.hasNext()) {
                        AdvisorCourseRequest acr = (AdvisorCourseRequest)oldReq22.next();
                        acr.setCourseOffering(null);
                    }
                    deletedOfferings.add(co2);
                    Set<CourseOffering> offerings = io.getCourseOfferings();
                    for (CourseOffering co3 : offerings) {
                        if (!co3.equals(co1)) continue;
                        SubjectArea sa = co3.getSubjectArea();
                        sa.getCourseOfferings().remove(co1);
                        hibSession.merge((Object)sa);
                    }
                    sa1.getCourseOfferings().remove(co1);
                    hibSession.merge((Object)sa1);
                    io.removeCourseOffering(co1);
                    Event.deleteFromEvents(hibSession, co1);
                    Exam.deleteFromExams(hibSession, co1);
                    String className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
                    if (className != null && className.trim().length() > 0) {
                        ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        removeAction.performExternalCourseOfferingRemoveAction(co1, hibSession);
                    }
                    hibSession.remove((Object)co1);
                    hibSession.merge((Object)io);
                    hibSession.flush();
                    co2.setInstructionalOffering(instructionalOffering);
                    instructionalOffering.addToCourseOfferings(co2);
                    if (instructionalOffering.getInstrOfferingPermId() == null) {
                        instructionalOffering.generateInstrOfferingPermId();
                    }
                    hibSession.persist((Object)instructionalOffering);
                    hibSession.flush();
                    className = ApplicationProperty.ExternalActionInstructionalOfferingInCrosslistAdd.value();
                    if (className == null || className.trim().length() <= 0) continue;
                    ExternalInstructionalOfferingInCrosslistAddAction addAction = (ExternalInstructionalOfferingInCrosslistAddAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    addAction.performExternalInstructionalOfferingInCrosslistAddAction(instructionalOffering, hibSession);
                    continue;
                }
                Debug.debug("Updating controlling course  and course reservation: " + l);
                CourseOffering courseOffering = (CourseOffering)cdao.get(Long.valueOf(l));
                if (((CrossListsModifyForm)this.form).getCtrlCrsOfferingId().equals(courseOffering.getUniqueId())) {
                    courseOffering.setIsControl(true);
                } else {
                    courseOffering.setIsControl(false);
                }
                int indx = ((CrossListsModifyForm)this.form).getIndex(l);
                try {
                    if (ApplicationProperty.ModifyCrossListSingleCourseLimit.isTrue()) {
                        courseOffering.setReservation(((CrossListsModifyForm)this.form).getLimits(indx));
                    } else {
                        courseOffering.setReservation(courseIds.size() > 1 ? ((CrossListsModifyForm)this.form).getLimits(indx) : null);
                    }
                }
                catch (NumberFormatException e) {
                    courseOffering.setReservation(null);
                }
                hibSession.merge((Object)courseOffering);
                hibSession.flush();
            }
            ArrayList<CourseOffering> addedOfferings = new ArrayList<CourseOffering>();
            for (Long l : courseIds) {
                if (origCourseIds.indexOf(l) >= 0) continue;
                Debug.debug("Course added to offering: " + l);
                co1 = (CourseOffering)cdao.get(l);
                Iterator io1 = co1.getInstructionalOffering();
                SubjectArea sa = ((InstructionalOffering)((Object)io1)).getControllingCourseOffering().getSubjectArea();
                Set<CourseOffering> offerings = ((BaseInstructionalOffering)((Object)io1)).getCourseOfferings();
                for (CourseOffering co2 : offerings) {
                    Object oldReq32;
                    SubjectArea sa2 = co2.getSubjectArea();
                    CourseOffering co3 = (CourseOffering)co2.clone();
                    if (((CrossListsModifyForm)this.form).getCtrlCrsOfferingId().equals(co2.getUniqueId())) {
                        co3.setIsControl(true);
                    } else {
                        co3.setIsControl(false);
                    }
                    for (CurriculumCourse x : hibSession.createQuery("from CurriculumCourse where course.uniqueId = :courseId", CurriculumCourse.class).setParameter("courseId", (Object)co2.getUniqueId()).list()) {
                        cc.add(x.clone(co3));
                        x.getClassification().getCourses().remove(x);
                        hibSession.remove((Object)x);
                    }
                    if (ApplicationProperty.ModifyCrossListKeepCourseRequests.isTrue()) {
                        for (Object oldReq32 : hibSession.createQuery("from CourseRequest where courseOffering.uniqueId = :courseId", CourseRequest.class).setParameter("courseId", (Object)co2.getUniqueId()).list()) {
                            CourseRequest newReq = new CourseRequest();
                            newReq.setAllowOverlap(((BaseCourseRequest)oldReq32).getAllowOverlap());
                            newReq.setOrder(((BaseCourseRequest)oldReq32).getOrder());
                            newReq.setCredit(((BaseCourseRequest)oldReq32).getCredit());
                            newReq.setCourseOffering(co3);
                            newReq.setCourseDemand(((BaseCourseRequest)oldReq32).getCourseDemand());
                            ((BaseCourseRequest)oldReq32).getCourseDemand().getCourseRequests().remove(oldReq32);
                            courseRequests.add(newReq);
                            hibSession.remove(oldReq32);
                        }
                    }
                    List acrs3 = hibSession.createQuery("from AdvisorCourseRequest where courseOffering.uniqueId = :courseId", AdvisorCourseRequest.class).setParameter("courseId", (Object)co2.getUniqueId()).list();
                    advCourseReqs.put(co3.getCourseName(), acrs3);
                    addedOfferings.add(co3);
                    oldReq32 = acrs3.iterator();
                    while (oldReq32.hasNext()) {
                        AdvisorCourseRequest acr = (AdvisorCourseRequest)oldReq32.next();
                        acr.setCourseOffering(null);
                    }
                    int indx = ((CrossListsModifyForm)this.form).getIndex(l);
                    try {
                        co3.setReservation(((CrossListsModifyForm)this.form).getLimits(indx));
                    }
                    catch (NumberFormatException e) {
                        co3.setReservation(null);
                    }
                    sa2.getCourseOfferings().remove(co2);
                    hibSession.merge((Object)sa2);
                    ((InstructionalOffering)((Object)io1)).removeCourseOffering(co2);
                    Event.deleteFromEvents(hibSession, co2);
                    Exam.deleteFromExams(hibSession, co2);
                    String className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
                    if (className != null && className.trim().length() > 0) {
                        ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        removeAction.performExternalCourseOfferingRemoveAction(co2, hibSession);
                    }
                    hibSession.remove((Object)co2);
                    hibSession.flush();
                }
                Event.deleteFromEvents(hibSession, (InstructionalOffering)((Object)io1));
                Exam.deleteFromExams(hibSession, (InstructionalOffering)((Object)io1));
                hibSession.remove((Object)io1);
                hibSession.flush();
                hibSession.merge((Object)sa);
            }
            hibSession.flush();
            boolean bl = false;
            while (var13_18 < addedOfferings.size()) {
                CourseOffering courseOffering = (CourseOffering)addedOfferings.get((int)var13_18);
                courseOffering.setInstructionalOffering(io);
                io.addToCourseOfferings(courseOffering);
                hibSession.persist((Object)courseOffering);
                hibSession.flush();
                hibSession.merge((Object)io);
                ++var13_18;
            }
            for (CurriculumCourse curriculumCourse : cc) {
                hibSession.persist((Object)curriculumCourse);
            }
            for (CourseRequest courseRequest : courseRequests) {
                courseRequest.getCourseDemand().getCourseRequests().add(courseRequest);
                hibSession.persist((Object)courseRequest);
            }
            for (CourseOffering courseOffering : deletedOfferings) {
                acrs = (List)advCourseReqs.get(courseOffering.getCourseName());
                if (acrs == null) continue;
                for (AdvisorCourseRequest req : acrs) {
                    req.setCourseOffering(courseOffering);
                    Iterator<AdvisorSectioningPref> ip = req.getPreferences().iterator();
                    while (ip.hasNext()) {
                        AdvisorSectioningPref p = ip.next();
                        if (!(p instanceof AdvisorClassPref)) continue;
                        hibSession.remove((Object)p);
                        ip.remove();
                    }
                    hibSession.merge((Object)req);
                }
            }
            for (CourseOffering courseOffering : addedOfferings) {
                acrs = (List)advCourseReqs.get(courseOffering.getCourseName());
                if (acrs == null) continue;
                for (AdvisorCourseRequest req : acrs) {
                    req.setCourseOffering(courseOffering);
                    hibSession.merge((Object)req);
                }
            }
            Department department = io.getControllingCourseOffering().getDepartment();
            Set<InstrOfferingConfig> set = io.getInstrOfferingConfigs();
            for (InstrOfferingConfig cfg : set) {
                Set<SchedulingSubpart> subparts = cfg.getSchedulingSubparts();
                for (SchedulingSubpart subpart : subparts) {
                    Set<Class_> classes = subpart.getClasses();
                    for (Class_ cls : classes) {
                        if (!cls.getManagingDept().isExternalManager().booleanValue()) {
                            cls.setManagingDept(department, this.sessionContext.getUser(), hibSession);
                            hibSession.merge((Object)cls);
                        }
                        Iterator<ClassInstructor> i = cls.getClassInstructors().iterator();
                        while (i.hasNext()) {
                            DepartmentalInstructor di;
                            ClassInstructor ci = i.next();
                            if (ci.getInstructor().getDepartment().equals(department)) continue;
                            ci.getInstructor().getClasses().remove(ci);
                            DepartmentalInstructor departmentalInstructor = di = ci.getInstructor().getExternalUniqueId() == null ? null : DepartmentalInstructor.findByPuidDepartmentId(ci.getInstructor().getExternalUniqueId(), department.getUniqueId(), hibSession);
                            if (di == null) {
                                hibSession.remove((Object)ci);
                                i.remove();
                                continue;
                            }
                            ci.setInstructor(di);
                            di.getClasses().add(ci);
                            hibSession.merge((Object)ci);
                        }
                    }
                }
            }
            if (io.getOfferingCoordinators() != null) {
                Iterator<OfferingCoordinator> i = io.getOfferingCoordinators().iterator();
                while (i.hasNext()) {
                    DepartmentalInstructor di;
                    OfferingCoordinator oc = i.next();
                    if (oc.getInstructor().getDepartment().equals(department)) continue;
                    oc.getInstructor().getOfferingCoordinators().remove(oc);
                    DepartmentalInstructor departmentalInstructor = di = oc.getInstructor().getExternalUniqueId() == null ? null : DepartmentalInstructor.findByPuidDepartmentId(oc.getInstructor().getExternalUniqueId(), department.getUniqueId(), hibSession);
                    if (di == null) {
                        hibSession.remove((Object)oc);
                        i.remove();
                        continue;
                    }
                    oc.setInstructor(di);
                    di.getOfferingCoordinators().add(oc);
                    hibSession.merge((Object)oc);
                }
            }
            ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.CROSS_LIST, ChangeLog.Operation.UPDATE, io.getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            hibSession.flush();
            hibSession.clear();
            String className = ApplicationProperty.ExternalActionCourseCrosslist.value();
            if (className != null && className.trim().length() > 0) {
                ExternalCourseCrosslistAction addAction = (ExternalCourseCrosslistAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addAction.performExternalCourseCrosslistAction(io, hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void doLoad(Long courseOfferingId) throws Exception {
        if (courseOfferingId == null) {
            throw new Exception(MSG.errorUniqueIdNeeded());
        }
        CourseOfferingDAO coDao = CourseOfferingDAO.getInstance();
        CourseOffering co = (CourseOffering)coDao.get(courseOfferingId);
        InstructionalOffering io = co.getInstructionalOffering();
        this.sessionContext.checkPermission(io, Right.InstructionalOfferingCrossLists);
        ArrayList<CourseOffering> offerings = new ArrayList<CourseOffering>(io.getCourseOfferings());
        Collections.sort(offerings, new CourseOfferingComparator(2));
        ((CrossListsModifyForm)this.form).setInstrOfferingId(io.getUniqueId());
        ((CrossListsModifyForm)this.form).setCtrlCrsOfferingId(io.getControllingCourseOffering().getUniqueId());
        ((CrossListsModifyForm)this.form).setReadOnlyCrsOfferingId(null);
        ((CrossListsModifyForm)this.form).setSubjectAreaId(co.getSubjectArea().getUniqueId());
        ((CrossListsModifyForm)this.form).setInstrOfferingName(io.getCourseNameWithTitle());
        ((CrossListsModifyForm)this.form).setOwnedInstrOffr(true);
        ((CrossListsModifyForm)this.form).setIoLimit(io.getLimit());
        ((CrossListsModifyForm)this.form).setUnlimited(io.hasUnlimitedEnrollment());
        if (io.hasUnlimitedEnrollment().booleanValue()) {
            ((CrossListsModifyForm)this.form).setIoLimit(-1);
        }
        for (CourseOffering co1 : offerings) {
            ((CrossListsModifyForm)this.form).addToCourseOfferings(co1, this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent) || this.sessionContext.getUser().getCurrentAuthority().hasQualifier(co1.getDepartment()), this.sessionContext.hasPermission(co1, Right.CourseOfferingDeleteFromCrossList));
            ((CrossListsModifyForm)this.form).addToOriginalCourseOfferings(co1);
        }
    }

    public String getCrsNbr() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
    }

    public boolean isModifyCrossListSingleCourseLimit() {
        return ApplicationProperty.ModifyCrossListSingleCourseLimit.isTrue();
    }
}

