/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.commons.Debug;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Action(value="classDetail", results={@Result(name={"displayClass"}, type="tiles", location="classDetail.tiles"), @Result(name={"instructionalOfferingSearch"}, type="redirect", location="/instructionalOfferingSearch.action"), @Result(name={"addDistributionPrefs"}, type="redirect", location="/distributionPrefs.action", params={"classId", "${form.classId}", "op", "${op}"})})
@TilesDefinition(name="classDetail.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Class Detail"), @TilesPutAttribute(name="body", value="/user/classDetail.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class ClassDetailAction
extends PreferencesAction2<ClassEditForm> {
    private static final long serialVersionUID = -2989783006446330571L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtConstants CONST = Localization.create(GwtConstants.class);
    protected String classId = null;
    protected String op2 = null;

    public String getCid() {
        return this.classId;
    }

    public void setCid(String classId) {
        this.classId = classId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new ClassEditForm();
        }
        super.execute();
        if (this.classId == null && this.request.getAttribute("cid") != null) {
            this.classId = (String)this.request.getAttribute("cid");
        }
        if (this.op == null) {
            this.op = ((ClassEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (MSG.actionEditClass().equals(this.op) || MSG.actionAddDistributionPreference().equals(this.op) || MSG.actionNextClass().equals(this.op) || MSG.actionPreviousClass().equals(this.op) || MSG.actionEditClassInstructorAssignmentPreferences().equals(this.op)) {
            this.classId = ((ClassEditForm)this.form).getClassId().toString();
        } else {
            ((ClassEditForm)this.form).reset();
        }
        Debug.debug("op: " + this.op);
        Debug.debug("class: " + this.classId);
        if (this.classId == null || this.classId.trim().isEmpty()) {
            throw new Exception(MSG.errorClassInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.classId), "Class_", Right.ClassDetail);
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        Class_DAO cdao = new Class_DAO();
        Class_ c = (Class_)cdao.get(Long.valueOf(this.classId));
        if (MSG.actionEditClass().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("classEdit.action?cid=" + c.getUniqueId().toString() + "&sec=" + c.getSectionNumberString()));
            return null;
        }
        if (MSG.actionEditClassInstructorAssignmentPreferences().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("classInstrAssgnEdit.do?cid=" + c.getUniqueId().toString() + "&sec=" + c.getSectionNumberString()));
            return null;
        }
        if (MSG.actionNextClass().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("classDetail.action?cid=" + ((ClassEditForm)this.form).getNextId()));
            return null;
        }
        if (MSG.actionPreviousClass().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("classDetail.action?cid=" + ((ClassEditForm)this.form).getPreviousId()));
            return null;
        }
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            return "addDistributionPrefs";
        }
        this.doLoad(c, this.op);
        ((ClassEditForm)this.form).setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), c.getSchedulingSubpart().getMinutesPerWk(), c.effectiveDatePattern(), c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), true, c.getManagingDept()));
        Set timePatterns = null;
        this.initPrefs(c, null, false);
        timePatterns = c.effectiveTimePatterns();
        DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
        String html = tbl.getDistPrefsTableForClass(this.request, this.sessionContext, c);
        if (html != null) {
            this.request.setAttribute("distPrefs", (Object)html);
        }
        this.processPrefAction();
        super.generateTimePatternGrids(c, c.getSchedulingSubpart().getMinutesPerWk(), c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), c.effectiveDatePattern(), timePatterns, "init", timeVertical, false, null);
        this.setupInstructors(this.request, (ClassEditForm)this.form, c);
        this.setupDatePatterns(this.request, (ClassEditForm)this.form, c);
        LookupTables.setupDatePatterns(this.request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), c.getSchedulingSubpart().effectiveDatePattern(), c.getManagingDept(), c.effectiveDatePattern());
        LookupTables.setupRooms(this.request, c);
        LookupTables.setupBldgs(this.request, c);
        LookupTables.setupRoomFeatures(this.request, c);
        LookupTables.setupRoomGroups(this.request, c);
        LookupTables.setupInstructorAttributes(this.request, c);
        LookupTables.setupInstructors(this.request, this.sessionContext, c.getDepartmentForSubjectArea().getUniqueId());
        try {
            Set<RoomAvailabilityInterface.TimeBlock> ec;
            Set<ClassAssignmentProxy.AssignmentInfo> conflicts;
            ClassAssignmentProxy.AssignmentInfo a;
            ClassAssignmentProxy proxy;
            if (RoomAvailability.getInstance() != null && !(RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService)) {
                Session session = c.getManagingDept().getSession();
                Date[] bounds = DatePattern.getBounds(session.getUniqueId());
                RoomAvailability.getInstance().activate(session.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType, false);
                RoomAvailability.setAvailabilityWarning(this.request, session, true, true);
            }
            if (!((proxy = this.getClassAssignmentService().getAssignment()) == null || (a = proxy.getAssignment(c)) == null || !a.isCommitted() || a.getDatePattern() == null || a.getDatePattern().equals(c.effectiveDatePattern()) || a.getDatePattern().getParents() != null && a.getDatePattern().getParents().contains(c.effectiveDatePattern()))) {
                this.addFieldError("datePatternChanged", MSG.datePatternCommittedIsDifferent(c.getClassLabel(), a.getDatePattern().getName(), c.effectiveDatePattern().getName()));
            }
            Set<ClassAssignmentProxy.AssignmentInfo> set = conflicts = proxy == null ? null : proxy.getConflicts(c.getUniqueId());
            if (conflicts != null && !conflicts.isEmpty()) {
                TreeSet<ClassAssignmentProxy.AssignmentInfo> orderedConflicts = new TreeSet<ClassAssignmentProxy.AssignmentInfo>(new Comparator<ClassAssignmentProxy.AssignmentInfo>(){
                    ClassComparator cc = new ClassComparator(5);

                    @Override
                    public int compare(ClassAssignmentProxy.AssignmentInfo a1, ClassAssignmentProxy.AssignmentInfo a2) {
                        return this.cc.compare(a1.getClazz(), a2.getClazz());
                    }
                });
                orderedConflicts.addAll(conflicts);
                WebTable.setOrder(this.sessionContext, "classDetail.conflictsOrd", this.request.getParameter("conflicts"), 1);
                final HashSet<DepartmentalInstructor> conflictingInstructors = new HashSet<DepartmentalInstructor>();
                WebTable table = new WebTable(8, MSG.sectionTitleClassConflicts(), "classDetail.action?cid=" + c.getUniqueId() + "&conflicts=%%", new String[]{MSG.columnClass(), MSG.columnExternalId(), MSG.columnDemand(), MSG.columnSnapshotLimit(), MSG.columnInstructor(), MSG.columnDatePattern(), MSG.columnAssignedTime(), MSG.columnAssignedRoom(), MSG.columnEnrollmentConflict()}, new String[]{"left", "left", "right", "right", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true}){

                    @Override
                    protected boolean isFiltered(int col) {
                        if (col == 7) {
                            return conflictingInstructors.isEmpty();
                        }
                        return false;
                    }
                };
                String nameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
                Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                for (ClassAssignmentProxy.AssignmentInfo assignment : orderedConflicts) {
                    String suffix = assignment.getClazz().getClassSuffix();
                    DatePattern dp = assignment.getDatePattern();
                    TimeLocation t = assignment.getTimeLocation();
                    Object time = "";
                    if (t != null) {
                        Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
                        for (int i = 0; i < CONST.shortDays().length; ++i) {
                            int idx;
                            int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                            if ((Constants.DAY_CODES[idx] & t.getDayCode()) == 0) continue;
                            time = (String)time + CONST.shortDays()[idx];
                        }
                        time = (String)time + " " + t.getStartTimeHeader(CONST.useAmPm()) + "-" + t.getEndTimeHeader(CONST.useAmPm());
                    }
                    Object roomsHtml = "";
                    Object roomsText = "";
                    for (Location r : assignment.getRooms()) {
                        if (!((String)roomsHtml).isEmpty()) {
                            roomsHtml = (String)roomsHtml + ", ";
                            roomsText = (String)roomsText + ", ";
                        }
                        roomsHtml = (String)roomsHtml + "<span onmouseover=\"showGwtRoomHint(this, '" + r.getUniqueId() + "', '');\" onmouseout=\"hideGwtRoomHint();\">" + r.getLabel() + "</span>";
                        roomsText = (String)roomsText + r.getLabel();
                    }
                    Object enrolledHtml = "";
                    Object enrolledText = "";
                    for (ClassInstructor instructor : c.getClassInstructors()) {
                        if (!instructor.isLead().booleanValue() || instructor.getInstructor().getExternalUniqueId() == null) continue;
                        for (StudentClassEnrollment e : assignment.getClazz().getStudentEnrollments()) {
                            if (!instructor.getInstructor().getExternalUniqueId().equals(e.getStudent().getExternalUniqueId())) continue;
                            enrolledHtml = (String)enrolledHtml + (((String)enrolledHtml).isEmpty() ? "" : "<br>") + e.getStudent().getName(nameFormat);
                            enrolledText = (String)enrolledText + (((String)enrolledText).isEmpty() ? "" : ", ") + e.getStudent().getName(nameFormat);
                            conflictingInstructors.add(instructor.getInstructor());
                        }
                    }
                    table.addLine(this.sessionContext.hasPermission(assignment.getClazz(), Right.ClassDetail) ? "onClick=\"document.location='classDetail.action?cid=" + assignment.getClassId() + "';\"" : null, new String[]{assignment.getClazz().getClassLabel(), suffix == null ? "&nbsp;" : suffix, assignment.getClazz().getEnrollment().toString(), assignment.getClazz().getSnapshotLimit() == null ? "&nbsp;" : assignment.getClazz().getSnapshotLimit().toString(), assignment.getClazz().instructorHtml(nameFormat), dp == null ? "&nbsp;" : "<span title='" + dateFormat.format(dp.getStartDate()) + " - " + dateFormat.format(dp.getEndDate()) + "'>" + dp.getName() + "</span>", time, roomsHtml, enrolledHtml}, new Comparable[]{assignment.getClazz().getClassLabel(), suffix == null ? "" : suffix, assignment.getClazz().getEnrollment(), assignment.getClazz().getSnapshotLimit() == null ? Integer.valueOf(0) : assignment.getClazz().getSnapshotLimit(), assignment.getClazz().instructorText(nameFormat, ","), dp == null ? "" : dp.getName(), new MultiComparable(Integer.valueOf(t == null ? 0 : t.getDayCode()), Integer.valueOf(t == null ? 0 : t.getStartSlot())), roomsText, enrolledText});
                }
                this.request.setAttribute("classConflicts", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "classDetail.conflictsOrd")));
            }
            Set<RoomAvailabilityInterface.TimeBlock> set2 = ec = proxy == null ? null : proxy.getConflictingTimeBlocks(c.getUniqueId());
            if (ec != null && !ec.isEmpty()) {
                WebTable table = new WebTable(4, MSG.sectionTitleEventConflicts(), new String[]{MSG.columnEventName(), MSG.columnEventType(), MSG.columnEventDate(), MSG.columnEventTime()}, new String[]{"left", "left", "left", "left"}, new boolean[]{true, true, true, true});
                table.setBlankWhenSame(true);
                Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
                Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
                for (RoomAvailabilityInterface.TimeBlock block : ec) {
                    DefaultRoomAvailabilityService.MeetingTimeBlock mtb;
                    String link = null;
                    if (block instanceof DefaultRoomAvailabilityService.MeetingTimeBlock && (mtb = (DefaultRoomAvailabilityService.MeetingTimeBlock)block).getEventId() != null && this.sessionContext.hasPermission(mtb.getEventId(), Right.EventDetail)) {
                        link = "onClick=\"showGwtDialog('Event Detail', 'gwt.jsp?page=events&menu=hide#event=" + mtb.getEventId() + "','900','85%');\"";
                    }
                    table.addLine(link, new String[]{block.getEventName(), block.getEventType(), dateFormat.format(block.getStartTime()), timeFormat.format(block.getStartTime()) + " - " + timeFormat.format(block.getEndTime())}, new Comparable[]{block.getEventName(), block.getEventType(), block.getStartTime(), block.getEndTime()});
                }
                this.request.setAttribute("eventConflicts", (Object)table.printTable());
            }
        }
        catch (Exception e) {
            Debug.error("Failed to compute conflicts: " + e.getMessage(), e);
        }
        BackTracker.markForBack(this.request, "classDetail.action?cid=" + ((ClassEditForm)this.form).getClassId(), MSG.backClass(((ClassEditForm)this.form).getClassName()), true, false);
        return "displayClass";
    }

    private void doLoad(Class_ c, String op) {
        String parentClassName = "-";
        Long parentClassId = null;
        if (c.getParentClass() != null) {
            parentClassName = c.getParentClass().toString();
            if (this.sessionContext.hasPermission(c.getParentClass(), Right.ClassDetail)) {
                parentClassId = c.getParentClass().getUniqueId();
            }
        }
        CourseOffering cco = c.getSchedulingSubpart().getControllingCourseOffering();
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
        ((ClassEditForm)this.form).setClassId(c.getUniqueId());
        ((ClassEditForm)this.form).setSection(c.getSectionNumberString());
        ((ClassEditForm)this.form).setClassName(c.getClassLabel());
        SchedulingSubpart ss = c.getSchedulingSubpart();
        Object itypeDesc = c.getItypeDesc();
        if (ss.getInstrOfferingConfig().getInstructionalOffering().hasMultipleConfigurations()) {
            itypeDesc = (String)itypeDesc + " [" + ss.getInstrOfferingConfig().getName() + "]";
        }
        ((ClassEditForm)this.form).setItypeDesc((String)itypeDesc);
        ((ClassEditForm)this.form).setParentClassName(parentClassName);
        ((ClassEditForm)this.form).setParentClassId(parentClassId);
        ((ClassEditForm)this.form).setSubjectAreaId(cco.getSubjectArea().getUniqueId().toString());
        ((ClassEditForm)this.form).setInstrOfferingId(cco.getInstructionalOffering().getUniqueId().toString());
        if (this.sessionContext.hasPermission(c.getSchedulingSubpart(), Right.SchedulingSubpartDetail)) {
            ((ClassEditForm)this.form).setSubpart(c.getSchedulingSubpart().getUniqueId());
        } else {
            ((ClassEditForm)this.form).setSubpart(null);
        }
        ((ClassEditForm)this.form).setCourseName(cco.getInstructionalOffering().getCourseName());
        ((ClassEditForm)this.form).setCourseTitle(cco.getTitle());
        ((ClassEditForm)this.form).setIsCrosslisted(cco.getInstructionalOffering().getCourseOfferings().size() > 1);
        ((ClassEditForm)this.form).setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(c)));
        ((ClassEditForm)this.form).setIsCancelled(c.isCancelled());
        ((ClassEditForm)this.form).setExpectedCapacity(c.getExpectedCapacity());
        ((ClassEditForm)this.form).setEnrollment(c.getEnrollment());
        ((ClassEditForm)this.form).setSnapshotLimit(c.getSnapshotLimit());
        ((ClassEditForm)this.form).setDatePattern(c.getDatePattern() == null ? Long.valueOf(-1L) : c.getDatePattern().getUniqueId());
        ((ClassEditForm)this.form).setDatePatternEditable(ApplicationProperty.WaitListCanChangeDatePattern.isTrue() || c.getEnrollment() == 0 || !c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().effectiveReScheduleNow());
        ((ClassEditForm)this.form).setLms(c.getLms() == null ? "" : c.getLms().getLabel());
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            ((ClassEditForm)this.form).setFundingDept(c.getEffectiveFundingDept().getLabel());
        } else {
            ((ClassEditForm)this.form).setFundingDept("");
        }
        ((ClassEditForm)this.form).setNbrRooms(c.getNbrRooms());
        ((ClassEditForm)this.form).setSplitAttendance(c.isRoomsSplitAttendance());
        if (c.getNotes() == null) {
            ((ClassEditForm)this.form).setNotes("");
        } else {
            ((ClassEditForm)this.form).setNotes(c.getNotes());
        }
        ((ClassEditForm)this.form).setManagingDept(c.getManagingDept().getUniqueId());
        ((ClassEditForm)this.form).setControllingDept(c.getControllingDept().getUniqueId());
        ((ClassEditForm)this.form).setManagingDeptLabel(c.getManagingDept().getManagingDeptLabel());
        ((ClassEditForm)this.form).setSchedulePrintNote(c.getSchedulePrintNote());
        ((ClassEditForm)this.form).setClassSuffix(c.getDivSecNumber());
        ((ClassEditForm)this.form).setMaxExpectedCapacity(c.getMaxExpectedCapacity());
        ((ClassEditForm)this.form).setRoomRatio(c.getRoomRatio());
        ((ClassEditForm)this.form).setEnabledForStudentScheduling(c.isEnabledForStudentScheduling());
        ((ClassEditForm)this.form).setDisplayInstructor(c.isDisplayInstructor());
        ((ClassEditForm)this.form).setMinRoomLimit(c.getMinRoomLimit());
        Class_ next = c.getNextClass(this.sessionContext, Right.ClassDetail);
        ((ClassEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        Class_ previous = c.getPreviousClass(this.sessionContext, Right.ClassDetail);
        ((ClassEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(c.getClassInstructors());
        Collections.sort(instructors, new InstructorComparator(this.sessionContext));
        for (ClassInstructor classInstr : instructors) {
            ((ClassEditForm)this.form).addToInstructors(classInstr);
        }
        if (c.getNbrRooms() > 0) {
            if (c.hasRoomIndexedPrefs()) {
                StringBuffer rooms = new StringBuffer();
                rooms.append("<table width='100%'>");
                for (int roomIndex = 0; roomIndex < c.getNbrRooms(); ++roomIndex) {
                    rooms.append("<tr><td style='width:50px;' nowrap>" + MSG.itemOnlyRoom(1 + roomIndex) + ":</td><td>");
                    List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(c, roomIndex);
                    if (roomLocations.isEmpty()) {
                        rooms.append("<font color='red'><b>" + MSG.warnNoRoomsAreAvaliable() + "</b></font>");
                    } else {
                        int idx = 0;
                        for (RoomLocation rl : roomLocations) {
                            if (idx > 0) {
                                rooms.append(", ");
                            }
                            if (idx == 6) {
                                rooms.append("<span id='room_dots_" + roomIndex + "' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('room_dots_" + roomIndex + "').style.display='none';document.getElementById('room_rest_" + roomIndex + "').style.display='inline';\">" + MSG.moreAvailableRooms(roomLocations.size() - 6) + "</a></span><span id='room_rest_" + roomIndex + "' style='display:none'>");
                            }
                            rooms.append("<span style='color:" + PreferenceLevel.int2color(rl.getPreference()) + ";' onmouseover=\"showGwtRoomHint(this, '" + rl.getId() + "', '" + PreferenceLevel.int2string(rl.getPreference()) + "');\" onmouseout=\"hideGwtRoomHint();\">" + rl.getName() + "</span>");
                            ++idx;
                        }
                        if (idx >= 6) {
                            rooms.append("</span>");
                        }
                    }
                    rooms.append("</td></tr>");
                }
                rooms.append("</table>");
                this.request.setAttribute("availableLocations", (Object)rooms.toString());
            } else {
                List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(c);
                StringBuffer rooms = new StringBuffer();
                if (roomLocations.isEmpty()) {
                    this.request.setAttribute("availableLocations", (Object)("<font color='red'><b>" + MSG.warnNoRoomsAreAvaliable() + "</b></font>"));
                } else {
                    int idx = 0;
                    for (RoomLocation rl : roomLocations) {
                        if (idx > 0) {
                            rooms.append(", ");
                        }
                        if (idx == 6) {
                            rooms.append("<span id='room_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('room_dots').style.display='none';document.getElementById('room_rest').style.display='inline';\">" + MSG.moreAvailableRooms(roomLocations.size() - 6) + "</a></span><span id='room_rest' style='display:none'>");
                        }
                        rooms.append("<span style='color:" + PreferenceLevel.int2color(rl.getPreference()) + ";' onmouseover=\"showGwtRoomHint(this, '" + rl.getId() + "', '" + PreferenceLevel.int2string(rl.getPreference()) + "');\" onmouseout=\"hideGwtRoomHint();\">" + rl.getName() + "</span>");
                        ++idx;
                    }
                    if (idx >= 6) {
                        rooms.append("</span>");
                    }
                    if (roomLocations.size() < c.getNbrRooms()) {
                        this.request.setAttribute("availableLocations", (Object)("<font color='red'><b>" + MSG.warnNotEnoughtRoomsAreAvaliable() + "</b></font> " + String.valueOf(rooms)));
                    } else {
                        this.request.setAttribute("availableLocations", (Object)rooms);
                    }
                }
            }
        }
    }

    protected void setupInstructors(HttpServletRequest request, ClassEditForm form, Class_ c) throws Exception {
        List<String> instructors = form.getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        LookupTables.setupInstructors(request, this.sessionContext, c.getDepartmentForSubjectArea().getUniqueId());
        LookupTables.setupInstructorTeachingResponsibilities(request);
    }

    private void setupDatePatterns(HttpServletRequest request, ClassEditForm form, Class_ c) throws Exception {
        DatePattern selectedDatePattern = c.effectiveDatePattern();
        if (selectedDatePattern != null) {
            List<DatePattern> children = selectedDatePattern.findChildren();
            for (DatePattern dp : children) {
                if (form.getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                form.addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
            }
            form.sortDatePatternPrefs(form.getDatePatternPrefs(), form.getDatePatternPrefLevels(), children);
        }
    }
}

