/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.unitime.commons.JavaMailWrapper;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;

public class JavaMailMockupEmail
extends JavaMailWrapper {
    private String iSubject = null;

    @Override
    public void setSubject(String subject) throws MessagingException {
        this.iSubject = subject;
        super.setSubject(ApplicationProperties.getProperty("unitime.email.test.subject", "[TEST]") + " " + subject);
    }

    protected void space(StringBuffer s, int len) {
        for (int i = 0; i < len; ++i) {
            s.append(' ');
        }
    }

    protected String format(String name, Address ... list) {
        if (list == null || list.length == 0) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i == 0) {
                ret.append(name);
            } else {
                this.space(ret, name.length());
            }
            ret.append(list[i].toString());
            ret.append('\n');
        }
        return ret.toString();
    }

    @Override
    public void send() throws MessagingException, UnsupportedEncodingException {
        StringBuffer message = new StringBuffer("\n");
        if (this.iSubject != null) {
            message.append("Subject:  " + this.iSubject + "\n");
        }
        message.append(this.format("From:     ", this.iMail.getFrom()));
        message.append(this.format("Reply-To: ", this.iMail.getReplyTo()));
        message.append(this.format("To:       ", this.iMail.getRecipients(Message.RecipientType.TO)));
        message.append(this.format("CC:       ", this.iMail.getRecipients(Message.RecipientType.CC)));
        message.append(this.format("BCC:      ", this.iMail.getRecipients(Message.RecipientType.BCC)));
        MimeBodyPart text = new MimeBodyPart();
        text.setContent((Object)message.toString(), "text/plain");
        text.setFileName("original-recipients.txt");
        this.iBody.addBodyPart((BodyPart)text);
        this.iMail.setRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{new InternetAddress(ApplicationProperties.getProperty("unitime.email.test.recipient", ApplicationProperty.EmailNotificationAddress.value()), ApplicationProperties.getProperty("unitime.email.test.recipient.name", ApplicationProperty.EmailNotificationAddressName.value()), "UTF-8")});
        this.iMail.setRecipients(Message.RecipientType.CC, new Address[0]);
        this.iMail.setRecipients(Message.RecipientType.BCC, new Address[0]);
        super.send();
    }
}

