/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.HashSet;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.StaffDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.NameFormat;

public class InstructorAction
extends UniTimeAction<InstructorEditForm> {
    private static final long serialVersionUID = -3849156971109264456L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new InstructorEditForm();
        }
        LookupTables.setupPositionTypes(this.request);
        ((InstructorEditForm)this.form).setNameFormat(NameFormat.fromReference(this.sessionContext.getUser().getProperty(UserProperty.NameFormat)));
        ((InstructorEditForm)this.form).setLookupEnabled(ApplicationProperty.InstructorExternalIdLookup.isTrue() && ApplicationProperty.InstructorExternalIdLookupClass.value() != null);
        if (this.op == null) {
            this.op = ((InstructorEditForm)this.form).getOp();
        } else {
            ((InstructorEditForm)this.form).setOp(this.op);
        }
        return null;
    }

    protected void fillStaffInfo() throws Exception {
        Staff staff = (Staff)new StaffDAO().get(Long.valueOf(((InstructorEditForm)this.form).getSearchSelect()));
        ((InstructorEditForm)this.form).setPuId(staff.getExternalUniqueId());
        ((InstructorEditForm)this.form).setFname(staff.getFirstName() != null ? staff.getFirstName().trim() : "");
        ((InstructorEditForm)this.form).setMname(staff.getMiddleName() != null ? staff.getMiddleName().trim() : "");
        ((InstructorEditForm)this.form).setLname(staff.getLastName() != null ? staff.getLastName().trim() : "");
        ((InstructorEditForm)this.form).setTitle(staff.getAcademicTitle() != null ? staff.getAcademicTitle().trim() : "");
        ((InstructorEditForm)this.form).setEmail(staff.getEmail());
        if (staff.getPositionType() != null && (((InstructorEditForm)this.form).getPosType() == null || ((InstructorEditForm)this.form).getPosType().trim().length() == 0)) {
            ((InstructorEditForm)this.form).setPosType(staff.getPositionType().getUniqueId().toString());
        }
    }

    protected void fillI2A2Info() throws Exception {
        ExternalUidLookup.UserInfo results;
        String login = ((InstructorEditForm)this.form).getCareerAcct();
        if (login != null && login.trim().length() > 0 && ((InstructorEditForm)this.form).getLookupEnabled().booleanValue() && (results = this.lookupInstructor()) != null) {
            ((InstructorEditForm)this.form).setPuId(results.getExternalId());
            ((InstructorEditForm)this.form).setCareerAcct(results.getUserName());
            ((InstructorEditForm)this.form).setFname(results.getFirstName());
            ((InstructorEditForm)this.form).setMname(results.getMiddleName());
            ((InstructorEditForm)this.form).setLname(results.getLastName());
            ((InstructorEditForm)this.form).setEmail(results.getEmail());
            ((InstructorEditForm)this.form).setTitle(results.getAcademicTitle());
        }
    }

    protected void findMatchingInstructor() throws Exception {
        ExternalUidLookup.UserInfo results;
        ((InstructorEditForm)this.form).setMatchFound(false);
        String fname = ((InstructorEditForm)this.form).getFname();
        String lname = ((InstructorEditForm)this.form).getLname();
        String login = ((InstructorEditForm)this.form).getCareerAcct();
        if (login != null && login.trim().length() > 0 && ((InstructorEditForm)this.form).getLookupEnabled().booleanValue() && (results = this.lookupInstructor()) != null) {
            ((InstructorEditForm)this.form).setI2a2Match(results);
            ((InstructorEditForm)this.form).setMatchFound(Boolean.TRUE);
        }
        List staffList = Staff.findMatchingName(fname, lname);
        ((InstructorEditForm)this.form).setStaffMatch(staffList);
        if (staffList != null && staffList.size() > 0) {
            ((InstructorEditForm)this.form).setMatchFound(true);
        }
    }

    private ExternalUidLookup.UserInfo lookupInstructor() throws Exception {
        String id = ((InstructorEditForm)this.form).getCareerAcct();
        if (id != null && id.trim().length() > 0 && ((InstructorEditForm)this.form).getLookupEnabled().booleanValue()) {
            String className = ApplicationProperty.InstructorExternalIdLookupClass.value();
            ExternalUidLookup lookup = (ExternalUidLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return lookup.doLookup(id);
        }
        return null;
    }

    protected void doUpdate() throws Exception {
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            PositionType pt;
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = null;
            String instrId = ((InstructorEditForm)this.form).getInstructorId();
            if (instrId != null && instrId.trim().length() > 0) {
                inst = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(Long.valueOf(instrId));
            } else {
                inst = new DepartmentalInstructor();
                inst.setAttributes(new HashSet<InstructorAttribute>());
            }
            if (((InstructorEditForm)this.form).getFname() != null && ((InstructorEditForm)this.form).getFname().trim().length() > 0) {
                inst.setFirstName(((InstructorEditForm)this.form).getFname().trim());
            } else {
                inst.setFirstName(null);
            }
            if (((InstructorEditForm)this.form).getMname() != null && ((InstructorEditForm)this.form).getMname().trim().length() > 0) {
                inst.setMiddleName(((InstructorEditForm)this.form).getMname().trim());
            } else {
                inst.setMiddleName(null);
            }
            inst.setLastName(((InstructorEditForm)this.form).getLname().trim());
            if (((InstructorEditForm)this.form).getTitle() != null && ((InstructorEditForm)this.form).getTitle().trim().length() > 0) {
                inst.setAcademicTitle(((InstructorEditForm)this.form).getTitle().trim());
            } else {
                inst.setAcademicTitle(null);
            }
            if (((InstructorEditForm)this.form).getPuId() != null && ((InstructorEditForm)this.form).getPuId().trim().length() > 0 && !((InstructorEditForm)this.form).getPuId().equalsIgnoreCase("null")) {
                inst.setExternalUniqueId(((InstructorEditForm)this.form).getPuId().trim());
            } else {
                inst.setExternalUniqueId(null);
            }
            if (((InstructorEditForm)this.form).getCareerAcct() != null && ((InstructorEditForm)this.form).getCareerAcct().trim().length() > 0) {
                inst.setCareerAcct(((InstructorEditForm)this.form).getCareerAcct().trim());
            } else {
                inst.setCareerAcct(null);
            }
            inst.setEmail(((InstructorEditForm)this.form).getEmail());
            if (((InstructorEditForm)this.form).getPosType() != null && ((InstructorEditForm)this.form).getPosType().trim().length() > 0 && (pt = PositionType.findById(Long.valueOf(((InstructorEditForm)this.form).getPosType().trim()))) != null) {
                inst.setPositionType(pt);
            }
            if (((InstructorEditForm)this.form).getNote() != null && !((InstructorEditForm)this.form).getNote().isEmpty()) {
                if (((InstructorEditForm)this.form).getNote().length() > 2048) {
                    inst.setNote(((InstructorEditForm)this.form).getNote().substring(0, 2048));
                } else {
                    inst.setNote(((InstructorEditForm)this.form).getNote());
                }
            } else {
                inst.setNote(null);
            }
            Department d = null;
            if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) == null) {
                throw new Exception("Department Id could not be retrieved from session");
            }
            String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
            d = (Department)new DepartmentDAO().get(Long.valueOf(deptId));
            inst.setDepartment(d);
            d.getInstructors().add(inst);
            inst.setIgnoreToFar(((InstructorEditForm)this.form).getIgnoreDist());
            hibSession.saveOrUpdate((Object)inst);
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_EDIT, instrId == null || instrId.trim().length() <= 0 ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, inst.getDepartment());
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    protected boolean isDeptInstructorUnique() {
        String query = "from DepartmentalInstructor where externalUniqueId=:puid and department.uniqueId=:deptId";
        if (((InstructorEditForm)this.form).getInstructorId() != null && ((InstructorEditForm)this.form).getInstructorId().trim().length() > 0) {
            query = query + " and uniqueId!=:uniqueId";
        }
        DepartmentalInstructorDAO ddao = new DepartmentalInstructorDAO();
        Session hibSession = ddao.getSession();
        String deptId = (String)this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
        Query q = hibSession.createQuery(query);
        q.setString("puid", ((InstructorEditForm)this.form).getPuId().trim());
        q.setLong("deptId", Long.parseLong(deptId));
        if (((InstructorEditForm)this.form).getInstructorId() != null && ((InstructorEditForm)this.form).getInstructorId().trim().length() > 0) {
            q.setLong("uniqueId", Long.parseLong(((InstructorEditForm)this.form).getInstructorId().trim()));
        }
        return q.list().size() == 0;
    }
}

