/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.hibernate.stats.StatsProvider;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="hibernateStats", results={@Result(name={"show"}, type="tiles", location="hibernateStats.tiles")})
@TilesDefinition(name="hibernateStats.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Hibernate Statistics"), @TilesPutAttribute(name="body", value="/admin/hibernateStats.jsp")})
public class HibernateStatistics
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = 5335714912646440433L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private boolean details = false;

    public boolean getDetails() {
        return this.details;
    }

    public void setDetails(boolean details) {
        this.details = details;
    }

    public String execute() {
        this.sessionContext.checkPermission(Right.HibernateStatistics);
        if (MSG.actionEnableStatistics().equals(this.op)) {
            new _RootDAO().getSession().getSessionFactory().getStatistics().setStatisticsEnabled(true);
        }
        if (MSG.actionDisableStatistics().equals(this.op)) {
            new _RootDAO().getSession().getSessionFactory().getStatistics().setStatisticsEnabled(false);
        }
        if (MSG.actionHideDetails().equals(this.op)) {
            this.details = false;
        }
        if (MSG.actionShowDetails().equals(this.op)) {
            this.details = true;
        }
        return "show";
    }

    public boolean getEnabled() {
        return new _RootDAO().getSession().getSessionFactory().getStatistics().isStatisticsEnabled();
    }

    public String getStats() {
        return StatsProvider.getStatsHtml(!this.details);
    }
}

