/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Action(value="instructorPrefEdit", results={@Result(name={"showEdit"}, type="tiles", location="instructorPrefEdit.tiles"), @Result(name={"showDetail"}, type="redirect", location="/instructorDetail.action", params={"instructorId", "${form.instructorId}"}), @Result(name={"showList"}, type="redirect", location="/instructorSearch.action")})
@TilesDefinition(name="instructorPrefEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructor Preferences"), @TilesPutAttribute(name="body", value="/user/instructorPrefsEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="checkRole", value="false")})
public class InstructorPrefEditAction
extends PreferencesAction2<InstructorEditForm> {
    private static final long serialVersionUID = 5756382132156450413L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String instructorId = null;
    protected String op2 = null;

    public String getInstructorId() {
        return this.instructorId;
    }

    public void setInstructorId(String instructorId) {
        this.instructorId = instructorId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new InstructorEditForm();
        }
        super.execute();
        if (this.instructorId == null && this.request.getAttribute("instructorId") != null) {
            this.instructorId = (String)this.request.getAttribute("instructorId");
        }
        if (this.instructorId == null) {
            this.instructorId = ((InstructorEditForm)this.form).getInstructorId();
        }
        if (this.op == null) {
            this.op = ((InstructorEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "init";
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            throw new Exception(MSG.exceptionNullOperationNotSupported());
        }
        if (this.instructorId == null || this.instructorId.trim().isEmpty()) {
            throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.instructorId), "DepartmentalInstructor", Right.InstructorPreferences);
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        ((InstructorEditForm)this.form).setScreenName("instructorPref");
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(this.instructorId));
        LookupTables.setupInstructorDistribTypes(this.request, this.sessionContext, inst);
        if (MSG.actionBackToDetail().equals(this.op)) {
            if (BackTracker.hasBack(this.request, 1)) {
                BackTracker.doBack(this.request, this.response);
                return null;
            }
            if (this.instructorId != null && !this.instructorId.trim().isEmpty()) {
                return "showDetail";
            }
            return "showList";
        }
        if (MSG.actionClearInstructorPreferences().equals(this.op)) {
            this.doClear(inst.getPreferences(), Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DISTRIBUTION);
            idao.update(inst);
            this.op = "init";
            ChangeLog.addChange(null, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.CLEAR_PREF, null, inst.getDepartment());
            return "showDetail";
        }
        if ("init".equals(this.op)) {
            ((InstructorEditForm)this.form).reset();
        }
        this.doLoad(inst, this.instructorId);
        if (MSG.actionUpdatePreferences().equals(this.op) || MSG.actionNextInstructor().equals(this.op) || MSG.actionPreviousInstructor().equals(this.op)) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                Set<Preference> s = inst.getPreferences();
                Iterator<Preference> i = s.iterator();
                while (i.hasNext()) {
                    Preference p = i.next();
                    if (p instanceof InstructorCoursePref) continue;
                    i.remove();
                }
                super.doUpdate(inst, s, timeVertical, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DISTRIBUTION);
                if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Preferences".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                    inst.setUnavailablePatternAndOffset(this.request);
                }
                ChangeLog.addChange(null, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.UPDATE, null, inst.getDepartment());
                idao.saveOrUpdate(inst);
                if (MSG.actionNextInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorPrefEdit.action?instructorId=" + ((InstructorEditForm)this.form).getNextId()));
                    return null;
                }
                if (MSG.actionPreviousInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorPrefEdit.action?instructorId=" + ((InstructorEditForm)this.form).getPreviousId()));
                    return null;
                }
                return "showDetail";
            }
        }
        HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
        ((InstructorEditForm)this.form).setAvailableTimePatterns(null);
        if ("init".equals(this.op)) {
            this.initPrefs(inst, null, true);
            timePatterns.add(new TimePattern(-1L));
            for (Preference pref : inst.getPreferences()) {
                if (!(pref instanceof TimePref)) continue;
                ((InstructorEditForm)this.form).setAvailability(((TimePref)pref).getPreference());
                break;
            }
        }
        if (!inst.getClasses().isEmpty()) {
            WebTable classTable = new WebTable(3, null, new String[]{"class", "Type", "Limit"}, new String[]{"left", "left", "left"}, null);
            for (ClassInstructor ci : inst.getClasses()) {
                Class_ c = ci.getClassInstructing();
                classTable.addLine(null, new String[]{c.getClassLabel(), c.getItypeDesc(), c.getExpectedCapacity().toString()}, null, null);
            }
            String tblData = classTable.printTable();
            this.request.setAttribute("classTable", (Object)tblData);
        }
        this.processPrefAction();
        LookupTables.setupRooms(this.request, inst);
        LookupTables.setupBldgs(this.request, inst);
        LookupTables.setupRoomFeatures(this.request, inst);
        LookupTables.setupRoomGroups(this.request, inst);
        BackTracker.markForBack(this.request, "instructorDetail.action?instructorId=" + ((InstructorEditForm)this.form).getInstructorId(), MSG.backInstructor(((InstructorEditForm)this.form).getName() == null ? "null" : ((InstructorEditForm)this.form).getName().trim()), true, false);
        return "showEdit";
    }

    private void doLoad(DepartmentalInstructor inst, String instructorId) {
        ((InstructorEditForm)this.form).setInstructorId(instructorId);
        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Preferences".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
            this.request.setAttribute("unavailableDaysPattern", (Object)inst.getUnavailablePatternHtml(true));
        }
        ((InstructorEditForm)this.form).setName(inst.getName(UserProperty.NameFormat.get(this.sessionContext.getUser())) + (inst.getPositionType() == null ? "" : " (" + inst.getPositionType().getLabel() + ")"));
        if (inst.getExternalUniqueId() != null) {
            ((InstructorEditForm)this.form).setPuId(inst.getExternalUniqueId());
        }
        ((InstructorEditForm)this.form).setDeptName(inst.getDepartment().getName().trim());
        if (inst.getPositionType() != null) {
            ((InstructorEditForm)this.form).setPosType(inst.getPositionType().getUniqueId().toString());
        }
        if (inst.getCareerAcct() != null) {
            ((InstructorEditForm)this.form).setCareerAcct(inst.getCareerAcct().trim());
        }
        ((InstructorEditForm)this.form).setEmail(inst.getEmail());
        if (inst.getNote() != null) {
            ((InstructorEditForm)this.form).setNote(inst.getNote().trim());
        }
        try {
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorPreferences);
            ((InstructorEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorPreferences);
            ((InstructorEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

