/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class InstructorExamReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(InstructorExamReport.class);
    Hashtable<Long, String> iStudentNames = null;
    Hashtable<Long, ClassEvent> iClass2event = null;
    Hashtable<Long, Location> iLocations = null;

    public InstructorExamReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legactReportInstructorExaminationSchedule(), session, examType, subjectAreas, exams);
    }

    public InstructorExamReport(int mode, OutputStream out, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, out, MSG.legactReportInstructorExaminationSchedule(), session, examType, subjectAreas, exams);
    }

    private void generateCache() {
        if (this.iStudentNames == null) {
            this.iStudentNames = new Hashtable();
            sLog.debug((Object)MSG.statusLoadingStudents());
            for (Object[] o : new StudentDAO().getSession().createQuery("select s.uniqueId, s.externalUniqueId, s.lastName, s.firstName, s.middleName from Student s where s.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iStudentNames.put((Long)o[0], (String)o[2] + (o[3] == null ? "" : " " + ((String)o[3]).substring(0, 1)) + (o[4] == null ? "" : " " + ((String)o[4]).substring(0, 1)));
            }
        }
        if (this.iClass2event == null) {
            sLog.info((Object)MSG.statusLoadingClassEvents());
            this.iClass2event = new Hashtable();
            if (this.hasSubjectAreas()) {
                for (SubjectArea subject : this.getSubjectAreas()) {
                    for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId=:subjectAreaId").setLong("subjectAreaId", subject.getUniqueId().longValue()).setCacheable(true).list()) {
                        this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                    }
                }
            } else {
                for (Object[] o : new SessionDAO().getSession().createQuery("select c.uniqueId, e from ClassEvent e inner join e.clazz c left join fetch e.meetings m inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.session.uniqueId=:sessionId").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                    this.iClass2event.put((Long)o[0], (ClassEvent)o[1]);
                }
            }
        }
        if (this.iLocations == null) {
            sLog.info((Object)MSG.statusLoadingLocations());
            this.iLocations = new Hashtable();
            for (Location location : new SessionDAO().getSession().createQuery("select r from Room r where r.session.uniqueId=:sessionId and r.permanentId!=null").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
            for (Location location : new SessionDAO().getSession().createQuery("select r from NonUniversityLocation r where r.session.uniqueId=:sessionId and r.permanentId!=null").setLong("sessionId", this.getSession().getUniqueId().longValue()).setCacheable(true).list()) {
                this.iLocations.put(location.getPermanentId(), location);
            }
        }
    }

    public String getStudentName(Long studentId) {
        String name;
        if (this.iStudentNames == null) {
            this.iStudentNames = new Hashtable();
        }
        if ((name = this.iStudentNames.get(studentId)) != null) {
            return name;
        }
        Student student = (Student)StudentDAO.getInstance().get(studentId);
        name = student == null ? "" : student.getName(DepartmentalInstructor.sNameFormatLastInitial);
        this.iStudentNames.put(studentId, name);
        return name;
    }

    public boolean isOfSubjectArea(TreeSet<ExamAssignmentInfo> exams) {
        for (ExamAssignmentInfo exam : exams) {
            if (!this.hasSubjectArea(exam)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printReport() throws DocumentException {
        this.generateCache();
        sLog.info((Object)MSG.statusPrintingReport());
        Hashtable<ExamInfo.ExamInstructorInfo, TreeSet<ExamAssignmentInfo>> exams = new Hashtable<ExamInfo.ExamInstructorInfo, TreeSet<ExamAssignmentInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamInstructorInfo instructor : exam.getInstructors()) {
                TreeSet<ExamAssignmentInfo> examsThisInstructor = (TreeSet<ExamAssignmentInfo>)exams.get(instructor);
                if (examsThisInstructor == null) {
                    examsThisInstructor = new TreeSet<ExamAssignmentInfo>();
                    exams.put(instructor, examsThisInstructor);
                }
                examsThisInstructor.add(exam);
            }
        }
        boolean firstInstructor = true;
        this.printHeader();
        for (ExamInfo.ExamInstructorInfo instructor : new TreeSet(exams.keySet())) {
            ChangeLog last;
            TreeSet examsThisInstructor = (TreeSet)exams.get(instructor);
            if (!this.isOfSubjectArea(examsThisInstructor)) continue;
            if (this.iSince != null && ((last = this.getLastChange(instructor, examsThisInstructor)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)("    " + MSG.logNoChangesFoundFor(instructor.getName())));
                continue;
            }
            if (!firstInstructor) {
                this.newPage();
            }
            this.printReport(instructor, examsThisInstructor);
            firstInstructor = false;
        }
        this.lastPage();
    }

    public Hashtable<ExamInfo.ExamInstructorInfo, File> printInstructorReports(String filePrefix, FileGenerator gen) throws DocumentException, IOException {
        this.generateCache();
        sLog.info((Object)MSG.statusPrintingIndividualInstructorReports());
        Hashtable<ExamInfo.ExamInstructorInfo, File> files = new Hashtable<ExamInfo.ExamInstructorInfo, File>();
        Hashtable<ExamInfo.ExamInstructorInfo, TreeSet<ExamAssignmentInfo>> exams = new Hashtable<ExamInfo.ExamInstructorInfo, TreeSet<ExamAssignmentInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamInstructorInfo instructor : exam.getInstructors()) {
                TreeSet<ExamAssignmentInfo> examsThisInstructor = (TreeSet<ExamAssignmentInfo>)exams.get(instructor);
                if (examsThisInstructor == null) {
                    examsThisInstructor = new TreeSet<ExamAssignmentInfo>();
                    exams.put(instructor, examsThisInstructor);
                }
                examsThisInstructor.add(exam);
            }
        }
        for (ExamInfo.ExamInstructorInfo instructor : new TreeSet(exams.keySet())) {
            ChangeLog last;
            TreeSet examsThisInstructor = (TreeSet)exams.get(instructor);
            if (!this.isOfSubjectArea(examsThisInstructor)) continue;
            if (this.iSince != null && ((last = this.getLastChange(instructor, examsThisInstructor)) == null || this.iSince.compareTo(last.getTimeStamp()) > 0)) {
                sLog.debug((Object)("    " + MSG.logNoChangesFoundFor(instructor.getName())));
                continue;
            }
            sLog.debug((Object)("  " + MSG.logGeneratingFileFor(instructor.getName())));
            File file = gen.generate(filePrefix + "_" + (instructor.getExternalUniqueId() != null ? instructor.getExternalUniqueId() : instructor.getInstructor().getLastName()), this.getExtension());
            this.open(file);
            this.printHeader();
            this.printReport(instructor, examsThisInstructor);
            this.lastPage();
            this.close();
            files.put(instructor, file);
        }
        return files;
    }

    public void printReport(ExamInfo.ExamInstructorInfo instructor) throws DocumentException {
        TreeSet<ExamAssignmentInfo> exams = new TreeSet<ExamAssignmentInfo>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() != null && !exam.getInstructors().contains(instructor)) continue;
        }
        if (exams.isEmpty()) {
            return;
        }
        this.printHeader();
        this.printReport(instructor, exams);
        this.lastPage();
    }

    public ChangeLog getLastChange(ExamInfo.ExamInstructorInfo instructor, TreeSet<ExamAssignmentInfo> exams) {
        ChangeLog lastChange = ChangeLog.findLastChange(instructor.getInstructor());
        for (ExamAssignmentInfo exam : exams) {
            ChangeLog c = ChangeLog.findLastChange(exam.getExam());
            if (c == null || lastChange != null && lastChange.getTimeStamp().compareTo(c.getTimeStamp()) >= 0) continue;
            lastChange = c;
        }
        return lastChange;
    }

    /*
     * WARNING - void declaration
     */
    public void printReport(ExamInfo.ExamInstructorInfo instructor, TreeSet<ExamAssignmentInfo> exams) throws DocumentException {
        ExamAssignmentInfo exam;
        TreeSet<ExamInfo.ExamSectionInfo> sections = new TreeSet<ExamInfo.ExamSectionInfo>();
        for (ExamAssignmentInfo exam2 : exams) {
            sections.addAll(exam2.getSectionsIncludeCrosslistedDummies());
        }
        this.setFooter(instructor.getName());
        this.setCont(instructor.getName());
        this.println(this.rpad(MSG.lrPropInstructor(), 12), new AbstractReport.Cell(instructor.getName()).withColSpan(9));
        if (instructor.getInstructor().getEmail() != null) {
            this.println(this.rpad(MSG.lrPropEmail(), 12), new AbstractReport.Cell(instructor.getInstructor().getEmail()).withColSpan(9));
        }
        Date lastChange = null;
        String changeObject = null;
        ChangeLog c = ChangeLog.findLastChange(instructor.getInstructor());
        if (c != null && (lastChange == null || lastChange.compareTo(c.getTimeStamp()) < 0)) {
            lastChange = c.getTimeStamp();
        }
        for (ExamAssignmentInfo exam3 : exams) {
            c = ChangeLog.findLastChange(exam3.getExam());
            if (c == null || lastChange != null && lastChange.compareTo(c.getTimeStamp()) >= 0) continue;
            lastChange = c.getTimeStamp();
            changeObject = c.getObjectTitle().replaceAll("&rarr;", "->");
        }
        if (lastChange != null && this.iSince != null) {
            this.println(this.rpad(MSG.lrPropLastChange(), 12), new AbstractReport.Cell(new SimpleDateFormat(MSG.lrLastChangeDateFormat()).format(lastChange) + (changeObject == null ? "" : " " + changeObject)));
        }
        if (this.iClassSchedule) {
            TreeSet<ClassInstructor> allClasses = new TreeSet<ClassInstructor>(new Comparator<ClassInstructor>(){
                ClassComparator cc = new ClassComparator(5);

                @Override
                public int compare(ClassInstructor c1, ClassInstructor c2) {
                    return this.cc.compare(c1.getClassInstructing(), c2.getClassInstructing());
                }
            });
            for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor(), this.getSession().getUniqueId())) {
                allClasses.addAll(di.getClasses());
            }
            if (!allClasses.isEmpty()) {
                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDates(), 25), this.rpad(MSG.lrTime(), 15), this.rpad(MSG.lrRoom(), 11), this.rpad(MSG.lrChk(), 3), this.lpad(MSG.lrShare(), 5)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 15), this.lpad("", '-', 11), this.lpad("", '-', 3), this.lpad("", '-', 5)));
                this.println();
                this.println(this.mpad(MSG.lrSectClassSchedule(), this.getNrCharsPerLine()).withColSpan(10));
                this.printHeader(false);
                for (ClassInstructor ci : allClasses) {
                    ClassEvent event;
                    String subject = ci.getClassInstructing().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv();
                    String course = ci.getClassInstructing().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr();
                    String itype = this.getItype(ci.getClassInstructing().getSchedulingSubpart().getControllingCourseOffering(), ci.getClassInstructing());
                    String string = this.iUseClassSuffix && ci.getClassInstructing().getClassSuffix() != null ? ci.getClassInstructing().getClassSuffix() : ci.getClassInstructing().getSectionNumberString();
                    ClassEvent classEvent = event = this.iClass2event == null ? ci.getClassInstructing().getEvent() : this.iClass2event.get(ci.getClassInstructing().getUniqueId());
                    if (event == null && this.iClass2event != null && !this.hasSubjectArea(subject)) {
                        event = ci.getClassInstructing().getEvent();
                    }
                    if (event == null || event.getMeetings().isEmpty()) {
                        this.println(this.rpad(subject, 7), this.rpad(course, 8), this.iItype ? this.rpad(itype, 6) : NULL, this.rpad(string, 9), this.rpad(MSG.lrArrangedHours(), 53).withColSpan(3), this.rpad(ci.isLead() != false ? MSG.lrYes() : MSG.lrNo(), 3), this.lpad(ci.getPercentShare() + "%", 5));
                    } else {
                        Event.MultiMeeting last = null;
                        Object var16_28 = null;
                        Object var17_43 = null;
                        AbstractReport.Cell lastLoc = null;
                        for (Event.MultiMeeting meeting : event.getMultiMeetings()) {
                            AbstractReport.Cell loc;
                            Location location;
                            void var17_44;
                            void var16_29;
                            ArrayList<AbstractReport.Cell> line = new ArrayList<AbstractReport.Cell>();
                            if (last == null) {
                                line.add(this.rpad(subject, 7));
                                line.add(this.rpad(course, 8));
                                line.add(this.iItype ? this.rpad(itype, 6) : NULL);
                                line.add(this.rpad(string, 9));
                            } else {
                                line.add(this.rpad("", 26 + (this.iItype ? 7 : 0)).withColSpan(this.iItype ? 4 : 3));
                            }
                            String date = this.getMeetingDate(meeting);
                            String time = this.getMeetingTime(meeting.getMeetings().first());
                            if (last == null || !time.equals(var16_29) || !date.equals(var17_44)) {
                                line.add(this.rpad(date.equals(var17_44) ? "" : date, 25));
                                line.add(this.rpad(time.equals(var16_29) ? "" : time, 15));
                            } else {
                                line.add(this.rpad("", 41).withColSpan(2));
                            }
                            Long permId = meeting.getMeetings().first().getLocationPermanentId();
                            Location location2 = permId == null ? null : (location = this.iLocations == null ? meeting.getMeetings().first().getLocation() : this.iLocations.get(permId));
                            if (location == null && this.iLocations != null && !this.hasSubjectArea(subject)) {
                                location = meeting.getMeetings().first().getLocation();
                            }
                            AbstractReport.Cell cell = loc = location == null ? this.rpad("", 11) : this.formatRoom(location);
                            if (last == null || !loc.equals(lastLoc)) {
                                line.add(loc);
                            } else {
                                line.add(this.rpad("", 11));
                            }
                            if (last == null) {
                                line.add(this.rpad(ci.isLead() != false ? MSG.lrYes() : MSG.lrNo(), 3));
                                line.add(this.lpad(ci.getPercentShare() + "%", 5));
                            } else {
                                line.add(this.rpad("", 3));
                                line.add(this.lpad("", 5));
                            }
                            lastLoc = loc;
                            String string2 = time;
                            String string3 = date;
                            last = meeting;
                            this.println(line.toArray(new AbstractReport.Cell[line.size()]));
                            if (!this.iNewPage) continue;
                            last = null;
                            Object var16_31 = null;
                            Object var17_46 = null;
                            lastLoc = null;
                        }
                    }
                    if (ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings().size() <= 1) continue;
                    for (CourseOffering courseOffering : ci.getClassInstructing().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                        if (courseOffering.isIsControl().booleanValue()) continue;
                        String string4 = courseOffering.getSubjectAreaAbbv();
                        String xcourse = courseOffering.getCourseNbr();
                        this.println(this.rpad("  " + string4, 8).withSeparator(""), this.rpad(xcourse, 8), this.iItype ? this.rpad(itype, 6) : NULL, this.rpad(string, 9), new AbstractReport.Cell(MSG.lrCrossList()).withColSpan(5));
                    }
                }
            }
        }
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrMeetingTimes(), 36), this.lpad(MSG.lrEnrl(), 5).withSeparator("  "), this.rpad(MSG.lrDateAndTime(), 30), this.rpad(MSG.lrRoom(), 11), this.lpad(MSG.lrCap(), 5), this.lpad(MSG.lrExCap(), 5)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 36), this.lpad("", '-', 5).withSeparator("  "), this.lpad("", '-', 30), this.lpad("", '-', 11), this.lpad("", '-', 5), this.lpad("", '-', 5)));
        this.println();
        this.println(this.mpad(MSG.lrSectExaminationSchedule(), this.getNrCharsPerLine()).withColSpan(10));
        this.printHeader(false);
        this.iSubjectPrinted = false;
        String lastSubject = null;
        this.iCoursePrinted = false;
        String lastCourse = null;
        this.iITypePrinted = false;
        String lastItype = null;
        this.iPeriodPrinted = false;
        String lastSection = null;
        for (ExamAssignmentInfo exam4 : exams) {
            for (ExamInfo.ExamSectionInfo section : exam4.getSectionsIncludeCrosslistedDummies()) {
                if (this.iSubjectPrinted && !section.getSubject().equals(lastSubject)) {
                    this.iSubjectPrinted = false;
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                    this.iPeriodPrinted = false;
                }
                if (this.iCoursePrinted && !section.getCourseNbr().equals(lastCourse)) {
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                    this.iPeriodPrinted = false;
                }
                if (this.iITypePrinted && !section.getItype().equals(lastItype)) {
                    this.iITypePrinted = false;
                    this.iPeriodPrinted = false;
                }
                if (this.iPeriodPrinted && !section.getSection().equals(lastSection)) {
                    this.iPeriodPrinted = false;
                }
                if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                    this.println(this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iITypePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(this.iPeriodPrinted ? "" : section.getSection(), 9), this.rpad(this.getMeetingTime(section), 36), this.lpad(String.valueOf(section.getNrStudents()), 5).withSeparator("  "), this.rpad(section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength(), 30), new AbstractReport.Cell(section.getExamAssignment() == null ? "" : this.iNoRoom).withColSpan(3));
                } else {
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo examRoomInfo : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iSubjectPrinted ? "" : section.getSubject(), 7), this.rpad(!firstRoom || this.iCoursePrinted ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(!firstRoom || this.iITypePrinted ? "" : section.getItype(), 6) : NULL, this.rpad(!firstRoom || this.iPeriodPrinted ? "" : section.getSection(), 9), !firstRoom ? this.rpad("", 36) : this.rpad(this.getMeetingTime(section), 36), this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5).withSeparator("  "), this.rpad(!firstRoom ? "" : (section.getExamAssignment() == null ? "" : section.getExamAssignment().getPeriodNameFixedLength()), 30), this.formatRoom(examRoomInfo), this.lpad("" + examRoomInfo.getCapacity(), 5), this.lpad("" + examRoomInfo.getExamCapacity(), 5));
                        firstRoom = false;
                    }
                }
                if (this.iNewPage) {
                    this.iPeriodPrinted = false;
                    this.iCoursePrinted = false;
                    this.iITypePrinted = false;
                    this.iSubjectPrinted = false;
                    lastSection = null;
                    lastCourse = null;
                    lastItype = null;
                    lastSubject = null;
                    continue;
                }
                this.iPeriodPrinted = true;
                this.iCoursePrinted = true;
                this.iITypePrinted = true;
                this.iSubjectPrinted = true;
                lastSubject = section.getSubject();
                lastItype = section.getItype();
                lastCourse = section.getCourseNbr();
                lastSection = section.getSection();
            }
            this.println();
        }
        this.setHeaderLine(new AbstractReport.Line[0]);
        boolean headerPrinted = false;
        lastSubject = null;
        for (ExamInfo.ExamSectionInfo examSectionInfo : sections) {
            boolean bl = this.iSubjectPrinted = !this.iNewPage && lastSubject != null && lastSubject.equals(examSectionInfo.getSubject());
            exam = examSectionInfo.getExamAssignmentInfo();
            if (exam == null || exam.getPeriod() == null) continue;
            this.iCoursePrinted = false;
            if (this.iDirect) {
                for (ExamAssignmentInfo.DirectConflict directConflict : exam.getInstructorDirectConflicts()) {
                    if (!directConflict.getStudents().contains(instructor.getId())) continue;
                    this.iPeriodPrinted = false;
                    if (directConflict.getOtherExam() != null) {
                        for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!directConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                            if (!headerPrinted) {
                                this.setHeaderLine(new AbstractReport.Line[0]);
                                if (!this.iNewPage) {
                                    this.println();
                                }
                                if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                    this.newPage();
                                }
                                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                this.println(this.mpad(MSG.lrSectInstructorConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                this.printHeader(false);
                                this.setCont(MSG.lrInstructorConflicts(instructor.getName()));
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = examSectionInfo.getSubject();
                        }
                        continue;
                    }
                    if (directConflict.getOtherEventId() == null) continue;
                    if (!headerPrinted) {
                        this.setHeaderLine(new AbstractReport.Line[0]);
                        if (!this.iNewPage) {
                            this.println();
                        }
                        if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                            this.newPage();
                        }
                        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                        this.println(this.mpad(MSG.lrSectInstructorConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                        this.printHeader(false);
                        this.setCont(MSG.lrInstructorConflicts(instructor.getName()));
                        headerPrinted = true;
                    }
                    if (directConflict.isOtherClass()) {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.rpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9), this.getMeetingTime(directConflict.getOtherEventTime()));
                    } else {
                        this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26), this.getMeetingTime(directConflict.getOtherEventTime()));
                    }
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = examSectionInfo.getSubject();
                }
            }
            if (this.iM2d) {
                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getInstructorMoreThanTwoADaysConflicts()) {
                    if (!moreThanTwoADayConflict.getStudents().contains(instructor.getId())) continue;
                    this.iPeriodPrinted = false;
                    for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                        if (!otherExam.getInstructors().contains(instructor)) continue;
                        for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                            if (!headerPrinted) {
                                this.setHeaderLine(new AbstractReport.Line[0]);
                                if (!this.iNewPage) {
                                    this.println();
                                }
                                if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                    this.newPage();
                                }
                                this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                this.println(this.mpad(MSG.lrSectInstructorConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                this.printHeader(false);
                                this.setCont(MSG.lrInstructorConflicts(instructor.getName()));
                                headerPrinted = true;
                            }
                            this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrMore2DAY(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                            lastSubject = examSectionInfo.getSubject();
                        }
                    }
                }
            }
            if (!this.iBtb) continue;
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getInstructorBackToBackConflicts()) {
                if (!backToBackConflict.getStudents().contains(instructor.getId())) continue;
                this.iPeriodPrinted = false;
                for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                    if (!backToBackConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                    if (!headerPrinted) {
                        this.setHeaderLine(new AbstractReport.Line[0]);
                        if (!this.iNewPage) {
                            this.println();
                        }
                        if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                            this.newPage();
                        }
                        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDateAndTime(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                        this.println(this.mpad(MSG.lrSectInstructorConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                        this.printHeader(false);
                        this.setCont(MSG.lrInstructorConflicts(instructor.getName()));
                        headerPrinted = true;
                    }
                    this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.rpad(this.iCoursePrinted ? "" : exam.getPeriodNameFixedLength(), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                    this.iPeriodPrinted = !this.iNewPage;
                    this.iStudentPrinted = this.iPeriodPrinted;
                    this.iCoursePrinted = this.iPeriodPrinted;
                    this.iSubjectPrinted = this.iPeriodPrinted;
                    lastSubject = examSectionInfo.getSubject();
                }
            }
        }
        this.setHeaderLine(new AbstractReport.Line[0]);
        headerPrinted = false;
        lastSubject = null;
        for (ExamInfo.ExamSectionInfo examSectionInfo : sections) {
            boolean bl = this.iSubjectPrinted = !this.iNewPage && lastSubject != null && lastSubject.equals(examSectionInfo.getSubject());
            exam = examSectionInfo.getExamAssignmentInfo();
            if (exam == null || exam.getPeriod() == null) continue;
            this.iCoursePrinted = false;
            Vector<Long> students = new Vector<Long>(examSectionInfo.getStudentIds());
            Collections.sort(students, new Comparator<Long>(){

                @Override
                public int compare(Long s1, Long s2) {
                    int cmp = InstructorExamReport.this.getStudentName(s1).compareTo(InstructorExamReport.this.getStudentName(s2));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.compareTo(s2);
                }
            });
            for (Long l : students) {
                this.iStudentPrinted = false;
                if (this.iDirect) {
                    for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                        if (!directConflict.getStudents().contains(l)) continue;
                        this.iPeriodPrinted = false;
                        if (directConflict.getOtherExam() != null) {
                            for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                if (!other.getStudentIds().contains(l)) continue;
                                if (!headerPrinted) {
                                    this.setHeaderLine(new AbstractReport.Line[0]);
                                    if (!this.iNewPage) {
                                        this.println();
                                    }
                                    if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                        this.newPage();
                                    }
                                    this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                    this.println(this.mpad(MSG.lrSectStudentConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                    this.printHeader(false);
                                    this.setCont(MSG.lrStudentConflicts(instructor.getName()));
                                    headerPrinted = true;
                                }
                                this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.iCoursePrinted ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted ? "" : this.getStudentName(l), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                this.iPeriodPrinted = !this.iNewPage;
                                this.iStudentPrinted = this.iPeriodPrinted;
                                this.iCoursePrinted = this.iPeriodPrinted;
                                this.iSubjectPrinted = this.iPeriodPrinted;
                                lastSubject = examSectionInfo.getSubject();
                            }
                            continue;
                        }
                        if (directConflict.getOtherEventId() == null) continue;
                        if (!headerPrinted) {
                            this.setHeaderLine(new AbstractReport.Line[0]);
                            if (!this.iNewPage) {
                                this.println();
                            }
                            if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                this.newPage();
                            }
                            this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                            this.println(this.mpad(MSG.lrSectStudentConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                            this.printHeader(false);
                            this.setCont(MSG.lrStudentConflicts(instructor.getName()));
                            headerPrinted = true;
                        }
                        if (directConflict.isOtherClass()) {
                            this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.iCoursePrinted ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted ? "" : this.getStudentName(l), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.rpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9), this.getMeetingTime(directConflict.getOtherEventTime()));
                        } else {
                            this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.iCoursePrinted ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted ? "" : this.getStudentName(l), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26), this.getMeetingTime(directConflict.getOtherEventTime()));
                        }
                        this.iPeriodPrinted = !this.iNewPage;
                        this.iStudentPrinted = this.iPeriodPrinted;
                        this.iCoursePrinted = this.iPeriodPrinted;
                        this.iSubjectPrinted = this.iPeriodPrinted;
                        lastSubject = examSectionInfo.getSubject();
                    }
                }
                if (this.iM2d) {
                    for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                        if (!moreThanTwoADayConflict.getStudents().contains(l)) continue;
                        this.iPeriodPrinted = false;
                        for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                            for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                if (!other.getStudentIds().contains(l)) continue;
                                if (!headerPrinted) {
                                    if (!this.iNewPage) {
                                        this.println();
                                    }
                                    this.setHeaderLine(new AbstractReport.Line[0]);
                                    if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                        this.newPage();
                                    }
                                    this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                                    this.println(this.mpad(MSG.lrSectStudentConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                                    this.printHeader(false);
                                    this.setCont(MSG.lrStudentConflicts(instructor.getName()));
                                    headerPrinted = true;
                                }
                                this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.iCoursePrinted ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted ? "" : this.getStudentName(l), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrMore2DAY(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                this.iPeriodPrinted = !this.iNewPage;
                                this.iStudentPrinted = this.iPeriodPrinted;
                                this.iCoursePrinted = this.iPeriodPrinted;
                                this.iSubjectPrinted = this.iPeriodPrinted;
                                lastSubject = examSectionInfo.getSubject();
                            }
                        }
                    }
                }
                if (!this.iBtb) continue;
                for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                    if (!backToBackConflict.getStudents().contains(l)) continue;
                    this.iPeriodPrinted = false;
                    for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                        if (!other.getStudentIds().contains(l)) continue;
                        if (!headerPrinted) {
                            this.setHeaderLine(new AbstractReport.Line[0]);
                            if (!this.iNewPage) {
                                this.println();
                            }
                            if (this.getLineNumber() + 5 >= this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                                this.newPage();
                            }
                            this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 9), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 9), this.lpad("", '-', 15)));
                            this.println(this.mpad(MSG.lrSectStudentConflicts(), this.getNrCharsPerLine()).withColSpan(10));
                            this.printHeader(false);
                            this.setCont(MSG.lrStudentConflicts(instructor.getName()));
                            headerPrinted = true;
                        }
                        this.println(this.rpad(this.iSubjectPrinted ? "" : examSectionInfo.getSubject(), 7), this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getItype(), 6) : NULL, this.rpad(this.iCoursePrinted ? "" : examSectionInfo.getSection(), 9), this.iCoursePrinted ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted ? "" : this.getStudentName(l), 25), this.rpad(this.iPeriodPrinted ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.rpad(other.getSection(), 9), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                        this.iPeriodPrinted = !this.iNewPage;
                        this.iStudentPrinted = this.iPeriodPrinted;
                        this.iCoursePrinted = this.iPeriodPrinted;
                        this.iSubjectPrinted = this.iPeriodPrinted;
                        lastSubject = examSectionInfo.getSubject();
                    }
                }
            }
        }
        this.setHeaderLine(new AbstractReport.Line[0]);
        this.setCont(null);
    }

    public static interface FileGenerator {
        public File generate(String var1, String var2);
    }
}

