/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class SolverInterface
implements IsSerializable {

    public static class SolverPageMessages
    implements GwtRpcResponse,
    HasPageMessages {
        private List<PageMessage> iPageMessages = null;

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<PageMessage>();
            }
            this.iPageMessages.add(message);
        }
    }

    public static class SolverPageMessagesRequest
    implements GwtRpcRequest<SolverPageMessages> {
        private SolverType iType;

        public SolverPageMessagesRequest() {
        }

        public SolverPageMessagesRequest(SolverType type) {
            this.iType = type;
        }

        public SolverType getType() {
            return this.iType;
        }

        public void setType(SolverType type) {
            this.iType = type;
        }
    }

    public static class SolverLogPageRequest
    implements GwtRpcRequest<SolverLogPageResponse> {
        private ProgressLogLevel iLevel;
        private SolverType iType;
        private Date iLast;

        public SolverLogPageRequest() {
        }

        public SolverLogPageRequest(SolverType type, ProgressLogLevel level, Date last) {
            this.iType = type;
            this.iLevel = level;
            this.iLast = last;
        }

        public SolverType getType() {
            return this.iType;
        }

        public void setType(SolverType type) {
            this.iType = type;
        }

        public void setLevel(ProgressLogLevel level) {
            this.iLevel = level;
        }

        public boolean hasLevel() {
            return this.iLevel != null;
        }

        public ProgressLogLevel getLevel() {
            return this.iLevel;
        }

        public Date getLastDate() {
            return this.iLast;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.getType()) + ": " + (Object)((Object)this.getLevel());
        }
    }

    public static class SolverLogPageResponse
    implements GwtRpcResponse {
        private List<ProgressMessage> iLog = null;
        private List<SolutionLog> iSolutionLogs = null;
        private ProgressLogLevel iLevel;

        public SolverLogPageResponse() {
        }

        public SolverLogPageResponse(int level) {
            this.iLevel = ProgressLogLevel.values()[level];
        }

        public SolverLogPageResponse(ProgressLogLevel level) {
            this.iLevel = level;
        }

        public ProgressLogLevel getLevel() {
            return this.iLevel;
        }

        public void addMessage(int level, Date date, String message, String[] trace) {
            if (this.iLog == null) {
                this.iLog = new ArrayList<ProgressMessage>();
            }
            this.iLog.add(new ProgressMessage(level, date, message, trace));
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public List<ProgressMessage> getLog() {
            return this.iLog;
        }

        public boolean hasSolutionLogs() {
            return this.iSolutionLogs != null && !this.iSolutionLogs.isEmpty();
        }

        public List<SolutionLog> getSolutionLogs() {
            return this.iSolutionLogs;
        }

        public void addSolutionLog(SolutionLog log) {
            if (this.iSolutionLogs == null) {
                this.iSolutionLogs = new ArrayList<SolutionLog>();
            }
            this.iSolutionLogs.add(log);
        }
    }

    public static class SolutionLog
    implements GwtRpcResponse {
        private List<ProgressMessage> iLog = null;
        private String iOwner;

        public SolutionLog() {
        }

        public SolutionLog(String owner) {
            this.iOwner = owner;
        }

        public String getOwner() {
            return this.iOwner;
        }

        public void addMessage(int level, Date date, String message, String[] trace) {
            if (this.iLog == null) {
                this.iLog = new ArrayList<ProgressMessage>();
            }
            this.iLog.add(new ProgressMessage(level, date, message, trace));
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public List<ProgressMessage> getLog() {
            return this.iLog;
        }
    }

    public static class ProgressMessage
    implements IsSerializable {
        private ProgressLogLevel iLevel;
        private Date iDate;
        private String iMessage;
        private String[] iStackTrace;

        public ProgressMessage() {
        }

        public ProgressMessage(int level, Date date, String message, String[] trace) {
            this.iLevel = ProgressLogLevel.values()[level];
            this.iDate = date;
            this.iMessage = message;
            this.iStackTrace = trace;
        }

        public ProgressLogLevel getLevel() {
            return this.iLevel;
        }

        public Date getDate() {
            return this.iDate;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public boolean hasStackTrace() {
            return this.iStackTrace != null && this.iStackTrace.length > 0;
        }

        public String[] getStackTrace() {
            return this.iStackTrace;
        }
    }

    public static enum ProgressLogLevel implements IsSerializable
    {
        TRACE,
        DEBUG,
        PROGRESS,
        INFO,
        STAGE,
        WARN,
        ERROR,
        FATAL;

    }

    public static class SolverPageRequest
    implements GwtRpcRequest<SolverPageResponse> {
        private SolverType iType;
        private SolverOperation iOperation;
        private List<Long> iOwnerIds;
        private Long iConfigurationId;
        private String iHost;
        private Map<Long, String> iParameters;

        public SolverPageRequest() {
        }

        public SolverPageRequest(SolverType type, SolverOperation operation) {
            this.iType = type;
            this.iOperation = operation;
        }

        public SolverType getType() {
            return this.iType;
        }

        public void setType(SolverType type) {
            this.iType = type;
        }

        public SolverOperation getOperation() {
            return this.iOperation;
        }

        public void setOperation(SolverOperation operation) {
            this.iOperation = operation;
        }

        public Long getConfigurationId() {
            return this.iConfigurationId;
        }

        public void setConfigurationId(Long configId) {
            this.iConfigurationId = configId;
        }

        public boolean hasOwerIds() {
            return this.iOwnerIds != null && !this.iOwnerIds.isEmpty();
        }

        public List<Long> getOwnerIds() {
            return this.iOwnerIds;
        }

        public void addOwnerId(Long ownerId) {
            if (this.iOwnerIds == null) {
                this.iOwnerIds = new ArrayList<Long>();
            }
            this.iOwnerIds.add(ownerId);
        }

        public String getHost() {
            return this.iHost;
        }

        public void setHost(String host) {
            this.iHost = host;
        }

        public boolean hasParameters() {
            return this.iParameters != null && !this.iParameters.isEmpty();
        }

        public void addParameter(Long id, String value) {
            if (this.iParameters == null) {
                this.iParameters = new HashMap<Long, String>();
            }
            this.iParameters.put(id, value);
        }

        public Map<Long, String> getParameters() {
            return this.iParameters;
        }

        public String getParameter(Long id) {
            if (this.iParameters == null) {
                return null;
            }
            return this.iParameters == null ? null : this.iParameters.get(id);
        }

        public void clear() {
            this.iOwnerIds = null;
            this.iConfigurationId = null;
            this.iHost = null;
            this.iParameters = null;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.getType()) + ": " + (Object)((Object)this.getOperation());
        }
    }

    public static class SolverPageResponse
    implements GwtRpcResponse,
    HasPageMessages {
        private Date iLoadDate;
        private SolverType iSolverType;
        private SolverOperation iOperation;
        private String iSolverStatus;
        private String iSolverProgress;
        private Long iConfigurationId;
        private List<SolverConfiguration> iConfigurations;
        private List<SolverParameter> iParameters;
        private List<Long> iOwnerIds;
        private List<SolverOwner> iSolverOwners;
        private String iHost;
        private List<String> iHosts;
        private SolutionInfo iCurrentSolution;
        private SolutionInfo iBestSolution;
        private List<SolutionInfo> iSelectedSolutions;
        private List<ProgressMessage> iLog;
        private int iOperations = 0;
        private boolean iAllowMultipleOwners = false;
        private boolean iWorking = false;
        private boolean iRefresh = false;
        private List<PageMessage> iPageMessages = null;

        public SolverType getSolverType() {
            return this.iSolverType;
        }

        public void setSolverType(SolverType type) {
            this.iSolverType = type;
        }

        public SolverOperation getOperation() {
            return this.iOperation;
        }

        public void setOperation(SolverOperation operation) {
            this.iOperation = operation;
        }

        public String getSolverStatus() {
            return this.iSolverStatus;
        }

        public void setSolverStatus(String solverStatus) {
            this.iSolverStatus = solverStatus;
        }

        public String getSolverProgress() {
            return this.iSolverProgress;
        }

        public void setSolverProgress(String solverProgress) {
            this.iSolverProgress = solverProgress;
        }

        public Long getConfigurationId() {
            return this.iConfigurationId;
        }

        public void setConfigurationId(Long configId) {
            this.iConfigurationId = configId;
        }

        public boolean hasConfigurations() {
            return this.iConfigurations != null && !this.iConfigurations.isEmpty();
        }

        public SolverConfiguration getConfiguration(Long id) {
            if (this.iConfigurations == null) {
                return null;
            }
            for (SolverConfiguration config : this.iConfigurations) {
                if (!id.equals(config.getId())) continue;
                return config;
            }
            return null;
        }

        public List<SolverConfiguration> getConfigurations() {
            return this.iConfigurations;
        }

        public void addConfiguration(SolverConfiguration config) {
            if (this.iConfigurations == null) {
                this.iConfigurations = new ArrayList<SolverConfiguration>();
            }
            this.iConfigurations.add(config);
        }

        public boolean hasParameters() {
            return this.iParameters != null && !this.iParameters.isEmpty();
        }

        public List<SolverParameter> getParameters() {
            return this.iParameters;
        }

        public void addParameter(SolverParameter parameter) {
            if (this.iParameters == null) {
                this.iParameters = new ArrayList<SolverParameter>();
            }
            this.iParameters.add(parameter);
        }

        public SolverParameter getParameter(Long id) {
            if (this.iParameters == null || id == null) {
                return null;
            }
            for (SolverParameter paremeter : this.iParameters) {
                if (!id.equals(paremeter.getId())) continue;
                return paremeter;
            }
            return null;
        }

        public boolean hasSolverOwners() {
            return this.iSolverOwners != null && !this.iSolverOwners.isEmpty();
        }

        public List<SolverOwner> getSolverOwners() {
            return this.iSolverOwners;
        }

        public void addSolverOwner(SolverOwner solverOwner) {
            if (this.iSolverOwners == null) {
                this.iSolverOwners = new ArrayList<SolverOwner>();
            }
            this.iSolverOwners.add(solverOwner);
        }

        public SolverOwner getSolverOwner(Long id) {
            if (this.iSolverOwners == null || id == null) {
                return null;
            }
            for (SolverOwner g : this.iSolverOwners) {
                if (!id.equals(g.getId())) continue;
                return g;
            }
            return null;
        }

        public boolean isAllowMultipleOwners() {
            return this.iAllowMultipleOwners;
        }

        public void setAllowMultipleOwners(boolean allow) {
            this.iAllowMultipleOwners = allow;
        }

        public boolean hasOwerIds() {
            return this.iOwnerIds != null && !this.iOwnerIds.isEmpty();
        }

        public List<Long> getOwnerIds() {
            return this.iOwnerIds;
        }

        public void addOwnerId(Long ownerId) {
            if (this.iOwnerIds == null) {
                this.iOwnerIds = new ArrayList<Long>();
            }
            this.iOwnerIds.add(ownerId);
        }

        public String getHost() {
            return this.iHost;
        }

        public void setHost(String host) {
            this.iHost = host;
        }

        public boolean hasHosts() {
            return this.iHosts != null && !this.iHosts.isEmpty();
        }

        public List<String> getHosts() {
            return this.iHosts;
        }

        public void addHost(String host) {
            if (this.iHosts == null) {
                this.iHosts = new ArrayList<String>();
            }
            this.iHosts.add(host);
        }

        public void addHost(int index, String host) {
            if (this.iHosts == null) {
                this.iHosts = new ArrayList<String>();
            }
            this.iHosts.add(index, host);
        }

        public boolean hasCurrentSolution() {
            return this.iCurrentSolution != null;
        }

        public SolutionInfo getCurrentSolution() {
            return this.iCurrentSolution;
        }

        public void setCurrentSolution(SolutionInfo current) {
            this.iCurrentSolution = current;
        }

        public boolean hasBestSolution() {
            return this.iBestSolution != null;
        }

        public SolutionInfo getBestSolution() {
            return this.iBestSolution;
        }

        public void setBestSolution(SolutionInfo best) {
            this.iBestSolution = best;
        }

        public boolean hasSelectedSolutions() {
            return this.iSelectedSolutions != null && !this.iSelectedSolutions.isEmpty();
        }

        public void addSelectedSolution(SolutionInfo selected) {
            if (this.iSelectedSolutions == null) {
                this.iSelectedSolutions = new ArrayList<SolutionInfo>();
            }
            this.iSelectedSolutions.add(selected);
        }

        public List<SolutionInfo> getSelectedSolutions() {
            return this.iSelectedSolutions;
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public void addMessage(int level, Date date, String message, String[] trace) {
            if (this.iLog == null) {
                this.iLog = new ArrayList<ProgressMessage>();
            }
            this.iLog.add(new ProgressMessage(level, date, message, trace));
        }

        public List<ProgressMessage> getLog() {
            return this.iLog;
        }

        public boolean canExecute(SolverOperation operation) {
            return operation.in(this.iOperations);
        }

        public void setCanExecute(SolverOperation operation, boolean enabled) {
            this.iOperations = enabled ? operation.set(this.iOperations) : operation.clear(this.iOperations);
        }

        public void setCanExecute(SolverOperation ... operations) {
            for (SolverOperation operation : operations) {
                this.iOperations = operation.set(this.iOperations);
            }
        }

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<PageMessage>();
            }
            this.iPageMessages.add(message);
        }

        public Date getLoadDate() {
            return this.iLoadDate;
        }

        public void setLoadDate(Date date) {
            this.iLoadDate = date;
        }

        public boolean isWorking() {
            return this.iWorking;
        }

        public void setWorking(boolean working) {
            this.iWorking = working;
        }

        public boolean isRefresh() {
            return this.iRefresh;
        }

        public void setRefresh(boolean refresh) {
            this.iRefresh = refresh;
        }
    }

    public static interface HasPageMessages {
        public boolean hasPageMessages();

        public List<PageMessage> getPageMessages();

        public void addPageMessage(PageMessage var1);
    }

    public static class PageMessage
    implements IsSerializable {
        private PageMessageType iType;
        private String iMessage;
        private String iUrl;

        public PageMessage() {
        }

        public PageMessage(PageMessageType type, String message, String url) {
            this.iType = type;
            this.iMessage = message;
            this.iUrl = url;
        }

        public PageMessage(PageMessageType type, String message) {
            this(type, message, null);
        }

        public PageMessageType getType() {
            return this.iType;
        }

        public void setType(PageMessageType type) {
            this.iType = type;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasUrl() {
            return this.iUrl != null && !this.iUrl.isEmpty();
        }

        public String getUrl() {
            return this.iUrl;
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }
    }

    public static enum PageMessageType implements IsSerializable
    {
        INFO,
        WARNING,
        ERROR;

    }

    public static class SolutionInfo
    implements IsSerializable {
        private Long iId = null;
        private List<InfoPair> iPairs = new ArrayList<InfoPair>();
        private String iName = null;
        private List<ProgressMessage> iLog = null;
        private String iCreated = null;
        private String iCommitted = null;
        private String iNote = null;
        private String iOwner = null;

        public InfoPair addPair(String name, String value) {
            InfoPair pair = new InfoPair(name, value);
            this.iPairs.add(pair);
            return pair;
        }

        public List<InfoPair> getPairs() {
            return this.iPairs;
        }

        public boolean isEmpty() {
            return this.iPairs.isEmpty();
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public void addMessage(int level, Date date, String message, String[] trace) {
            if (this.iLog == null) {
                this.iLog = new ArrayList<ProgressMessage>();
            }
            this.iLog.add(new ProgressMessage(level, date, message, trace));
        }

        public List<ProgressMessage> getLog() {
            return this.iLog;
        }

        public String getCreated() {
            return this.iCreated;
        }

        public void setCreated(String date) {
            this.iCreated = date;
        }

        public String getCommitted() {
            return this.iCommitted;
        }

        public void setCommitted(String committed) {
            this.iCommitted = committed;
        }

        public String getNote() {
            return this.iNote == null ? "" : this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String getOwner() {
            return this.iOwner;
        }

        public void setOwner(String owner) {
            this.iOwner = owner;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String toString() {
            return this.iPairs.toString();
        }
    }

    public static class InfoPair
    implements IsSerializable {
        private String iName;
        private String iValue;

        public InfoPair() {
        }

        public InfoPair(String name, String value) {
            this.iName = name;
            this.iValue = value;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getValue() {
            return this.iValue;
        }

        public String toString() {
            return this.iName + ": " + this.iValue;
        }
    }

    public static class SolverOwner
    implements IsSerializable {
        private Long iId;
        private String iName;

        public SolverOwner() {
        }

        public SolverOwner(Long id, String name) {
            this.iId = id;
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }
    }

    public static class SolverConfiguration
    implements IsSerializable {
        private Long iId;
        private String iName;
        private Map<Long, String> iParameters;

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public boolean hasParameters() {
            return this.iParameters != null && !this.iParameters.isEmpty();
        }

        public void addParameter(Long id, String value) {
            if (this.iParameters == null) {
                this.iParameters = new HashMap<Long, String>();
            }
            this.iParameters.put(id, value);
        }

        public Map<Long, String> getParameters() {
            return this.iParameters;
        }

        public String getParameter(Long id) {
            if (this.iParameters == null) {
                return null;
            }
            return this.iParameters == null ? null : this.iParameters.get(id);
        }
    }

    public static class SolverParameter
    implements IsSerializable {
        private Long iId;
        private String iKey;
        private String iType;
        private String iName;
        private String iValue;
        private String iDefaut;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getKey() {
            return this.iKey;
        }

        public void setKey(String key) {
            this.iKey = key;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getDefaultValue() {
            return this.iDefaut;
        }

        public void setDefaultValue(String defaultValue) {
            this.iDefaut = defaultValue;
        }

        public String toString() {
            return this.getKey() + "=" + (this.getValue() != null ? this.getValue() : (this.getDefaultValue() != null ? this.getDefaultValue() : ""));
        }
    }

    public static enum SolverOperation implements IsSerializable
    {
        INIT,
        CHECK,
        LOAD,
        START,
        UNLOAD,
        RELOAD,
        STOP,
        CLEAR,
        EXPORT_CSV,
        EXPORT_XML,
        STUDENT_SECTIONING,
        SAVE_BEST,
        RESTORE_BEST,
        SAVE,
        SAVE_AS_NEW,
        SAVE_COMMIT,
        SAVE_AS_NEW_COMMIT,
        SAVE_UNCOMMIT,
        VALIDATE,
        PUBLISH,
        UNPUBLISH,
        CLONE;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }

    public static enum SolverType implements IsSerializable
    {
        COURSE,
        EXAM,
        STUDENT,
        INSTRUCTOR;

    }
}

