/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;

public abstract class BaseRoomGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iAbbv;
    private String iDescription;
    private Boolean iGlobal;
    private Boolean iDefaultGroup;
    private Department iDepartment;
    private Session iSession;
    private Set<Location> iRooms;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_NAME = "name";
    public static String PROP_ABBV = "abbv";
    public static String PROP_DESCRIPTION = "description";
    public static String PROP_GLOBAL = "global";
    public static String PROP_DEFAULT_GROUP = "defaultGroup";

    public BaseRoomGroup() {
        this.initialize();
    }

    public BaseRoomGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public Boolean isGlobal() {
        return this.iGlobal;
    }

    public Boolean getGlobal() {
        return this.iGlobal;
    }

    public void setGlobal(Boolean global) {
        this.iGlobal = global;
    }

    public Boolean isDefaultGroup() {
        return this.iDefaultGroup;
    }

    public Boolean getDefaultGroup() {
        return this.iDefaultGroup;
    }

    public void setDefaultGroup(Boolean defaultGroup) {
        this.iDefaultGroup = defaultGroup;
    }

    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addTorooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RoomGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "RoomGroup[\n\tAbbv: " + this.getAbbv() + "\n\tDefaultGroup: " + this.getDefaultGroup() + "\n\tDepartment: " + this.getDepartment() + "\n\tDescription: " + this.getDescription() + "\n\tGlobal: " + this.getGlobal() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

