/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Iterator;
import java.util.Set;
import org.unitime.timetable.model.base.BaseExternalRoomDepartment;

public class ExternalRoomDepartment
extends BaseExternalRoomDepartment {
    private static final long serialVersionUID = 1L;
    public static String ASSIGNMENT_TYPE_ASSIGNED = "assigned";
    public static String ASSIGNMENT_TYPE_SCHEDULING = "scheduling";

    public ExternalRoomDepartment() {
    }

    public ExternalRoomDepartment(Long uniqueId) {
        super(uniqueId);
    }

    public boolean isAssigned() {
        return this.checkAssignmentType(ASSIGNMENT_TYPE_ASSIGNED);
    }

    public boolean isScheduling() {
        return this.checkAssignmentType(ASSIGNMENT_TYPE_SCHEDULING);
    }

    private boolean checkAssignmentType(String assignmentType) {
        boolean result = false;
        if (this.getAssignmentType().equals(assignmentType)) {
            result = true;
        }
        return result;
    }

    public static boolean isControllingExternalDept(ExternalRoomDepartment externalRoomDept, Set deptList) {
        String asgn = "assigned";
        String sched = "scheduling";
        if (externalRoomDept == null || deptList == null || deptList.isEmpty()) {
            return false;
        }
        if (deptList.size() == 1) {
            return deptList.contains(externalRoomDept);
        }
        boolean isControl = true;
        ExternalRoomDepartment erd = null;
        Iterator erdIt = deptList.iterator();
        while (erdIt.hasNext() && isControl) {
            erd = (ExternalRoomDepartment)erdIt.next();
            if (erd == null || erd.equals(externalRoomDept) || erd.getDepartmentCode().equals(externalRoomDept.getDepartmentCode())) continue;
            if (externalRoomDept.getAssignmentType().equals(asgn)) {
                if (erd.getAssignmentType().equals(asgn) && erd.getPercent().compareTo(externalRoomDept.getPercent()) >= 0) {
                    isControl = false;
                    continue;
                }
                if (!erd.getAssignmentType().equals(sched)) continue;
                isControl = false;
                continue;
            }
            if (!externalRoomDept.getAssignmentType().equals(sched) || !erd.getAssignmentType().equals(sched) || erd.getPercent().compareTo(externalRoomDept.getPercent()) < 0) continue;
            isControl = false;
        }
        return isControl;
    }
}

