/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseLong;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;

public class PointInTimeDataReportsInterface
implements IsSerializable {

    public static class PITDSetBackRpcRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private String iHistory;
        private List<Long> iIds = new ArrayList<Long>();
        private String iType;

        public String getHistory() {
            return this.iHistory;
        }

        public void setHistory(String history) {
            this.iHistory = history;
        }

        public void addId(Long id) {
            if (!this.iIds.contains(id)) {
                this.iIds.add(id);
            }
        }

        public List<Long> getIds() {
            return this.iIds;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getType() {
            return this.iType;
        }

        @Override
        public String toString() {
            return "courses#" + this.getHistory();
        }
    }

    public static class PITDDeleteRpcRequest
    implements GwtRpcRequest<GwtRpcResponseBoolean> {
        private Long iId = null;

        public PITDDeleteRpcRequest() {
        }

        public PITDDeleteRpcRequest(Long id) {
            this.iId = id;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        @Override
        public String toString() {
            return this.iId == null ? "null" : this.iId.toString();
        }
    }

    public static class PITDStoreRpcRequest
    extends Report
    implements GwtRpcRequest<GwtRpcResponseLong> {
        public PITDStoreRpcRequest() {
        }

        public PITDStoreRpcRequest(Report query) {
            this.setId(query.getId());
            this.setName(query.getName());
            this.setDescription(query.getDescription());
            this.setFlags(query.getFlags());
        }
    }

    public static class PITDExecuteRpcRequest
    implements GwtRpcRequest<Table> {
        private Report iReport;
        private List<IdValue> iParameters = new ArrayList<IdValue>();

        public void setReport(Report report) {
            this.iReport = report;
        }

        public Report getReport() {
            return this.iReport;
        }

        public void addParameter(String value, String text) {
            this.iParameters.add(new IdValue(value, text));
        }

        public List<IdValue> getParameters() {
            return this.iParameters;
        }

        @Override
        public String toString() {
            return this.iReport.getName() + " {options: " + this.getParameters() + "}";
        }
    }

    public static class Table
    implements GwtRpcResponse {
        private List<String[]> iData = new ArrayList<String[]>();

        public void add(String ... line) {
            this.iData.add(line);
        }

        public int size() {
            return this.iData.size();
        }

        public String[] get(int row) {
            return this.iData.get(row);
        }
    }

    public static class PITDQueriesRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<Report>> {
    }

    public static class PITDParametersRpcRequest
    implements GwtRpcRequest<PITDParametersInterface> {
        @Override
        public String toString() {
            return null;
        }
    }

    public static class PITDParametersInterface
    implements GwtRpcResponse {
        private List<Flag> iFlags = new ArrayList<Flag>();
        private List<Parameter> iParameters = new ArrayList<Parameter>();
        private boolean iEditable = false;

        public void addFlag(Flag flag) {
            this.iFlags.add(flag);
        }

        public List<Flag> getFlags() {
            return this.iFlags;
        }

        public void addParameter(Parameter parameter) {
            this.iParameters.add(parameter);
        }

        public List<Parameter> getParameters() {
            return this.iParameters;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }
    }

    public static class Report
    implements GwtRpcResponse {
        private String iId = null;
        private String iName;
        private String iDescription;
        private List<Parameter> iParameters = new ArrayList<Parameter>();
        private int iFlags = 0;

        public String getId() {
            return this.iId;
        }

        public void setId(String id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getDescription() {
            return this.iDescription == null ? "" : this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public int getFlags() {
            return this.iFlags;
        }

        public void setFlags(int flags) {
            this.iFlags = flags;
        }

        public void addParameter(Parameter parameter) {
            this.iParameters.add(parameter);
        }

        public List<Parameter> getParameters() {
            return this.iParameters;
        }

        public String toString() {
            return this.getName();
        }

        public boolean parametersContain(String type) {
            if (type == null || type.isEmpty()) {
                return false;
            }
            boolean found = false;
            for (Parameter param : this.getParameters()) {
                if (!type.equals(param.getType())) continue;
                found = true;
                break;
            }
            return found;
        }
    }

    public static class Parameter
    implements IsSerializable {
        private String iType;
        private String iName;
        private List<IdValue> iValues = new ArrayList<IdValue>();
        private boolean iMultiSelect;
        private boolean iTextField;
        private String iDefaultTextValue;

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public List<IdValue> values() {
            return this.iValues;
        }

        public boolean isMultiSelect() {
            return this.iMultiSelect;
        }

        public void setMultiSelect(boolean multiSelect) {
            this.iMultiSelect = multiSelect;
        }

        public boolean isTextField() {
            return this.iTextField;
        }

        public void setTextField(boolean textField) {
            this.iTextField = textField;
        }

        public String getDefaultTextValue() {
            return this.iDefaultTextValue;
        }

        public void setDefaultTextValue(String defaultValue) {
            this.iDefaultTextValue = defaultValue;
        }
    }

    public static class IdValue
    implements IsSerializable,
    Comparable<IdValue> {
        private String iValue;
        private String iText;

        public IdValue() {
        }

        public IdValue(String value, String text) {
            this.iValue = value;
            this.iText = text;
        }

        public String getValue() {
            return this.iValue;
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        @Override
        public int compareTo(IdValue o) {
            return this.getText().compareTo(o.getText());
        }

        public String toString() {
            return this.getValue() + ": " + this.getText();
        }
    }

    public static class Flag
    implements IsSerializable {
        private int iValue;
        private String iText;

        public int getValue() {
            return this.iValue;
        }

        public void setValue(int value) {
            this.iValue = value;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }
    }
}

