/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.i18n.shared.WordCountDirectionEstimator;

public class AutoDirectionHandler
implements KeyUpHandler,
HasDirectionEstimator {
    private DirectionEstimator directionEstimator;
    private HandlerRegistration handlerRegistration;
    private Target target;

    public static AutoDirectionHandler addTo(Target target) {
        return AutoDirectionHandler.addTo(target, true);
    }

    public static AutoDirectionHandler addTo(Target target, boolean enabled) {
        return AutoDirectionHandler.addTo(target, enabled ? WordCountDirectionEstimator.get() : null);
    }

    public static AutoDirectionHandler addTo(Target target, DirectionEstimator directionEstimator) {
        return new AutoDirectionHandler(target, directionEstimator);
    }

    private AutoDirectionHandler(Target target, DirectionEstimator directionEstimator) {
        this.target = target;
        this.handlerRegistration = null;
        this.setDirectionEstimator(directionEstimator);
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.directionEstimator;
    }

    @Override
    public void onKeyUp(KeyUpEvent event) {
        this.refreshDirection();
    }

    public void refreshDirection() {
        HasDirection.Direction dir;
        if (this.directionEstimator != null && (dir = this.directionEstimator.estimateDirection(this.target.getText())) != this.target.getDirection()) {
            this.target.setDirection(dir);
        }
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.setDirectionEstimator(enabled ? WordCountDirectionEstimator.get() : null);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.directionEstimator = directionEstimator;
        if (directionEstimator == null != (this.handlerRegistration == null)) {
            if (directionEstimator == null) {
                this.handlerRegistration.removeHandler();
                this.handlerRegistration = null;
            } else {
                this.handlerRegistration = this.target.addKeyUpHandler(this);
            }
        }
        this.refreshDirection();
    }

    public static interface Target
    extends HasDirection,
    HasKeyUpHandlers {
        public String getText();

        public void setText(String var1);
    }
}

