/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.TaskInterface;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.dao.TaskExecutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.TaskExecutionItem;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueMessage;

@GwtRpcImplements(value=TaskInterface.GetTaskExecutionLogRpcRequest.class)
public class GetTaskExecutionLogBackend
implements GwtRpcImplementation<TaskInterface.GetTaskExecutionLogRpcRequest, TaskInterface.TaskExecutionLogInterface> {
    public static final Type TYPE_LOG = new TypeToken<ArrayList<QueueMessage>>(){}.getType();
    @Autowired
    SolverServerService solverServerService;

    @Override
    public TaskInterface.TaskExecutionLogInterface execute(TaskInterface.GetTaskExecutionLogRpcRequest request, SessionContext context) {
        QueueItem item;
        context.hasPermission(Right.TaskDetail);
        TaskExecution e = (TaskExecution)TaskExecutionDAO.getInstance().get(request.getTaskExecutionId());
        if (e == null) {
            return null;
        }
        List log = null;
        if ((e.getExecutionStatus().intValue() == TaskInterface.ExecutionStatus.QUEUED.ordinal() || e.getExecutionStatus().intValue() == TaskInterface.ExecutionStatus.RUNNING.ordinal()) && (item = this.solverServerService.getQueueProcessor().getByExecutionId(request.getTaskExecutionId())) != null) {
            log = item.getLog();
        }
        if (e.getLogFile() != null) {
            log = (List)TaskExecutionItem.createGson().fromJson(e.getLogFile(), TYPE_LOG);
        }
        TaskInterface.TaskExecutionLogInterface ret = new TaskInterface.TaskExecutionLogInterface();
        if (log != null) {
            String html = "";
            for (QueueMessage m : log) {
                if (!html.isEmpty()) {
                    html = html + "<br>";
                }
                html = html + m.toHTML();
            }
            ret.setLog(html);
        }
        return ret;
    }
}

