/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseDemandDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationHelper;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.util.Formats;

public class PurdueWaitListValidationProvider
implements WaitListValidationProvider {
    private static Log sLog = LogFactory.getLog(PurdueWaitListValidationProvider.class);
    protected static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public PurdueWaitListValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiValidationSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site.validation", this.getSpecialRegistrationApiSite() + "/checkRestrictions");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkAllSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkAllSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.waitlist", "WAITL"));
    }

    protected String getBannerId(Student student) {
        String id = student.getExternalUniqueId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        String id = user.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected SpecialRegistrationInterface.RequestorRole getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (student != null) {
            return user.getExternalId().equals(student.getExternalId()) ? SpecialRegistrationInterface.RequestorRole.STUDENT : SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        if (user.hasType()) {
            switch (user.getType()) {
                case MANAGER: {
                    return SpecialRegistrationInterface.RequestorRole.MANAGER;
                }
                case STUDENT: {
                    return SpecialRegistrationInterface.RequestorRole.STUDENT;
                }
            }
            return SpecialRegistrationInterface.RequestorRole.MANAGER;
        }
        return null;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    protected String getCRN(Section section, Course course) {
        String name = section.getName(course.getId());
        if (name != null && name.indexOf(45) >= 0) {
            return name.substring(0, name.indexOf(45));
        }
        return name;
    }

    protected boolean isValidationEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status != null && status.hasOption(StudentSectioningStatus.Option.waitlist) && status.hasOption(StudentSectioningStatus.Option.specreg);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.waitlist) && dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }

    protected Enrollment firstEnrollment(CourseRequest request, Assignment<Request, Enrollment> assignment, Course course, Config config, HashSet<Section> sections, int idx) {
        if (config.getSubparts().size() == idx) {
            Enrollment e = new Enrollment((Request)request, request.getCourses().indexOf(course), null, config, new HashSet<Section>(sections), null);
            if (request.isNotAllowed(e)) {
                return null;
            }
            return e;
        }
        Subpart subpart = (Subpart)config.getSubparts().get(idx);
        List sectionsThisSubpart = subpart.getSections();
        ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
        for (Section section : sectionsThisSubpart) {
            if (section.isCancelled() || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections) || request.isNotAllowed(course, section)) continue;
            matchingSectionsThisSubpart.add(section);
        }
        for (Section section : matchingSectionsThisSubpart) {
            sections.add(section);
            Enrollment e = this.firstEnrollment(request, assignment, course, config, sections, idx + 1);
            if (e != null) {
                return e;
            }
            sections.remove(section);
        }
        return null;
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.ChangeStatus status) {
        if (status == null) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        switch (status) {
            case denied: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
            }
            case approved: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
            }
            case cancelled: {
                return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected CourseRequestInterface.RequestedCourseStatus combine(CourseRequestInterface.RequestedCourseStatus s1, CourseRequestInterface.RequestedCourseStatus s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == s2) {
            return s1;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
        }
        if (s1 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED || s2 == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
        }
        return s1;
    }

    protected CourseRequestInterface.RequestedCourseStatus status(SpecialRegistrationInterface.SpecialRegistration request, boolean credit) {
        CourseRequestInterface.RequestedCourseStatus ret = null;
        if (request.changes != null) {
            for (SpecialRegistrationInterface.Change ch : request.changes) {
                if (ch.status == null) continue;
                if (credit && ch.subject == null && ch.courseNbr == null) {
                    ret = this.combine(ret, this.status(ch.status));
                }
                if (credit || ch.subject == null || ch.courseNbr == null) continue;
                ret = this.combine(ret, this.status(ch.status));
            }
        }
        if (ret != null) {
            return ret;
        }
        if (request.completionStatus != null) {
            switch (request.completionStatus) {
                case completed: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
                }
                case cancelled: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
                }
                case inProgress: {
                    return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
                }
            }
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_BANNER = 1;
        String creditError = null;
        Float maxCreditNeeded = null;
        for (CourseRequestInterface.Request line : request.getCourses()) {
            Object cr;
            if (!line.isWaitList() || !line.hasRequestedCourse()) continue;
            XCourseId enrolled = null;
            for (CourseRequestInterface.RequestedCourse rc : line.getRequestedCourse()) {
                if (!rc.hasCourseId() || (cr = original.getRequestForCourse(rc.getCourseId())) == null || ((XCourseRequest)cr).getEnrollment() == null) continue;
                enrolled = ((XCourseRequest)cr).getEnrollment();
                break;
            }
            if (enrolled != null && !enrolled.getCourseId().equals(line.getWaitListSwapWithCourseOfferingId())) continue;
            XCourse dropCourse = null;
            Object dropCrns = null;
            if (line.hasWaitListSwapWithCourseOfferingId()) {
                dropCourse = server.getCourse(line.getWaitListSwapWithCourseOfferingId());
                cr = original.getRequestForCourse(line.getWaitListSwapWithCourseOfferingId());
                if (cr != null && ((XCourseRequest)cr).getEnrollment() != null && ((XCourseRequest)cr).getEnrollment().getCourseId().equals(line.getWaitListSwapWithCourseOfferingId())) {
                    dropCrns = new TreeSet();
                    XOffering dropOffering = server.getOffering(dropCourse.getOfferingId());
                    for (XSection section : dropOffering.getSections(((XCourseRequest)cr).getEnrollment())) {
                        dropCrns.add(section.getExternalId(line.getWaitListSwapWithCourseOfferingId()));
                    }
                }
            }
            cr = line.getRequestedCourse().iterator();
            while (cr.hasNext()) {
                Object problems;
                String course;
                Object q2;
                XOffering offering;
                XCourse xcourse;
                CourseRequestInterface.RequestedCourse rc = (CourseRequestInterface.RequestedCourse)cr.next();
                if (!rc.hasCourseId() || (xcourse = server.getCourse(rc.getCourseId())) == null || enrolled != null && line.getIndex(rc.getCourseId()) > line.getIndex(enrolled.getCourseId()) || (offering = server.getOffering(xcourse.getOfferingId())) == null || !offering.isWaitList() || enrolled != null && enrolled.getCourseId().equals(rc.getCourseId()) && ((XEnrollment)enrolled).isRequired(rc, offering)) continue;
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, new XCourseRequest(original, xcourse, rc), dropCourse, server, OnlineSectioningInterface.WaitListMode.WaitList);
                List enrls = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                Enrollment testEnrollment2 = null;
                for (Enrollment testEnrollment2 : enrls) {
                    boolean overlaps = false;
                    for (Object q2 : testEnrollment2.getStudent().getRequests()) {
                        Enrollment x;
                        if (q2.equals((Object)courseRequest) || (x = (Enrollment)assignment.getValue((Variable)q2)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                        for (SctAssignment a : x.getAssignments()) {
                            if (!a.isOverlapping(testEnrollment2.getAssignments())) continue;
                            overlaps = true;
                        }
                    }
                    if (overlaps) continue;
                    break;
                }
                if (testEnrollment2 == null) {
                    Course c = (Course)courseRequest.getCourses().get(0);
                    for (Config config : c.getOffering().getConfigs()) {
                        if (courseRequest.isNotAllowed(c, config)) continue;
                        testEnrollment2 = this.firstEnrollment(courseRequest, (Assignment<Request, Enrollment>)assignment, c, config, new HashSet<Section>(), 0);
                    }
                }
                if (testEnrollment2 == null) continue;
                SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
                req.studentId = this.getBannerId(original);
                req.term = this.getBannerTerm(server.getAcademicSession());
                req.campus = this.getBannerCampus(server.getAcademicSession());
                req.mode = this.getSpecialRegistrationApiMode();
                HashSet<String> crns = new HashSet<String>();
                HashSet<String> keep = new HashSet<String>();
                q2 = testEnrollment2.getSections().iterator();
                while (q2.hasNext()) {
                    Section section = (Section)q2.next();
                    String crn = this.getCRN(section, testEnrollment2.getCourse());
                    if (dropCrns != null && dropCrns.contains(crn)) {
                        keep.add(crn);
                        continue;
                    }
                    SpecialRegistrationHelper.addWaitListCrn(req, crn);
                    crns.add(crn);
                }
                if (dropCrns != null) {
                    q2 = dropCrns.iterator();
                    while (q2.hasNext()) {
                        String crn = (String)q2.next();
                        if (keep.contains(crn)) continue;
                        SpecialRegistrationHelper.dropWaitListCrn(req, crn);
                        crns.add(crn);
                    }
                }
                if (crns.isEmpty()) continue;
                SpecialRegistrationInterface.CheckRestrictionsResponse resp = null;
                ClientResource resource = null;
                try {
                    resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                    resource.setNext((Uniform)this.iClient);
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Request: " + gson.toJson((Object)req));
                    }
                    helper.getAction().addOptionBuilder().setKey("wl-req-" + testEnrollment2.getCourse().getName().replace(" ", "").toLowerCase()).setValue(gson.toJson((Object)req));
                    long t1 = System.currentTimeMillis();
                    resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
                    helper.getAction().setApiPostTime((helper.getAction().hasApiPostTime() ? helper.getAction().getApiPostTime() : 0L) + System.currentTimeMillis() - t1);
                    resp = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Response: " + gson.toJson((Object)resp));
                    }
                    helper.getAction().addOptionBuilder().setKey("wl-resp-" + testEnrollment2.getCourse().getName().replace(" ", "").toLowerCase()).setValue(gson.toJson((Object)resp));
                    if (SpecialRegistrationInterface.ResponseStatus.success != resp.status) {
                        throw new SectioningException(resp.message == null || resp.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)resp.status) + ")." : resp.message);
                    }
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
                finally {
                    if (resource != null) {
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                    }
                }
                Float maxCredit = resp.maxCredit;
                if (maxCredit == null) {
                    maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
                }
                Float maxCreditDenied = null;
                if (resp.deniedMaxCreditRequests != null) {
                    for (SpecialRegistrationInterface.DeniedMaxCredit r : resp.deniedMaxCreditRequests) {
                        if (r.maxCredit == null || !(r.maxCredit.floatValue() > maxCredit.floatValue()) || maxCreditDenied != null && !(maxCreditDenied.floatValue() > r.maxCredit.floatValue())) continue;
                        maxCreditDenied = r.maxCredit;
                    }
                }
                HashMap overrides = new HashMap();
                Float maxCreditOverride = null;
                CourseRequestInterface.RequestedCourseStatus maxCreditOverrideStatus = null;
                if (resp.cancelRegistrationRequests != null) {
                    for (SpecialRegistrationInterface.SpecialRegistration r : resp.cancelRegistrationRequests) {
                        if (r.changes == null || r.changes.isEmpty()) continue;
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (ch.status == SpecialRegistrationInterface.ChangeStatus.cancelled || ch.status == SpecialRegistrationInterface.ChangeStatus.denied) continue;
                            if (ch.subject != null && ch.courseNbr != null) {
                                course = ch.subject + " " + ch.courseNbr;
                                problems = (Map)overrides.get(course);
                                if (problems == null) {
                                    problems = new HashMap<String, CourseRequestInterface.RequestedCourseStatus>();
                                    overrides.put(course, problems);
                                }
                                if (ch.errors == null) continue;
                                for (SpecialRegistrationInterface.ChangeError err : ch.errors) {
                                    if (err.code == null) continue;
                                    problems.put(err.code, this.status(ch.status));
                                }
                                continue;
                            }
                            if (r.maxCredit == null || maxCreditOverride != null && !(maxCreditOverride.floatValue() < r.maxCredit.floatValue())) continue;
                            maxCreditOverride = r.maxCredit;
                            maxCreditOverrideStatus = this.status(ch.status);
                        }
                    }
                }
                Float neededCredit = null;
                if (resp.outJson != null && resp.outJson.maxHoursCalc != null) {
                    neededCredit = resp.outJson.maxHoursCalc;
                }
                if (neededCredit != null && (maxCreditNeeded == null || maxCreditNeeded.floatValue() < neededCredit.floatValue())) {
                    maxCreditNeeded = neededCredit;
                }
                if (maxCreditDenied != null && neededCredit != null && neededCredit.floatValue() >= maxCreditDenied.floatValue()) {
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "WL-CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(neededCredit)), CONF_NONE);
                    response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(neededCredit)).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied)));
                    response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                    creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(neededCredit)).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied));
                    response.setMaxCreditNeeded(maxCreditNeeded);
                }
                if (creditError == null && neededCredit != null && maxCredit.floatValue() < neededCredit.floatValue()) {
                    response.addMessage(rc.getCourseId(), rc.getCourseName(), "WL-CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(neededCredit)), maxCreditOverride == null || maxCreditOverride.floatValue() < neededCredit.floatValue() ? CONF_BANNER : CONF_NONE);
                    response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(neededCredit)));
                    response.setMaxCreditOverrideStatus(maxCreditOverrideStatus == null || maxCreditOverride.floatValue() < neededCredit.floatValue() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : maxCreditOverrideStatus);
                    response.setMaxCreditNeeded(maxCreditNeeded);
                }
                HashMap deniedOverrides = new HashMap();
                if (resp.deniedRequests != null) {
                    for (SpecialRegistrationInterface.DeniedRequest r : resp.deniedRequests) {
                        if (r.mode != req.mode) continue;
                        course = r.subject + " " + r.courseNbr;
                        problems = (TreeSet<String>)deniedOverrides.get(course);
                        if (problems == null) {
                            problems = new TreeSet<String>();
                            deniedOverrides.put(course, problems);
                        }
                        problems.add(r.code);
                    }
                }
                if (resp.outJson != null && resp.outJson.message != null && resp.outJson.status != null && resp.outJson.status != SpecialRegistrationInterface.ResponseStatus.success) {
                    response.addError(null, null, "Failure", resp.outJson.message);
                    response.setErrorMessage(resp.outJson.message);
                }
                if (resp.outJson != null && resp.outJson.problems != null) {
                    for (SpecialRegistrationInterface.Problem problem : resp.outJson.problems) {
                        CourseRequestInterface.RequestedCourseStatus status;
                        Set denied;
                        if ("HOLD".equals(problem.code)) {
                            response.addError(null, null, problem.code, problem.message);
                            response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                        }
                        if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || !crns.contains(problem.crn)) continue;
                        String bc = xcourse.getSubjectArea() + " " + xcourse.getCourseNumber();
                        problems = bc == null ? null : (Map)overrides.get(bc);
                        Set set = denied = bc == null ? null : (Set)deniedOverrides.get(bc);
                        if (denied != null && denied.contains(problem.code)) {
                            response.addMessage(xcourse.getCourseId(), xcourse.getCourseName(), problem.code, "Denied " + problem.message, CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                            continue;
                        }
                        CourseRequestInterface.RequestedCourseStatus requestedCourseStatus = status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                        if (status == null) {
                            if (resp.overrides != null && !resp.overrides.contains(problem.code)) {
                                response.addError(xcourse.getCourseId(), xcourse.getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                                response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.deniedOverrideError", "One or more wait-listed courses require registration overrides which is not allowed.\nYou cannot wait-list these courses."));
                                continue;
                            }
                            if (!xcourse.isOverrideEnabled(problem.code)) {
                                response.addError(xcourse.getCourseId(), xcourse.getCourseName(), problem.code, "Not Allowed " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                                response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.deniedOverrideError", "One or more wait-listed courses require registration overrides which is not allowed.\nYou cannot wait-list these courses."));
                                continue;
                            }
                        }
                        response.addMessage(xcourse.getCourseId(), xcourse.getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                    }
                }
                if (!response.hasMessages()) continue;
                for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                    if (m.getCourse() != null && m.getMessage().indexOf("this section") >= 0) {
                        m.setMessage(m.getMessage().replace("this section", m.getCourse()));
                    }
                    if (m.getCourse() == null || m.getMessage().indexOf(" (CRN ") < 0) continue;
                    m.setMessage(m.getMessage().replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " "));
                }
            }
        }
        if (response.getConfirms().contains(CONF_BANNER)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.bannerProblemsFound", "The following registration errors for the wait-listed courses have been detected:"), CONF_BANNER, -1);
            String note = ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.courseRequestNote", "<b>Request Note:</b>");
            int idx = 1;
            if (note != null && !note.isEmpty()) {
                response.addConfirmation(note, CONF_BANNER, idx++);
                HashSet<String> courses = new HashSet<String>();
                boolean hasCredit = false;
                for (CourseRequestInterface.CourseMessage x : response.getMessages(CONF_BANNER)) {
                    if ("WL-CREDIT".equals(x.getCode()) || "MAXI".equals(x.getCode())) {
                        hasCredit = true;
                        continue;
                    }
                    if (!x.hasCourse() || !courses.add(x.getCourse())) continue;
                    CourseRequestInterface.CourseMessage cm = response.addConfirmation("", CONF_BANNER, idx++);
                    cm.setCourse(x.getCourse());
                    cm.setCourseId(x.getCourseId());
                    cm.setCode("REQUEST_NOTE");
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        cm.addSuggestion(suggestion);
                    }
                }
                if (hasCredit) {
                    CourseRequestInterface.CourseMessage cm = response.addConfirmation("", CONF_BANNER, idx++);
                    cm.setCourse(MESSAGES.tabRequestNoteMaxCredit());
                    cm.setCode("REQUEST_NOTE");
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.prereg.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        cm.addSuggestion(suggestion);
                    }
                }
            }
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.requestOverrides", "\nIf you have already discussed these courses with your advisor and were advised to request registration in them please select Request Overrides. If you aren\u2019t sure, click Cancel Submit and consult with your advisor before wait-listing these courses."), CONF_BANNER, idx++);
        }
        if ((conf = response.getConfirms()).contains(CONF_BANNER)) {
            response.setConfirmation(CONF_BANNER, ApplicationProperties.getProperty("purdue.specreg.confirm.waitlist.bannerDialogName", "Request Wait-List Overrides"), ApplicationProperties.getProperty("purdue.specreg.confirm.waitlist.bannerYesButton", "Request Overrides"), ApplicationProperties.getProperty("purdue.specreg.confirm.waitlist.bannerNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.waitlist.bannerYesButtonTitle", "Request overrides for the above registration errors"), ApplicationProperties.getProperty("purdue.specreg.confirm.waitlist.bannerNoButtonTitle", "Go back to Scheduling Assistant"));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, Float neededCredit) throws SectioningException {
        block64: {
            v0 = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
            if (original == null) {
                return;
            }
            if (!this.isValidationEnabled(server, helper, original)) {
                return;
            }
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            resource = null;
            overrides = new HashMap<String, TreeSet<E>>();
            maxCredit = null;
            oldCredit = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                resource.setNext((Uniform)this.iClient);
                session = server.getAcademicSession();
                term = this.getBannerTerm(session);
                campus = this.getBannerCampus(session);
                resource.addQueryParameter("term", (String)term);
                resource.addQueryParameter("campus", campus);
                resource.addQueryParameter("studentId", this.getBannerId(original));
                resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
                helper.getAction().addOptionBuilder().setKey("term").setValue((String)term);
                helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                t1 = System.currentTimeMillis();
                resource.get(MediaType.APPLICATION_JSON);
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
                status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Status: " + gson.toJson((Object)status));
                }
                helper.getAction().addOptionBuilder().setKey("wl-status").setValue(gson.toJson((Object)status));
                if (status != null && status.data != null) {
                    maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                    request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                }
                if (maxCredit == null) {
                    maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
                }
                if (status == null || status.data == null || ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests == null) break block64;
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (r.changes == null) continue;
                    for (Object ch : r.changes) {
                        if (this.status(ch.status) == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING && ch.subject != null && ch.courseNbr != null) {
                            course = ch.subject + " " + ch.courseNbr;
                            problems = (TreeSet<String>)overrides.get(course);
                            if (problems == null) {
                                problems = new TreeSet<String>();
                                overrides.put((String)course, problems);
                            }
                            if (ch.errors == null) continue;
                            for (SpecialRegistrationInterface.ChangeError err : ch.errors) {
                                if (err.code == null) continue;
                                problems.add(err.code);
                            }
                            continue;
                        }
                        if (this.status(ch.status) != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING || r.maxCredit == null) continue;
                        oldCredit = r.maxCredit;
                    }
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                PurdueWaitListValidationProvider.sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        req = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        req.studentId = this.getBannerId(original);
        req.pgrmcode = SpecialRegistrationHelper.getProgramCode(original);
        req.term = this.getBannerTerm(server.getAcademicSession());
        req.campus = this.getBannerCampus(server.getAcademicSession());
        req.mode = this.getSpecialRegistrationApiMode();
        req.changes = new ArrayList<E>();
        if (helper.getUser() != null) {
            req.requestorId = this.getRequestorId(helper.getUser());
            req.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        if (request.hasConfirmations()) {
            for (CourseRequestInterface.CourseMessage m : request.getConfirmations()) {
                if (!"REQUEST_NOTE".equals(m.getCode()) || m.getMessage() == null || m.getMessage().isEmpty() || m.hasCourseId()) continue;
                req.maxCreditRequestorNotes = m.getMessage();
            }
            for (Object c : request.getCourses()) {
                if (!c.hasRequestedCourse() || !c.isWaitList()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                    if (cid == null) continue;
                    v1 = course = cid instanceof XCourse != false ? (XCourse)cid : server.getCourse(cid.getCourseId());
                    if (course == null) continue;
                    subject = course.getSubjectArea();
                    courseNbr = course.getCourseNumber();
                    errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    for (Object m : request.getConfirmations()) {
                        if ("WL-CREDIT".equals(m.getCode()) || "NO_ALT".equals(m.getCode()) || "DROP_CRIT".equals(m.getCode()) || "WL-OVERLAP".equals(m.getCode()) || "WL-INACTIVE".equals(m.getCode()) || "NOT-ONLINE".equals(m.getCode()) || "NOT-RESIDENTIAL".equals(m.getCode()) || "REQUEST_NOTE".equals(m.getCode()) || !m.hasCourse() || m.isError() || !course.getCourseId().equals(m.getCourseId()) && !course.getCourseName().equals(m.getCourse())) continue;
                        e = new SpecialRegistrationInterface.ChangeError();
                        e.code = m.getCode();
                        e.message = m.getMessage();
                        errors.add(e);
                    }
                    if (errors.isEmpty()) continue;
                    ch = new SpecialRegistrationInterface.Change();
                    ch.setCourse(subject, courseNbr, this.iExternalTermProvider, server.getAcademicSession());
                    ch.crn = "";
                    ch.errors = errors;
                    ch.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                    req.changes.add(ch);
                    m = request.getConfirmations().iterator();
                    while (m.hasNext()) {
                        m = (CourseRequestInterface.CourseMessage)m.next();
                        if (!"REQUEST_NOTE".equals(m.getCode()) || m.getMessage() == null || m.getMessage().isEmpty() || !course.getCourseName().equals(m.getCourse())) continue;
                        ch.requestorNotes = m.getMessage();
                    }
                    overrides.remove(subject + " " + courseNbr);
                }
            }
        }
        req.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        wlCredit = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.isWaitList()) continue;
            cc = null;
            credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                cid = server.getCourse(rc.getCourseId(), rc.getCourseName());
                if (cid == null || (course = cid instanceof XCourse != false ? (XCourse)cid : server.getCourse(cid.getCourseId())) == null) continue;
                if (cc == null) {
                    cc = new SpecialRegistrationInterface.CourseCredit();
                    cc.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    cc.title = course.getTitle();
                    cc.creditHrs = Float.valueOf(course.hasCredit() != false ? course.getMinCredit().floatValue() : 0.0f);
                } else {
                    if (cc.alternatives == null) {
                        cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                    }
                    acc = new SpecialRegistrationInterface.CourseCredit();
                    acc.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    acc.title = course.getTitle();
                    acc.creditHrs = Float.valueOf(course.hasCredit() != false ? course.getMinCredit().floatValue() : 0.0f);
                    cc.alternatives.add(acc);
                }
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue())) continue;
                credit = rc.getCreditMin();
            }
            if (cc != null) {
                req.courseCreditHrs.add(cc);
            }
            if (credit == null || wlCredit != null && !(wlCredit.floatValue() < credit.floatValue())) continue;
            wlCredit = credit;
        }
        if (neededCredit != null && maxCredit.floatValue() < neededCredit.floatValue()) {
            req.maxCredit = neededCredit;
        }
        if (!req.changes.isEmpty() || !overrides.isEmpty() || req.maxCredit != null || oldCredit != null) {
            resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("wl-request").setValue(gson.toJson((Object)req));
                t1 = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(req));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("wl-response").setValue(gson.toJson((Object)response));
                if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                    throw new SectioningException(response.message == null || response.message.isEmpty() != false ? "Failed to request overrides (" + (Object)response.status + ")." : response.message);
                }
                if (response.data != null) {
                    for (CourseRequestInterface.Request c : request.getCourses()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                            if (rc.getStatus() != null && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                                rc.setStatus(null);
                                rc.setOverrideExternalId(null);
                                rc.setOverrideTimeStamp(null);
                            }
                            if ((cid = server.getCourse(rc.getCourseId(), rc.getCourseName())) == null) continue;
                            v2 = course = cid instanceof XCourse != false ? (XCourse)cid : server.getCourse(cid.getCourseId());
                            if (course == null) continue;
                            subject = course.getSubjectArea();
                            courseNbr = course.getCourseNumber();
                            block24: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    rc.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    rc.setOverrideExternalId(r.regRequestId);
                                    rc.setStatus(this.status(r, false));
                                    rc.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    rc.setRequestId(r.regRequestId);
                                    rc.setRequestorNote(SpecialRegistrationHelper.requestorNotes(r, subject, courseNbr));
                                    continue block24;
                                }
                            }
                        }
                    }
                    for (CourseRequestInterface.Request c : request.getAlternatives()) {
                        if (!c.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                            if (rc.getStatus() != null && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE && rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                                rc.setStatus(null);
                                rc.setOverrideExternalId(null);
                                rc.setOverrideTimeStamp(null);
                            }
                            if ((cid = server.getCourse(rc.getCourseId(), rc.getCourseName())) == null) continue;
                            v3 = course = cid instanceof XCourse != false ? (XCourse)cid : server.getCourse(cid.getCourseId());
                            if (course == null) continue;
                            subject = course.getSubjectArea();
                            courseNbr = course.getCourseNumber();
                            block28: for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                                if (r.changes == null) continue;
                                for (SpecialRegistrationInterface.Change ch : r.changes) {
                                    if (!subject.equals(ch.subject) || !courseNbr.equals(ch.courseNbr)) continue;
                                    rc.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                                    rc.setOverrideExternalId(r.regRequestId);
                                    rc.setStatus(this.status(r, false));
                                    rc.setStatusNote(SpecialRegistrationHelper.note(r, false));
                                    continue block28;
                                }
                            }
                        }
                    }
                    if (req.maxCredit != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                            if (r.maxCredit == null) continue;
                            request.setMaxCreditOverride(r.maxCredit);
                            request.setMaxCreditOverrideExternalId(r.regRequestId);
                            request.setMaxCreditOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            request.setMaxCreditOverrideStatus(this.status(r, true));
                            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", PurdueWaitListValidationProvider.sCreditFormat.format(maxCredit)).replace("{credit}", PurdueWaitListValidationProvider.sCreditFormat.format(req.maxCredit)));
                            request.setCreditNote(SpecialRegistrationHelper.note(r, true));
                            request.setRequestorNote(SpecialRegistrationHelper.maxCreditRequestorNotes(r));
                            request.setRequestId(r.regRequestId);
                            break;
                        }
                    } else {
                        request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    }
                }
                if (!request.hasConfirmations()) ** GOTO lbl303
                for (CourseRequestInterface.CourseMessage message : request.getConfirmations()) {
                    if (message.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED) continue;
                    message.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                PurdueWaitListValidationProvider.sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        } else {
            for (CourseRequestInterface.Request c : request.getCourses()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    if (rc.getStatus() == null || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.ENROLLED) continue;
                    rc.setStatus(null);
                    rc.setOverrideExternalId(null);
                    rc.setOverrideTimeStamp(null);
                }
            }
            for (CourseRequestInterface.Request c : request.getAlternatives()) {
                if (!c.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : c.getRequestedCourse()) {
                    if (rc.getStatus() == null || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.ENROLLED) continue;
                    rc.setStatus(null);
                    rc.setOverrideExternalId(null);
                    rc.setOverrideTimeStamp(null);
                }
            }
        }
lbl303:
        // 3 sources

    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        block38: {
            XStudent original;
            XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
            if (original == null) {
                return;
            }
            if (!this.isValidationEnabled(server, helper, original)) {
                return;
            }
            HashMap<String, CourseRequestInterface.RequestedCourse> rcs = new HashMap<String, CourseRequestInterface.RequestedCourse>();
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse() || !r.isWaitList()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    if (rc.getOverrideExternalId() != null) {
                        rcs.put(rc.getOverrideExternalId(), rc);
                    }
                    rcs.put(rc.getCourseName(), rc);
                    if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED || !"TBD".equals(rc.getOverrideExternalId())) continue;
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NOT_REQUESTED", ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.notRequested", "Overrides not requested, wait-list inactive."), CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED, 1);
                }
            }
            if (request.getMaxCreditOverrideStatus() == null) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            }
            if (rcs.isEmpty() && !request.hasMaxCreditOverride()) {
                return;
            }
            Integer ORD_BANNER = 1;
            ClientResource resource = null;
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                resource.setNext((Uniform)this.iClient);
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                String campus = this.getBannerCampus(session);
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("campus", campus);
                resource.addQueryParameter("studentId", this.getBannerId(original));
                resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                long t0 = System.currentTimeMillis();
                resource.get(MediaType.APPLICATION_JSON);
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Status: " + gson.toJson((Object)status));
                }
                helper.getAction().addOptionBuilder().setKey("wl-status").setValue(gson.toJson((Object)status));
                Float maxCredit = null;
                if (status != null && status.data != null) {
                    maxCredit = ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit;
                    request.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                }
                if (maxCredit == null) {
                    maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
                }
                if (status == null || status.data == null || ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests == null) break block38;
                SpecialRegistrationInterface.SpecialRegistration maxCreditReq = null;
                if (request.getMaxCreditOverrideExternalId() != null) {
                    for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (specialRegistration.maxCredit == null || !request.getMaxCreditOverrideExternalId().equals(specialRegistration.regRequestId)) continue;
                        maxCreditReq = specialRegistration;
                        break;
                    }
                }
                if (maxCreditReq == null) {
                    for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (specialRegistration.maxCredit == null || this.status(specialRegistration, true) == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED || maxCreditReq != null && !specialRegistration.dateCreated.isAfter((ReadableInstant)maxCreditReq.dateCreated)) continue;
                        maxCreditReq = specialRegistration;
                    }
                }
                if (maxCreditReq != null) {
                    request.setMaxCreditOverrideExternalId(maxCreditReq.regRequestId);
                    request.setMaxCreditOverrideStatus(this.status(maxCreditReq, true));
                    request.setMaxCreditOverride(maxCreditReq.maxCredit);
                    request.setMaxCreditOverrideTimeStamp(maxCreditReq.dateCreated == null ? null : maxCreditReq.dateCreated.toDate());
                    request.setCreditNote(SpecialRegistrationHelper.note(maxCreditReq, true));
                    String warning = null;
                    if (maxCreditReq.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : maxCreditReq.changes) {
                            if (ch.subject != null || ch.courseNbr != null || ch.errors == null) continue;
                            for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                if (!"MAXI".equals(er.code) || er.message == null) continue;
                                warning = (warning == null ? "" : warning + "\n") + er.message;
                            }
                        }
                    }
                    request.setCreditWarning(warning);
                    request.setRequestorNote(SpecialRegistrationHelper.maxCreditRequestorNotes(maxCreditReq));
                    request.setRequestId(maxCreditReq.regRequestId);
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.waitlist.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        request.addRequestorNoteSuggestion(suggestion);
                    }
                }
                for (SpecialRegistrationInterface.SpecialRegistration specialRegistration : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (specialRegistration.regRequestId == null) continue;
                    CourseRequestInterface.RequestedCourse rc = (CourseRequestInterface.RequestedCourse)rcs.get(specialRegistration.regRequestId);
                    if (rc == null) {
                        if (specialRegistration.changes == null) continue;
                        for (SpecialRegistrationInterface.Change ch : specialRegistration.changes) {
                            if (ch.status != SpecialRegistrationInterface.ChangeStatus.approved || (rc = (CourseRequestInterface.RequestedCourse)rcs.get(ch.subject + " " + ch.courseNbr)) == null) continue;
                            for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), er.code, "Approved " + er.message, this.status(ch.status), ORD_BANNER);
                            }
                            if (rc.getRequestId() != null) continue;
                            rc.setStatusNote(SpecialRegistrationHelper.note(specialRegistration, false));
                            rc.setRequestorNote(SpecialRegistrationHelper.requestorNotes(specialRegistration, ch.subject, ch.courseNbr));
                            if (rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.ENROLLED) continue;
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                        }
                        continue;
                    }
                    if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                        rc.setStatus(this.status(specialRegistration, false));
                    }
                    if (specialRegistration.changes != null) {
                        for (SpecialRegistrationInterface.Change ch : specialRegistration.changes) {
                            if (ch.errors == null || ch.courseNbr == null || ch.subject == null || ch.status == null) continue;
                            for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.denied) {
                                    request.addConfirmationError(rc.getCourseId(), rc.getCourseName(), er.code, "Denied " + er.message, this.status(ch.status), ORD_BANNER);
                                    request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.waitlist.deniedOverrideError", "One or more wait-listed courses require registration overrides which have been denied.\nYou cannot wait-list these courses."));
                                    continue;
                                }
                                if (ch.status == SpecialRegistrationInterface.ChangeStatus.approved) {
                                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), er.code, "Approved " + er.message, this.status(ch.status), ORD_BANNER);
                                    continue;
                                }
                                request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), er.code, er.message, this.status(ch.status), ORD_BANNER);
                            }
                        }
                    }
                    rc.setStatusNote(SpecialRegistrationHelper.note(specialRegistration, false));
                    rc.setRequestorNote(SpecialRegistrationHelper.requestorNotes(specialRegistration, rc.getCourseName()));
                    rc.setRequestId(specialRegistration.regRequestId);
                    for (String suggestion : ApplicationProperties.getProperty("purdue.specreg.waitlist.requestorNoteSuggestions", "").split("[\r\n]+")) {
                        if (suggestion.isEmpty()) continue;
                        rc.addRequestorNoteSuggestion(suggestion);
                    }
                }
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        if (student == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, student)) {
            return;
        }
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
            return;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime((helper.getAction().hasApiGetTime() ? helper.getAction().getApiGetTime() : 0L) + System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("wl-eligibility").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check wait-list eligibility (" + (Object)((Object)eligibility.status) + ")." : eligibility.message);
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligible.booleanValue()) {
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.WAIT_LIST_VALIDATION, true);
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                String m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = m + "\n" + p.message;
                }
                if (m != null) {
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck(m));
                }
            }
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean hasOverride(Student student) {
        if (student.getOverrideExternalId() != null) {
            return true;
        }
        if (student.getMaxCredit() == null) {
            return true;
        }
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST && (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap())) continue;
                return true;
            }
        }
        return student.getOverrideExternalId() != null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST;
    }

    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        if (student == null || !this.hasOverride(student)) {
            return false;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            action.addOptionBuilder().setKey("term").setValue(term);
            action.addOptionBuilder().setKey("campus").setValue(campus);
            action.addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            action.setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            action.addOptionBuilder().setKey("wl-status").setValue(gson.toJson((Object)status));
            boolean changed = false;
            for (CourseDemand cd : student.getCourseDemands()) {
                for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                    if (cr.getOverrideExternalId() == null || "TBD".equals(cr.getOverrideExternalId()) || cr.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST && (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap())) continue;
                    SpecialRegistrationInterface.SpecialRegistration req = null;
                    for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                        req = r;
                        break;
                    }
                    if (req == null) {
                        if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                        cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        helper.getHibSession().update((Object)cr);
                        changed = true;
                        continue;
                    }
                    Integer oldStatus = cr.getOverrideStatus();
                    switch (this.status(req, false)) {
                        case OVERRIDE_REJECTED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                    }
                    if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                    helper.getHibSession().update((Object)cr);
                    changed = true;
                }
            }
            boolean studentChanged = false;
            if (((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit != null && !((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit.equals(student.getMaxCredit())) {
                student.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                studentChanged = true;
            }
            if (student.getOverrideExternalId() != null) {
                SpecialRegistrationInterface.SpecialRegistration req = null;
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                    req = r;
                    break;
                }
                if (req == null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
                    student.setOverrideExternalId(null);
                    student.setOverrideMaxCredit(null);
                    student.setOverrideStatus(null);
                    student.setOverrideTimeStamp(null);
                    student.setOverrideIntent(null);
                    studentChanged = true;
                } else if (req != null) {
                    Integer oldStatus = student.getOverrideStatus();
                    switch (this.status(req, true)) {
                        case OVERRIDE_REJECTED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                    }
                    if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                        studentChanged = true;
                    }
                }
            }
            if (studentChanged) {
                helper.getHibSession().update((Object)student);
            }
            if (changed || studentChanged) {
                helper.getHibSession().flush();
            }
            boolean bl = changed || studentChanged;
            return bl;
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean hasNotApprovedCourseRequestOverride(Student student) {
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.APPROVED || cr.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST && (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap())) continue;
                return true;
            }
        }
        return student.getOverrideExternalId() != null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST && student.getMaxCreditOverrideStatus() != CourseRequest.CourseRequestOverrideStatus.APPROVED;
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        if (!this.isValidationEnabled(student)) {
            return false;
        }
        boolean studentUpdated = false;
        if (this.hasOverride(student)) {
            studentUpdated = this.updateStudent(server, helper, student, action);
        }
        if (!this.hasNotApprovedCourseRequestOverride(student) && !"true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.forceRevalidation", "false"))) {
            return false;
        }
        XStudent original = server.getStudent(student.getUniqueId());
        if (original == null) {
            return false;
        }
        boolean changed = false;
        SpecialRegistrationInterface.SpecialRegistrationRequest submitRequest = new SpecialRegistrationInterface.SpecialRegistrationRequest();
        submitRequest.studentId = this.getBannerId(original);
        submitRequest.pgrmcode = SpecialRegistrationHelper.getProgramCode(original);
        submitRequest.term = this.getBannerTerm(server.getAcademicSession());
        submitRequest.campus = this.getBannerCampus(server.getAcademicSession());
        submitRequest.mode = this.getSpecialRegistrationApiMode();
        submitRequest.changes = new ArrayList();
        if (helper.getUser() != null) {
            submitRequest.requestorId = this.getRequestorId(helper.getUser());
            submitRequest.requestorRole = this.getRequestorType(helper.getUser(), original);
        }
        Float maxCredit = null;
        Float maxCreditNeeded = null;
        for (CourseDemand cd : student.getCourseDemands()) {
            XCourseId dropCourse = null;
            TreeSet<String> dropCrns = null;
            if (cd.getWaitListSwapWithCourseOffering() != null) {
                dropCourse = new XCourseId(cd.getWaitListSwapWithCourseOffering());
                dropCrns = new TreeSet<String>();
                for (StudentClassEnrollment enrl : student.getClassEnrollments()) {
                    if (!cd.getWaitListSwapWithCourseOffering().equals(enrl.getCourseOffering())) continue;
                    dropCrns.add(enrl.getClazz().getExternalId(cd.getWaitListSwapWithCourseOffering()));
                }
            }
            if (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap()) continue;
            Iterator<org.unitime.timetable.model.CourseRequest> enrolledCourse = null;
            Integer enrolledOrder = null;
            if (dropCourse != null && !dropCrns.isEmpty()) {
                for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                    if (!cr.getCourseOffering().getUniqueId().equals(dropCourse.getCourseId())) continue;
                    enrolledCourse = dropCourse;
                    enrolledOrder = cr.getOrder();
                }
            }
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                Object q2;
                if (!cr.getCourseOffering().getInstructionalOffering().effectiveWaitList() || "TBD".equals(cr.getOverrideExternalId())) continue;
                if (enrolledCourse != null) {
                    if (cr.getOrder() > enrolledOrder) continue;
                    if (cr.getOrder() == enrolledOrder) {
                        XCourseRequest rq = original.getRequestForCourse(((XCourseId)((Object)enrolledCourse)).getCourseId());
                        XOffering offering = server.getOffering(((XCourseId)((Object)enrolledCourse)).getOfferingId());
                        if (rq != null && rq.getEnrollment() != null && offering != null && rq.isRequired(rq.getEnrollment(), offering)) continue;
                    }
                }
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, new XCourseRequest(cr, helper, null), dropCourse, server, OnlineSectioningInterface.WaitListMode.WaitList);
                List enrls = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                Enrollment testEnrollment2 = null;
                for (Enrollment testEnrollment2 : enrls) {
                    boolean overlaps = false;
                    for (Object q2 : testEnrollment2.getStudent().getRequests()) {
                        Enrollment x;
                        if (q2.equals((Object)courseRequest) || (x = (Enrollment)assignment.getValue((Variable)q2)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                        for (SctAssignment a : x.getAssignments()) {
                            if (!a.isOverlapping(testEnrollment2.getAssignments())) continue;
                            overlaps = true;
                        }
                    }
                    if (overlaps) continue;
                    break;
                }
                if (testEnrollment2 == null) {
                    Course c = (Course)courseRequest.getCourses().get(0);
                    for (Config config : c.getOffering().getConfigs()) {
                        if (courseRequest.isNotAllowed(c, config)) continue;
                        testEnrollment2 = this.firstEnrollment(courseRequest, (Assignment<Request, Enrollment>)assignment, c, config, new HashSet<Section>(), 0);
                    }
                }
                if (testEnrollment2 == null) continue;
                SpecialRegistrationInterface.CheckRestrictionsRequest req = new SpecialRegistrationInterface.CheckRestrictionsRequest();
                req.studentId = this.getBannerId(original);
                req.term = this.getBannerTerm(server.getAcademicSession());
                req.campus = this.getBannerCampus(server.getAcademicSession());
                req.mode = this.getSpecialRegistrationApiMode();
                HashSet<String> crns = new HashSet<String>();
                HashSet<String> keep = new HashSet<String>();
                q2 = testEnrollment2.getSections().iterator();
                while (q2.hasNext()) {
                    Section section = (Section)q2.next();
                    String crn = this.getCRN(section, testEnrollment2.getCourse());
                    if (dropCrns != null && dropCrns.contains(crn)) {
                        keep.add(crn);
                        continue;
                    }
                    SpecialRegistrationHelper.addWaitListCrn(req, crn);
                    crns.add(crn);
                }
                if (dropCrns != null) {
                    q2 = dropCrns.iterator();
                    while (q2.hasNext()) {
                        String crn = (String)q2.next();
                        if (keep.contains(crn)) continue;
                        SpecialRegistrationHelper.dropWaitListCrn(req, crn);
                        crns.add(crn);
                    }
                }
                if (crns.isEmpty()) continue;
                SpecialRegistrationInterface.CheckRestrictionsResponse validation = null;
                ClientResource resource = null;
                try {
                    resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                    resource.setNext((Uniform)this.iClient);
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Request: " + gson.toJson((Object)req));
                    }
                    action.addOptionBuilder().setKey("wl-req-" + testEnrollment2.getCourse().getName().replace(" ", "").toLowerCase()).setValue(gson.toJson((Object)req));
                    long t1 = System.currentTimeMillis();
                    resource.post(new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsRequest>(req));
                    action.setApiPostTime((action.hasApiPostTime() ? action.getApiPostTime() : 0L) + System.currentTimeMillis() - t1);
                    validation = new GsonRepresentation<SpecialRegistrationInterface.CheckRestrictionsResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckRestrictionsResponse.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Response: " + gson.toJson((Object)validation));
                    }
                    action.addOptionBuilder().setKey("wl-resp-" + testEnrollment2.getCourse().getName().replace(" ", "").toLowerCase()).setValue(gson.toJson((Object)validation));
                    if (SpecialRegistrationInterface.ResponseStatus.success != validation.status) {
                        throw new SectioningException(validation.message == null || validation.message.isEmpty() ? "Failed to check student eligibility (" + (Object)((Object)validation.status) + ")." : validation.message);
                    }
                }
                catch (SectioningException e) {
                    action.setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    action.setApiException(e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
                finally {
                    if (resource != null) {
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                    }
                }
                if (validation.outJson != null && validation.outJson.problems != null) {
                    block34: for (SpecialRegistrationInterface.Problem problem : validation.outJson.problems) {
                        if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || !crns.contains(problem.crn)) continue;
                        SpecialRegistrationInterface.Change change = null;
                        for (SpecialRegistrationInterface.Change ch : submitRequest.changes) {
                            if (!ch.subject.equals(cr.getCourseOffering().getSubjectAreaAbbv()) || !ch.courseNbr.equals(cr.getCourseOffering().getCourseNbr())) continue;
                            change = ch;
                            break;
                        }
                        if (change == null) {
                            change = new SpecialRegistrationInterface.Change();
                            change.setCourse(cr.getCourseOffering().getSubjectAreaAbbv(), cr.getCourseOffering().getCourseNbr(), this.iExternalTermProvider, server.getAcademicSession());
                            change.crn = "";
                            change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                            change.operation = SpecialRegistrationInterface.ChangeOperation.ADD;
                            submitRequest.changes.add(change);
                        } else {
                            for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                                if (!problem.code.equals(err.code)) continue;
                                continue block34;
                            }
                        }
                        SpecialRegistrationInterface.ChangeError err = new SpecialRegistrationInterface.ChangeError();
                        err.code = problem.code;
                        err.message = problem.message;
                        if (err.message != null && err.message.indexOf("this section") >= 0) {
                            err.message = err.message.replace("this section", cr.getCourseOffering().getCourseName());
                        }
                        if (err.message != null && err.message.indexOf(" (CRN ") >= 0) {
                            err.message = err.message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                        }
                        change.errors.add(err);
                    }
                }
                if (maxCredit == null && validation.maxCredit != null) {
                    maxCredit = validation.maxCredit;
                }
                if (validation.outJson.maxHoursCalc == null || maxCreditNeeded != null && !(maxCreditNeeded.floatValue() < validation.outJson.maxHoursCalc.floatValue())) continue;
                maxCreditNeeded = validation.outJson.maxHoursCalc;
            }
        }
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        if (maxCreditNeeded != null && maxCreditNeeded.floatValue() > maxCredit.floatValue()) {
            submitRequest.maxCredit = maxCreditNeeded;
        }
        submitRequest.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
        for (XRequest r : original.getRequests()) {
            SpecialRegistrationInterface.CourseCredit cc = null;
            if (r instanceof XCourseRequest) {
                XCourseRequest cr = (XCourseRequest)r;
                if (!cr.isWaitlist() || cr.getEnrollment() != null) continue;
                for (XCourseId cid : cr.getCourseIds()) {
                    XCourse course = cid instanceof XCourse ? (XCourse)cid : server.getCourse(cid.getCourseId());
                    if (course == null) continue;
                    if (cc == null) {
                        cc = new SpecialRegistrationInterface.CourseCredit();
                        cc.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                        cc.title = course.getTitle();
                        cc.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                        continue;
                    }
                    if (cc.alternatives == null) {
                        cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                    }
                    SpecialRegistrationInterface.CourseCredit acc = new SpecialRegistrationInterface.CourseCredit();
                    acc.setCourse(course.getSubjectArea(), course.getCourseNumber(), this.iExternalTermProvider, server.getAcademicSession());
                    acc.title = course.getTitle();
                    acc.creditHrs = Float.valueOf(course.hasCredit() ? course.getMinCredit().floatValue() : 0.0f);
                    cc.alternatives.add(acc);
                }
            }
            if (cc == null) continue;
            submitRequest.courseCreditHrs.add(cc);
        }
        SpecialRegistrationInterface.SpecialRegistrationResponseList response = null;
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
            resource.setNext((Uniform)this.iClient);
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Request: " + gson.toJson((Object)submitRequest));
            }
            action.addOptionBuilder().setKey("wl-request").setValue(gson.toJson((Object)submitRequest));
            long t1 = System.currentTimeMillis();
            resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(submitRequest));
            action.setApiPostTime(action.getApiPostTime() + System.currentTimeMillis() - t1);
            response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
            if (helper.isDebugEnabled()) {
                helper.debug("Submit Response: " + gson.toJson((Object)response));
            }
            action.addOptionBuilder().setKey("wl-response").setValue(gson.toJson((Object)response));
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to request overrides (" + (Object)((Object)response.status) + ")." : response.message);
            }
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
        for (CourseDemand cd : student.getCourseDemands()) {
            block40: for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if ((cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST) && (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap())) continue;
                if (response != null && response.data != null) {
                    for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                        if (r.changes == null) continue;
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (!cr.getCourseOffering().getSubjectAreaAbbv().equals(ch.subject) || !cr.getCourseOffering().getCourseNbr().equals(ch.courseNbr)) continue;
                            Integer oldStatus = cr.getOverrideStatus();
                            switch (this.status(r, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(cr.getOverrideStatus())) {
                                changed = true;
                            }
                            if (cr.getOverrideExternalId() == null || !cr.getOverrideExternalId().equals(r.regRequestId)) {
                                changed = true;
                            }
                            cr.setOverrideExternalId(r.regRequestId);
                            cr.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            cr.setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                            helper.getHibSession().update((Object)cr);
                            continue block40;
                        }
                    }
                }
                if (cr.getOverrideExternalId() == null && cr.getOverrideStatus() == null || "TBD".equals(cr.getOverrideExternalId()) && Boolean.TRUE.equals(cd.isWaitlist()) && !Boolean.TRUE.equals(cd.isAlternative())) continue;
                cr.setOverrideExternalId(null);
                cr.setOverrideStatus(null);
                cr.setOverrideTimeStamp(null);
                cr.setOverrideIntent(null);
                helper.getHibSession().update((Object)cr);
                changed = true;
            }
        }
        boolean studentChanged = false;
        if (submitRequest.maxCredit != null) {
            for (SpecialRegistrationInterface.SpecialRegistration r : (List)response.data) {
                if (r.maxCredit == null) continue;
                Integer oldStatus = student.getOverrideStatus();
                switch (this.status(r, true)) {
                    case OVERRIDE_REJECTED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                        break;
                    }
                    case OVERRIDE_APPROVED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                        break;
                    }
                    case OVERRIDE_CANCELLED: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        break;
                    }
                    case OVERRIDE_PENDING: {
                        student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                    }
                }
                if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                    studentChanged = true;
                }
                if (student.getOverrideMaxCredit() == null || !student.getOverrideMaxCredit().equals(r.maxCredit)) {
                    studentChanged = true;
                }
                student.setOverrideMaxCredit(r.maxCredit);
                if (student.getOverrideExternalId() == null || !student.getOverrideExternalId().equals(r.regRequestId)) {
                    studentChanged = true;
                }
                student.setOverrideExternalId(r.regRequestId);
                student.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                student.setMaxCreditOverrideIntent(CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                break;
            }
        } else if (student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
            student.setOverrideExternalId(null);
            student.setOverrideMaxCredit(null);
            student.setOverrideStatus(null);
            student.setOverrideTimeStamp(null);
            student.setOverrideIntent(null);
            studentChanged = true;
        }
        if (studentChanged) {
            helper.getHibSession().update((Object)student);
        }
        if (changed) {
            helper.getHibSession().flush();
        }
        if (changed || studentChanged) {
            helper.getHibSession().flush();
        }
        return changed || studentChanged || studentUpdated;
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<Student> students) throws SectioningException {
        HashMap<String, Student> id2student = new HashMap<String, Student>();
        ArrayList<Long> reloadIds = new ArrayList<Long>();
        int batchNumber = 1;
        for (int i = 0; i < students.size(); ++i) {
            Student student = students.get(i);
            if (student == null || !this.hasOverride(student) || !this.isValidationEnabled(student)) continue;
            String id = this.getBannerId(student);
            id2student.put(id, student);
            if (id2student.size() < 100) continue;
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
            id2student.clear();
        }
        if (!id2student.isEmpty()) {
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
        }
        if (!reloadIds.isEmpty()) {
            helper.getHibSession().flush();
        }
        if (!reloadIds.isEmpty() && server != null && !(server instanceof DatabaseServer)) {
            server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
        }
        return reloadIds;
    }

    protected void checkStudentStatuses(OnlineSectioningServer server, OnlineSectioningHelper helper, Map<String, Student> id2student, List<Long> reloadIds, int batchNumber) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? null : server.getAcademicSession();
            String studentIds = null;
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<String, Student> e : id2student.entrySet()) {
                if (session == null) {
                    session = new AcademicSessionInfo(e.getValue().getSession());
                }
                studentIds = studentIds == null ? e.getKey() : studentIds + "," + e.getKey();
                ids.add(e.getKey());
            }
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentIds", studentIds);
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (action != null) {
                action.addOptionBuilder().setKey("term").setValue(term);
                action.addOptionBuilder().setKey("campus").setValue(campus);
                action.addOptionBuilder().setKey("studentIds-" + batchNumber).setValue(studentIds);
            }
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (action != null) {
                action.setApiGetTime(action.getApiGetTime() + System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            if (action != null) {
                action.addOptionBuilder().setKey("wl-response-" + batchNumber).setValue(gson.toJson((Object)response));
            }
            if (SpecialRegistrationInterface.ResponseStatus.success != response.status) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to check student statuses (" + (Object)((Object)response.status) + ")." : response.message);
            }
            if (response.data != null && ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students != null) {
                int index = 0;
                for (SpecialRegistrationInterface.SpecialRegistrationStatus status : ((SpecialRegistrationInterface.SpecialRegistrationMultipleStatus)response.data).students) {
                    String studentId = status.studentId;
                    if (studentId == null && status.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistration req : status.requests) {
                            if (req.studentId == null) continue;
                            studentId = req.studentId;
                            break;
                        }
                    }
                    if (studentId == null) {
                        studentId = (String)ids.get(index);
                    }
                    ++index;
                    Student student = id2student.get(studentId);
                    if (student == null) continue;
                    boolean changed = false;
                    for (CourseDemand cd : student.getCourseDemands()) {
                        for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                            if ((cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideIntent() != CourseRequest.CourseRequestOverrideIntent.WAITLIST) && (!Boolean.TRUE.equals(cd.isWaitlist()) || !Boolean.FALSE.equals(cd.isAlternative()) || cd.isEnrolledExceptForWaitListSwap())) continue;
                            SpecialRegistrationInterface.SpecialRegistration req = null;
                            for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                                if (!cr.getOverrideExternalId().equals(r.regRequestId)) continue;
                                req = r;
                                break;
                            }
                            if (req == null) {
                                if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                helper.getHibSession().update((Object)cr);
                                changed = true;
                                continue;
                            }
                            Integer oldStatus = cr.getOverrideStatus();
                            switch (this.status(req, false)) {
                                case OVERRIDE_REJECTED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                            helper.getHibSession().update((Object)cr);
                            changed = true;
                        }
                    }
                    boolean studentChanged = false;
                    if (status.maxCredit != null && !status.maxCredit.equals(student.getMaxCredit())) {
                        student.setMaxCredit(status.maxCredit);
                        studentChanged = true;
                    }
                    if (student.getOverrideExternalId() != null) {
                        SpecialRegistrationInterface.SpecialRegistration req = null;
                        for (SpecialRegistrationInterface.SpecialRegistration r : status.requests) {
                            if (!student.getOverrideExternalId().equals(r.regRequestId)) continue;
                            req = r;
                            break;
                        }
                        if (req == null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
                            student.setOverrideExternalId(null);
                            student.setOverrideMaxCredit(null);
                            student.setOverrideStatus(null);
                            student.setOverrideTimeStamp(null);
                            student.setOverrideIntent(null);
                            studentChanged = true;
                        } else if (req != null) {
                            Integer oldStatus = student.getOverrideStatus();
                            switch (this.status(req, true)) {
                                case OVERRIDE_REJECTED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                                }
                            }
                            if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                                studentChanged = true;
                            }
                        }
                    }
                    if (studentChanged) {
                        helper.getHibSession().update((Object)student);
                    }
                    if (!changed && !studentChanged) continue;
                    reloadIds.add(student.getUniqueId());
                }
            }
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        if (student == null) {
            return false;
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            action.addOptionBuilder().setKey("term").setValue(term);
            action.addOptionBuilder().setKey("campus").setValue(campus);
            action.addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            action.setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Status: " + gson.toJson((Object)status));
            }
            action.addOptionBuilder().setKey("wl-status").setValue(gson.toJson((Object)status));
            boolean studentChanged = false;
            for (XRequest xRequest : student.getRequests()) {
                XCourseRequest cr;
                if (!(xRequest instanceof XCourseRequest) || !(cr = (XCourseRequest)xRequest).hasOverrides()) continue;
                for (Map.Entry<XCourseId, XOverride> e : cr.getOverrides().entrySet()) {
                    XCourseId course = e.getKey();
                    XOverride override = e.getValue();
                    if ("TBD".equals(override.getExternalId())) continue;
                    SpecialRegistrationInterface.SpecialRegistration req = null;
                    for (SpecialRegistrationInterface.SpecialRegistration q : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                        if (!override.getExternalId().equals(q.regRequestId)) continue;
                        req = q;
                        break;
                    }
                    if (req == null) continue;
                    Integer oldStatus = override.getStatus();
                    Integer newStatus = null;
                    switch (this.status(req, false)) {
                        case OVERRIDE_REJECTED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
                        }
                    }
                    if (newStatus == null || newStatus.equals(oldStatus)) continue;
                    override.setStatus(newStatus);
                    CourseDemand dbCourseDemand = (CourseDemand)CourseDemandDAO.getInstance().get(cr.getRequestId(), helper.getHibSession());
                    if (dbCourseDemand != null) {
                        for (org.unitime.timetable.model.CourseRequest dbCourseRequest : dbCourseDemand.getCourseRequests()) {
                            if (!dbCourseRequest.getCourseOffering().getUniqueId().equals(course.getCourseId())) continue;
                            dbCourseRequest.setOverrideStatus(newStatus);
                            helper.getHibSession().update((Object)dbCourseRequest);
                        }
                    }
                    studentChanged = true;
                }
            }
            if (((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit != null && !((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit.equals(student.getMaxCredit())) {
                student.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                if (dbStudent != null) {
                    dbStudent.setMaxCredit(((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).maxCredit);
                    helper.getHibSession().update((Object)dbStudent);
                }
                studentChanged = true;
            }
            if (student.getMaxCreditOverride() != null) {
                SpecialRegistrationInterface.SpecialRegistration req = null;
                for (SpecialRegistrationInterface.SpecialRegistration r : ((SpecialRegistrationInterface.SpecialRegistrationStatus)status.data).requests) {
                    if (r.regRequestId == null || !r.regRequestId.equals(student.getMaxCreditOverride().getExternalId())) continue;
                    req = r;
                    break;
                }
                if (req != null) {
                    Integer n = student.getMaxCreditOverride().getStatus();
                    Integer newStatus = null;
                    switch (this.status(req, true)) {
                        case OVERRIDE_REJECTED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal();
                            break;
                        }
                        case OVERRIDE_APPROVED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal();
                            break;
                        }
                        case OVERRIDE_CANCELLED: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal();
                            break;
                        }
                        case OVERRIDE_PENDING: {
                            newStatus = CourseRequest.CourseRequestOverrideStatus.PENDING.ordinal();
                        }
                    }
                    if (newStatus == null || !newStatus.equals(n)) {
                        student.getMaxCreditOverride().setStatus(newStatus);
                        Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
                        if (dbStudent != null) {
                            dbStudent.setOverrideStatus(newStatus);
                            helper.getHibSession().update((Object)dbStudent);
                        }
                        studentChanged = true;
                    }
                }
            }
            if (studentChanged) {
                server.update(student, false);
                helper.getHibSession().flush();
            }
            if (studentChanged) {
                helper.getHibSession().flush();
            }
            boolean bl = studentChanged;
            return bl;
        }
        catch (SectioningException e) {
            action.setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            action.setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }
}

