/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ExternalClassesCollector
extends DefaultTreeVisitor
implements CssCompilerPass {
    public static final String EXTERNAL_AT_RULE = "external";
    private static final String STAR_SUFFIX = "*";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private Set<String> externalClassNames;
    private Set<String> remainingStyleClassNames;
    private List<String> externalClassPrefixes;
    private boolean matchAll;

    public ExternalClassesCollector(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    public void runPass() {
        this.externalClassNames = new HashSet<String>();
        this.remainingStyleClassNames = new HashSet<String>();
        this.externalClassPrefixes = new ArrayList<String>();
        this.visitController.startVisit((CssTreeVisitor)this);
    }

    public boolean enterClassSelector(CssClassSelectorNode classSelector) {
        this.remainingStyleClassNames.add(classSelector.getRefinerName());
        return true;
    }

    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (EXTERNAL_AT_RULE.equals(node.getName().getValue())) {
            if (!this.matchAll) {
                this.processParameters(node.getParameters(), node.getSourceCodeLocation());
            }
            this.visitController.removeCurrentNode();
        }
    }

    public ImmutableSet<String> getExternalClassNames(Set<String> styleClassesSet, Set<String> orphanClassName) {
        if (this.matchAll) {
            return ImmutableSet.copyOf(styleClassesSet);
        }
        TreeSet<String> classNames = new TreeSet<String>(styleClassesSet);
        ImmutableSet.Builder externalClassesSetBuilder = ImmutableSet.builder();
        externalClassesSetBuilder.addAll(this.externalClassNames);
        for (String prefix : this.externalClassPrefixes) {
            String styleClass;
            Iterator iterator = classNames.tailSet(prefix).iterator();
            while (iterator.hasNext() && (styleClass = (String)iterator.next()).startsWith(prefix)) {
                externalClassesSetBuilder.add(styleClass);
            }
        }
        for (String className : orphanClassName) {
            if (this.remainingStyleClassNames.contains(className)) continue;
            externalClassesSetBuilder.add(className);
        }
        return externalClassesSetBuilder.build();
    }

    private void processParameters(List<CssValueNode> values, SourceCodeLocation sourceCodeLocation) {
        for (CssValueNode value : values) {
            if (value instanceof CssCompositeValueNode) {
                this.processParameters(((CssCompositeValueNode)value).getValues(), sourceCodeLocation);
                continue;
            }
            if (value instanceof CssStringNode) {
                String selector = ((CssStringNode)value).getConcreteValue();
                if (STAR_SUFFIX.equals(selector)) {
                    this.matchAll = true;
                    return;
                }
                if (selector.endsWith(STAR_SUFFIX)) {
                    this.externalClassPrefixes.add(selector.substring(0, selector.length() - 1));
                    continue;
                }
                this.externalClassNames.add(selector);
                continue;
            }
            if (value instanceof CssLiteralNode) {
                this.externalClassNames.add(value.getValue());
                continue;
            }
            this.errorManager.report(new GssError("External at-rule invalid. The following terms is not accepted in an external at-rule [" + value.getValue() + "]", sourceCodeLocation));
        }
    }
}

