/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverInfo;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSolverInfo;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.server.solver.TimetableGridContext;
import org.unitime.timetable.server.solver.TimetableGridHelper;
import org.unitime.timetable.server.solver.TimetableGridSolutionHelper;
import org.unitime.timetable.server.solver.TimetableGridSolverHelper;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.util.RoomAvailability;

@GwtRpcImplements(value=TimetableGridInterface.TimetableGridRequest.class)
public class TimetableGridBackend
implements GwtRpcImplementation<TimetableGridInterface.TimetableGridRequest, TimetableGridInterface.TimetableGridResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    /*
     * WARNING - void declaration
     */
    @Override
    public TimetableGridInterface.TimetableGridResponse execute(TimetableGridInterface.TimetableGridRequest request, SessionContext context) {
        context.checkPermission(Right.TimetableGrid);
        context.getUser().setProperty("TimetableGridTable.week", request.getFilter().getParameterValue("weeks"));
        context.getUser().setProperty("TimetableGridTable.resourceType", request.getFilter().getParameterValue("resource"));
        context.getUser().setProperty("TimetableGridTable.findString", request.getFilter().getParameterValue("filter"));
        context.getUser().setProperty("TimetableGridTable.classFilter", request.getFilter().getParameterValue("classFilter"));
        context.getUser().setProperty("TimetableGridTable.day", request.getFilter().getParameterValue("days"));
        context.getUser().setProperty("TimetableGridTable.times", request.getFilter().getParameterValue("times"));
        context.getUser().setProperty("TimetableGridTable.dispMode", request.getFilter().getParameterValue("dispMode"));
        context.getUser().setProperty("TimetableGridTable.bgMode", request.getFilter().getParameterValue("background"));
        context.getUser().setProperty("TimetableGridTable.showUselessTimes", request.getFilter().getParameterValue("showFreeTimes"));
        context.getUser().setProperty("TimetableGridTable.showComments", request.getFilter().getParameterValue("showPreferences"));
        context.getUser().setProperty("TimetableGridTable.showInstructors", request.getFilter().getParameterValue("showInstructors"));
        context.getUser().setProperty("TimetableGridTable.showEvents", request.getFilter().getParameterValue("showEvents"));
        context.getUser().setProperty("TimetableGridTable.showTimes", request.getFilter().getParameterValue("showTimes"));
        context.getUser().setProperty("TimetableGridTable.orderBy", request.getFilter().getParameterValue("orderBy"));
        context.getUser().setProperty("TimetableGridTable.showTitles", request.getFilter().getParameterValue("showTitles"));
        TimetableGridInterface.TimetableGridResponse response = new TimetableGridInterface.TimetableGridResponse();
        Session acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        DatePattern defaultDatePattern = acadSession.getDefaultDatePatternNotNull();
        response.setDefaultDatePatternName(defaultDatePattern == null ? null : defaultDatePattern.getName());
        TimetableGridContext cx = new TimetableGridContext(request.getFilter(), acadSession);
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        response.setWeekOffset(cx.getWeekOffset());
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        if (solver != null) {
            cx.setInstructorNameFormat(solver.getProperties().getProperty("General.InstructorFormat", cx.getInstructorNameFormat()));
            boolean fixInstructors = ApplicationProperty.TimeGridFixInstructors.isTrue() && cx.isShowInstructor();
            List<TimetableGridInterface.TimetableGridModel> models = solver.getTimetableGridTables(cx);
            if (models != null) {
                for (TimetableGridInterface.TimetableGridModel timetableGridModel : models) {
                    if (fixInstructors) {
                        TimetableGridSolverHelper.fixInstructors(timetableGridModel, cx);
                    }
                    if (cx.isShowClassNameTwoLines() || cx.isShowCourseTitle()) {
                        TimetableGridSolverHelper.fixClassNames(timetableGridModel, cx);
                    } else if (cx.isShowCrossLists()) {
                        TimetableGridSolverHelper.addCrosslistedNames(timetableGridModel, cx);
                    }
                    if (cx.getBgMode() == TimetableGridHelper.BgMode.InstructionalType.ordinal()) {
                        TimetableGridSolverHelper.setInstructionalTypeBackgroundColors(timetableGridModel, cx);
                    }
                    TimetableGridHelper.computeIndexes(timetableGridModel, cx);
                    response.addModel(timetableGridModel);
                }
            }
            String ts = null;
            try {
                ts = solver.getProperties().getProperty("RoomAvailability.TimeStamp");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ts == null) {
                response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, MESSAGES.warnCourseSolverNoRoomAvailability()));
            } else {
                response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoCourseSolverRoomAvailabilityLastUpdated(ts)));
            }
        } else {
            Object solutionIdsStr;
            Query filter = null;
            String filterStr = request.getFilter().getParameterValue("filter");
            if (filterStr != null && !filterStr.trim().isEmpty()) {
                filter = new Query(filterStr);
            }
            if ((solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution)) == null || ((String)solutionIdsStr).isEmpty()) {
                if (ApplicationProperty.TimeGridShowAllCommitted.isTrue()) {
                    for (Long id : SolutionDAO.getInstance().getSession().createQuery("select s.uniqueId from Solution s where s.commited = true and s.owner.session = :sessionId").setLong("sessionId", acadSession.getUniqueId().longValue()).setCacheable(true).list()) {
                        if (solutionIdsStr == null) {
                            solutionIdsStr = id.toString();
                            continue;
                        }
                        solutionIdsStr = (String)solutionIdsStr + (((String)solutionIdsStr).isEmpty() ? "" : ",") + id;
                    }
                } else {
                    for (SolverGroup g : SolverGroup.getUserSolverGroups(context.getUser())) {
                        for (Long id : SolutionDAO.getInstance().getSession().createQuery("select s.uniqueId from Solution s where s.commited = true and s.owner = :groupId").setLong("groupId", g.getUniqueId().longValue()).setCacheable(true).list()) {
                            if (solutionIdsStr == null) {
                                solutionIdsStr = id.toString();
                                continue;
                            }
                            solutionIdsStr = (String)solutionIdsStr + (((String)solutionIdsStr).isEmpty() ? "" : ",") + id;
                        }
                    }
                }
            }
            if (solutionIdsStr == null || ((String)solutionIdsStr).isEmpty()) {
                throw new GwtRpcException(MESSAGES.errorTimetableGridNoSolution());
            }
            Object var12_25 = null;
            try {
                void var12_27;
                HashSet<Long> infos;
                String name;
                org.hibernate.Query q;
                String ts;
                SolutionDAO dao = new SolutionDAO();
                org.hibernate.Session hibSession = dao.getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    Transaction transaction = hibSession.beginTransaction();
                }
                if (cx.getResourceType() == TimetableGridHelper.ResourceType.ROOM.ordinal()) {
                    if (RoomAvailability.getInstance() != null) {
                        RoomAvailability.getInstance().activate(acadSession.getUniqueId(), cx.getSessionStartDate(), cx.getSessionEndDate(), RoomAvailabilityInterface.sClassType, false);
                        ts = RoomAvailability.getInstance().getTimeStamp(cx.getSessionStartDate(), cx.getSessionEndDate(), RoomAvailabilityInterface.sClassType);
                        if (ts == null) {
                            response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, MESSAGES.warnCourseSolverNoRoomAvailability()));
                        } else {
                            response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoCourseSolverRoomAvailabilityLastUpdated(ts)));
                        }
                    }
                    q = hibSession.createQuery("select distinct r from Location as r inner join r.assignments as a where a.solution.uniqueId in (" + (String)solutionIdsStr + ")");
                    q.setCacheable(true);
                    for (Location room : q.list()) {
                        if (!this.match(filter, room)) continue;
                        response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, room, hibSession, cx));
                    }
                } else if (cx.getResourceType() == TimetableGridHelper.ResourceType.INSTRUCTOR.ordinal()) {
                    if (RoomAvailability.getInstance() != null && cx.isShowEvents()) {
                        RoomAvailability.getInstance().activate(acadSession.getUniqueId(), cx.getSessionStartDate(), cx.getSessionEndDate(), RoomAvailabilityInterface.sClassType, false);
                        ts = RoomAvailability.getInstance().getTimeStamp(cx.getSessionStartDate(), cx.getSessionEndDate(), RoomAvailabilityInterface.sClassType);
                        if (ts == null) {
                            response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.WARNING, MESSAGES.warnCourseSolverNoRoomAvailability()));
                        } else {
                            response.addPageMessage(new SolverInterface.PageMessage(SolverInterface.PageMessageType.INFO, MESSAGES.infoCourseSolverRoomAvailabilityLastUpdated(ts)));
                        }
                    }
                    String instructorNameFormat = UserProperty.NameFormat.get(context.getUser());
                    org.hibernate.Query q2 = null;
                    q2 = ApplicationProperty.TimetableGridUseClassInstructors.isTrue() ? hibSession.createQuery("select distinct i.instructor from ClassInstructor as i inner join i.classInstructing.assignments as a where a.solution.uniqueId in (" + (String)solutionIdsStr + ")") : hibSession.createQuery("select distinct i from DepartmentalInstructor as i inner join i.assignments as a where a.solution.uniqueId in (" + (String)solutionIdsStr + ")");
                    q2.setCacheable(true);
                    HashSet<String> puids = new HashSet<String>();
                    for (DepartmentalInstructor instructor : q2.list()) {
                        String name2 = (instructor.getLastName() + ", " + instructor.getFirstName() + " " + instructor.getMiddleName()).trim();
                        if (!this.match(filter, name2) || instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty() && !puids.add(instructor.getExternalUniqueId())) continue;
                        TimetableGridInterface.TimetableGridModel m = TimetableGridSolutionHelper.createModel((String)solutionIdsStr, instructor, hibSession, cx);
                        m.setName(instructor.getName(instructorNameFormat));
                        response.addModel(m);
                    }
                } else if (cx.getResourceType() == TimetableGridHelper.ResourceType.DEPARTMENT.ordinal()) {
                    q = hibSession.createQuery("select distinct d from Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea.department as d where a.solution.uniqueId in (" + (String)solutionIdsStr + ") and o.isControl=true");
                    q.setCacheable(true);
                    for (Department dept : q.list()) {
                        name = dept.getAbbreviation();
                        if (!this.match(filter, name)) continue;
                        response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, dept, hibSession, cx));
                    }
                } else if (cx.getResourceType() == TimetableGridHelper.ResourceType.SUBJECT_AREA.ordinal()) {
                    q = hibSession.createQuery("select distinct sa from Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea as sa where a.solution.uniqueId in (" + (String)solutionIdsStr + ") and o.isControl=true");
                    q.setCacheable(true);
                    for (SubjectArea sa : q.list()) {
                        name = sa.getSubjectAreaAbbreviation();
                        if (!this.match(filter, name)) continue;
                        response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, sa, hibSession, cx));
                    }
                } else if (cx.getResourceType() == TimetableGridHelper.ResourceType.CURRICULUM.ordinal()) {
                    q = hibSession.createQuery("select cc.classification from CurriculumCourse cc, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where a.solution.uniqueId in (" + (String)solutionIdsStr + ") and co = cc.course");
                    q.setCacheable(true);
                    infos = new HashSet<Long>();
                    for (CurriculumClassification cc : q.list()) {
                        String name3;
                        if (!infos.add(cc.getUniqueId()) || !this.match(filter, name3 = cc.getCurriculum().getAbbv() + " " + cc.getName())) continue;
                        response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, cc, hibSession, cx));
                    }
                } else if (cx.getResourceType() == TimetableGridHelper.ResourceType.STUDENT_GROUP.ordinal()) {
                    q = hibSession.createQuery("select c from ConstraintInfo c inner join c.assignments a where a.solution.uniqueId in (" + (String)solutionIdsStr + ") and c.definition.name = 'GroupInfo'");
                    q.setCacheable(true);
                    infos = new HashSet();
                    for (Serializable g : q.list()) {
                        TimetableInfo info;
                        if (!infos.add(((BaseSolverInfo)g).getUniqueId()) || !this.match(filter, ((BaseSolverInfo)g).getOpt()) || (info = ((SolverInfo)g).getInfo()) == null || !(info instanceof StudentGroupInfo)) continue;
                        response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, (StudentGroupInfo)info, hibSession, cx));
                    }
                    if (response.getModels().isEmpty()) {
                        q = hibSession.createQuery("select distinct r.group from StudentGroupReservation r, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering as io where a.solution.uniqueId in (" + (String)solutionIdsStr + ") and io = r.instructionalOffering");
                        q.setCacheable(true);
                        for (Serializable g : q.list()) {
                            if (!this.match(filter, ((BaseStudentGroup)g).getGroupName()) && !this.match(filter, ((BaseStudentGroup)g).getGroupAbbreviation())) continue;
                            response.addModel(TimetableGridSolutionHelper.createModel((String)solutionIdsStr, (StudentGroup)g, hibSession, cx));
                        }
                    }
                }
                if (var12_27 != null) {
                    var12_27.commit();
                }
            }
            catch (GwtRpcException e) {
                if (var12_25 != null) {
                    var12_25.rollback();
                }
                Debug.error(e);
                throw e;
            }
            catch (Exception e) {
                if (var12_25 != null) {
                    var12_25.rollback();
                }
                Debug.error(e);
                throw new GwtRpcException(e.getMessage(), e);
            }
            for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                TimetableGridHelper.computeIndexes(model, cx);
            }
        }
        if (response.getDefaultDatePatternName() != null) {
            for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
                for (TimetableGridInterface.TimetableGridCell timetableGridCell : model.getCells()) {
                    if (!timetableGridCell.hasDate() || !response.getDefaultDatePatternName().equals(timetableGridCell.getDate())) continue;
                    timetableGridCell.setDate(null);
                }
            }
        }
        final TimetableGridHelper.OrderBy order = TimetableGridHelper.OrderBy.values()[Integer.parseInt(request.getFilter().getParameterValue("orderBy", "0"))];
        Collections.sort(response.getModels(), new Comparator<TimetableGridInterface.TimetableGridModel>(){

            @Override
            public int compare(TimetableGridInterface.TimetableGridModel m1, TimetableGridInterface.TimetableGridModel m2) {
                int cmp = this.compareModels(m1, m2);
                if (cmp != 0) {
                    return cmp;
                }
                return m1.getName().compareTo(m2.getName());
            }

            public int compareModels(TimetableGridInterface.TimetableGridModel m1, TimetableGridInterface.TimetableGridModel m2) {
                switch (order) {
                    case NameAsc: {
                        return m1.getName().compareTo(m2.getName());
                    }
                    case NameDesc: {
                        return m2.getName().compareTo(m1.getName());
                    }
                    case SizeAsc: {
                        return Double.compare(m1.getSize(), m2.getSize());
                    }
                    case SizeDesc: {
                        return Double.compare(m2.getSize(), m1.getSize());
                    }
                    case TypeAsc: {
                        int cmp;
                        if (m1.getType() != null && m2.getType() != null && (cmp = m1.getType().compareTo(m2.getType())) != 0) {
                            return cmp;
                        }
                        return m1.getName().compareTo(m2.getName());
                    }
                    case TypeDesc: {
                        int cmp;
                        if (m1.getType() != null && m2.getType() != null && (cmp = m2.getType().compareTo(m1.getType())) != 0) {
                            return cmp;
                        }
                        return m2.getName().compareTo(m1.getName());
                    }
                    case UtilizationAsc: {
                        return Double.compare(m1.getUtilization(), m2.getUtilization());
                    }
                    case UtilizationDesc: {
                        return Double.compare(m2.getUtilization(), m1.getUtilization());
                    }
                }
                return 0;
            }
        });
        switch (TimetableGridHelper.BgMode.values()[cx.getBgMode()]) {
            case TimePref: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sRequired), MESSAGES.legendRequiredTime());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyPreferred), MESSAGES.legendStronglyPreferredTime());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sPreferred), MESSAGES.legendPreferredTime());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendNoTimePreference());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendDiscouragedTime());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendStronglyDiscouragedTime());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendProhibitedTime());
                break;
            }
            case RoomPref: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sRequired), MESSAGES.legendRequiredRoom());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyPreferred), MESSAGES.legendStronglyPreferredRoom());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sPreferred), MESSAGES.legendPreferredRoom());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendNoRoomPreference());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendDiscouragedRoom());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendStronglyDiscouragedRoom());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendProhibitedRoom());
                break;
            }
            case StudentConf: {
                for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                    if (nrConflicts < 15) {
                        response.addAssignedLegend(TimetableGridHelper.conflicts2color(nrConflicts), MESSAGES.legendStudentConflicts(String.valueOf(nrConflicts)));
                        continue;
                    }
                    response.addAssignedLegend(TimetableGridHelper.conflicts2color(nrConflicts), MESSAGES.legendStudentConflictsOrMore(String.valueOf(nrConflicts)));
                }
                break;
            }
            case InstructorBtbPref: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendInstructorBTBNoPreference());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendInstructorBTBDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendInstructorBTBStronglyDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendInstructorBTBProhibited());
                break;
            }
            case DistributionConstPref: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendDistributionNoViolation());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendDistributionDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendDistributionStronglyDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendDistributionProhibited());
                break;
            }
            case Perturbations: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyPreferred), MESSAGES.legendPerturbationNoChange());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendPerturbationNoInitial());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendPerturbationRoomChanged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendPerturbationTimeChanged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendPerturbationBothChanged());
                break;
            }
            case PerturbationPenalty: {
                for (int nrConflicts = 0; nrConflicts <= 15; ++nrConflicts) {
                    response.addAssignedLegend(TimetableGridHelper.conflicts2color(nrConflicts), nrConflicts == 0 ? MESSAGES.legendPerturbationNoPenalty() : (nrConflicts == 15 ? MESSAGES.legendPerturbationPenaltyAbove("15") : MESSAGES.legendPerturbationPenaltyBelow(String.valueOf(nrConflicts))));
                }
                break;
            }
            case HardConflicts: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sRequired), MESSAGES.legendHardRequired());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyPreferred), MESSAGES.legendHardStronglyPreferred());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sPreferred), MESSAGES.legendHardPreferred());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendHardNeutral());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendHardDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendHardStronglyDiscouraged());
                break;
            }
            case DepartmentalBalancing: {
                for (int nrConflicts = 0; nrConflicts <= 3; ++nrConflicts) {
                    response.addAssignedLegend(TimetableGridHelper.conflicts2colorFast(nrConflicts), nrConflicts == 0 ? MESSAGES.legendNoPenalty() : (nrConflicts == 3 ? MESSAGES.legendPenaltyEqualAbove("3") : MESSAGES.legendPenaltyEqual(String.valueOf(nrConflicts))));
                }
                break;
            }
            case TooBigRooms: {
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sRequired), MESSAGES.legendTooBigRoomsRequired());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendTooBigRoomsNeutral());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendTooBigRoomsDiscouraged());
                response.addAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendTooBigRoomsStronglyDiscouraged());
                break;
            }
            case StudentGroups: {
                for (int percentage = 0; percentage <= 100; percentage += 5) {
                    response.addAssignedLegend(TimetableGridHelper.percentage2color(percentage), MESSAGES.legendStudentGroups(String.valueOf(percentage)));
                }
                break;
            }
            case InstructionalType: {
                for (ItypeDesc it : ItypeDescDAO.getInstance().getSession().createQuery("from ItypeDesc where itype in (select s.itype.itype from SchedulingSubpart s where s.instrOfferingConfig.instructionalOffering.session = :sessionId) and parent is null order by itype").setLong("sessionId", acadSession.getUniqueId().longValue()).list()) {
                    response.addAssignedLegend(cx.getInstructionalTypeColor(it.getItype()), it.getDesc());
                }
                break;
            }
        }
        response.addNotAssignedLegend(TimetableGridHelper.sBgColorNotAvailable, MESSAGES.legendTimeNotAvailable());
        response.addNotAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sNeutral), MESSAGES.legendNoPreference());
        if (cx.isShowFreeTimes()) {
            response.addNotAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sDiscouraged), MESSAGES.legendFreeTimeDiscouraged());
            response.addNotAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sStronglyDiscouraged), MESSAGES.legendFreeTimeStronglyDiscouraged());
            response.addNotAssignedLegend(TimetableGridHelper.pref2color(PreferenceLevel.sProhibited), MESSAGES.legendFreeTimeProhibited());
        }
        return response;
    }

    private boolean match(Query q, final String name) {
        return q == null || q.match(new Query.TermMatcher(){

            @Override
            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(term, " ,");
                    block0: while (s.hasMoreTokens()) {
                        String termToken = s.nextToken();
                        StringTokenizer t = new StringTokenizer(name, " ,");
                        while (t.hasMoreTokens()) {
                            String token = t.nextToken();
                            if (!token.toLowerCase().startsWith(termToken.toLowerCase())) continue;
                            continue block0;
                        }
                        return false;
                    }
                    return true;
                }
                if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                    return name.matches(term);
                }
                if ("find".equals(attr)) {
                    return name.toLowerCase().indexOf(term.toLowerCase()) >= 0;
                }
                return false;
            }
        });
    }

    private boolean match(Query q, final Location location) {
        return q == null || q.match(new Query.TermMatcher(){

            @Override
            public boolean match(String attr, String term) {
                if (term.isEmpty()) {
                    return true;
                }
                if (attr == null) {
                    StringTokenizer s = new StringTokenizer(location.getLabel(), " ,");
                    while (s.hasMoreTokens()) {
                        String token = s.nextToken();
                        if (!term.equalsIgnoreCase(token)) continue;
                        return true;
                    }
                } else {
                    if ("regex".equals(attr) || "regexp".equals(attr) || "re".equals(attr)) {
                        return location.getLabel().matches(term);
                    }
                    if ("find".equals(attr)) {
                        return location.getLabel().toLowerCase().indexOf(term.toLowerCase()) >= 0;
                    }
                    if ("type".equals(attr)) {
                        return term.equalsIgnoreCase(location.getRoomType().getReference()) || term.equalsIgnoreCase(location.getRoomType().getLabel());
                    }
                    if ("size".equals(attr)) {
                        int min = 0;
                        int max = Integer.MAX_VALUE;
                        Size prefix = Size.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = Size.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = Size.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = Size.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = Size.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = Size.eq;
                            number = number.substring(1);
                        }
                        try {
                            int a = Integer.parseInt(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1;
                                    break;
                                }
                                case gt: {
                                    min = a + 1;
                                }
                            }
                        }
                        catch (NumberFormatException a) {
                            // empty catch block
                        }
                        if (term.contains("..")) {
                            try {
                                String a = term.substring(0, term.indexOf(46));
                                String b = term.substring(term.indexOf("..") + 2);
                                min = Integer.parseInt(a);
                                max = Integer.parseInt(b);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        return min <= location.getCapacity() && location.getCapacity() <= max;
                    }
                }
                return false;
            }
        });
    }

    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

