/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.SolverParameterDefDAO;
import org.unitime.timetable.model.dao.SolverParameterGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=solverParamDef]")
public class SolverParameterDefs
implements AdminTable,
AdminTable.HasFilter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageSolverParam(), MESSAGES.pageSolverParams());
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        return this.load(null, context, hibSession);
    }

    protected List<SolverParameterDef> getSolverParameterDefs(String[] filter, SessionContext context) {
        if (filter == null || filter[0] == null || filter[0].isEmpty() || filter[0].equals("null")) {
            context.getUser().setProperty("Admin.SolverParameterDef.FilterType", null);
            return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterDef order by group.order, order, name").list();
        }
        context.getUser().setProperty("Admin.SolverParameterDef.FilterType", filter[0]);
        return SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterDef where group = :group order by group.order, order, name").setLong("group", Long.valueOf(filter[0]).longValue()).list();
    }

    protected List<SimpleEditInterface.ListItem> getGroupTypes() {
        ArrayList<SimpleEditInterface.ListItem> types = new ArrayList<SimpleEditInterface.ListItem>();
        for (SolverParameterGroup group : SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterGroup order by order, name").list()) {
            String name = group.getDescription();
            switch (group.getSolverType()) {
                case COURSE: {
                    name = MESSAGES.solverSolverParameterGroupCourses(group.getDescription());
                    break;
                }
                case EXAM: {
                    name = MESSAGES.solverSolverParameterGroupExams(group.getDescription());
                    break;
                }
                case INSTRUCTOR: {
                    name = MESSAGES.solverSolverParameterGroupInstructors(group.getDescription());
                    break;
                }
                case STUDENT: {
                    name = MESSAGES.solverSolverParameterGroupStudents(group.getDescription());
                }
            }
            types.add(new SimpleEditInterface.ListItem(group.getUniqueId().toString(), name));
        }
        return types;
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public SimpleEditInterface load(String[] filter, SessionContext context, Session hibSession) {
        SimpleEditInterface.Field name = null;
        SimpleEditInterface.Field groups = null;
        if (filter != null && filter[0] != null && !filter[0].isEmpty() && !filter[0].equals("null")) {
            name = new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY);
            groups = new SimpleEditInterface.Field(MESSAGES.fieldSolverParameterGroup(), SimpleEditInterface.FieldType.list, 200, this.getGroupTypes(), SimpleEditInterface.Flag.NOT_EMPTY, SimpleEditInterface.Flag.NO_LIST).withDefault(filter[0]);
        } else {
            name = new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.NOT_EMPTY);
            groups = new SimpleEditInterface.Field(MESSAGES.fieldSolverParameterGroup(), SimpleEditInterface.FieldType.list, 200, this.getGroupTypes(), SimpleEditInterface.Flag.NOT_EMPTY);
        }
        SimpleEditInterface data = new SimpleEditInterface(name, groups, new SimpleEditInterface.Field(MESSAGES.fieldDescription(), SimpleEditInterface.FieldType.text, 700, 1000, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldType(), SimpleEditInterface.FieldType.text, 700, 1000, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldDefault(), SimpleEditInterface.FieldType.text, 700, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldVisible(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED));
        data.setSaveOrder(false);
        data.setCanMoveUpAndDown(true);
        data.setAllowSort(false);
        for (SolverParameterDef def : this.getSolverParameterDefs(filter, context)) {
            SimpleEditInterface.Record r = data.addRecord(def.getUniqueId());
            r.setField(0, def.getName());
            r.setField(1, def.getGroup() == null ? "" : def.getGroup().getUniqueId().toString());
            r.setField(2, def.getDescription());
            r.setField(3, def.getType());
            r.setField(4, def.getDefault());
            r.setField(5, def.getVisible() != false ? "true" : "false");
        }
        return data;
    }

    protected int nextOrd(Set<Integer> ords) {
        for (int i = 0; i < ords.size() + 1; ++i) {
            if (ords.contains(i)) continue;
            ords.add(i);
            return i;
        }
        return ords.size();
    }

    protected int nextOrd(Long groupId) {
        List defs = SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterDef where group = :group order by group.order, order, name").setLong("group", groupId.longValue()).list();
        int idx = 0;
        block0: while (true) {
            for (SolverParameterDef t : defs) {
                if (idx != t.getOrder()) continue;
                ++idx;
                continue block0;
            }
            break;
        }
        return idx;
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        this.save(null, data, context, hibSession);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public void save(String[] filter, SimpleEditInterface data, SessionContext context, Session hibSession) {
        HashMap<Long, HashSet<Integer>> g2ords = new HashMap<Long, HashSet<Integer>>();
        if (filter != null && filter[0] != null && !filter[0].isEmpty() && !filter[0].equals("null")) {
            for (SolverParameterDef def : SolverParameterGroupDAO.getInstance().getSession().createQuery("from SolverParameterDef where group != :group order by group.order, order, name").setLong("group", Long.valueOf(filter[0]).longValue()).list()) {
                HashSet<Integer> ords = (HashSet<Integer>)g2ords.get(def.getGroup().getUniqueId());
                if (ords == null) {
                    ords = new HashSet<Integer>();
                    g2ords.put(def.getGroup().getUniqueId(), ords);
                }
                ords.add(def.getOrder());
            }
        }
        for (SimpleEditInterface.Record r : data.getRecords()) {
            if (r.isEmpty(data)) continue;
            Long gid = Long.valueOf(r.getField(1));
            HashSet<Integer> ords = (HashSet<Integer>)g2ords.get(gid);
            if (ords == null) {
                ords = new HashSet<Integer>();
                g2ords.put(gid, ords);
            }
            r.setOrder(this.nextOrd(ords));
        }
        for (SolverParameterDef def : this.getSolverParameterDefs(filter, context)) {
            SimpleEditInterface.Record r = data.getRecord(def.getUniqueId());
            if (r == null) {
                this.delete(def, context, hibSession);
                continue;
            }
            this.update(def, r, r.getOrder(), context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, r.getOrder(), context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.save(record, null, context, hibSession);
    }

    protected void save(SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        Long gid = Long.valueOf(record.getField(1));
        if (order == null) {
            order = this.nextOrd(gid);
        }
        SolverParameterDef def = new SolverParameterDef();
        def.setName(record.getField(0));
        def.setGroup((SolverParameterGroup)SolverParameterGroupDAO.getInstance().get(gid));
        def.setDescription(record.getField(2));
        def.setType(record.getField(3));
        def.setDefault(record.getField(4));
        def.setVisible(!"false".equalsIgnoreCase(record.getField(5)));
        def.setOrder(order);
        record.setUniqueId((Long)hibSession.save((Object)def));
        ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(SolverParameterDef def, SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        boolean changed;
        if (def == null) {
            return;
        }
        Long gid = Long.valueOf(record.getField(1));
        if (order == null) {
            order = gid.equals(def.getGroup().getUniqueId()) ? def.getOrder() : Integer.valueOf(this.nextOrd(gid));
        }
        boolean bl = !ToolBox.equals((Object)def.getName(), (Object)record.getField(0)) || !ToolBox.equals((Object)def.getGroup().getUniqueId().toString(), (Object)record.getField(1)) || !ToolBox.equals((Object)def.getDescription(), (Object)record.getField(2)) || !ToolBox.equals((Object)def.getType(), (Object)record.getField(3)) || !ToolBox.equals((Object)def.getDefault(), (Object)record.getField(4)) || !ToolBox.equals((Object)(def.isVisible() != false ? "true" : "false"), (Object)record.getField(5)) ? true : (changed = false);
        if (!changed && ToolBox.equals((Object)def.getOrder(), (Object)order)) {
            return;
        }
        def.setName(record.getField(0));
        def.setGroup((SolverParameterGroup)SolverParameterGroupDAO.getInstance().get(gid));
        def.setDescription(record.getField(2));
        def.setType(record.getField(3));
        def.setDefault(record.getField(4));
        def.setVisible(!"false".equalsIgnoreCase(record.getField(5)));
        def.setOrder(order);
        hibSession.saveOrUpdate((Object)def);
        if (changed) {
            ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((SolverParameterDef)SolverParameterDefDAO.getInstance().get(record.getUniqueId(), hibSession), record, null, context, hibSession);
    }

    protected void delete(SolverParameterDef def, SessionContext context, Session hibSession) {
        if (def == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)def);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((SolverParameterDef)SolverParameterDefDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolverParameters')")
    public SimpleEditInterface.Filter getFilter(SessionContext context, Session hibSession) {
        List<SimpleEditInterface.ListItem> types = this.getGroupTypes();
        types.add(0, new SimpleEditInterface.ListItem("", MESSAGES.itemAll()));
        SimpleEditInterface.Filter filter = new SimpleEditInterface.Filter(new SimpleEditInterface.Field(MESSAGES.fieldSolverParameterGroup(), SimpleEditInterface.FieldType.list, 100, types, new SimpleEditInterface.Flag[0]));
        String lastId = context.getUser().getProperty("Admin.SolverParameterDef.FilterType");
        if (lastId != null) {
            filter.getDefaultValue().setField(0, lastId);
        }
        return filter;
    }
}

