/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Meeting;

public abstract class BaseEventNote
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iNoteType;
    private String iTextNote;
    private Date iTimeStamp;
    private String iUser;
    private String iUserId;
    private String iMeetings;
    private byte[] iAttachedFile;
    private String iAttachedName;
    private String iAttachedContentType;
    private Event iEvent;
    private Set<Meeting> iAffectedMeetings;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_NOTE_TYPE = "noteType";
    public static String PROP_TEXT_NOTE = "textNote";
    public static String PROP_TIME_STAMP = "timeStamp";
    public static String PROP_UNAME = "user";
    public static String PROP_USER_ID = "userId";
    public static String PROP_MEETINGS = "meetings";
    public static String PROP_ATTACHED_FILE = "attachedFile";
    public static String PROP_ATTACHED_NAME = "attachedName";
    public static String PROP_ATTACHED_CONTENT = "attachedContentType";

    public BaseEventNote() {
        this.initialize();
    }

    public BaseEventNote(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Integer getNoteType() {
        return this.iNoteType;
    }

    public void setNoteType(Integer noteType) {
        this.iNoteType = noteType;
    }

    public String getTextNote() {
        return this.iTextNote;
    }

    public void setTextNote(String textNote) {
        this.iTextNote = textNote;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    public String getUser() {
        return this.iUser;
    }

    public void setUser(String user) {
        this.iUser = user;
    }

    public String getUserId() {
        return this.iUserId;
    }

    public void setUserId(String userId) {
        this.iUserId = userId;
    }

    public String getMeetings() {
        return this.iMeetings;
    }

    public void setMeetings(String meetings) {
        this.iMeetings = meetings;
    }

    public byte[] getAttachedFile() {
        return this.iAttachedFile;
    }

    public void setAttachedFile(byte[] attachedFile) {
        this.iAttachedFile = attachedFile;
    }

    public String getAttachedName() {
        return this.iAttachedName;
    }

    public void setAttachedName(String attachedName) {
        this.iAttachedName = attachedName;
    }

    public String getAttachedContentType() {
        return this.iAttachedContentType;
    }

    public void setAttachedContentType(String attachedContentType) {
        this.iAttachedContentType = attachedContentType;
    }

    public Event getEvent() {
        return this.iEvent;
    }

    public void setEvent(Event event) {
        this.iEvent = event;
    }

    public Set<Meeting> getAffectedMeetings() {
        return this.iAffectedMeetings;
    }

    public void setAffectedMeetings(Set<Meeting> affectedMeetings) {
        this.iAffectedMeetings = affectedMeetings;
    }

    public void addToaffectedMeetings(Meeting meeting) {
        if (this.iAffectedMeetings == null) {
            this.iAffectedMeetings = new HashSet<Meeting>();
        }
        this.iAffectedMeetings.add(meeting);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EventNote)) {
            return false;
        }
        if (this.getUniqueId() == null || ((EventNote)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((EventNote)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "EventNote[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "EventNote[\n\tAttachedContentType: " + this.getAttachedContentType() + "\n\tAttachedFile: " + this.getAttachedFile() + "\n\tAttachedName: " + this.getAttachedName() + "\n\tEvent: " + this.getEvent() + "\n\tMeetings: " + this.getMeetings() + "\n\tNoteType: " + this.getNoteType() + "\n\tTextNote: " + this.getTextNote() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUser: " + this.getUser() + "\n\tUserId: " + this.getUserId() + "]";
    }
}

