/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.validate;

import java.util.BitSet;

public class AllowedCharacters {
    private static final int LENGTH = 128;
    private final BitSet bitSet;
    private final boolean allowNonAscii;

    public AllowedCharacters(BitSet bitSet, boolean allowNonAscii) {
        this.bitSet = bitSet;
        this.allowNonAscii = allowNonAscii;
    }

    public BitSet bitSet() {
        return this.bitSet;
    }

    public boolean isNonAsciiAllowed() {
        return this.allowNonAscii;
    }

    public boolean check(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c >= '\u0080' ? !this.allowNonAscii : !this.bitSet.get(c))) continue;
            return false;
        }
        return true;
    }

    public AllowedCharacters flip() {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.flip(0, 128);
        return new AllowedCharacters(bitSet, !this.allowNonAscii);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printableOnly) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        block6: for (int i = 0; i < 128; ++i) {
            if (!this.bitSet.get(i)) continue;
            String toPrint = null;
            char c = (char)i;
            switch (c) {
                case ' ': {
                    toPrint = "<space>";
                    break;
                }
                case '\r': {
                    toPrint = "\\r";
                    break;
                }
                case '\n': {
                    toPrint = "\\n";
                    break;
                }
                case '\t': {
                    toPrint = "\\t";
                    break;
                }
                default: {
                    if (i >= 32 && i != 127) break;
                    if (printableOnly) continue block6;
                    toPrint = "(" + i + ")";
                }
            }
            sb.append(' ');
            if (toPrint == null) {
                sb.append(c);
                continue;
            }
            sb.append(toPrint);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static class Builder {
        private final BitSet bitSet;
        private boolean allowNonAscii;

        public Builder() {
            this.bitSet = new BitSet(128);
            this.allowNonAscii = false;
        }

        public Builder(AllowedCharacters original) {
            this.bitSet = (BitSet)original.bitSet.clone();
            this.allowNonAscii = original.allowNonAscii;
        }

        public Builder allowAll() {
            this.bitSet.set(0, 128);
            this.allowNonAscii = true;
            return this;
        }

        public Builder allow(int from, int to) {
            this.bitSet.set(from, to + 1);
            return this;
        }

        public Builder allow(String characters) {
            this.setAll(characters, true);
            return this;
        }

        public Builder allow(char c) {
            this.bitSet.set(c);
            return this;
        }

        public Builder allowPrintable() {
            return this.allow(32, 126);
        }

        public Builder allowNonAscii() {
            this.allowNonAscii = true;
            return this;
        }

        public Builder except(String characters) {
            this.setAll(characters, false);
            return this;
        }

        public Builder except(char c) {
            this.bitSet.set((int)c, false);
            return this;
        }

        public AllowedCharacters build() {
            return new AllowedCharacters(this.bitSet, this.allowNonAscii);
        }

        private void setAll(String characters, boolean value) {
            for (int i = 0; i < characters.length(); ++i) {
                char c = characters.charAt(i);
                this.bitSet.set((int)c, value);
            }
        }
    }
}

