/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.dao.ItypeDescDAO;

public class ItypeDescEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 3555401912530970356L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private Integer iUniqueId = null;
    private String iId = null;
    private String iReference = null;
    private String iName = null;
    private String iAbbreviation = null;
    private int iType = 1;
    private boolean iOrganized = false;
    private Integer iParent = null;

    @Override
    public void validate(UniTimeAction action) {
        try {
            if (this.iAbbreviation == null || this.iAbbreviation.trim().length() == 0) {
                action.addFieldError("form.abbreviation", MSG.errorRequiredField(MSG.fieldAbbreviation()));
            }
            if (this.iName == null || this.iName.trim().length() == 0) {
                action.addFieldError("form.name", MSG.errorRequiredField(MSG.fieldName()));
            }
            try {
                if (this.iId == null || this.iId.trim().length() == 0) {
                    action.addFieldError("form.id", MSG.errorRequiredField(MSG.fieldIType()));
                } else {
                    Integer id = Integer.valueOf(this.iId);
                    ItypeDesc itype = (ItypeDesc)new ItypeDescDAO().get(id);
                    if (itype != null && (this.iUniqueId == null || this.iUniqueId < 0 || itype.equals(this.iUniqueId))) {
                        action.addFieldError("form.id", MSG.errorAlreadyExists(this.iId));
                    }
                    if ((itype = (ItypeDesc)ItypeDescDAO.getInstance().getSession().createQuery("from ItypeDesc x where x.abbv = :abbv and x.id != :id").setString("abbv", this.iAbbreviation).setInteger("id", id.intValue()).setMaxResults(1).uniqueResult()) != null) {
                        action.addFieldError("abbreviation", MSG.errorAlreadyExists(this.iAbbreviation));
                    }
                    if ((itype = (ItypeDesc)ItypeDescDAO.getInstance().getSession().createQuery("from ItypeDesc x where x.desc = :name and x.id != :id").setString("name", this.iName).setInteger("id", id.intValue()).setMaxResults(1).uniqueResult()) != null) {
                        action.addFieldError("form.name", MSG.errorAlreadyExists(this.iName));
                    }
                }
            }
            catch (NumberFormatException e) {
                action.addFieldError("form.id", MSG.errorNotNumber(this.iId));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            action.addFieldError("form.id", e.getMessage());
        }
    }

    @Override
    public void reset() {
        this.iId = null;
        this.iUniqueId = -1;
        this.iAbbreviation = null;
        this.iReference = null;
        this.iName = null;
        this.iType = 1;
        this.iOrganized = false;
    }

    public Integer getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Integer uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getId() {
        return this.iId;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getReference() {
        return this.iReference;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    public String getType() {
        return ItypeDesc.sBasicTypes[this.iType];
    }

    public void setType(String type) {
        for (int i = 0; i < ItypeDesc.sBasicTypes.length; ++i) {
            if (!ItypeDesc.sBasicTypes[i].equals(type)) continue;
            this.iType = i;
        }
    }

    public int getBasicType() {
        return this.iType;
    }

    public void setBasicType(int type) {
        this.iType = type;
    }

    public String[] getTypes() {
        return ItypeDesc.sBasicTypes;
    }

    public boolean getOrganized() {
        return this.iOrganized;
    }

    public void setOrganized(boolean organized) {
        this.iOrganized = organized;
    }

    public Integer getParent() {
        return this.iParent;
    }

    public void setParent(Integer parent) {
        this.iParent = parent;
    }

    public void load(ItypeDesc itype) {
        this.setId(itype.getItype().toString());
        this.setUniqueId(itype.getItype());
        this.setAbbreviation(itype.getAbbv());
        this.setName(itype.getDesc());
        this.setReference(itype.getSis_ref());
        this.setBasicType(itype.getBasic() != false ? 1 : 0);
        this.setParent(itype.getParent() == null ? null : itype.getParent().getItype());
        this.setOrganized(itype.isOrganized());
    }

    public void saveOrUpdate(Session hibSession) throws Exception {
        ItypeDesc itype = null;
        if (this.getUniqueId() != null) {
            itype = (ItypeDesc)new ItypeDescDAO().get(this.getUniqueId());
        }
        if (itype == null) {
            itype = new ItypeDesc();
        }
        itype.setItype(Integer.valueOf(this.getId()));
        itype.setAbbv(this.getAbbreviation());
        itype.setDesc(this.getName());
        itype.setSis_ref(this.getReference());
        itype.setBasic(this.getBasicType() == 1);
        itype.setParent(this.getParent() == null ? null : (ItypeDesc)new ItypeDescDAO().get(this.getParent()));
        itype.setOrganized(this.getOrganized());
        hibSession.saveOrUpdate((Object)itype);
    }

    public void delete(Session hibSession) {
        ItypeDesc itype = (ItypeDesc)new ItypeDescDAO().get(this.getUniqueId());
        if (itype != null) {
            hibSession.delete((Object)itype);
        }
    }
}

