/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ExamInfoForm;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ui.ExamConflictStatisticsInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfoModel;
import org.unitime.timetable.util.RoomAvailability;

@Action(value="examInfo", results={@Result(name={"show"}, type="tiles", location="examInfo.tiles")})
@TilesDefinition(name="examInfo.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Assignment"), @TilesPutAttribute(name="body", value="/exam/info.jsp"), @TilesPutAttribute(name="showMenu", value="false"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamInfoAction
extends UniTimeAction<ExamInfoForm> {
    private static final long serialVersionUID = 3810998750494935506L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private Long examId;
    private Long period;
    private String room;
    private Integer suggestion;
    private Long delete;

    public Long getExamId() {
        return this.examId;
    }

    public void setExamId(Long examId) {
        this.examId = examId;
    }

    public Long getPeriod() {
        return this.period;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public Integer getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(Integer suggestion) {
        this.suggestion = suggestion;
    }

    public Long getDelete() {
        return this.delete;
    }

    public void setDelete(Long delete) {
        this.delete = delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ExamInfoModel examInfoModel;
        ExamInfoModel model;
        if (this.form == null) {
            this.form = new ExamInfoForm();
            ((ExamInfoForm)this.form).reset();
        }
        if (((ExamInfoForm)this.form).getOp() != null) {
            this.op = ((ExamInfoForm)this.form).getOp();
        }
        if ((model = (ExamInfoModel)this.sessionContext.getAttribute(SessionAttribute.ExamInfoModel)) == null) {
            model = new ExamInfoModel();
            this.sessionContext.setAttribute(SessionAttribute.ExamInfoModel, (Object)model);
        }
        if (this.op == null && model.getExam() != null && this.examId == null) {
            this.op = MSG.buttonApply();
        }
        if (MSG.buttonApply().equals(this.op)) {
            ((ExamInfoForm)this.form).save(this.request.getSession());
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((ExamInfoForm)this.form).reset();
        }
        ((ExamInfoForm)this.form).load(this.request.getSession());
        ((ExamInfoForm)this.form).setModel(model);
        model.apply(this.request, (ExamInfoForm)this.form);
        if (this.op == null) {
            model.clear(this.sessionContext.getUser());
        } else if (MSG.buttonApply().equals(this.op)) {
            model.refreshRooms();
            model.refreshSuggestions();
        }
        if (MSG.buttonSearchDeeper().equals(this.op)) {
            ((ExamInfoForm)this.form).setDepth(((ExamInfoForm)this.form).getDepth() + 1);
            ((ExamInfoForm)this.form).save(this.request.getSession());
            model.refreshSuggestions();
        } else if (MSG.buttonSearchLonger().equals(this.op)) {
            ((ExamInfoForm)this.form).setTimeout(2L * ((ExamInfoForm)this.form).getTimeout());
            ((ExamInfoForm)this.form).save(this.request.getSession());
            model.refreshSuggestions();
        }
        model.setSolver(WebSolver.getExamSolver(this.request.getSession()));
        if (this.examId != null) {
            model.setExam((Exam)new ExamDAO().get(this.examId));
            ((ExamInfoForm)this.form).save(this.request.getSession());
        }
        if (model.getExam() == null) {
            throw new Exception("No exam given.");
        }
        this.sessionContext.checkPermission(model.getExam().getExam(), Right.ExaminationAssignment);
        ((ExamInfoForm)this.form).setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        ((ExamInfoForm)this.form).setExamTypeId(model.getExam().getExamTypeId());
        if (RoomAvailability.getInstance() != null && this.op == null) {
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            Date[] bounds = ExamPeriod.getBounds(session, model.getExam().getExamType().getUniqueId());
            String exclude = model.getExam().getExamType().getReference();
            RoomAvailability.getInstance().activate(session.getUniqueId(), bounds[0], bounds[1], exclude, false);
            RoomAvailability.setAvailabilityWarning(this.request, session, model.getExam().getExamType().getUniqueId(), true, true);
        }
        if ("Select".equals(this.op)) {
            examInfoModel = model;
            synchronized (examInfoModel) {
                if (this.period != null) {
                    model.setPeriod(this.period);
                }
                if (this.room != null) {
                    model.setRooms(this.room);
                }
                if (this.suggestion != null) {
                    model.setSuggestion(this.suggestion);
                }
                if (this.delete != null) {
                    model.delete(this.delete);
                }
            }
        }
        if (MSG.buttonAssign().equals(this.op)) {
            examInfoModel = model;
            synchronized (examInfoModel) {
                String message = model.assign();
                if (message == null || message.trim().length() == 0) {
                    ((ExamInfoForm)this.form).setOp("Close");
                } else {
                    ((ExamInfoForm)this.form).setMessage(message);
                }
            }
        }
        if (MSG.buttonClose().equals(this.op) || "Close".equals(this.op)) {
            ((ExamInfoForm)this.form).setOp("Close");
        }
        return "show";
    }

    public void printCbsHeader() {
        ExamConflictStatisticsInfo.printHtmlHeader(this.getPageContext().getOut());
    }

    public void printCbs() {
        ((ExamInfoForm)this.form).getModel().getCbs().printHtml(this.getPageContext().getOut(), ((ExamInfoForm)this.form).getModel().getExam().getExamId(), 1.0, ExamConflictStatisticsInfo.TYPE_CONSTRAINT_BASED, true);
    }
}

