/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.commons.Debug;

public class WebTextValidation {
    private static final String patternStr = ".*[|<>\"+].*";
    private static final String hexPatternStr = ".*%[0-9A-Fa-f][0-9A-Fa-f].*";
    private static final String phonePatternStr = "^[ \t\n\f\r]*[0-9)( \t\n\f\r+][0-9)( \t\n\f\r.,-]+[ \t\n\f\r]*$";

    public static boolean isTextValid(String aText, boolean canBeNull) {
        if (!(canBeNull || aText != null && aText.trim().length() != 0)) {
            return false;
        }
        if (canBeNull && (aText == null || aText.trim().length() == 0)) {
            return true;
        }
        String checkText = aText.toUpperCase();
        try {
            Pattern pattern = Pattern.compile(patternStr, 35);
            Matcher matcher = pattern.matcher(checkText);
            if (matcher.matches()) {
                return false;
            }
            Pattern patternHex = Pattern.compile(hexPatternStr, 35);
            Matcher matcherHex = patternHex.matcher(checkText);
            if (matcherHex.matches()) {
                return false;
            }
        }
        catch (Exception e) {
            Debug.info("Threw exception " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean containsOnlyCharactersUsedInPhoneNumbers(String aText, boolean canBeNull) {
        if (!(canBeNull || aText != null && aText.trim().length() != 0)) {
            return false;
        }
        if (canBeNull && (aText == null || aText.trim().length() == 0)) {
            return true;
        }
        try {
            Pattern phonePattern = Pattern.compile(phonePatternStr);
            Matcher matcher = phonePattern.matcher(aText);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

