/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.webutil.PdfWebTable;

public class ExportUtils {
    public static OutputStream getPdfOutputStream(HttpServletResponse response, String name) throws IOException {
        response.setContentType("application/pdf; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + ".pdf\"");
        return response.getOutputStream();
    }

    public static OutputStream getXmlOutputStream(HttpServletResponse response, String name) throws IOException {
        response.setContentType("application/xml; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + ".xml\"");
        return response.getOutputStream();
    }

    public static PrintWriter getCsvWriter(HttpServletResponse response, String name) throws IOException {
        response.setContentType("text/csv; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + name + ".csv\"");
        return response.getWriter();
    }

    public static PrintWriter getPlainTextWriter(HttpServletResponse response, String name) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + (name.indexOf(46) < 0 ? name + ".txt" : name) + "\"");
        return response.getWriter();
    }

    public static void exportCSV(CSVFile csv, HttpServletResponse response, String name) throws IOException {
        PrintWriter writer = ExportUtils.getCsvWriter(response, name);
        if (csv.getHeader() != null) {
            writer.println(csv.getHeader().toString());
        }
        if (csv.getLines() != null) {
            for (CSVFile.CSVLine line : csv.getLines()) {
                writer.println(line.toString());
            }
        }
        writer.flush();
        writer.close();
    }

    public static void exportPDF(PdfWebTable table, int ordCol, HttpServletResponse response, String name) throws Exception {
        OutputStream out = ExportUtils.getPdfOutputStream(response, name);
        try {
            table.exportPdf(out, ordCol);
        }
        catch (Exception e) {
            Debug.error("Failed to export PDF: " + e.getMessage(), e);
        }
        out.flush();
        out.close();
    }

    public static void exportCSV(WebTable table, int ordCol, HttpServletResponse response, String name) throws IOException {
        ExportUtils.exportCSV(table.printCsvTable(ordCol), response, name);
    }
}

