/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseExamConflict;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;

public class UpdateExamConflicts {
    private static Log sLog = LogFactory.getLog(UpdateExamConflicts.class);
    private static DecimalFormat sDF = new DecimalFormat("0.0");
    private static boolean sDebug = false;
    private static int sCreate = 0;
    private static int sUpdate = 1;
    private static int sDelete = 2;
    private static int sStudents = 0;
    private static int sInstructors = 1;
    private int[][][] iCnt;
    private int[][] iTotal;
    private DataExchangeHelper iHelper = null;

    public UpdateExamConflicts() {
    }

    public UpdateExamConflicts(DataExchangeHelper helper) {
        this.iHelper = helper;
    }

    private void debug(String message) {
        if (!sDebug) {
            return;
        }
        if (this.iHelper == null) {
            sLog.debug((Object)message);
        } else {
            this.iHelper.debug(message);
        }
    }

    private void info(String message) {
        if (this.iHelper == null) {
            sLog.info((Object)message);
        } else {
            this.iHelper.info(message);
        }
    }

    public void updateConflicts(ExamAssignmentInfo assignment, org.hibernate.Session hibSession) throws Exception {
        Transaction tx = null;
        try {
            Object conf;
            HashSet<DepartmentalInstructor> instructors;
            Object students;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            Exam exam = assignment.getExam(hibSession);
            HashSet<Exam> otherExams = new HashSet<Exam>();
            HashSet<ExamConflict> conflicts = new HashSet<ExamConflict>(exam.getConflicts());
            for (ExamAssignmentInfo.DirectConflict directConflict : assignment.getDirectConflicts()) {
                if (directConflict.getOtherExam() == null) continue;
                BaseExamConflict conf2 = null;
                for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != 0 || c.getNrStudents() == 0) continue;
                    Exam other3 = null;
                    for (Exam x : c.getExams()) {
                        if (!x.getUniqueId().equals(directConflict.getOtherExam().getExamId())) continue;
                        other3 = x;
                        break;
                    }
                    if (other3 == null) continue;
                    conf2 = c;
                    break;
                }
                students = UpdateExamConflicts.getStudents(hibSession, directConflict.getStudents());
                if (exam.getUniqueId().compareTo(directConflict.getOtherExam().getExamId()) < 0) {
                    int[] nArray = this.iTotal[sStudents];
                    nArray[0] = nArray[0] + ((HashSet)students).size();
                }
                if (conf2 == null) {
                    this.debug("    new direct " + assignment.getExamName() + " " + directConflict.getOtherExam().getExamName() + " (" + ((HashSet)students).size() + " students)");
                    conf2 = new ExamConflict();
                    conf2.setConflictType(0);
                    conf2.setStudents((Set<Student>)students);
                    conf2.setNrStudents(((HashSet)students).size());
                    exam.getConflicts().add((ExamConflict)conf2);
                    Exam other4 = directConflict.getOtherExam().getExam(hibSession);
                    other4.getConflicts().add((ExamConflict)conf2);
                    otherExams.add(other4);
                    conf2.setExams(new HashSet<Exam>());
                    conf2.getExams().add(exam);
                    conf2.getExams().add(other4);
                    hibSession.save((Object)conf2);
                    int[] nArray = this.iCnt[sStudents][conf2.getConflictType()];
                    int n = sCreate;
                    nArray[n] = nArray[n] + conf2.getNrStudents();
                    continue;
                }
                conflicts.remove(conf2);
                boolean change = ((HashSet)students).size() != conf2.getStudents().size() || !((AbstractCollection)students).containsAll(conf2.getStudents());
                if (!change) continue;
                this.debug("    update direct " + assignment.getExamName() + " " + directConflict.getOtherExam().getExamName() + " (" + conf2.getNrStudents() + "->" + ((HashSet)students).size() + " students)");
                conf2.setStudents((Set<Student>)students);
                conf2.setNrStudents(((HashSet)students).size());
                hibSession.update((Object)conf2);
                int[] nArray = this.iCnt[sStudents][conf2.getConflictType()];
                int n = sUpdate;
                nArray[n] = nArray[n] + conf2.getNrStudents();
            }
            for (ExamAssignmentInfo.DirectConflict directConflict : assignment.getInstructorDirectConflicts()) {
                if (directConflict.getOtherExam() == null) continue;
                BaseExamConflict conf2 = null;
                for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != 0 || c.getNrInstructors() == 0) continue;
                    Exam other = null;
                    for (Exam x : c.getExams()) {
                        if (!x.getUniqueId().equals(directConflict.getOtherExam().getExamId())) continue;
                        other = x;
                        break;
                    }
                    if (other == null) continue;
                    conf2 = c;
                    break;
                }
                instructors = UpdateExamConflicts.getInstructors(hibSession, directConflict.getStudents());
                if (exam.getUniqueId().compareTo(directConflict.getOtherExam().getExamId()) < 0) {
                    int[] nArray = this.iTotal[sInstructors];
                    nArray[0] = nArray[0] + instructors.size();
                }
                if (conf2 == null) {
                    this.debug("    new direct " + assignment.getExamName() + " " + directConflict.getOtherExam().getExamName() + " (" + instructors.size() + " instructors)");
                    conf2 = new ExamConflict();
                    conf2.setConflictType(0);
                    conf2.setInstructors(instructors);
                    conf2.setNrInstructors(instructors.size());
                    exam.getConflicts().add((ExamConflict)conf2);
                    Exam other5 = directConflict.getOtherExam().getExam(hibSession);
                    other5.getConflicts().add((ExamConflict)conf2);
                    otherExams.add(other5);
                    conf2.setExams(new HashSet<Exam>());
                    conf2.getExams().add(exam);
                    conf2.getExams().add(other5);
                    hibSession.save((Object)conf2);
                    int[] nArray = this.iCnt[sInstructors][conf2.getConflictType()];
                    int n = sCreate;
                    nArray[n] = nArray[n] + conf2.getNrInstructors();
                    continue;
                }
                conflicts.remove(conf2);
                boolean change = instructors.size() != conf2.getInstructors().size() || !instructors.containsAll(conf2.getInstructors());
                if (!change) continue;
                this.debug("    update direct " + assignment.getExamName() + " " + directConflict.getOtherExam().getExamName() + " (" + conf2.getNrInstructors() + "->" + instructors.size() + " instructors)");
                conf2.setInstructors(instructors);
                conf2.setNrInstructors(instructors.size());
                hibSession.update((Object)conf2);
                int[] nArray = this.iCnt[sInstructors][conf2.getConflictType()];
                int n = sUpdate;
                nArray[n] = nArray[n] + conf2.getNrInstructors();
            }
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : assignment.getBackToBackConflicts()) {
                boolean change;
                int type;
                int n = type = backToBackConflict.isDistance() ? 2 : 3;
                if (backToBackConflict.getOtherExam() == null) continue;
                conf = null;
                for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != type || c.getNrStudents() == 0) continue;
                    Exam other2 = null;
                    for (Exam exam2 : c.getExams()) {
                        if (!exam2.getUniqueId().equals(backToBackConflict.getOtherExam().getExamId())) continue;
                        other2 = exam2;
                        break;
                    }
                    if (other2 == null) continue;
                    conf = c;
                    break;
                }
                HashSet<Student> students2 = UpdateExamConflicts.getStudents(hibSession, backToBackConflict.getStudents());
                if (exam.getUniqueId().compareTo(backToBackConflict.getOtherExam().getExamId()) < 0) {
                    int[] nArray = this.iTotal[sStudents];
                    int n2 = type;
                    nArray[n2] = nArray[n2] + students2.size();
                }
                if (conf == null) {
                    this.debug("    new btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (" + students2.size() + " students)");
                    conf = new ExamConflict();
                    ((BaseExamConflict)conf).setConflictType(type);
                    ((BaseExamConflict)conf).setStudents(students2);
                    ((BaseExamConflict)conf).setNrStudents(students2.size());
                    ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                    exam.getConflicts().add((ExamConflict)conf);
                    Exam other6 = backToBackConflict.getOtherExam().getExam(hibSession);
                    other6.getConflicts().add((ExamConflict)conf);
                    otherExams.add(other6);
                    ((BaseExamConflict)conf).setExams(new HashSet<Exam>());
                    ((BaseExamConflict)conf).getExams().add(exam);
                    ((BaseExamConflict)conf).getExams().add(other6);
                    hibSession.save(conf);
                    int[] nArray = this.iCnt[sStudents][((BaseExamConflict)conf).getConflictType()];
                    int n3 = sCreate;
                    nArray[n3] = nArray[n3] + ((BaseExamConflict)conf).getNrStudents();
                    continue;
                }
                conflicts.remove(conf);
                boolean bl = change = students2.size() != ((BaseExamConflict)conf).getStudents().size() || !students2.containsAll(((BaseExamConflict)conf).getStudents());
                if (change) {
                    this.debug("    update btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (" + ((BaseExamConflict)conf).getNrStudents() + "->" + students2.size() + " students)");
                    ((BaseExamConflict)conf).setStudents(students2);
                    ((BaseExamConflict)conf).setNrStudents(students2.size());
                    ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                    hibSession.update(conf);
                    int[] nArray = this.iCnt[sStudents][((BaseExamConflict)conf).getConflictType()];
                    int n4 = sUpdate;
                    nArray[n4] = nArray[n4] + ((BaseExamConflict)conf).getNrStudents();
                    continue;
                }
                if (((BaseExamConflict)conf).getDistance() != null && !(Math.abs(((BaseExamConflict)conf).getDistance() - backToBackConflict.getDistance()) > 1.0)) continue;
                this.debug("    update btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (distance " + ((BaseExamConflict)conf).getDistance() + " -> " + backToBackConflict.getDistance() + ")");
                ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                hibSession.update(conf);
                int[] nArray = this.iCnt[sStudents][((BaseExamConflict)conf).getConflictType()];
                int n5 = sUpdate;
                nArray[n5] = nArray[n5] + ((BaseExamConflict)conf).getNrStudents();
            }
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : assignment.getInstructorBackToBackConflicts()) {
                boolean change;
                int type;
                int n = type = backToBackConflict.isDistance() ? 2 : 3;
                if (backToBackConflict.getOtherExam() == null) continue;
                conf = null;
                for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != type || c.getNrInstructors() == 0) continue;
                    Exam other = null;
                    for (Exam exam3 : c.getExams()) {
                        if (!exam3.getUniqueId().equals(backToBackConflict.getOtherExam().getExamId())) continue;
                        other = exam3;
                        break;
                    }
                    if (other == null) continue;
                    conf = c;
                    break;
                }
                HashSet<DepartmentalInstructor> instructors2 = UpdateExamConflicts.getInstructors(hibSession, backToBackConflict.getStudents());
                if (exam.getUniqueId().compareTo(backToBackConflict.getOtherExam().getExamId()) < 0) {
                    int[] nArray = this.iTotal[sInstructors];
                    int n6 = type;
                    nArray[n6] = nArray[n6] + instructors2.size();
                }
                if (conf == null) {
                    this.debug("    new btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (" + instructors2.size() + " instructors)");
                    conf = new ExamConflict();
                    ((BaseExamConflict)conf).setConflictType(type);
                    ((BaseExamConflict)conf).setInstructors(instructors2);
                    ((BaseExamConflict)conf).setNrInstructors(instructors2.size());
                    if (backToBackConflict.isDistance()) {
                        ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                    }
                    exam.getConflicts().add((ExamConflict)conf);
                    Exam other7 = backToBackConflict.getOtherExam().getExam(hibSession);
                    other7.getConflicts().add((ExamConflict)conf);
                    otherExams.add(other7);
                    ((BaseExamConflict)conf).setExams(new HashSet<Exam>());
                    ((BaseExamConflict)conf).getExams().add(exam);
                    ((BaseExamConflict)conf).getExams().add(other7);
                    hibSession.save(conf);
                    int[] nArray = this.iCnt[sInstructors][((BaseExamConflict)conf).getConflictType()];
                    int n7 = sCreate;
                    nArray[n7] = nArray[n7] + ((BaseExamConflict)conf).getNrInstructors();
                    continue;
                }
                conflicts.remove(conf);
                boolean bl = change = instructors2.size() != ((BaseExamConflict)conf).getStudents().size() || !instructors2.containsAll(((BaseExamConflict)conf).getInstructors());
                if (change) {
                    this.debug("    update btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (" + ((BaseExamConflict)conf).getNrInstructors() + "->" + instructors2.size() + " instructors)");
                    ((BaseExamConflict)conf).setInstructors(instructors2);
                    ((BaseExamConflict)conf).setNrInstructors(instructors2.size());
                    ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                    hibSession.update(conf);
                    int[] nArray = this.iCnt[sInstructors][((BaseExamConflict)conf).getConflictType()];
                    int n8 = sUpdate;
                    nArray[n8] = nArray[n8] + ((BaseExamConflict)conf).getNrInstructors();
                    continue;
                }
                if (((BaseExamConflict)conf).getDistance() != null && !(Math.abs(((BaseExamConflict)conf).getDistance() - backToBackConflict.getDistance()) > 1.0)) continue;
                this.debug("    update btb " + assignment.getExamName() + " " + backToBackConflict.getOtherExam().getExamName() + " (distance " + ((BaseExamConflict)conf).getDistance() + " -> " + backToBackConflict.getDistance() + ")");
                ((BaseExamConflict)conf).setDistance(backToBackConflict.getDistance());
                hibSession.update(conf);
                int[] nArray = this.iCnt[sInstructors][((BaseExamConflict)conf).getConflictType()];
                int n9 = sUpdate;
                nArray[n9] = nArray[n9] + ((BaseExamConflict)conf).getNrInstructors();
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : assignment.getMoreThanTwoADaysConflicts()) {
                if (moreThanTwoADayConflict.getOtherExams() == null || moreThanTwoADayConflict.getOtherExams().isEmpty()) continue;
                ExamConflict conf3 = null;
                block15: for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != 1 || c.getNrStudents() == 0 || c.getExams().size() != 1 + moreThanTwoADayConflict.getOtherExams().size()) continue;
                    for (Exam other8 : c.getExams()) {
                        if (other8.getUniqueId().equals(exam.getUniqueId())) continue;
                        boolean contain = false;
                        for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                            if (!x.getExamId().equals(other8.getUniqueId())) continue;
                            contain = true;
                            break;
                        }
                        if (contain) continue;
                        continue block15;
                    }
                    conf3 = c;
                    break;
                }
                students = UpdateExamConflicts.getStudents(hibSession, moreThanTwoADayConflict.getStudents());
                boolean smallest = true;
                for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.getUniqueId().compareTo(x.getExamId()) <= 0) continue;
                    smallest = false;
                    break;
                }
                if (smallest) {
                    int[] nArray = this.iTotal[sStudents];
                    nArray[1] = nArray[1] + ((HashSet)students).size();
                }
                String name = assignment.getExamName();
                for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                    name = name + " " + x.getExamName();
                }
                if (conf3 == null) {
                    this.debug("    new m2d " + name + " (" + ((HashSet)students).size() + " students)");
                    conf3 = new ExamConflict();
                    conf3.setConflictType(1);
                    conf3.setStudents((Set<Student>)students);
                    conf3.setNrStudents(((HashSet)students).size());
                    exam.getConflicts().add(conf3);
                    conf3.setExams(new HashSet<Exam>());
                    conf3.getExams().add(exam);
                    for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                        Exam exam4 = x.getExam(hibSession);
                        exam4.getConflicts().add(conf3);
                        otherExams.add(exam4);
                        conf3.getExams().add(exam4);
                    }
                    hibSession.save((Object)conf3);
                    int[] nArray = this.iCnt[sStudents][conf3.getConflictType()];
                    int n = sCreate;
                    nArray[n] = nArray[n] + conf3.getNrStudents();
                    continue;
                }
                conflicts.remove(conf3);
                boolean change = ((HashSet)students).size() != conf3.getStudents().size() || !((AbstractCollection)students).containsAll(conf3.getStudents());
                if (!change) continue;
                this.debug("    update m2d " + name + " (" + conf3.getNrStudents() + "->" + ((HashSet)students).size() + " students)");
                conf3.setStudents((Set<Student>)students);
                conf3.setNrStudents(((HashSet)students).size());
                hibSession.update((Object)conf3);
                int[] nArray = this.iCnt[sStudents][conf3.getConflictType()];
                int n = sUpdate;
                nArray[n] = nArray[n] + conf3.getNrStudents();
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : assignment.getInstructorMoreThanTwoADaysConflicts()) {
                if (moreThanTwoADayConflict.getOtherExams() == null || moreThanTwoADayConflict.getOtherExams().isEmpty()) continue;
                ExamConflict conf4 = null;
                block22: for (ExamConflict c : conflicts) {
                    if (c.getConflictType() != 1 || c.getNrInstructors() == 0 || c.getExams().size() != 1 + moreThanTwoADayConflict.getOtherExams().size()) continue;
                    for (Exam other9 : c.getExams()) {
                        if (other9.getUniqueId().equals(exam.getUniqueId())) continue;
                        boolean contain = false;
                        for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                            if (!x.getExamId().equals(other9.getUniqueId())) continue;
                            contain = true;
                            break;
                        }
                        if (contain) continue;
                        continue block22;
                    }
                    conf4 = c;
                    break;
                }
                instructors = UpdateExamConflicts.getInstructors(hibSession, moreThanTwoADayConflict.getStudents());
                boolean smallest = true;
                for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.getUniqueId().compareTo(x.getExamId()) <= 0) continue;
                    smallest = false;
                    break;
                }
                if (smallest) {
                    int[] nArray = this.iTotal[sInstructors];
                    nArray[1] = nArray[1] + instructors.size();
                }
                String name = assignment.getExamName();
                for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                    name = name + " " + x.getExamName();
                }
                if (conf4 == null) {
                    this.debug("    new btb " + name + " (" + instructors.size() + " instructors)");
                    conf4 = new ExamConflict();
                    conf4.setConflictType(1);
                    conf4.setInstructors(instructors);
                    conf4.setNrInstructors(instructors.size());
                    exam.getConflicts().add(conf4);
                    conf4.setExams(new HashSet<Exam>());
                    conf4.getExams().add(exam);
                    for (ExamAssignment x : moreThanTwoADayConflict.getOtherExams()) {
                        Exam exam5 = x.getExam(hibSession);
                        exam5.getConflicts().add(conf4);
                        otherExams.add(exam5);
                        conf4.getExams().add(exam5);
                    }
                    hibSession.save((Object)conf4);
                    int[] nArray = this.iCnt[sInstructors][conf4.getConflictType()];
                    int n = sCreate;
                    nArray[n] = nArray[n] + conf4.getNrInstructors();
                    continue;
                }
                conflicts.remove(conf4);
                boolean change = instructors.size() != conf4.getStudents().size() || !instructors.containsAll(conf4.getInstructors());
                if (!change) continue;
                this.debug("    update btb " + name + " (" + conf4.getNrInstructors() + "->" + instructors.size() + " instructors)");
                conf4.setInstructors(instructors);
                conf4.setNrInstructors(instructors.size());
                hibSession.update((Object)conf4);
                int[] nArray = this.iCnt[sInstructors][conf4.getConflictType()];
                int n = sUpdate;
                nArray[n] = nArray[n] + conf4.getNrInstructors();
            }
            for (ExamConflict examConflict : conflicts) {
                String name = "";
                if (examConflict.getConflictType() == 0) {
                    name = "direct";
                } else if (examConflict.getConflictType() == 1) {
                    name = "m2d";
                } else if (examConflict.getConflictType() == 3) {
                    name = "btb";
                } else if (examConflict.getConflictType() == 2) {
                    name = "btb";
                }
                if (examConflict.getNrInstructors() != null) {
                    int[] nArray = this.iCnt[sInstructors][examConflict.getConflictType()];
                    int n = sDelete;
                    nArray[n] = nArray[n] + examConflict.getNrInstructors();
                }
                if (examConflict.getNrStudents() != null) {
                    int[] nArray = this.iCnt[sStudents][examConflict.getConflictType()];
                    int n = sDelete;
                    nArray[n] = nArray[n] + examConflict.getNrStudents();
                }
                for (Exam other10 : examConflict.getExams()) {
                    name = name + " " + other10.getLabel();
                    other10.getConflicts().remove(examConflict);
                    if (other10.equals(exam)) continue;
                    otherExams.add(other10);
                }
                this.debug("  delete " + name + " (" + (examConflict.getNrStudents() != null && examConflict.getNrStudents() > 0 ? examConflict.getNrStudents() + " students" : "") + (examConflict.getNrInstructors() != null && examConflict.getNrInstructors() > 0 ? examConflict.getNrInstructors() + " instructors" : "") + ")");
                hibSession.delete((Object)examConflict);
            }
            hibSession.update((Object)exam);
            for (Exam exam6 : otherExams) {
                hibSession.update((Object)exam6);
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    protected static HashSet<Student> getStudents(org.hibernate.Session hibSession, Collection studentIds) {
        HashSet<Student> students = new HashSet<Student>();
        if (studentIds == null || studentIds.isEmpty()) {
            return students;
        }
        for (Long studentId : studentIds) {
            Student student = (Student)new StudentDAO().get(studentId, hibSession);
            if (student != null) {
                students.add(student);
                continue;
            }
            sLog.warn((Object)("Student " + studentId + " not found."));
        }
        return students;
    }

    protected static HashSet<DepartmentalInstructor> getInstructors(org.hibernate.Session hibSession, Collection instructorIds) {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        if (instructorIds == null || instructorIds.isEmpty()) {
            return instructors;
        }
        for (Long instructorId : instructorIds) {
            DepartmentalInstructor instructor = (DepartmentalInstructor)new DepartmentalInstructorDAO().get(instructorId, hibSession);
            if (instructor != null) {
                instructors.add(instructor);
                continue;
            }
            sLog.warn((Object)("Instructor " + instructorId + " not found."));
        }
        return instructors;
    }

    public void simpleCheck(ExamAssignmentInfo e1, ExamAssignmentInfo e2) {
        if (e1.getNrDirectConflicts() != e2.getNrDirectConflicts()) {
            sLog.warn((Object)("Wrong number of direct student conflicts for " + e1.getExamName() + " (" + e1.getNrDirectConflicts() + "!=" + e2.getNrDirectConflicts() + ")"));
        }
        if (e1.getNrBackToBackConflicts() != e2.getNrBackToBackConflicts()) {
            sLog.warn((Object)("Wrong number of back-to-back student conflicts for " + e1.getExamName() + " (" + e1.getNrBackToBackConflicts() + "!=" + e2.getNrBackToBackConflicts() + ")"));
        }
        if (e1.getNrMoreThanTwoConflicts() != e2.getNrMoreThanTwoConflicts()) {
            sLog.warn((Object)("Wrong number of >2 exams a day student conflicts for " + e1.getExamName() + " (" + e1.getNrMoreThanTwoConflicts() + "!=" + e2.getNrMoreThanTwoConflicts() + ")"));
        }
        if (e1.getNrInstructorDirectConflicts() != e2.getNrInstructorDirectConflicts()) {
            sLog.warn((Object)("Wrong number of direct instructor conflicts for " + e1.getExamName() + " (" + e1.getNrInstructorDirectConflicts() + "!=" + e2.getNrInstructorDirectConflicts() + ")"));
        }
        if (e1.getNrInstructorBackToBackConflicts() != e2.getNrInstructorBackToBackConflicts()) {
            sLog.warn((Object)("Wrong number of back-to-back instructor conflicts for " + e1.getExamName() + " (" + e1.getNrInstructorBackToBackConflicts() + "!=" + e2.getNrInstructorBackToBackConflicts() + ")"));
        }
        if (e1.getNrInstructorMoreThanTwoConflicts() != e2.getNrInstructorMoreThanTwoConflicts()) {
            sLog.warn((Object)("Wrong number of >2 exams a day instructor conflicts for " + e1.getExamName() + " (" + e1.getNrInstructorMoreThanTwoConflicts() + "!=" + e2.getNrInstructorMoreThanTwoConflicts() + ")"));
        }
    }

    public TreeSet<ExamAssignmentInfo> loadExams(Long sessionId, Long examTypeId) throws Exception {
        Set<Long> studentsOfCourse;
        Hashtable<Object, Object> course2students;
        Long courseId;
        Set examsOfStudent;
        Set<Long> studentsOfOwner;
        Long studentId;
        Long ownerId;
        Long examId;
        this.info("Loading exams...");
        long t0 = System.currentTimeMillis();
        Hashtable<Long, Exam> exams = new Hashtable<Long, Exam>();
        for (Exam exam : new ExamDAO().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            exams.put(exam.getUniqueId(), exam);
        }
        this.info("  Fetching related objects (class)...");
        new ExamDAO().getSession().createQuery("select c from Class_ c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("classType", 3).setCacheable(true).list();
        this.info("  Fetching related objects (config)...");
        new ExamDAO().getSession().createQuery("select c from InstrOfferingConfig c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:configType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("configType", 2).setCacheable(true).list();
        this.info("  Fetching related objects (course)...");
        new ExamDAO().getSession().createQuery("select c from CourseOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:courseType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("courseType", 1).setCacheable(true).list();
        this.info("  Fetching related objects (offering)...");
        new ExamDAO().getSession().createQuery("select c from InstructionalOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:offeringType and c.uniqueId=o.ownerId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setInteger("offeringType", 0).setCacheable(true).list();
        Hashtable<Long, Set<Long>> owner2students = new Hashtable<Long, Set<Long>>();
        Hashtable<Long, Set<Exam>> student2exams = new Hashtable<Long, Set<Exam>>();
        Hashtable<Long, Hashtable<Long, Set<Long>>> owner2course2students = new Hashtable<Long, Hashtable<Long, Set<Long>>>();
        this.info("  Loading students (class)...");
        for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            examId = (Long)o[0];
            ownerId = (Long)o[1];
            studentId = (Long)o[2];
            studentsOfOwner = (HashSet<Long>)owner2students.get(ownerId);
            if (studentsOfOwner == null) {
                studentsOfOwner = new HashSet<Long>();
                owner2students.put(ownerId, studentsOfOwner);
            }
            studentsOfOwner.add(studentId);
            examsOfStudent = (HashSet)student2exams.get(studentId);
            if (examsOfStudent == null) {
                examsOfStudent = new HashSet();
                student2exams.put(studentId, examsOfStudent);
            }
            examsOfStudent.add(exams.get(examId));
            courseId = (Long)o[3];
            course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
            if (course2students == null) {
                course2students = new Hashtable<Long, HashSet<Long>>();
                owner2course2students.put(ownerId, course2students);
            }
            if ((studentsOfCourse = (HashSet<Long>)course2students.get(courseId)) == null) {
                studentsOfCourse = new HashSet<Long>();
                course2students.put(courseId, studentsOfCourse);
            }
            studentsOfCourse.add(studentId);
        }
        this.info("  Loading students (config)...");
        for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            examId = (Long)o[0];
            ownerId = (Long)o[1];
            studentId = (Long)o[2];
            studentsOfOwner = (Set)owner2students.get(ownerId);
            if (studentsOfOwner == null) {
                studentsOfOwner = new HashSet();
                owner2students.put(ownerId, studentsOfOwner);
            }
            studentsOfOwner.add(studentId);
            examsOfStudent = (Set)student2exams.get(studentId);
            if (examsOfStudent == null) {
                examsOfStudent = new HashSet();
                student2exams.put(studentId, examsOfStudent);
            }
            examsOfStudent.add(exams.get(examId));
            courseId = (Long)o[3];
            course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
            if (course2students == null) {
                course2students = new Hashtable<Long, HashSet<Long>>();
                owner2course2students.put(ownerId, course2students);
            }
            if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                studentsOfCourse = new HashSet();
                course2students.put(courseId, studentsOfCourse);
            }
            studentsOfCourse.add(studentId);
        }
        this.info("  Loading students (course)...");
        for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            examId = (Long)o[0];
            ownerId = (Long)o[1];
            studentId = (Long)o[2];
            studentsOfOwner = (Set)owner2students.get(ownerId);
            if (studentsOfOwner == null) {
                studentsOfOwner = new HashSet();
                owner2students.put(ownerId, studentsOfOwner);
            }
            studentsOfOwner.add(studentId);
            examsOfStudent = (Set)student2exams.get(studentId);
            if (examsOfStudent == null) {
                examsOfStudent = new HashSet();
                student2exams.put(studentId, examsOfStudent);
            }
            examsOfStudent.add(exams.get(examId));
            courseId = (Long)o[3];
            course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
            if (course2students == null) {
                course2students = new Hashtable<Long, HashSet<Long>>();
                owner2course2students.put(ownerId, course2students);
            }
            if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                studentsOfCourse = new HashSet();
                course2students.put(courseId, studentsOfCourse);
            }
            studentsOfCourse.add(studentId);
        }
        this.info("  Loading students (offering)...");
        for (Object[] o : new ExamDAO().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list()) {
            examId = (Long)o[0];
            ownerId = (Long)o[1];
            studentId = (Long)o[2];
            studentsOfOwner = (Set)owner2students.get(ownerId);
            if (studentsOfOwner == null) {
                studentsOfOwner = new HashSet();
                owner2students.put(ownerId, studentsOfOwner);
            }
            studentsOfOwner.add(studentId);
            examsOfStudent = (Set)student2exams.get(studentId);
            if (examsOfStudent == null) {
                examsOfStudent = new HashSet();
                student2exams.put(studentId, examsOfStudent);
            }
            examsOfStudent.add(exams.get(examId));
            courseId = (Long)o[3];
            course2students = owner2course2students.get(ownerId);
            if (course2students == null) {
                course2students = new Hashtable();
                owner2course2students.put(ownerId, course2students);
            }
            if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                studentsOfCourse = new HashSet();
                course2students.put(courseId, studentsOfCourse);
            }
            studentsOfCourse.add(studentId);
        }
        Hashtable<Long, Set<Meeting>> period2meetings = new Hashtable<Long, Set<Meeting>>();
        ExamAssignmentInfo.Parameters p = new ExamAssignmentInfo.Parameters(sessionId, examTypeId);
        this.info("  Creating exam assignments...");
        TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
        Enumeration e = exams.elements();
        while (e.hasMoreElements()) {
            Exam exam = (Exam)e.nextElement();
            ExamAssignmentInfo info = new ExamAssignmentInfo(exam, owner2students, owner2course2students, student2exams, period2meetings, p);
            ret.add(info);
        }
        long t1 = System.currentTimeMillis();
        this.info("Exams loaded in " + sDF.format((double)(t1 - t0) / 1000.0) + "s.");
        return ret;
    }

    public void update(Long sessionId, Long examTypeId, org.hibernate.Session hibSession) throws Exception {
        this.iCnt = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        this.iTotal = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}};
        TreeSet<ExamAssignmentInfo> exams = this.loadExams(sessionId, examTypeId);
        for (ExamAssignmentInfo exam : exams) {
            this.debug("Checking " + exam.getExamName() + " ...");
            this.updateConflicts(exam, hibSession);
        }
        if (this.iTotal[sStudents][0] > 0) {
            this.info("Direct student conflicts: " + this.iTotal[sStudents][0]);
            this.info("    created: " + this.iCnt[sStudents][0][sCreate]);
            this.info("    updated: " + this.iCnt[sStudents][0][sUpdate]);
            this.info("    deleted: " + this.iCnt[sStudents][0][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sStudents][0] - this.iCnt[sStudents][0][sCreate] - this.iCnt[sStudents][0][sUpdate] - this.iCnt[sStudents][0][sDelete]));
        }
        if (this.iTotal[sStudents][1] > 0) {
            this.info(">2 exams a day student conflicts: " + this.iTotal[sStudents][1]);
            this.info("    created: " + this.iCnt[sStudents][1][sCreate]);
            this.info("    updated: " + this.iCnt[sStudents][1][sUpdate]);
            this.info("    deleted: " + this.iCnt[sStudents][1][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sStudents][1] - this.iCnt[sStudents][1][sCreate] - this.iCnt[sStudents][1][sUpdate] - this.iCnt[sStudents][1][sDelete]));
        }
        if (this.iTotal[sStudents][3] > 0) {
            this.info("Back-to-back student conflicts: " + this.iTotal[sStudents][3]);
            this.info("    created: " + this.iCnt[sStudents][3][sCreate]);
            this.info("    updated: " + this.iCnt[sStudents][3][sUpdate]);
            this.info("    deleted: " + this.iCnt[sStudents][3][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sStudents][3] - this.iCnt[sStudents][3][sCreate] - this.iCnt[sStudents][3][sUpdate] - this.iCnt[sStudents][3][sDelete]));
        }
        if (this.iTotal[sStudents][2] > 0) {
            this.info("Distance back-to-back student conflicts: " + this.iTotal[sStudents][2]);
            this.info("    created: " + this.iCnt[sStudents][2][sCreate]);
            this.info("    updated: " + this.iCnt[sStudents][2][sUpdate]);
            this.info("    deleted: " + this.iCnt[sStudents][2][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sStudents][2] - this.iCnt[sStudents][2][sCreate] - this.iCnt[sStudents][2][sUpdate] - this.iCnt[sStudents][2][sDelete]));
        }
        if (this.iTotal[sInstructors][0] > 0) {
            this.info("Direct instructor conflicts: " + this.iTotal[sInstructors][0]);
            this.info("    created: " + this.iCnt[sInstructors][0][sCreate]);
            this.info("    updated: " + this.iCnt[sInstructors][0][sUpdate]);
            this.info("    deleted: " + this.iCnt[sInstructors][0][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sInstructors][0] - this.iCnt[sInstructors][0][sCreate] - this.iCnt[sInstructors][0][sUpdate] - this.iCnt[sInstructors][0][sDelete]));
        }
        if (this.iTotal[sInstructors][1] > 0) {
            this.info(">2 exams a day instructor conflicts: " + this.iTotal[sInstructors][1]);
            this.info("    created: " + this.iCnt[sInstructors][1][sCreate]);
            this.info("    updated: " + this.iCnt[sInstructors][1][sUpdate]);
            this.info("    deleted: " + this.iCnt[sInstructors][1][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sInstructors][1] - this.iCnt[sInstructors][1][sCreate] - this.iCnt[sInstructors][1][sUpdate] - this.iCnt[sInstructors][1][sDelete]));
        }
        if (this.iTotal[sInstructors][3] > 0) {
            this.info("Back-to-back instructor conflicts: " + this.iTotal[sInstructors][3]);
            this.info("    created: " + this.iCnt[sInstructors][3][sCreate]);
            this.info("    updated: " + this.iCnt[sInstructors][3][sUpdate]);
            this.info("    deleted: " + this.iCnt[sInstructors][3][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sInstructors][3] - this.iCnt[sInstructors][3][sCreate] - this.iCnt[sInstructors][3][sUpdate] - this.iCnt[sInstructors][3][sDelete]));
        }
        if (this.iTotal[sInstructors][2] > 0) {
            this.info("Distance back-to-back instructor conflicts: " + this.iTotal[sInstructors][2]);
            this.info("    created: " + this.iCnt[sInstructors][2][sCreate]);
            this.info("    updated: " + this.iCnt[sInstructors][2][sUpdate]);
            this.info("    deleted: " + this.iCnt[sInstructors][2][sDelete]);
            this.info("  unchanged: " + (this.iTotal[sInstructors][2] - this.iCnt[sInstructors][2][sCreate] - this.iCnt[sInstructors][2][sUpdate] - this.iCnt[sInstructors][2][sDelete]));
        }
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2008"), ApplicationProperties.getProperty("term", "Fal"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + session));
            }
            ExamType examType = ExamType.findByReference(ApplicationProperties.getProperty("type", "final"));
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                new UpdateExamConflicts().update(session.getUniqueId(), examType.getUniqueId(), hibSession);
                tx.commit();
            }
            catch (Exception e) {
                sLog.error((Object)e);
                if (tx != null) {
                    tx.rollback();
                }
            }
        }
        catch (Exception e) {
            sLog.error((Object)e);
        }
    }
}

