/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.util.RoomAvailability;

public class RemoteRoomAvailability {
    private static Log sLog = LogFactory.getLog(RemoteRoomAvailability.class);
    private RpcDispatcher iDispatcher;

    public RemoteRoomAvailability(JChannel channel, short scope) {
        this.iDispatcher = new MuxRpcDispatcher(scope, (Channel)channel, null, null, (Object)this);
    }

    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String method, Class[] types, Object[] args) throws Exception {
        try {
            RoomAvailabilityInterface availability = RoomAvailability.getInstance();
            if (availability == null) {
                throw new Exception("There is no room availability.");
            }
            Object object = availability.getClass().getMethod(method, types).invoke((Object)availability, args);
            return object;
        }
        finally {
            _RootDAO.closeCurrentThreadSessions();
        }
    }

    public Object dispatch(Address address, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), method.getParameterTypes(), args}, new Class[]{String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (Exception e) {
            sLog.error((Object)("Excution of room availability method " + method + " failed: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

