/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.weights;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.course.weights.ClassWeightProvider;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;

public class AverageHoursAWeekClassWeights
implements ClassWeightProvider {
    private BitSet[] iDaysOfWeek = null;
    private double iCoeficient = 1.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageHoursAWeekClassWeights(DataProperties config) {
        try (org.hibernate.Session hibSession = SessionDAO.getInstance().createNewSession();){
            Session session = (Session)SessionDAO.getInstance().get(config.getPropertyLong("General.SessionId", -1L));
            this.iDaysOfWeek = new BitSet[Constants.DAY_CODES.length];
            for (int i = 0; i < this.iDaysOfWeek.length; ++i) {
                this.iDaysOfWeek[i] = new BitSet();
            }
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setLenient(true);
            cal.setTime(DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear()));
            Date last = DateUtils.getDate(1, session.getPatternEndMonth(), session.getSessionStartYear());
            int idx = 0;
            while (cal.getTime().before(last)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        this.iDaysOfWeek[0].set(idx);
                        break;
                    }
                    case 3: {
                        this.iDaysOfWeek[1].set(idx);
                        break;
                    }
                    case 4: {
                        this.iDaysOfWeek[2].set(idx);
                        break;
                    }
                    case 5: {
                        this.iDaysOfWeek[3].set(idx);
                        break;
                    }
                    case 6: {
                        this.iDaysOfWeek[4].set(idx);
                        break;
                    }
                    case 7: {
                        this.iDaysOfWeek[5].set(idx);
                        break;
                    }
                    case 1: {
                        this.iDaysOfWeek[6].set(idx);
                    }
                }
                cal.add(6, 1);
                ++idx;
            }
            if (session.getDefaultDatePattern() != null) {
                BitSet ddp = session.getDefaultDatePattern().getPatternBitSet();
                this.iCoeficient = 5.0 / (double)(this.intersection(ddp, this.iDaysOfWeek[0]) + this.intersection(ddp, this.iDaysOfWeek[1]) + this.intersection(ddp, this.iDaysOfWeek[2]) + this.intersection(ddp, this.iDaysOfWeek[3]) + this.intersection(ddp, this.iDaysOfWeek[4]));
            }
        }
    }

    public int intersection(BitSet a, BitSet b) {
        BitSet c = (BitSet)a.clone();
        c.and(b);
        return c.cardinality();
    }

    @Override
    public double getWeight(Lecture lecture) {
        double nrMeetingSlots = 0.0;
        int nrTimes = 0;
        for (TimeLocation time : lecture.timeLocations()) {
            for (int d = 0; d < Constants.DAY_CODES.length; ++d) {
                if ((time.getDayCode() & Constants.DAY_CODES[d]) == 0) continue;
                nrMeetingSlots += (double)(this.intersection(time.getWeekCode(), this.iDaysOfWeek[d]) * time.getNrSlotsPerMeeting());
            }
            ++nrTimes;
        }
        if (nrTimes == 0) {
            return 1.0;
        }
        return (double)Math.round(100.0 * this.iCoeficient * nrMeetingSlots / (12.0 * (double)nrTimes)) / 100.0;
    }
}

