/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.menu;

import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.AnonymousUserContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=MenuInterface.UserInfoRpcRequest.class)
public class UserInfoBackend
implements GwtRpcImplementation<MenuInterface.UserInfoRpcRequest, MenuInterface.UserInfoInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MenuInterface.UserInfoInterface execute(MenuInterface.UserInfoRpcRequest request, SessionContext context) {
        MenuInterface.UserInfoInterface ret = new MenuInterface.UserInfoInterface();
        try (Session hibSession = SessionDAO.getInstance().getSession();){
            String role;
            UserContext user = this.sessionContext.getUser();
            if (user == null || user instanceof AnonymousUserContext) {
                MenuInterface.UserInfoInterface userInfoInterface = null;
                return userInfoInterface;
            }
            ret.addPair(MESSAGES.fieldName(), user.getName());
            ret.setName(user.getName());
            String dept = "";
            if (user.getCurrentAuthority() != null) {
                for (Qualifiable qualifiable : user.getCurrentAuthority().getQualifiers("Department")) {
                    if (!dept.isEmpty()) {
                        dept = dept + ",";
                    }
                    dept = dept + "<span title='" + qualifiable.getQualifierLabel() + "'>" + qualifiable.getQualifierReference() + "</span>";
                }
            }
            ret.addPair(MESSAGES.fieldDepartment(), dept);
            String string = role = user.getCurrentAuthority() == null ? null : user.getCurrentAuthority().getLabel();
            if (role == null) {
                role = MESSAGES.noRole();
            }
            ret.addPair(MESSAGES.fieldRole(), role);
            ret.setRole(role);
            ret.setChameleon(this.sessionContext.hasPermission(Right.Chameleon) || user instanceof UserContext.Chameleon);
        }
        return ret;
    }
}

