/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=InstructorInterface.GetInstructorAttributeParentsRequest.class)
public class GetInstructorAttributeParentsBackend
implements GwtRpcImplementation<InstructorInterface.GetInstructorAttributeParentsRequest, GwtRpcResponseList<InstructorInterface.AttributeInterface>> {
    @Override
    public GwtRpcResponseList<InstructorInterface.AttributeInterface> execute(InstructorInterface.GetInstructorAttributeParentsRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorAttributes);
        InstructorAttribute current = request.getAttributeId() == null ? null : (InstructorAttribute)InstructorAttributeDAO.getInstance().get(request.getAttributeId());
        GwtRpcResponseList<InstructorInterface.AttributeInterface> response = new GwtRpcResponseList<InstructorInterface.AttributeInterface>();
        for (InstructorAttribute attribute : InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute a where a.session.uniqueId = :sessionId and (a.department is null or a.department.uniqueId = :departmentId) and a.type.uniqueId = :typeId").setLong("sessionId", context.getUser().getCurrentAcademicSessionId().longValue()).setLong("departmentId", request.getDepartmentId() == null ? -1L : request.getDepartmentId()).setLong("typeId", request.getTypeId().longValue()).setCacheable(true).list()) {
            if (current != null && (current.equals(attribute) || current.isParentOf(attribute))) continue;
            InstructorInterface.AttributeInterface a = new InstructorInterface.AttributeInterface();
            a.setId(attribute.getUniqueId());
            a.setName(attribute.getName());
            response.add(a);
        }
        return response;
    }
}

