/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.departments;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.DepartmentInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:departments.pdf")
public class ExportDepartmentsPDF
implements Exporter {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public String reference() {
        return "departments.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        SessionContext context = helper.getSessionContext();
        boolean dispLastChanges = CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(context.getUser()));
        helper.getSessionContext().checkPermission(Right.Departments);
        PDFPrinter out = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(out.getContentType(), this.reference(), false);
        DecimalFormat df5 = new DecimalFormat("####0.######");
        out.printHeader(MESSAGES.propDepartmentlist(context.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel()));
        ArrayList<Department> departments = new ArrayList<Department>(Department.findAll(helper.getAcademicSessionId()));
        String sort = helper.getParameter("sort");
        String showAllDept = helper.getParameter("showAllDept");
        if (sort != null && !"0".equals(sort)) {
            int sortBy = Integer.valueOf(sort);
            DepartmentComparator cmp = null;
            if (sortBy != 0) {
                cmp = sortBy > 0 ? new DepartmentComparator(DepartmentInterface.DepartmentsColumn.values()[sortBy - 1], true) : new DepartmentComparator(DepartmentInterface.DepartmentsColumn.values()[-1 - sortBy], false);
            }
            if (cmp != null) {
                Collections.sort(departments, cmp);
            }
        }
        Boolean printHeaderText = false;
        for (Department d : departments) {
            if (!printHeaderText.booleanValue()) {
                ArrayList<String> headerText = new ArrayList<String>();
                headerText.add(MESSAGES.colCode());
                headerText.add(MESSAGES.colAbbv());
                headerText.add(MESSAGES.colName());
                headerText.add(MESSAGES.colExternalManager().replace("<br>", "\n"));
                headerText.add(MESSAGES.colSubjects());
                headerText.add(MESSAGES.colRooms());
                headerText.add(MESSAGES.colStatus());
                headerText.add(MESSAGES.colDistPrefPriority().replace("<br>", "\n"));
                headerText.add(MESSAGES.colAllowRequired().replace("<br>", "\n"));
                headerText.add(MESSAGES.colInstructorPref().replace("<br>", "\n"));
                headerText.add(MESSAGES.colEvents());
                headerText.add(MESSAGES.colStudentScheduling().replace("<br>", "\n"));
                if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
                    headerText.add(MESSAGES.colExternalFundingDept().replace("<br>", "\n"));
                }
                if (dispLastChanges) {
                    headerText.add(MESSAGES.colLastChange().replace("<br>", "\n"));
                }
                String[] headerTextStr = new String[headerText.size()];
                for (int i = 0; i < headerText.size(); ++i) {
                    headerTextStr[i] = (String)headerText.get(i);
                }
                out.printHeader(headerTextStr);
                printHeaderText = true;
            }
            if (!showAllDept.trim().equalsIgnoreCase("true") && d.getSubjectAreas().isEmpty() && d.getTimetableManagers().isEmpty() && !d.isExternalManager().booleanValue()) continue;
            String lastChangeStr = null;
            if (dispLastChanges) {
                List<ChangeLog> changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                lastChangeStr = lastChange == null ? "" : MESSAGES.lastChange(ChangeLog.sDFdate.format(lastChange.getTimeStamp()), lastChange.getManager().getShortName());
            }
            String allowReq = "";
            int allowReqOrd = 0;
            if (d.isAllowReqRoom() != null && d.isAllowReqRoom().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MESSAGES.colRoom();
                ++allowReqOrd;
            }
            if (d.isAllowReqTime() != null && d.isAllowReqTime().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MESSAGES.colTime();
                allowReqOrd += 2;
            }
            if (d.isAllowReqDistribution() != null && d.isAllowReqDistribution().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + MESSAGES.colDistribution();
                allowReqOrd += 4;
            }
            if (allowReqOrd == 7) {
                allowReq = MESSAGES.colAll();
            }
            String dependentStatuses = null;
            if (d.isExternalManager().booleanValue() && d.getExternalStatusTypes() != null && !d.getExternalStatusTypes().isEmpty()) {
                TreeSet<ExternalDepartmentStatusType> set = new TreeSet<ExternalDepartmentStatusType>(new Comparator<ExternalDepartmentStatusType>(){

                    @Override
                    public int compare(ExternalDepartmentStatusType e1, ExternalDepartmentStatusType e2) {
                        return e1.getDepartment().compareTo(e2.getDepartment());
                    }
                });
                set.addAll(d.getExternalStatusTypes());
                for (ExternalDepartmentStatusType t : set) {
                    if (dependentStatuses == null) {
                        dependentStatuses = "    " + t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                        continue;
                    }
                    dependentStatuses = dependentStatuses + "\n    " + t.getDepartment().getDeptCode() + ": " + t.getStatusType().getLabel();
                }
            }
            ArrayList<String> bodyText = new ArrayList<String>();
            bodyText.add(d.getDeptCode());
            bodyText.add(d.getAbbreviation());
            bodyText.add(d.getName());
            bodyText.add(d.isExternalManager() != false ? d.getExternalMgrAbbv() : "");
            bodyText.add(df5.format(d.getSubjectAreas().size()));
            bodyText.add(df5.format(d.getRoomDepts().size()));
            bodyText.add(d.effectiveStatusType().getLabel() + (dependentStatuses == null ? "" : "\n" + dependentStatuses));
            bodyText.add(d.getDistributionPrefPriority() == null && d.getDistributionPrefPriority() != 0 ? "" : d.getDistributionPrefPriority().toString());
            bodyText.add(allowReq);
            bodyText.add(d.isInheritInstructorPreferences() != false ? MESSAGES.exportTrue() : MESSAGES.exportFalse());
            bodyText.add(d.isAllowEvents() != false ? MESSAGES.exportTrue() : MESSAGES.exportFalse());
            bodyText.add(d.isAllowStudentScheduling() != false ? MESSAGES.exportTrue() : MESSAGES.exportFalse());
            if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
                bodyText.add(d.isExternalFundingDept() != null ? (d.isExternalFundingDept().booleanValue() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()) : MESSAGES.exportFalse());
            }
            if (dispLastChanges) {
                bodyText.add(lastChangeStr);
            }
            String[] bodyTextStr = new String[bodyText.size()];
            for (int i = 0; i < bodyText.size(); ++i) {
                bodyTextStr[i] = (String)bodyText.get(i);
            }
            out.printLine(bodyTextStr);
        }
        out.close();
    }

    class DepartmentComparator
    implements Comparator<Department> {
        private DepartmentInterface.DepartmentsColumn iColumn;
        private boolean iAsc;

        public DepartmentComparator(DepartmentInterface.DepartmentsColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareByExternalId(Department r1, Department r2) {
            return this.compare(r1.getExternalUniqueId(), r2.getExternalUniqueId());
        }

        public int compareById(Department r1, Department r2) {
            return this.compare(r1.getUniqueId(), r2.getUniqueId());
        }

        public int compareByDeptCode(Department r1, Department r2) {
            return this.compare(r1.getDeptCode(), r2.getDeptCode());
        }

        public int compareByName(Department r1, Department r2) {
            return this.compare(r1.getName(), r2.getName());
        }

        public int compareByAbbreviation(Department r1, Department r2) {
            return this.compare(r1.getAbbreviation(), r2.getAbbreviation());
        }

        public int compareByExtMgr(Department r1, Department r2) {
            return this.compare(r1.getExternalMgrAbbv(), r2.getExternalMgrAbbv());
        }

        public int compareByStatus(Department r1, Department r2) {
            return this.compare(r1.getStatusType().getLabel(), r2.getStatusType().getLabel());
        }

        public int compareByDistPrefPriority(Department r1, Department r2) {
            return this.compare(r1.getDistributionPrefPriority(), r2.getDistributionPrefPriority());
        }

        public int compareByAllowReqd(Department r1, Department r2) {
            return this.compare(r1.getAllowReqTime(), r2.getAllowReqTime());
        }

        public int compareByInstrucPref(Department r1, Department r2) {
            return this.compare(r1.isInheritInstructorPreferences(), r2.isInheritInstructorPreferences());
        }

        public int compareByEvent(Department r1, Department r2) {
            return this.compare(r1.isAllowEvents(), r2.isAllowEvents());
        }

        public int compareByStdntSched(Department r1, Department r2) {
            return this.compare(r1.isAllowStudentScheduling(), r2.isAllowStudentScheduling());
        }

        public int compareByExtFundingDept(Department r1, Department r2) {
            return this.compare(r1.isExternalFundingDept(), r2.isExternalFundingDept());
        }

        public int compareBySubjectCount(Department r1, Department r2) {
            return this.compare(r1.getSubjectAreas().size(), r2.getSubjectAreas().size());
        }

        public int compareByRoomCount(Department r1, Department r2) {
            return this.compare(r1.getRoomDepts().size(), r2.getRoomDepts().size());
        }

        protected int compareByColumn(Department r1, Department r2) {
            switch (this.iColumn) {
                case CODE: {
                    return this.compareByDeptCode(r1, r2);
                }
                case ABBV: {
                    return this.compareByAbbreviation(r1, r2);
                }
                case NAME: {
                    return this.compareByName(r1, r2);
                }
                case EXTERNAL_MANAGER: {
                    return this.compareByExtMgr(r1, r2);
                }
                case SUBJECTS: {
                    return this.compareBySubjectCount(r1, r2);
                }
                case ROOMS: {
                    return this.compareByRoomCount(r1, r2);
                }
                case STATUS: {
                    return this.compareByStatus(r1, r2);
                }
                case DIST_PREF_PRIORITY: {
                    return this.compareByDistPrefPriority(r1, r2);
                }
                case ALLOW_REQUIRED: {
                    return this.compareByAllowReqd(r1, r2);
                }
                case INSTRUCTOR_PREF: {
                    return this.compareByInstrucPref(r1, r2);
                }
                case EVENTS: {
                    return this.compareByEvent(r1, r2);
                }
                case STUDENT_SCHEDULING: {
                    return this.compareByStdntSched(r1, r2);
                }
                case EXT_FUNDING_DEPT: {
                    return this.compareByExtFundingDept(r1, r2);
                }
            }
            return this.compareByAbbreviation(r1, r2);
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return -Boolean.compare(b1 != null && b1 != false, b2 != null && b2 != false);
        }

        @Override
        public int compare(Department r1, Department r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByAbbreviation(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }
    }
}

