/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.classinstructors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AssignClassInstructorsInterface;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.OfferingCoordinatorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.classinstructors.AssignClassInstructorsTable;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;

@Service(value="gwtAssignClassInstrs")
public class AssignClassInstructors
implements AssignClassInstructorsTable {
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeeded;
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private String defaultTeachingResponsibilityId;

    public String getDefaultTeachingResponsibilityId() {
        if (this.defaultTeachingResponsibilityId == null) {
            return "";
        }
        return this.defaultTeachingResponsibilityId;
    }

    public void setDefaultTeachingResponsibilityId(String defaultTeachingResponsibilityId) {
        this.defaultTeachingResponsibilityId = defaultTeachingResponsibilityId;
    }

    @Override
    public AssignClassInstructorsInterface.PageName name() {
        return new AssignClassInstructorsInterface.PageName(MESSAGES.pageAssignInstructors(), MESSAGES.pageAssignInstructors());
    }

    private AssignClassInstructorsInterface.Field getFieldForColumn(AssignClassInstructorsInterface.DataColumn dataColumn, InstrOfferingConfig ioc, SessionContext context) {
        switch (dataColumn) {
            case CLASS_UID: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldClassUid(), AssignClassInstructorsInterface.FieldType.number, 40, AssignClassInstructorsInterface.Flag.HIDDEN);
            }
            case CLASS_PARENT_UID: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldClassParentUid(), AssignClassInstructorsInterface.FieldType.number, 40, AssignClassInstructorsInterface.Flag.HIDDEN);
            }
            case IS_FIRST_RECORD_FOR_CLASS: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldFirstRecordForClassUid(), AssignClassInstructorsInterface.FieldType.toggle, 40, AssignClassInstructorsInterface.Flag.HIDDEN);
            }
            case HAS_ERROR: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldError(), AssignClassInstructorsInterface.FieldType.hasError, 40, AssignClassInstructorsInterface.Flag.HIDE_LABEL);
            }
            case CLASS_NAME: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldClassName(), AssignClassInstructorsInterface.FieldType.textarea, 120, AssignClassInstructorsInterface.Flag.READ_ONLY, AssignClassInstructorsInterface.Flag.HIDE_LABEL);
            }
            case CLASS_EXTERNAL_UID: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldExternalId(), AssignClassInstructorsInterface.FieldType.textarea, 120, AssignClassInstructorsInterface.Flag.READ_ONLY);
            }
            case ADD: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldAdd(), AssignClassInstructorsInterface.FieldType.add, 40, AssignClassInstructorsInterface.Flag.HIDE_LABEL);
            }
            case DELETE: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldDelete(), AssignClassInstructorsInterface.FieldType.delete, 40, AssignClassInstructorsInterface.Flag.HIDE_LABEL);
            }
            case INSTR_NAME: {
                String nf = UserProperty.NameFormat.get(context.getUser());
                ArrayList<DepartmentalInstructor> instructorList = new ArrayList<DepartmentalInstructor>(ioc.getDepartment().getInstructors());
                if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                    Collections.sort(instructorList, new DepartmentalInstructorComparator(nf));
                } else {
                    Collections.sort(instructorList, new DepartmentalInstructorComparator());
                }
                ArrayList<AssignClassInstructorsInterface.ListItem> instructors = new ArrayList<AssignClassInstructorsInterface.ListItem>();
                instructors.add(new AssignClassInstructorsInterface.ListItem("-1", MESSAGES.itemSelect()));
                for (DepartmentalInstructor di : instructorList) {
                    instructors.add(new AssignClassInstructorsInterface.ListItem(di.getUniqueId().toString(), di.getName(nf)));
                }
                return new AssignClassInstructorsInterface.Field(MESSAGES.colNamePerson(), AssignClassInstructorsInterface.FieldType.list, 300, instructors, new AssignClassInstructorsInterface.Flag[0]);
            }
            case PCT_SHARE: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldPercentShare(), AssignClassInstructorsInterface.FieldType.number, 60, 40, new AssignClassInstructorsInterface.Flag[0]);
            }
            case CHECK_CONFICTS: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldCheckConflicts(), AssignClassInstructorsInterface.FieldType.toggle, 120, 40, new AssignClassInstructorsInterface.Flag[0]);
            }
            case RESPONSIBILITY: {
                ArrayList<AssignClassInstructorsInterface.ListItem> responsibilities = new ArrayList<AssignClassInstructorsInterface.ListItem>();
                for (TeachingResponsibility tr : TeachingResponsibility.getInstructorTeachingResponsibilities()) {
                    responsibilities.add(new AssignClassInstructorsInterface.ListItem(tr.getUniqueId().toString(), tr.getLabel()));
                    if (!tr.hasOption(TeachingResponsibility.Option.isdefault)) continue;
                    this.setDefaultTeachingResponsibilityId(tr.getUniqueId().toString());
                }
                AssignClassInstructorsInterface.Flag respFlag = null;
                if (responsibilities.isEmpty()) {
                    respFlag = AssignClassInstructorsInterface.Flag.HIDDEN;
                } else if (this.getDefaultTeachingResponsibilityId().equals("")) {
                    responsibilities.add(0, new AssignClassInstructorsInterface.ListItem("", ""));
                }
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldResponsibility(), AssignClassInstructorsInterface.FieldType.list, 100, responsibilities, respFlag);
            }
            case DISPLAY: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldDisplay("&otimes;"), AssignClassInstructorsInterface.FieldType.toggle, 120, new AssignClassInstructorsInterface.Flag[0]);
            }
            case FUNDING_DEPT: {
                ArrayList<AssignClassInstructorsInterface.ListItem> fundingDepts = new ArrayList<AssignClassInstructorsInterface.ListItem>();
                boolean fundingDeptsUsed = false;
                for (Department d : ioc.findPossibleFundingDepts(DepartmentDAO.getInstance().getSession())) {
                    if (d.isExternalFundingDept() != null && d.isExternalFundingDept().booleanValue()) {
                        fundingDeptsUsed = true;
                    }
                    fundingDepts.add(new AssignClassInstructorsInterface.ListItem(d.getUniqueId().toString(), d.getLabel()));
                }
                AssignClassInstructorsInterface.Flag fdFlag = null;
                if (!fundingDeptsUsed) {
                    fdFlag = AssignClassInstructorsInterface.Flag.HIDDEN;
                }
                return new AssignClassInstructorsInterface.Field(MESSAGES.fieldFundingDepartment(), AssignClassInstructorsInterface.FieldType.list, 100, fundingDepts, fdFlag);
            }
            case TIME: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.colTime(), AssignClassInstructorsInterface.FieldType.textarea, 120, AssignClassInstructorsInterface.Flag.READ_ONLY);
            }
            case ROOM: {
                return new AssignClassInstructorsInterface.Field(MESSAGES.colRoom(), AssignClassInstructorsInterface.FieldType.textarea, 120, AssignClassInstructorsInterface.Flag.READ_ONLY);
            }
        }
        return new AssignClassInstructorsInterface.Field(dataColumn.name(), AssignClassInstructorsInterface.FieldType.textarea, 120, new AssignClassInstructorsInterface.Flag[0]);
    }

    @Override
    public AssignClassInstructorsInterface load(String cfgIdStr, SessionContext context, Session hibSession) throws Exception {
        InstrOfferingConfig prev;
        Long cfgId = null;
        if (cfgIdStr == null || cfgIdStr.trim().equals("")) {
            throw new Exception(MESSAGES.errorConfigurationIdNotFound());
        }
        cfgId = Long.parseLong(cfgIdStr);
        InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(cfgId, hibSession);
        AssignClassInstructorsInterface.Field[] fields = new AssignClassInstructorsInterface.Field[AssignClassInstructorsInterface.DataColumn.values().length];
        for (AssignClassInstructorsInterface.DataColumn dc : AssignClassInstructorsInterface.DataColumn.values()) {
            fields[dc.ordinal()] = this.getFieldForColumn(dc, ioc, context);
        }
        AssignClassInstructorsInterface data = new AssignClassInstructorsInterface(fields);
        data.setConfigId(ioc.getUniqueId());
        data.setOfferingId(ioc.getInstructionalOffering().getUniqueId());
        data.setCourseName(ioc.getInstructionalOffering().getCourseNameWithTitle());
        String coordinators = "";
        String instructorNameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        ArrayList<OfferingCoordinator> coordinatorList = new ArrayList<OfferingCoordinator>(ioc.getInstructionalOffering().getOfferingCoordinators());
        Collections.sort(coordinatorList, new OfferingCoordinatorComparator(context));
        for (OfferingCoordinator coordinator : coordinatorList) {
            if (!coordinators.isEmpty()) {
                coordinators = coordinators + "\n";
            }
            coordinators = coordinators + coordinator.getInstructor().getName(instructorNameFormat) + (coordinator.getResponsibility() == null ? (coordinator.getPercentShare() != 0 ? " (" + coordinator.getPercentShare() + "%)" : "") : " (" + coordinator.getResponsibility().getLabel() + (coordinator.getPercentShare() > 0 ? ", " + coordinator.getPercentShare() + "%" : "") + ")");
        }
        data.setCourseCoordinators(coordinators);
        InstrOfferingConfig next = ioc.getNextInstrOfferingConfig(context);
        if (next != null) {
            data.setNextConfigId(next.getUniqueId());
        }
        if ((prev = ioc.getPreviousInstrOfferingConfig(context)) != null) {
            data.setPreviousConfigId(prev.getUniqueId());
        }
        try {
            this.addRecordsForConfig(ioc, data, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data.setEditable(true);
        return data;
    }

    private void addRecordsForConfig(InstrOfferingConfig ioc, AssignClassInstructorsInterface data, SessionContext context) throws Exception {
        Debug.info("In addRecordsForConfig");
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        for (SchedulingSubpart ss : subpartList) {
            if (ss.getClasses() == null || ss.getClasses().size() == 0) {
                throw new Exception(MESSAGES.exceptionInitialIOSetupIncomplete());
            }
            if (ss.getParentSubpart() != null) continue;
            this.loadClasses(data, ss.getClasses(), new String(), context);
        }
    }

    private void loadClasses(AssignClassInstructorsInterface data, Set<Class_> classes, String indent, SessionContext context) {
        if (classes != null && classes.size() > 0) {
            ArrayList<Class_> classesList = new ArrayList<Class_>(classes);
            if (CommonValues.Yes.eq(UserProperty.ClassesKeepSort.get(context.getUser()))) {
                Collections.sort(classesList, new ClassCourseComparator(context.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), this.classAssignmentService.getAssignment(), false));
            } else {
                Collections.sort(classesList, new ClassComparator(3));
            }
            for (Class_ cls : classesList) {
                this.addClassRecords(data, cls, !context.hasPermission(cls, Right.AssignInstructorsClass), indent, context);
                this.loadClasses(data, cls.getChildClasses(), indent + "&nbsp;&nbsp;&nbsp;&nbsp;", context);
            }
        }
    }

    public void addClassRecords(AssignClassInstructorsInterface data, Class_ cls, Boolean isReadOnly, String indent, SessionContext cx) {
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(cls.getClassInstructors());
        Collections.sort(instructors, new InstructorComparator(cx));
        ClassInstructor instructor = null;
        boolean isEditable = isReadOnly == false;
        int i = 0;
        do {
            int recId = data.getRecords().size();
            AssignClassInstructorsInterface.Record rec = data.addRecord(Long.valueOf(recId));
            rec.setDeletable(isEditable);
            rec.setField(AssignClassInstructorsInterface.DataColumn.CLASS_UID.ordinal(), cls.getUniqueId().toString(), false);
            if (ApplicationProperty.InstructorsCopyToSubSubparts.isTrue()) {
                Class_ parent = cls;
                while (parent.getParentClass() != null && parent.getSchedulingSubpart().getItype().equals(parent.getParentClass().getSchedulingSubpart().getItype())) {
                    parent = parent.getParentClass();
                }
                if (!cls.equals(parent)) {
                    rec.setField(AssignClassInstructorsInterface.DataColumn.CLASS_PARENT_UID.ordinal(), parent.getUniqueId().toString(), false);
                }
            }
            rec.setField(AssignClassInstructorsInterface.DataColumn.IS_FIRST_RECORD_FOR_CLASS.ordinal(), Boolean.valueOf(i == 0).toString(), false);
            rec.setField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal(), Boolean.FALSE.toString(), true, true);
            if (instructors.size() <= 1) {
                rec.setField(AssignClassInstructorsInterface.DataColumn.DELETE.ordinal(), Boolean.FALSE.toString(), isEditable);
            } else {
                rec.setField(AssignClassInstructorsInterface.DataColumn.DELETE.ordinal(), Boolean.TRUE.toString(), isEditable);
            }
            if (isEditable) {
                rec.setField(AssignClassInstructorsInterface.DataColumn.ADD.ordinal(), Boolean.TRUE.toString(), isEditable);
            } else {
                rec.setField(AssignClassInstructorsInterface.DataColumn.ADD.ordinal(), Boolean.FALSE.toString(), isEditable);
            }
            if (instructors.size() > 0) {
                instructor = instructors.get(i);
            }
            rec.setField(AssignClassInstructorsInterface.DataColumn.CLASS_NAME.ordinal(), indent + cls.htmlLabel(), false, i == 0);
            rec.setField(AssignClassInstructorsInterface.DataColumn.CLASS_EXTERNAL_UID.ordinal(), cls.getClassSuffix() == null ? "" : cls.getClassSuffix(), false, i == 0);
            String time = cls.buildAssignedTimeHtml(this.classAssignmentService.getAssignment());
            if (time != null && !time.trim().equals("")) {
                data.setShowTimeAndRoom(true);
            }
            rec.setField(AssignClassInstructorsInterface.DataColumn.TIME.ordinal(), time, false, i == 0);
            rec.setField(AssignClassInstructorsInterface.DataColumn.ROOM.ordinal(), cls.buildAssignedRoomHtml(this.classAssignmentService.getAssignment()), false, i == 0);
            rec.setField(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal(), cls.isDisplayInstructor().toString(), isEditable, i == 0);
            rec.setField(AssignClassInstructorsInterface.DataColumn.FUNDING_DEPT.ordinal(), cls.getEffectiveFundingDept() == null ? "" : cls.getEffectiveFundingDept().getUniqueId().toString(), isEditable, i == 0);
            if (instructors.size() > 0) {
                rec.setField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal(), instructor.getInstructor().getUniqueId().toString(), isEditable, true);
                rec.setField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal(), instructor.getPercentShare().toString(), isEditable, true);
                rec.setField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal(), instructor.isLead().toString(), isEditable, true);
                rec.setField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal(), instructor.getResponsibility() == null ? this.getDefaultTeachingResponsibilityId() : instructor.getResponsibility().getUniqueId().toString(), isEditable, true);
                continue;
            }
            rec.setField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal(), "", isEditable, true);
            rec.setField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal(), "100", isEditable);
            rec.setField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal(), Boolean.TRUE.toString(), isEditable, true);
            rec.setField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal(), this.getDefaultTeachingResponsibilityId(), isEditable, true);
        } while (++i < instructors.size());
    }

    private boolean matchesInstructorIncludingResponsibility(AssignClassInstructorsInterface.Record record, ClassInstructor classInstructor) {
        if (this.matchesInstructor(record, classInstructor)) {
            if (record.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals("") && classInstructor.getResponsibility() == null) {
                return true;
            }
            if (!record.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals("") && classInstructor.getResponsibility() != null && record.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals(classInstructor.getResponsibility().getUniqueId().toString())) {
                return true;
            }
        }
        return false;
    }

    private boolean matchesInstructor(AssignClassInstructorsInterface.Record record, ClassInstructor classInstructor) {
        return record.getField(AssignClassInstructorsInterface.DataColumn.CLASS_UID.ordinal()) != null && record.getField(AssignClassInstructorsInterface.DataColumn.CLASS_UID.ordinal()).equals(classInstructor.getClassInstructing().getUniqueId().toString()) && record.getField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()) != null && record.getField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()).equals(classInstructor.getInstructor().getUniqueId().toString());
    }

    private ClassInstructor findMatchingInstructorForRecord(AssignClassInstructorsInterface.Record record, HashSet<ClassInstructor> classInstructors) {
        ArrayList<ClassInstructor> possibleMatches = new ArrayList<ClassInstructor>();
        for (ClassInstructor ci : classInstructors) {
            if (!this.matchesInstructor(record, ci)) continue;
            possibleMatches.add(ci);
        }
        if (possibleMatches.size() > 1) {
            for (ClassInstructor ci : possibleMatches) {
                if (!this.matchesInstructorIncludingResponsibility(record, ci)) continue;
                return ci;
            }
        } else if (possibleMatches.size() == 1) {
            return (ClassInstructor)possibleMatches.get(0);
        }
        return null;
    }

    private ClassInstructor findMatchingInstructorIncludingResponsibilityForRecord(AssignClassInstructorsInterface.Record record, HashSet<ClassInstructor> classInstructors) {
        ArrayList<ClassInstructor> possibleMatches = new ArrayList<ClassInstructor>();
        for (ClassInstructor ci : classInstructors) {
            if (!this.matchesInstructor(record, ci)) continue;
            possibleMatches.add(ci);
        }
        for (ClassInstructor ci : possibleMatches) {
            if (!this.matchesInstructorIncludingResponsibility(record, ci)) continue;
            return ci;
        }
        return null;
    }

    @Override
    public void save(AssignClassInstructorsInterface data, SessionContext context, Session hibSession) {
        boolean somethingChanged = false;
        if (data.getConfigId() == null) {
            throw new Error(MESSAGES.errorConfigurationIdNotProvided());
        }
        InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(data.getConfigId());
        if (ioc == null) {
            throw new Error(MESSAGES.errorConfigurationIdNotFound());
        }
        HashMap<String, ArrayList<AssignClassInstructorsInterface.Record>> classIdRecordMap = new HashMap<String, ArrayList<AssignClassInstructorsInterface.Record>>();
        for (AssignClassInstructorsInterface.Record r : data.getRecords()) {
            ArrayList records = (ArrayList)classIdRecordMap.get(r.getField(AssignClassInstructorsInterface.DataColumn.CLASS_UID.ordinal()));
            if (records == null) {
                records = new ArrayList();
                classIdRecordMap.put(r.getField(AssignClassInstructorsInterface.DataColumn.CLASS_UID.ordinal()), records);
            }
            records.add(r);
        }
        StringBuffer sbErrorsFound = new StringBuffer();
        boolean errorsFound = false;
        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
            for (Class_ c : ss.getClasses()) {
                ArrayList records = (ArrayList)classIdRecordMap.get(c.getUniqueId().toString());
                if (records == null) {
                    errorsFound = true;
                    sbErrorsFound.append(MESSAGES.errorInstructorInputDataNotFoundForClass(c.getClassLabel(true))).append("\n<br>");
                    continue;
                }
                HashSet<ClassInstructor> origInstrs = new HashSet<ClassInstructor>();
                origInstrs.addAll(c.getClassInstructors());
                HashSet<ClassInstructor> newInstrs = new HashSet<ClassInstructor>();
                for (AssignClassInstructorsInterface.Record r : records) {
                    String instrIdStr;
                    ClassInstructor ci;
                    if (r == null) continue;
                    if (r.getField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal()).equals(Boolean.TRUE.toString())) {
                        r.setField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal(), Boolean.FALSE.toString(), true, true);
                    }
                    if (r.getField(AssignClassInstructorsInterface.DataColumn.IS_FIRST_RECORD_FOR_CLASS.ordinal()).equals(Boolean.TRUE.toString())) {
                        if (!r.getField(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal()).equals(c.isDisplayInstructor().toString())) {
                            c.setDisplayInstructor(Boolean.parseBoolean(r.getField(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal())));
                            hibSession.update((Object)c);
                            somethingChanged = true;
                        }
                        if (!r.getField(AssignClassInstructorsInterface.DataColumn.FUNDING_DEPT.ordinal()).equals(c.getEffectiveFundingDept() == null ? "" : c.getEffectiveFundingDept().getUniqueId().toString())) {
                            if (!r.getField(AssignClassInstructorsInterface.DataColumn.FUNDING_DEPT.ordinal()).equals("")) {
                                c.setFundingDept((Department)DepartmentDAO.getInstance().get(Long.valueOf(r.getField(AssignClassInstructorsInterface.DataColumn.FUNDING_DEPT.ordinal()))));
                            } else {
                                c.setFundingDept(null);
                            }
                            hibSession.update((Object)c);
                            somethingChanged = true;
                        }
                    }
                    if ((ci = this.findMatchingInstructorForRecord(r, origInstrs)) != null) {
                        origInstrs.remove(ci);
                        newInstrs.add(ci);
                        boolean changed = false;
                        if (!r.getField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal()).equals(ci.getLead().toString())) {
                            ci.setLead(Boolean.parseBoolean(r.getField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal())));
                            changed = true;
                        }
                        if (!r.getField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal()).equals(ci.getPercentShare().toString())) {
                            ci.setPercentShare(Integer.parseInt(r.getField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal())));
                            changed = true;
                        }
                        if (ci.getResponsibility() != null && (r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()) == null || !r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals(ci.getResponsibility().getUniqueId().toString())) || ci.getResponsibility() == null && !r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals("")) {
                            if (r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()) == null || r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals("")) {
                                if (TeachingResponsibility.getDefaultInstructorTeachingResponsibility() != null) {
                                    ci.setResponsibility(TeachingResponsibility.getDefaultInstructorTeachingResponsibility());
                                } else {
                                    ci.setResponsibility(null);
                                }
                            } else {
                                ci.setResponsibility((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.parseLong(r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()))));
                            }
                            changed = true;
                        }
                        if (!changed) continue;
                        hibSession.update((Object)ci);
                        somethingChanged = true;
                        continue;
                    }
                    ClassInstructor dupCi = this.findMatchingInstructorIncludingResponsibilityForRecord(r, newInstrs);
                    if (dupCi != null) {
                        r.setField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal(), Boolean.TRUE.toString(), true, true);
                        sbErrorsFound.append(MESSAGES.errorDuplicateInstructorData(dupCi.getInstructor().getName(UserProperty.NameFormat.get(context.getUser())), dupCi.getResponsibility() == null ? "" : dupCi.getResponsibility().getLabel(), c.getClassLabel(true))).append("\n<br>");
                        errorsFound = true;
                        continue;
                    }
                    if (r.getField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal()).equals(Boolean.TRUE.toString())) {
                        r.setField(AssignClassInstructorsInterface.DataColumn.HAS_ERROR.ordinal(), Boolean.FALSE.toString(), true, true);
                    }
                    if ((instrIdStr = r.getField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal())) == null || instrIdStr.trim().equals("") || instrIdStr.trim().equals("-1")) {
                        if (!r.getField(AssignClassInstructorsInterface.DataColumn.IS_FIRST_RECORD_FOR_CLASS.ordinal()).equals(Boolean.TRUE.toString())) {
                            data.getRecords().remove(r);
                            continue;
                        }
                        if (records.size() > 1 && records.indexOf(r) + 1 < records.size()) {
                            AssignClassInstructorsInterface.Record newFirst = (AssignClassInstructorsInterface.Record)records.get(records.indexOf(r) + 1);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.IS_FIRST_RECORD_FOR_CLASS.ordinal(), Boolean.TRUE.toString(), false, false);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.CLASS_NAME.ordinal(), r.getField(AssignClassInstructorsInterface.DataColumn.CLASS_NAME.ordinal()), false, true);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.CLASS_EXTERNAL_UID.ordinal(), r.getField(AssignClassInstructorsInterface.DataColumn.CLASS_EXTERNAL_UID.ordinal()), false, true);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.TIME.ordinal(), r.getField(AssignClassInstructorsInterface.DataColumn.TIME.ordinal()), false, true);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.ROOM.ordinal(), r.getField(AssignClassInstructorsInterface.DataColumn.ROOM.ordinal()), false, true);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal(), r.getField(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal()), r.isEditable(AssignClassInstructorsInterface.DataColumn.DISPLAY.ordinal()), true);
                            newFirst.setField(AssignClassInstructorsInterface.DataColumn.DELETE.ordinal(), Boolean.valueOf(records.size() > 2).toString(), false, false);
                            data.getRecords().remove(r);
                            continue;
                        }
                        r.setField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal(), "", r.isEditable(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()), r.isVisible(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()));
                        r.setField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal(), this.getDefaultTeachingResponsibilityId(), r.isEditable(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()), r.isVisible(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()));
                        r.setField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal(), "100", r.isEditable(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal()), r.isVisible(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal()));
                        r.setField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal(), Boolean.TRUE.toString(), r.isEditable(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal()), r.isVisible(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal()));
                        continue;
                    }
                    ci = new ClassInstructor();
                    ci.setClassInstructing(c);
                    c.addToclassInstructors(ci);
                    DepartmentalInstructor di = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instrIdStr));
                    if (di == null) continue;
                    ci.setInstructor(di);
                    di.addToclasses(ci);
                    ci.setLead(Boolean.parseBoolean(r.getField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal())));
                    String pctShareStr = r.getField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal());
                    if (pctShareStr == null || pctShareStr.trim().equals("")) {
                        pctShareStr = "0";
                    }
                    ci.setPercentShare(Integer.parseInt(pctShareStr));
                    if (r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()).equals("")) {
                        if (TeachingResponsibility.getDefaultInstructorTeachingResponsibility() != null) {
                            ci.setResponsibility(TeachingResponsibility.getDefaultInstructorTeachingResponsibility());
                        } else {
                            ci.setResponsibility(null);
                        }
                    } else {
                        ci.setResponsibility((TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.parseLong(r.getField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()))));
                    }
                    ci.setUniqueId((Long)hibSession.save((Object)ci));
                    newInstrs.add(ci);
                    somethingChanged = true;
                }
                for (ClassInstructor ci : origInstrs) {
                    c.removeClassInstructor(ci);
                    ci.getInstructor().removeClassInstructor(ci);
                    hibSession.delete((Object)ci);
                    somethingChanged = true;
                }
            }
        }
        if (!errorsFound && somethingChanged) {
            ChangeLog.addChange(hibSession, context, ioc, ChangeLog.Source.CLASS_INSTR_ASSIGN, ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            if (this.permissionOfferingLockNeeded.check(context.getUser(), ioc.getInstructionalOffering())) {
                StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), ioc.getInstructionalOffering().getSessionId(), ioc.getInstructionalOffering().getUniqueId());
            }
            hibSession.flush();
            String className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
            if (className != null && className.trim().length() > 0) {
                ExternalInstrOfferingConfigAssignInstructorsAction assignAction = null;
                try {
                    assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    Debug.info(MESSAGES.exceptionExternalSystemUpdateFailure(e.getClass().getSimpleName(), className));
                    e.printStackTrace();
                }
                if (assignAction != null) {
                    assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, InstrOfferingConfigDAO.getInstance().getSession());
                }
            }
        }
        data.setErrors(sbErrorsFound.toString());
        data.setSaveSuccessful(!errorsFound);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAllInstructors(AssignClassInstructorsInterface data, SessionContext context, Session hibSession) throws Exception {
        if (data.getConfigId() == null) {
            throw new Exception(MESSAGES.errorConfigurationIdNotProvided());
        }
        InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(data.getConfigId());
        if (ioc == null) {
            throw new Exception(MESSAGES.errorConfigurationIdNotFound());
        }
        for (SchedulingSubpart schedulingSubpart : ioc.getSchedulingSubparts()) {
            for (Class_ class_ : schedulingSubpart.getClasses()) {
                if (context.hasPermission(class_, Right.AssignInstructorsClass)) continue;
                throw new Exception(MESSAGES.errorDeleteAllInstructorsPermission());
            }
        }
        boolean changed = false;
        for (SchedulingSubpart schedulingSubpart : ioc.getSchedulingSubparts()) {
            for (Class_ c : schedulingSubpart.getClasses()) {
                HashSet<ClassInstructor> origInstrs = new HashSet<ClassInstructor>();
                origInstrs.addAll(c.getClassInstructors());
                for (ClassInstructor ci : origInstrs) {
                    c.removeClassInstructor(ci);
                    ci.getInstructor().removeClassInstructor(ci);
                    hibSession.delete((Object)ci);
                    changed = true;
                }
            }
        }
        ArrayList<AssignClassInstructorsInterface.Record> arrayList = new ArrayList<AssignClassInstructorsInterface.Record>();
        arrayList.addAll(data.getRecords());
        for (AssignClassInstructorsInterface.Record record : arrayList) {
            if (record.getField(AssignClassInstructorsInterface.DataColumn.IS_FIRST_RECORD_FOR_CLASS.ordinal()).equals(Boolean.TRUE.toString())) {
                record.setField(AssignClassInstructorsInterface.DataColumn.DELETE.ordinal(), Boolean.FALSE.toString(), false, false);
                record.setField(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal(), "", record.isEditable(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()), record.isVisible(AssignClassInstructorsInterface.DataColumn.INSTR_NAME.ordinal()));
                record.setField(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal(), this.getDefaultTeachingResponsibilityId(), record.isEditable(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()), record.isVisible(AssignClassInstructorsInterface.DataColumn.RESPONSIBILITY.ordinal()));
                record.setField(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal(), "100", record.isEditable(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal()), record.isVisible(AssignClassInstructorsInterface.DataColumn.PCT_SHARE.ordinal()));
                record.setField(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal(), Boolean.TRUE.toString(), record.isEditable(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal()), record.isVisible(AssignClassInstructorsInterface.DataColumn.CHECK_CONFICTS.ordinal()));
                continue;
            }
            data.getRecords().remove(record);
        }
        if (changed) {
            ChangeLog.addChange(hibSession, context, ioc, ChangeLog.Source.CLASS_INSTR_ASSIGN, ChangeLog.Operation.DELETE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            if (this.permissionOfferingLockNeeded.check(context.getUser(), ioc.getInstructionalOffering())) {
                StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), ioc.getInstructionalOffering().getSessionId(), ioc.getInstructionalOffering().getUniqueId());
            }
            hibSession.flush();
            String string = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
            if (string != null && string.trim().length() > 0) {
                void var8_22;
                Object var8_20 = null;
                try {
                    ExternalInstrOfferingConfigAssignInstructorsAction externalInstrOfferingConfigAssignInstructorsAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    Debug.info("Failed to Send Update to External System:  InstantiationException = " + string);
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    Debug.info("Failed to Send Update to External System:  IllegalAccessException = " + string);
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    Debug.info("Failed to Send Update to External System:  IllegalArgumentException = " + string);
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Debug.info("Failed to Send Update to External System:  InvocationTargetException = " + string);
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    Debug.info("Failed to Send Update to External System:  NoSuchMethodException = " + string);
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    Debug.info("Failed to Send Update to External System:  SecurityException = " + string);
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    Debug.info("Failed to Send Update to External System:  ClassNotFoundException = " + string);
                    e.printStackTrace();
                }
                if (var8_22 != null) {
                    var8_22.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, InstrOfferingConfigDAO.getInstance().getSession());
                }
            }
        }
    }
}

