/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=roles]")
public class UserRoles
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageRole(), MESSAGES.pageRoles());
    }

    @Override
    @PreAuthorize(value="checkPermission('Roles')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 250, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldInstructor(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldEnabled(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldSortOrder(), SimpleEditInterface.FieldType.text, 80, 10, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.HIDDEN));
        data.setSortBy(4);
        int idx = 0;
        for (Roles role : Roles.findAll(false)) {
            SimpleEditInterface.Record r = data.addRecord(role.getRoleId(), (role.isManager() != false || role.isInstructor() != false) && !role.isUsed());
            r.setField(0, role.getReference(), role.isManager() != false || role.isInstructor() != false);
            r.setField(1, role.getAbbv());
            r.setField(2, role.isInstructor() != false ? "true" : "false");
            r.setField(3, role.isEnabled() != false ? "true" : "false");
            r.setField(4, String.valueOf(idx++));
        }
        data.setEditable(context.hasPermission(Right.RoleEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('RoleEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (Roles role : RolesDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(role.getRoleId());
            if (r == null) {
                this.delete(role, context, hibSession);
                continue;
            }
            this.update(role, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('RoleEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        Roles role = new Roles();
        role.setReference(record.getField(0));
        role.setAbbv(record.getField(1));
        role.setInstructor("true".equals(record.getField(2)));
        role.setEnabled("true".equals(record.getField(3)));
        role.setManager(true);
        record.setUniqueId((Long)hibSession.save((Object)role));
        ChangeLog.addChange(hibSession, context, role, role.getAbbv() + " role", ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(Roles role, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (role == null) {
            return;
        }
        if (ToolBox.equals((Object)role.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)role.getAbbv(), (Object)record.getField(1)) && ToolBox.equals((Object)role.isInstructor(), (Object)"true".equals(record.getField(2))) && ToolBox.equals((Object)role.isEnabled(), (Object)"true".equals(record.getField(3)))) {
            return;
        }
        role.setReference(record.getField(0));
        role.setAbbv(record.getField(1));
        role.setInstructor("true".equals(record.getField(2)));
        role.setEnabled("true".equals(record.getField(3)));
        hibSession.saveOrUpdate((Object)role);
        ChangeLog.addChange(hibSession, context, role, role.getAbbv() + " role", ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('RoleEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((Roles)RolesDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(Roles role, SessionContext context, Session hibSession) {
        if (role == null) {
            return;
        }
        if (!role.isManager().booleanValue()) {
            throw new PageAccessException(MESSAGES.failedDeleteRole(role.getAbbv()));
        }
        ChangeLog.addChange(hibSession, context, role, role.getAbbv() + " role", ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)role);
    }

    @Override
    @PreAuthorize(value="checkPermission('RoleEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((Roles)RolesDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

