/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=roomType]")
public class RoomTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageRoomType(), MESSAGES.pageRoomTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> types = new ArrayList<SimpleEditInterface.ListItem>();
        types.add(new SimpleEditInterface.ListItem("room", MESSAGES.typeRoomClass()));
        types.add(new SimpleEditInterface.ListItem("other", MESSAGES.typeNonUniversityLocationClass()));
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 140, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldLabel(), SimpleEditInterface.FieldType.text, 400, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldRoomClassType(), SimpleEditInterface.FieldType.list, 120, types, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldNbrRooms(), SimpleEditInterface.FieldType.number, 80, 10, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.NO_DETAIL));
        data.setSaveOrder(false);
        data.setCanMoveUpAndDown(true);
        data.setAllowSort(false);
        for (RoomType type : RoomType.findAll()) {
            SimpleEditInterface.Record r = data.addRecord(type.getUniqueId());
            boolean canEdit = context.hasPermission(Right.RoomTypes);
            r.setField(0, type.getReference(), canEdit);
            r.setField(1, type.getLabel(), canEdit);
            int nbrRooms = type.countRooms();
            r.setField(2, type.isRoom() != false ? "room" : "other", canEdit && nbrRooms == 0);
            r.setField(3, String.valueOf(nbrRooms), false);
            r.setDeletable(canEdit && nbrRooms == 0);
            r.setOrder(type.getOrd());
        }
        data.setAddable(context.hasPermission(Right.RoomTypes));
        data.setEditable(context.hasPermission(Right.RoomTypes));
        return data;
    }

    protected int nextOrd() {
        TreeSet<RoomType> types = RoomType.findAll();
        int idx = 0;
        block0: while (true) {
            for (RoomType t : types) {
                if (idx != t.getOrd()) continue;
                ++idx;
                continue block0;
            }
            break;
        }
        return idx;
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomTypes')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        int ord = 0;
        for (SimpleEditInterface.Record r : data.getRecords()) {
            if (r.isEmpty(data)) continue;
            r.setOrder(ord++);
        }
        for (RoomType type : RoomType.findAll()) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, r.getOrder(), context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, r.getOrder(), context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomTypes')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.save(record, null, context, hibSession);
    }

    public void save(SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        if (order == null) {
            order = this.nextOrd();
        }
        context.checkPermission(Right.RoomTypes);
        RoomType type = new RoomType();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setRoom("room".equals(record.getField(2)));
        type.setOrd(order);
        record.setField(3, "0");
        record.setUniqueId((Long)hibSession.save((Object)type));
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(RoomType type, SimpleEditInterface.Record record, Integer order, SessionContext context, Session hibSession) {
        boolean changed;
        if (type == null) {
            return;
        }
        if (order == null) {
            order = record.getOrder();
        }
        context.checkPermission(Right.RoomTypes);
        boolean bl = !ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) || !ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1)) || !ToolBox.equals((Object)(type.isRoom() != false ? "room" : "other"), (Object)record.getField(2)) ? true : (changed = false);
        if (ToolBox.equals((Object)type.getOrd(), (Object)order) && !changed) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setRoom("room".equals(record.getField(2)));
        type.setOrd(order);
        hibSession.saveOrUpdate((Object)type);
        if (changed) {
            ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomTypes')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((RoomType)RoomTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, null, context, hibSession);
    }

    protected void delete(RoomType type, SessionContext context, Session hibSession) {
        context.checkPermission(Right.RoomTypes);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('RoomTypes')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((RoomType)RoomTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

