/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.UserData;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=eventDefault]")
public class EventDefaults
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageEventDefault(), MESSAGES.pageEventDefaults());
    }

    @Override
    @PreAuthorize(value="checkPermission('EventDefaults')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> states = new ArrayList<SimpleEditInterface.ListItem>();
        for (RoomTypeOption.Status state : RoomTypeOption.Status.values()) {
            states.add(new SimpleEditInterface.ListItem(String.valueOf(state.ordinal()), state.toString()));
        }
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldManager(), SimpleEditInterface.FieldType.text, 100, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 100, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.HIDDEN), new SimpleEditInterface.Field(MESSAGES.fieldAdditionalEmails(), SimpleEditInterface.FieldType.textarea, 50, 3, 4000, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0);
        data.setAddable(false);
        if (context.hasPermission(Right.EventDefaultsEditOther)) {
            for (TimetableManager manager : TimetableManagerDAO.getInstance().findAll()) {
                if (!context.hasPermission(Right.SessionIndependent)) {
                    boolean hasDepartment = false;
                    for (Department dept : manager.getDepartments()) {
                        if (!context.getUser().getCurrentAuthority().hasQualifier(dept)) continue;
                        hasDepartment = true;
                        break;
                    }
                    if (!hasDepartment) continue;
                }
                boolean hasRole = false;
                for (ManagerRole role : manager.getManagerRoles()) {
                    if (!role.getRole().hasRight(Right.EventDefaults)) continue;
                    hasRole = true;
                    break;
                }
                if (!hasRole) continue;
                SimpleEditInterface.Record r = data.addRecord(manager.getUniqueId(), false);
                r.setField(0, manager.getName(), false);
                r.setField(1, manager.getExternalUniqueId(), false);
                r.setField(2, UserData.getProperty(manager.getExternalUniqueId(), "Defaults[AddEvent.emails]", ""));
            }
        } else {
            data.getFields()[0] = new SimpleEditInterface.Field(MESSAGES.fieldManager(), SimpleEditInterface.FieldType.text, 100, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.HIDDEN);
            TimetableManager manager = TimetableManager.findByExternalId(context.getUser().getExternalUserId());
            if (manager != null) {
                SimpleEditInterface.Record r = data.addRecord(manager.getUniqueId(), false);
                r.setField(0, manager.getName(), false);
                r.setField(1, manager.getExternalUniqueId(), false);
                r.setField(2, UserData.getProperty(manager.getExternalUniqueId(), "Defaults[AddEvent.emails]", ""));
            }
        }
        data.setEditable(true);
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('EventDefaults')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (TimetableManager manager : TimetableManagerDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(manager.getUniqueId());
            if (r == null) continue;
            this.update(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('HasRole')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }

    @Override
    @PreAuthorize(value="checkPermission('EventDefaults')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        String extId = record.getField(1);
        if (!context.getUser().getExternalUserId().equals(extId)) {
            context.checkPermission(Right.EventDefaultsEditOther);
        }
        UserData.setProperty(extId, "Defaults[AddEvent.emails]", record.getField(2));
    }

    @Override
    @PreAuthorize(value="checkPermission('HasRole')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }
}

