/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=classification]")
public class AcademicClassifications
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageAcademicClassification(), MESSAGES.pageAcademicClassifications());
    }

    @Override
    @PreAuthorize(value="checkPermission('AcademicClassifications')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 500, 100, SimpleEditInterface.Flag.UNIQUE));
        data.setSortBy(1, 2);
        for (AcademicClassification clasf : AcademicClassificationDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(clasf.getUniqueId());
            r.setField(0, clasf.getExternalUniqueId());
            r.setField(1, clasf.getCode());
            r.setField(2, clasf.getName());
            r.setDeletable(clasf.getExternalUniqueId() == null && !clasf.isUsed(hibSession));
        }
        data.setEditable(context.hasPermission(Right.AcademicClassificationEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('AcademicClassificationEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (AcademicClassification clasf : AcademicClassificationDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(clasf.getUniqueId());
            if (r == null) {
                this.delete(clasf, context, hibSession);
                continue;
            }
            this.update(clasf, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('AcademicClassificationEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        AcademicClassification clasf = new AcademicClassification();
        clasf.setExternalUniqueId(record.getField(0));
        clasf.setCode(record.getField(1));
        clasf.setName(record.getField(2));
        clasf.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        record.setUniqueId((Long)hibSession.save((Object)clasf));
        ChangeLog.addChange(hibSession, context, clasf, clasf.getCode() + " " + clasf.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(AcademicClassification clasf, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (clasf == null) {
            return;
        }
        if (ToolBox.equals((Object)clasf.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)clasf.getCode(), (Object)record.getField(1)) && ToolBox.equals((Object)clasf.getName(), (Object)record.getField(2))) {
            return;
        }
        clasf.setExternalUniqueId(record.getField(0));
        clasf.setCode(record.getField(1));
        clasf.setName(record.getField(2));
        hibSession.saveOrUpdate((Object)clasf);
        ChangeLog.addChange(hibSession, context, clasf, clasf.getCode() + " " + clasf.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('AcademicClassificationEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((AcademicClassification)AcademicClassificationDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(AcademicClassification clasf, SessionContext context, org.hibernate.Session hibSession) {
        if (clasf == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, clasf, clasf.getCode() + " " + clasf.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)clasf);
    }

    @Override
    @PreAuthorize(value="checkPermission('AcademicClassificationEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((AcademicClassification)AcademicClassificationDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

