/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.reports.pointintimedata.WSCHByDepartment;

public class AllWSCHForDepartmentByInstructor
extends WSCHByDepartment {
    private ArrayList<Long> iDepartmentIds;

    public AllWSCHForDepartmentByInstructor() {
        this.getParameters().add(BasePointInTimeDataReports.Parameter.DEPARTMENTS);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnInstructor());
        hdr.add(MSG.columnInstructorExternalId());
        hdr.add(MSG.columnOrganizedWeeklyClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyClassHours());
        hdr.add(MSG.columnWeeklyClassHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS).size() >= 1) {
            this.setDepartmentIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS));
        }
    }

    @Override
    public String reportName() {
        return MSG.deptWSCHReportAllHoursForDepartmentByInstructor();
    }

    @Override
    public String reportDescription() {
        return MSG.deptWSCHReportAllHoursForDepartmentByInstructorNote();
    }

    @Override
    protected float weeklyClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    protected float weeklyStudentClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    public void createWeeklyStudentContactHoursByDepartmentReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (Long deptId : this.getDepartmentIds()) {
            Department d = (Department)hibSession.createQuery("from Department d where d.uniqueId = :id").setLong("id", deptId.longValue()).setCacheable(true).uniqueResult();
            HashMap<PitDepartmentalInstructor, InstructorHours> positionClassHours = new HashMap<PitDepartmentalInstructor, InstructorHours>();
            for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, deptId, hibSession)) {
                for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                    if (processedClasses.contains(pc.getUniqueId())) continue;
                    processedClasses.add(pc.getUniqueId());
                    if (pc.getPitClassInstructors() == null || pc.getPitClassInstructors().isEmpty()) {
                        InstructorHours ih = (InstructorHours)positionClassHours.get(null);
                        if (ih == null) {
                            ih = new InstructorHours(null, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                            positionClassHours.put(null, ih);
                        }
                        ih.addClassHours(null, pc);
                        continue;
                    }
                    int numInstructors = 0;
                    for (PitClassInstructor pci : pc.getPitClassInstructors()) {
                        InstructorHours ih = (InstructorHours)positionClassHours.get(pci.getPitDepartmentalInstructor());
                        if (ih == null) {
                            ih = new InstructorHours(pci.getPitDepartmentalInstructor(), this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                            positionClassHours.put(pci.getPitDepartmentalInstructor(), ih);
                        }
                        if (!ih.addClassHours(pci, pc)) continue;
                        ++numInstructors;
                    }
                    if (numInstructors != 0) continue;
                    InstructorHours ih = (InstructorHours)positionClassHours.get(null);
                    if (ih == null) {
                        ih = new InstructorHours(null, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        positionClassHours.put(null, ih);
                    }
                    ih.addClassHours(null, pc);
                }
            }
            for (PitDepartmentalInstructor pdi : positionClassHours.keySet()) {
                InstructorHours ih = (InstructorHours)positionClassHours.get(pdi);
                ArrayList<String> row = new ArrayList<String>();
                row.add(d.getDeptCode());
                row.add(d.getAbbreviation());
                row.add(d.getName());
                row.add(pdi == null ? MSG.labelUnknown() : pdi.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle));
                row.add(pdi == null ? MSG.labelUnknown() : (pdi.getExternalUniqueId() == null ? MSG.labelUnknown() : pdi.getExternalUniqueId()));
                row.add(Float.toString(ih.getOrganizedWeeklyClassHours()));
                row.add(Float.toString(ih.getNotOrganizedWeeklyClassHours()));
                row.add(Float.toString(ih.getWeeklyClassHours()));
                row.add(Float.toString(ih.getOrganizedWeeklyStudentClassHours()));
                row.add(Float.toString(ih.getNotOrganizedWeeklyStudentClassHours()));
                row.add(Float.toString(ih.getWeeklyStudentClassHours()));
                this.addDataRow(row);
            }
        }
    }

    public ArrayList<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(ArrayList<Object> departmentIds) {
        this.iDepartmentIds = new ArrayList();
        for (Object o : departmentIds) {
            this.iDepartmentIds.add((Long)o);
        }
    }

    private class InstructorHours {
        private float iWeeklyClassHours = 0.0f;
        private float iOrganizedWeeklyClassHours = 0.0f;
        private float iNotOrganizedWeeklyClassHours = 0.0f;
        private float iWeeklyStudentClassHours = 0.0f;
        private float iOrganizedWeeklyStudentClassHours = 0.0f;
        private float iNotOrganizedWeeklyStudentClassHours = 0.0f;
        private PitDepartmentalInstructor iPitDepartmentalInstructor;
        private Float iStandardMinutesInReportingHour;
        private Float iStandardWeeksInReportingTerm;

        public PitDepartmentalInstructor getPitDeparmentInstructor() {
            return this.iPitDepartmentalInstructor;
        }

        public float getOrganizedWeeklyClassHours() {
            return this.iOrganizedWeeklyClassHours;
        }

        public float getNotOrganizedWeeklyClassHours() {
            return this.iNotOrganizedWeeklyClassHours;
        }

        public float getOrganizedWeeklyStudentClassHours() {
            return this.iOrganizedWeeklyStudentClassHours;
        }

        public float getNotOrganizedWeeklyStudentClassHours() {
            return this.iNotOrganizedWeeklyStudentClassHours;
        }

        public float getWeeklyClassHours() {
            return this.iWeeklyClassHours;
        }

        public float getWeeklyStudentClassHours() {
            return this.iWeeklyStudentClassHours;
        }

        public InstructorHours(PitDepartmentalInstructor pitDepartmentalInstructor, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
            this.iPitDepartmentalInstructor = pitDepartmentalInstructor;
            this.iStandardMinutesInReportingHour = standardMinutesInReportingHour;
            this.iStandardWeeksInReportingTerm = standardWeeksInReportingTerm;
        }

        public boolean addClassHours(PitClassInstructor pitClassInstructor, PitClass pitClass) {
            if (pitClassInstructor == null) {
                if (this.iPitDepartmentalInstructor == null) {
                    this.updateHours(pitClass, 100);
                    return true;
                }
                return false;
            }
            if (pitClassInstructor.getResponsibility() != null && pitClassInstructor.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary)) {
                return false;
            }
            if (pitClassInstructor.getNormalizedPercentShare() == 0) {
                return false;
            }
            if (pitClassInstructor.getPitDepartmentalInstructor() == null) {
                if (this.iPitDepartmentalInstructor == null) {
                    this.updateHours(pitClass, pitClassInstructor.getNormalizedPercentShare());
                    return true;
                }
            } else if (pitClassInstructor.getPitDepartmentalInstructor().equals(this.getPitDeparmentInstructor())) {
                this.updateHours(pitClass, pitClassInstructor.getNormalizedPercentShare());
                return true;
            }
            return false;
        }

        private void updateHours(PitClass pitClass, Integer percentShare) {
            this.iWeeklyClassHours += pitClass.getAllWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iOrganizedWeeklyClassHours += pitClass.getOrganizedWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iNotOrganizedWeeklyClassHours += pitClass.getNotOrganizedWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iWeeklyStudentClassHours += pitClass.getAllWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iOrganizedWeeklyStudentClassHours += pitClass.getOrganizedWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iNotOrganizedWeeklyStudentClassHours += pitClass.getNotOrganizedWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
        }
    }
}

