/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.remoting.ReplicationQueue;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseIdSet;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseRequestSet;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.AbstractLockingServer;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.server.CourseComparator;
import org.unitime.timetable.onlinesectioning.server.SubSet;

public class ReplicatedServerWithMaster
extends AbstractLockingServer {
    private EmbeddedCacheManager iCacheManager;
    private Map<Long, XCourseId> iCourseForId;
    private Map<String, XCourseIdSet> iCourseForName;
    private Cache<Long, XStudent> iStudentTable;
    private Cache<Long, XOffering> iOfferingTable;
    private Map<Long, XCourseRequestSet> iOfferingRequests;
    private Cache<Long, XExpectations> iExpectations;
    private Cache<Long, Boolean> iOfferingLocks;
    private Map<String, Set<Long>> iInstructedOfferings;

    public ReplicatedServerWithMaster(OnlineSectioningServerContext context) throws SectioningException {
        super(context);
    }

    private String cacheName(String table) {
        return this.getAcademicSession().toCompactString() + "[" + table + "]";
    }

    private <U, T> Cache<U, T> getCache(String name) {
        Configuration config = this.iCacheManager.getCacheConfiguration(name);
        if (config != null) {
            this.iLog.info((Object)("Using " + config + " for " + name + " cache."));
            this.iCacheManager.defineConfiguration(this.cacheName(name), config);
        }
        return this.iCacheManager.getCache(this.cacheName(name), true);
    }

    @Override
    protected void load(OnlineSectioningServerContext context) throws SectioningException {
        this.iCacheManager = context.getCacheManager();
        this.iCourseForId = new Hashtable<Long, XCourseId>();
        this.iCourseForName = new Hashtable<String, XCourseIdSet>();
        this.iStudentTable = this.getCache("StudentTable");
        this.iOfferingTable = this.getCache("OfferingTable");
        this.iOfferingRequests = new HashMap<Long, XCourseRequestSet>();
        this.iExpectations = this.getCache("Expectations");
        this.iOfferingLocks = this.getCache("OfferingLocks");
        this.iInstructedOfferings = new HashMap<String, Set<Long>>();
        HashMap original = new HashMap(this.iProperties);
        this.iProperties = this.getCache("Config");
        this.iProperties.putAll(original);
        this.iOfferingTable.addListener((Object)new OfferingTableListener((Collection<XOffering>)this.iOfferingTable.values()));
        this.iStudentTable.addListener((Object)new StudentTableListener((Collection<XStudent>)this.iStudentTable.values()));
        super.load(context);
    }

    protected void removeCache(Cache<?, ?> cache) {
        this.iCacheManager.getGlobalComponentRegistry().removeCache(cache.getName());
        CacheJmxRegistration jmx = (CacheJmxRegistration)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class);
        cache.stop();
        if (jmx != null) {
            jmx.unregisterCacheMBean();
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.removeCache(this.iStudentTable);
        this.removeCache(this.iExpectations);
        this.removeCache(this.iOfferingTable);
        this.removeCache(this.iOfferingLocks);
        this.removeCache((Cache)this.iProperties);
    }

    @Override
    protected void loadOnMaster(OnlineSectioningServerContext context) throws SectioningException {
        this.releaseAllOfferingLocks();
        super.loadOnMaster(context);
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        return this.findCourses(query, limit, matcher, new CourseComparator(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher, Comparator<XCourseId> cmp) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            SubSet<XCourseId> ret = new SubSet<XCourseId>(limit, cmp);
            String queryInLowerCase = query.toLowerCase();
            for (XCourseId c : this.iCourseForId.values()) {
                if (!c.matchCourseName(queryInLowerCase) || matcher != null && !matcher.match(c)) continue;
                ret.add(c);
            }
            if (!ret.isLimitReached() && queryInLowerCase.length() > 2) {
                for (XCourseId c : this.iCourseForId.values()) {
                    if (!c.matchTitle(queryInLowerCase) || matcher != null && !matcher.match(c)) continue;
                    ret.add(c);
                }
            }
            Iterator<XCourseId> iterator = ret;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            TreeSet<XCourseId> ret = new TreeSet<XCourseId>();
            for (XCourseId c : this.iCourseForId.values()) {
                if (matcher != null && !matcher.match(c)) continue;
                ret.add(c);
            }
            TreeSet<XCourseId> treeSet = ret;
            return treeSet;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<XStudent> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            ArrayList<XStudent> ret = new ArrayList<XStudent>();
            for (XStudent s : this.iStudentTable.values()) {
                if (matcher != null && !matcher.match(s)) continue;
                ret.add(s);
            }
            Object object = ret;
            return object;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseId getCourse(String course) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XCourseId xCourseId;
            int idx = course.indexOf(45);
            while (idx >= 0) {
                String courseName = course.substring(0, idx).trim();
                String title = course.substring(idx + 1).trim();
                TreeSet infos = this.iCourseForName.get(courseName.toLowerCase());
                if (infos != null && !infos.isEmpty()) {
                    for (XCourseId info : infos) {
                        if (!title.equalsIgnoreCase(info.getTitle())) continue;
                        XCourseId xCourseId2 = info;
                        return xCourseId2;
                    }
                }
                idx = course.indexOf(45, idx + 1);
            }
            TreeSet infos = this.iCourseForName.get(course.toLowerCase());
            if (infos != null && !infos.isEmpty()) {
                xCourseId = (XCourseId)infos.first();
                return xCourseId;
            }
            xCourseId = null;
            return xCourseId;
        }
        finally {
            lock.release();
        }
    }

    private XCourse toCourse(XCourseId course) {
        if (course == null) {
            return null;
        }
        if (course instanceof XCourse) {
            return (XCourse)course;
        }
        XOffering offering = this.getOffering(course.getOfferingId());
        return offering == null ? null : offering.getCourse(course);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourse getCourse(Long courseId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XCourse xCourse = this.toCourse(this.iCourseForId.get(courseId));
            return xCourse;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XStudent getStudent(Long studentId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XStudent xStudent = (XStudent)this.iStudentTable.get((Object)studentId);
            return xStudent;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XOffering getOffering(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XOffering xOffering = (XOffering)this.iOfferingTable.get((Object)offeringId);
            return xOffering;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            Collection requests = this.iOfferingRequests.get(offeringId);
            ArrayList<XCourseRequest> arrayList = requests == null ? null : new ArrayList<XCourseRequest>(requests);
            return arrayList;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XExpectations getExpectations(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XExpectations expectations = (XExpectations)this.iExpectations.get((Object)offeringId);
            XExpectations xExpectations = expectations == null ? new XExpectations(offeringId) : expectations;
            return xExpectations;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void update(XExpectations expectations) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Updating expectations on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iExpectations.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)expectations.getOfferingId(), (Object)expectations);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void remove(XStudent student) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Removing student on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)student.getStudentId());
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XStudent student, boolean updateRequests) {
        this.iLog.debug((Object)("Update " + student + " with requests " + student.getRequests()));
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Updating student on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void remove(XOffering offering) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Removing offering on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iOfferingTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)offering.getOfferingId());
            this.iExpectations.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)offering.getOfferingId());
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void update(XOffering offering) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Updating offering on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iOfferingTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)offering.getOfferingId(), (Object)offering);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void clearAll() {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Clearing all data on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.clear();
            this.iOfferingTable.clear();
            this.iExpectations.clear();
            this.iOfferingLocks.clear();
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void clearAllStudents() {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Clearing all students on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.clear();
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        this.iLog.info((Object)("Assign " + request + " with " + enrollment));
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Assigning a request on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = (XStudent)this.iStudentTable.get((Object)request.getStudentId());
            for (XRequest r : student.getRequests()) {
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                cr.setEnrollment(enrollment);
                this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
                XCourseRequest xCourseRequest = cr;
                return xCourseRequest;
            }
            this.iLog.warn((Object)("ASSIGN[3]: Request " + student + " " + request + " was not found among student requests"));
            Iterator<XRequest> iterator = null;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Wait-listing a request on a slave node. That is suspicious.");
        }
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = (XStudent)this.iStudentTable.get((Object)request.getStudentId());
            for (XRequest r : student.getRequests()) {
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                cr.setWaitlist(waitlist);
                cr.setWaitListedTimeStamp(request.getWaitListedTimeStamp());
                cr.setWaitListSwapWithCourseOffering(request.getWaitListSwapWithCourseOffering());
                this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
                XCourseRequest xCourseRequest = cr;
                return xCourseRequest;
            }
            this.iLog.warn((Object)("WAITLIST[3]: Request " + student + " " + request + " was not found among student requests"));
            Iterator<XRequest> iterator = null;
            return iterator;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)("Failed to lock a student " + studentId + ": not executed on master."));
            return new NoLock();
        }
        return new FlushLock(super.lockStudent(studentId, offeringIds, actionName));
    }

    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)("Failed to lock an offering " + offeringId + ": not executed on master."));
            return new NoLock();
        }
        return new FlushLock(super.lockOffering(offeringId, studentIds, actionName));
    }

    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        if (!this.isMaster()) {
            this.iLog.warn((Object)("Failed to lock a request for student " + request.getStudentId() + ": not executed on master."));
            return new NoLock();
        }
        return new FlushLock(super.lockRequest(request, actionName));
    }

    @Override
    public boolean isOfferingLocked(Long offeringId) {
        return this.iOfferingLocks.containsKey((Object)offeringId);
    }

    @Override
    public void lockOffering(Long offeringId) {
        this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).put((Object)offeringId, (Object)Boolean.TRUE);
        this.flushCache(this.iOfferingLocks);
    }

    @Override
    public void unlockOffering(Long offeringId) {
        this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).remove((Object)offeringId);
        this.flushCache(this.iOfferingLocks);
    }

    @Override
    public Collection<Long> getLockedOfferings() {
        return new HashSet<Long>((Collection<Long>)this.iOfferingLocks.keySet());
    }

    @Override
    public void releaseAllOfferingLocks() {
        this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).clear();
        this.flushCache(this.iOfferingLocks);
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        CheckMaster ch = action.getClass().getAnnotation(CheckMaster.class);
        if (ch != null && ch.value() == CheckMaster.Master.REQUIRED && !this.isMaster()) {
            this.iLog.warn((Object)("Executing action " + action.name() + " (master required) on a slave node."));
        } else if (ch != null && ch.value() == CheckMaster.Master.AVOID && this.isMaster()) {
            this.iLog.warn((Object)("Executing action " + action.name() + " (avoid master) on a master node."));
        }
        E ret = super.execute(action, user);
        return ret;
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Asking for a WRITE lock on a slave node. That is suspicious.");
        }
        return new BatchLock(super.writeLock());
    }

    @Override
    public OnlineSectioningServer.Lock writeLockIfNotHeld() {
        OnlineSectioningServer.Lock lock = super.writeLockIfNotHeld();
        return lock == null ? null : new BatchLock(lock);
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        if (!this.isMaster()) {
            this.iLog.warn((Object)"Asking for an ALL lock on a slave node. That is suspicious.");
        }
        return new FlushLock(super.lockAll());
    }

    private TransactionManager getTransactionManager() {
        return this.iOfferingTable.getAdvancedCache().getTransactionManager();
    }

    protected void flushCache(Cache cache) {
        ReplicationQueue queue = (ReplicationQueue)cache.getAdvancedCache().getComponentRegistry().getComponent(ReplicationQueue.class);
        if (queue != null) {
            queue.flush();
        }
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        Cache properties = (Cache)this.iProperties;
        if (value == null) {
            properties.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).remove((Object)name);
        } else {
            properties.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.IGNORE_RETURN_VALUES}).put((Object)name, value);
        }
        this.flushCache(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getInstructedOfferings(String instructorExternalId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            Collection collection = this.iInstructedOfferings.get(instructorExternalId);
            return collection;
        }
        finally {
            lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getRequestedCourseIds(Long studentId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XStudent student = (XStudent)this.iStudentTable.get((Object)studentId);
            Set<Long> set = student == null ? null : student.getRequestedCourseIds();
            return set;
        }
        finally {
            lock.release();
        }
    }

    class FlushLock
    implements OnlineSectioningServer.Lock {
        private OnlineSectioningServer.Lock iLock = null;

        FlushLock(OnlineSectioningServer.Lock lock) {
            this.iLock = lock;
        }

        @Override
        public void release() {
            try {
                ReplicatedServerWithMaster.this.flushCache(ReplicatedServerWithMaster.this.iStudentTable);
                ReplicatedServerWithMaster.this.flushCache(ReplicatedServerWithMaster.this.iOfferingTable);
                ReplicatedServerWithMaster.this.flushCache(ReplicatedServerWithMaster.this.iExpectations);
            }
            finally {
                this.iLock.release();
            }
        }
    }

    class BatchLock
    implements OnlineSectioningServer.Lock {
        private OnlineSectioningServer.Lock iLock = null;
        private boolean iTransaction = false;

        BatchLock(OnlineSectioningServer.Lock lock) {
            this.iLock = lock;
            try {
                if (ReplicatedServerWithMaster.this.getTransactionManager().getTransaction() == null) {
                    ReplicatedServerWithMaster.this.getTransactionManager().begin();
                    this.iTransaction = true;
                }
            }
            catch (Throwable t) {
                ReplicatedServerWithMaster.this.iLog.warn((Object)("Failed to start a transaction: " + t.getMessage()), t);
            }
        }

        @Override
        public void release() {
            try {
                if (this.iTransaction) {
                    ReplicatedServerWithMaster.this.getTransactionManager().commit();
                }
            }
            catch (Throwable t) {
                ReplicatedServerWithMaster.this.iLog.warn((Object)("Failed to commit a transaction: " + t.getMessage()), t);
            }
            finally {
                this.iLock.release();
            }
        }
    }

    @Listener(sync=true)
    public class StudentTableListener {
        public StudentTableListener(Collection<XStudent> students) {
            for (XStudent student : students) {
                this.addRequests(student);
            }
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<Long, XStudent> event) {
            if (!event.isPre()) {
                this.addRequests((XStudent)event.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<Long, XStudent> event) {
            if (event.isPre()) {
                if (event.getValue() != null) {
                    this.removeRequests((XStudent)event.getValue());
                }
            } else if (event.getValue() != null) {
                this.addRequests((XStudent)event.getValue());
            }
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<Long, XStudent> event) {
            if (event.isPre()) {
                this.removeRequests((XStudent)event.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRequests(XStudent oldStudent) {
            OnlineSectioningServer.Lock lock = ReplicatedServerWithMaster.this.writeLockIfNotHeld();
            try {
                for (XRequest request : oldStudent.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                        XCourseRequestSet requests = (XCourseRequestSet)ReplicatedServerWithMaster.this.iOfferingRequests.get(course.getOfferingId());
                        if (requests != null) {
                            if (!requests.remove(request)) {
                                ReplicatedServerWithMaster.this.iLog.warn((Object)("UPDATE[1]: Request " + oldStudent + " " + request + " was not present in the offering requests table for " + course));
                            }
                            ReplicatedServerWithMaster.this.iOfferingRequests.put(course.getOfferingId(), requests);
                            continue;
                        }
                        ReplicatedServerWithMaster.this.iLog.warn((Object)("UPDATE[2]: Request " + oldStudent + " " + request + " was not present in the offering requests table for " + course));
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequests(XStudent student) {
            OnlineSectioningServer.Lock lock = ReplicatedServerWithMaster.this.writeLockIfNotHeld();
            try {
                for (XRequest request : student.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                        XCourseRequestSet requests = (XCourseRequestSet)ReplicatedServerWithMaster.this.iOfferingRequests.get(course.getOfferingId());
                        if (requests == null) {
                            requests = new XCourseRequestSet();
                        }
                        requests.add((XCourseRequest)request);
                        ReplicatedServerWithMaster.this.iOfferingRequests.put(course.getOfferingId(), requests);
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
    }

    @Listener(sync=true)
    public class OfferingTableListener {
        public OfferingTableListener(Collection<XOffering> offerings) {
            for (XOffering offering : offerings) {
                this.addCourses(offering);
            }
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<Long, XOffering> event) {
            if (!event.isPre()) {
                this.addCourses((XOffering)event.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<Long, XOffering> event) {
            if (event.isPre()) {
                if (event.getValue() != null) {
                    this.removeCourses((XOffering)event.getValue());
                }
            } else if (event.getValue() != null) {
                this.addCourses((XOffering)event.getValue());
            }
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<Long, XOffering> event) {
            if (event.isPre()) {
                this.removeCourses((XOffering)event.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCourses(XOffering offering) {
            OnlineSectioningServer.Lock lock = ReplicatedServerWithMaster.this.writeLockIfNotHeld();
            try {
                for (XCourse course : offering.getCourses()) {
                    ReplicatedServerWithMaster.this.iCourseForId.remove(course.getCourseId());
                    XCourseIdSet courses = (XCourseIdSet)ReplicatedServerWithMaster.this.iCourseForName.get(course.getCourseNameInLowerCase());
                    if (courses == null) continue;
                    courses.remove(course);
                    if (courses.size() == 1) {
                        for (XCourseId x : courses) {
                            x.setHasUniqueName(true);
                        }
                    }
                    if (!courses.isEmpty()) continue;
                    ReplicatedServerWithMaster.this.iCourseForName.remove(course.getCourseNameInLowerCase());
                }
                for (String externalId : offering.getInstructorExternalIds()) {
                    Set offeringIds = (Set)ReplicatedServerWithMaster.this.iInstructedOfferings.get(externalId);
                    if (offeringIds == null) continue;
                    offeringIds.remove(offering.getOfferingId());
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCourses(XOffering offering) {
            OnlineSectioningServer.Lock lock = ReplicatedServerWithMaster.this.writeLockIfNotHeld();
            try {
                for (XCourse course : offering.getCourses()) {
                    ReplicatedServerWithMaster.this.iCourseForId.put(course.getCourseId(), new XCourseId(course));
                    XCourseIdSet courses = (XCourseIdSet)ReplicatedServerWithMaster.this.iCourseForName.get(course.getCourseNameInLowerCase());
                    if (courses == null) {
                        courses = new XCourseIdSet();
                        ReplicatedServerWithMaster.this.iCourseForName.put(course.getCourseNameInLowerCase(), courses);
                    }
                    courses.add(new XCourseId(course));
                    if (courses.size() == 1) {
                        for (XCourseId x : courses) {
                            x.setHasUniqueName(true);
                        }
                        continue;
                    }
                    if (courses.size() <= 1) continue;
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(false);
                    }
                }
                for (String externalId : offering.getInstructorExternalIds()) {
                    HashSet<Long> offeringIds = (HashSet<Long>)ReplicatedServerWithMaster.this.iInstructedOfferings.get(externalId);
                    if (offeringIds == null) {
                        offeringIds = new HashSet<Long>();
                        ReplicatedServerWithMaster.this.iInstructedOfferings.put(externalId, offeringIds);
                    }
                    offeringIds.add(offering.getOfferingId());
                }
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
    }

    private static class NoLock
    implements OnlineSectioningServer.Lock {
        private NoLock() {
        }

        @Override
        public void release() {
        }
    }
}

