/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.Location;

@SerializeWith(value=XRoomSerializer.class)
public class XRoom
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iExternalId;
    private boolean iIgnoreTooFar;
    private Double iX;
    private Double iY;

    public XRoom() {
    }

    public XRoom(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XRoom(Location location) {
        this.iUniqueId = location.getUniqueId();
        this.iExternalId = location.getExternalUniqueId();
        this.iName = location.getLabelWithDisplayName();
        this.iIgnoreTooFar = location.isIgnoreTooFar();
        this.iX = location.getCoordinateX();
        this.iY = location.getCoordinateY();
    }

    public XRoom(RoomLocation location) {
        this.iUniqueId = location.getId();
        this.iName = location.getName();
        this.iIgnoreTooFar = location.getIgnoreTooFar();
        this.iX = location.getPosX();
        this.iY = location.getPosY();
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public String getName() {
        return this.iName;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public Double getX() {
        return this.iX;
    }

    public Double getY() {
        return this.iY;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XRoom)) {
            return false;
        }
        return this.getUniqueId().equals(((XRoom)o).getUniqueId());
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    public int getDistanceInMinutes(DistanceMetric m, XRoom other) {
        if (this.getUniqueId().equals(other.getUniqueId())) {
            return 0;
        }
        if (this.getIgnoreTooFar() || other.getIgnoreTooFar()) {
            return 0;
        }
        return m.getDistanceInMinutes(this.getUniqueId(), this.getX(), this.getY(), other.getUniqueId(), other.getX(), other.getY());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iName = (String)in.readObject();
        this.iExternalId = (String)in.readObject();
        this.iIgnoreTooFar = in.readBoolean();
        if (in.readBoolean()) {
            this.iX = in.readDouble();
            this.iY = in.readDouble();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iName);
        out.writeObject(this.iExternalId);
        out.writeBoolean(this.iIgnoreTooFar);
        out.writeBoolean(this.iX != null && this.iY != null);
        if (this.iX != null && this.iY != null) {
            out.writeDouble(this.iX);
            out.writeDouble(this.iY);
        }
    }

    public static class XRoomSerializer
    implements Externalizer<XRoom> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XRoom object) throws IOException {
            object.writeExternal(output);
        }

        public XRoom readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XRoom(input);
        }
    }
}

