/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.IndividualOverrideReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XIndividualReservationSerializer.class)
public class XIndividualReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private Set<Long> iStudentIds = new HashSet<Long>();
    private Integer iLimit = null;
    private Boolean iExpired = null;
    private boolean iOverride = false;
    private Boolean iBreakLinkedSections = null;

    public XIndividualReservation() {
    }

    public XIndividualReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XIndividualReservation(XOffering offering, IndividualReservation reservation) {
        super(XReservationType.Individual, offering, reservation);
        this.iOverride = false;
        for (Student student : reservation.getStudents()) {
            this.iStudentIds.add(student.getUniqueId());
        }
    }

    public XIndividualReservation(XOffering offering, OverrideReservation reservation) {
        super(XReservationType.IndividualOverride, offering, reservation);
        this.iOverride = reservation.isAlwaysExpired();
        for (Student student : reservation.getStudents()) {
            this.iStudentIds.add(student.getUniqueId());
        }
        this.setMustBeUsed(reservation.getOverrideType().isMustBeUsed());
        this.setAllowOverlap(reservation.getOverrideType().isAllowTimeConflict());
        this.setCanAssignOverLimit(reservation.getOverrideType().isAllowOverLimit());
        this.iExpired = reservation.getOverrideType().isExpired();
        this.iBreakLinkedSections = reservation.getOverrideType().isBreakLinkedSections();
    }

    public XIndividualReservation(XOffering offering, IndividualOverrideReservation reservation) {
        super(XReservationType.IndividualOverride, offering, reservation);
        this.iOverride = reservation.isAlwaysExpired();
        for (Student student : reservation.getStudents()) {
            this.iStudentIds.add(student.getUniqueId());
        }
        this.setMustBeUsed(reservation.isMustBeUsed());
        this.setAllowOverlap(reservation.isAllowOverlap());
        this.setCanAssignOverLimit(reservation.isCanAssignOverLimit());
        if (reservation.isAlwaysExpired()) {
            this.iExpired = true;
        } else {
            this.iType = XReservationType.Individual;
        }
    }

    public XIndividualReservation(org.cpsolver.studentsct.reservation.IndividualReservation reservation) {
        super(XReservationType.Individual, (Reservation)reservation);
        this.iOverride = false;
        this.iStudentIds.addAll(reservation.getStudentIds());
        this.iBreakLinkedSections = reservation.canBreakLinkedSections();
    }

    public XIndividualReservation(ReservationOverride reservation) {
        super(XReservationType.IndividualOverride, (Reservation)reservation);
        this.iOverride = true;
        this.iStudentIds.addAll(reservation.getStudentIds());
        this.iBreakLinkedSections = reservation.canBreakLinkedSections();
    }

    public XIndividualReservation(GroupReservation reservation) {
        super(XReservationType.Group, (Reservation)reservation);
        this.iOverride = false;
        this.iStudentIds.addAll(reservation.getStudentIds());
        this.iLimit = (int)Math.round(reservation.getReservationLimit());
        if (reservation.isAllowDisabled()) {
            this.setAllowDisabled(true);
        }
        this.iBreakLinkedSections = reservation.canBreakLinkedSections();
    }

    @Override
    public boolean isOverride() {
        return this.iOverride;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        return this.iStudentIds.contains(student.getStudentId());
    }

    public Set<Long> getStudentIds() {
        return this.iStudentIds;
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit == null ? this.iStudentIds.size() : this.iLimit.intValue();
    }

    @Override
    public boolean isExpired() {
        return this.getType() == XReservationType.IndividualOverride && this.iExpired != null ? this.iExpired.booleanValue() : super.isExpired();
    }

    @Override
    public boolean isAlwaysExpired() {
        return this.getType() == XReservationType.IndividualOverride && this.iExpired != null && this.iExpired != false;
    }

    @Override
    public boolean canBreakLinkedSections() {
        return this.iBreakLinkedSections == null ? false : this.iBreakLinkedSections;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int nrStudents = in.readInt();
        this.iStudentIds.clear();
        for (int i = 0; i < nrStudents; ++i) {
            this.iStudentIds.add(in.readLong());
        }
        this.iLimit = in.readInt();
        if (this.iLimit == -2) {
            this.iLimit = null;
        }
        if (this.getType() == XReservationType.IndividualOverride) {
            switch (in.readByte()) {
                case 0: {
                    this.iExpired = false;
                    break;
                }
                case 1: {
                    this.iExpired = true;
                    break;
                }
                default: {
                    this.iExpired = null;
                }
            }
            this.iOverride = in.readBoolean();
        } else {
            this.iExpired = null;
            this.iOverride = false;
        }
        switch (in.readByte()) {
            case 0: {
                this.iBreakLinkedSections = false;
                break;
            }
            case 1: {
                this.iBreakLinkedSections = true;
                break;
            }
            default: {
                this.iBreakLinkedSections = null;
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.iStudentIds.size());
        for (Long studentId : this.iStudentIds) {
            out.writeLong(studentId);
        }
        out.writeInt(this.iLimit == null ? -2 : this.iLimit);
        if (this.getType() == XReservationType.IndividualOverride) {
            out.writeByte(this.iExpired == null ? 2 : (this.iExpired != false ? 1 : 0));
            out.writeBoolean(this.iOverride);
        }
        out.writeByte(this.iBreakLinkedSections == null ? 2 : (this.iBreakLinkedSections != false ? 1 : 0));
    }

    public static class XIndividualReservationSerializer
    implements Externalizer<XIndividualReservation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XIndividualReservation object) throws IOException {
            object.writeExternal(output);
        }

        public XIndividualReservation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XIndividualReservation(input);
        }
    }
}

