/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XTime;

@SerializeWith(value=XAdvisorRequestSerializer.class)
public class XAdvisorRequest
implements Comparable<XAdvisorRequest>,
Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int iPriority;
    private int iAlternative;
    private boolean iSubstitute;
    private String iCourseName;
    private XCourseId iCourseId;
    private String iCredit;
    private String iNote;
    private int iCritical;
    private XTime iFreeTime;
    private List<XCourseRequest.XPreference> iPreferences = null;
    private Boolean iWaitList;
    private Boolean iNoSub;

    public XAdvisorRequest(AdvisorCourseRequest acr, OnlineSectioningHelper helper, BitSet freeTimePattern) {
        this.iPriority = acr.getPriority();
        this.iAlternative = acr.getAlternative();
        this.iSubstitute = acr.isSubstitute();
        this.iCritical = acr.getCritical() == null ? 0 : acr.getCritical();
        this.iCourseName = acr.getCourse();
        if (acr.getCourseOffering() != null) {
            this.iCourseId = new XCourseId(acr.getCourseOffering());
        }
        if (acr.getFreeTime() != null) {
            this.iFreeTime = new XTime(acr.getFreeTime(), freeTimePattern);
        }
        this.iCredit = acr.getCredit();
        this.iNote = acr.getNotes();
        if (acr.getPreferences() != null && !acr.getPreferences().isEmpty()) {
            this.iPreferences = new ArrayList<XCourseRequest.XPreference>();
            for (AdvisorSectioningPref p : acr.getPreferences()) {
                this.iPreferences.add(new XCourseRequest.XPreference(acr, p));
            }
        }
        this.iWaitList = acr.getWaitlist();
        this.iNoSub = acr.getNoSub();
    }

    public XAdvisorRequest(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iPriority = in.readInt();
        this.iAlternative = in.readInt();
        this.iSubstitute = in.readBoolean();
        this.iCourseName = (String)in.readObject();
        this.iCourseId = in.readBoolean() ? new XCourseId(in) : null;
        this.iCredit = (String)in.readObject();
        this.iNote = (String)in.readObject();
        this.iCritical = in.readInt();
        this.iFreeTime = in.readBoolean() ? new XTime(in) : null;
        int prefs = in.readInt();
        if (prefs < 0) {
            this.iPreferences = null;
        } else {
            this.iPreferences = new ArrayList<XCourseRequest.XPreference>(prefs);
            for (int i = 0; i < prefs; ++i) {
                this.iPreferences.add(new XCourseRequest.XPreference(in));
            }
        }
        this.iWaitList = (Boolean)in.readObject();
        this.iNoSub = (Boolean)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.iPriority);
        out.writeInt(this.iAlternative);
        out.writeBoolean(this.iSubstitute);
        out.writeObject(this.iCourseName);
        if (this.iCourseId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.iCourseId.writeExternal(out);
        }
        out.writeObject(this.iCredit);
        out.writeObject(this.iNote);
        out.writeInt(this.iCritical);
        if (this.iFreeTime == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.iFreeTime.writeExternal(out);
        }
        if (this.iPreferences == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.iPreferences.size());
            for (XCourseRequest.XPreference p : this.iPreferences) {
                p.writeExternal(out);
            }
        }
        out.writeObject(this.iWaitList);
        out.writeObject(this.iNoSub);
    }

    public int getPriority() {
        return this.iPriority;
    }

    public int getAlternative() {
        return this.iAlternative;
    }

    public boolean isSubstitute() {
        return this.iSubstitute;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public boolean hasCourseName() {
        return this.iCourseName != null && !this.iCourseName.isEmpty();
    }

    public XCourseId getCourseId() {
        return this.iCourseId;
    }

    public boolean hasCourseId() {
        return this.iCourseId != null;
    }

    public XTime getFreeTime() {
        return this.iFreeTime;
    }

    public boolean hasFreeTime() {
        return this.iFreeTime != null;
    }

    public String getCredit() {
        return this.iCredit;
    }

    public boolean hasCredit() {
        return this.iCredit != null && !this.iCredit.isEmpty();
    }

    public String getNote() {
        return this.iNote;
    }

    public boolean hasNote() {
        return this.iNote != null && !this.iNote.isEmpty();
    }

    public int getCritical() {
        return this.iCritical;
    }

    public boolean isCritical() {
        return this.iCritical > 0;
    }

    public boolean hasPreferences() {
        return this.iPreferences != null && !this.iPreferences.isEmpty();
    }

    public List<XCourseRequest.XPreference> getPreferences() {
        return this.iPreferences;
    }

    public Boolean getWaitList() {
        return this.iWaitList;
    }

    public boolean isWaitList() {
        return this.iWaitList != null && this.iWaitList != false;
    }

    public Boolean getNoSub() {
        return this.iNoSub;
    }

    public boolean isNoSub() {
        return this.iNoSub != null && this.iNoSub != false;
    }

    public boolean isWaitListOrNoSub() {
        return this.isWaitList() || this.isNoSub();
    }

    public float getCreditMin() {
        if (this.iCredit == null || this.iCredit.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.iCredit.replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iCredit.contains("-")) {
                try {
                    return Float.parseFloat(this.iCredit.substring(0, this.iCredit.indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    public float getCreditMax() {
        if (this.iCredit == null || this.iCredit.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.iCredit.replaceAll("\\s", ""));
        }
        catch (NumberFormatException numberFormatException) {
            if (this.iCredit.contains("-")) {
                try {
                    return Float.parseFloat(this.iCredit.substring(1 + this.iCredit.indexOf(45)).replaceAll("\\s", ""));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return 0.0f;
        }
    }

    @Override
    public int compareTo(XAdvisorRequest r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        if (this.getAlternative() != r.getAlternative()) {
            return this.getAlternative() < r.getAlternative() ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XAdvisorRequest)) {
            return false;
        }
        XAdvisorRequest ar = (XAdvisorRequest)o;
        return this.getPriority() == ar.getPriority() && this.getAlternative() == ar.getAlternative();
    }

    public int hashCode() {
        return 100 * this.getPriority() + this.getAlternative();
    }

    public static class XAdvisorRequestSerializer
    implements Externalizer<XAdvisorRequest> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XAdvisorRequest object) throws IOException {
            object.writeExternal(output);
        }

        public XAdvisorRequest readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XAdvisorRequest(input);
        }
    }
}

