/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.IOException;
import javax.servlet.ServletException;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.CriticalCoursesQuery;
import org.unitime.timetable.onlinesectioning.custom.purdue.DegreeWorksCourseRequests;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public class TestCriticalCourseProvider
implements CriticalCoursesProvider {
    CriticalCoursesProvider iSQL = new CriticalCoursesQuery();
    CriticalCoursesProvider iDGW = new DegreeWorksCourseRequests();
    Query iStudentQuery = new Query(ApplicationProperties.getProperty("purdue.critical.filter", "group:STAR group:VSTAR group:PREREG"));

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) {
        return this.getCriticalCourses(server, helper, student, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        CriticalCoursesProvider.CriticalCourses cc;
        XStudent student;
        XStudent xStudent = student = studentId instanceof XStudent ? (XStudent)studentId : server.getStudent(studentId.getStudentId());
        if (student == null) {
            return null;
        }
        if (this.iStudentQuery.match(new StatusPageSuggestionsAction.StudentMatcher(student, server.getAcademicSession().getDefaultSectioningStatus(), server, false)) && (cc = this.iDGW.getCriticalCourses(server, helper, student, action)) != null && !cc.isEmpty()) {
            return cc;
        }
        return this.iSQL.getCriticalCourses(server, helper, student, action);
    }

    @Override
    public void dispose() {
        this.iSQL.dispose();
        this.iDGW.dispose();
    }
}

