/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.DegreePlansProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.CriticalCoursesExplorers;
import org.unitime.timetable.onlinesectioning.custom.purdue.DegreeWorksCourseRequests;
import org.unitime.timetable.onlinesectioning.custom.purdue.EduNavPlansProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class EduNavPilotPlansProvider
implements DegreePlansProvider {
    private static Log sLog = LogFactory.getLog(EduNavPilotPlansProvider.class);
    private DegreePlansProvider iEduNav = new EduNavPlansProvider();
    private DegreePlansProvider iDGW;
    private DegreePlansProvider iFallback = this.iDGW = new DegreeWorksCourseRequests();

    public EduNavPilotPlansProvider() {
        try {
            String clazz = this.getEduNavFallbackProvider();
            if (clazz != null && !clazz.isEmpty()) {
                this.iFallback = (CriticalCoursesExplorers)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create fallback degree plan provider.");
        }
    }

    protected String getEduNavFallbackProvider() {
        return ApplicationProperties.getProperty("edunav.pilot.fallbackProvider");
    }

    protected String getCriticalPlaceholdersSQL() {
        return ApplicationProperties.getProperty("edunav.pilotSQL", "select count(*) from timetable.szvensa where szvensa_id = :externalId");
    }

    protected boolean isMarkEduNavPlanActive() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("edunav.pilot.markActive", "true"));
    }

    protected boolean isMarkAllEduNavPlansActive() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("edunav.pilot.markAllActive", "false"));
    }

    protected boolean getDegreeWorksActiveOnly() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.dgw.activeOnly", "true"));
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected boolean isStudentInPilot(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        SQLQuery query = helper.getHibSession().createSQLQuery(this.getCriticalPlaceholdersSQL());
        query.setString("externalId", this.getBannerId(student));
        return ((Number)query.uniqueResult()).intValue() > 0;
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, CourseMatcher matcher) throws SectioningException {
        if (this.isStudentInPilot(server, helper, student)) {
            boolean activeOnly = this.getDegreeWorksActiveOnly();
            ArrayList<DegreePlanInterface> plans = new ArrayList<DegreePlanInterface>();
            List<DegreePlanInterface> eduNavPlans = null;
            SectioningException eduNavErr = null;
            try {
                eduNavPlans = this.iEduNav.getDegreePlans(server, helper, student, matcher);
            }
            catch (SectioningException e) {
                eduNavErr = e;
            }
            List<DegreePlanInterface> dgwPlans = null;
            SectioningException dgwErr = null;
            try {
                dgwPlans = this.iDGW.getDegreePlans(server, helper, student, matcher);
            }
            catch (SectioningException e) {
                dgwErr = e;
            }
            if (eduNavPlans != null) {
                for (DegreePlanInterface plan : eduNavPlans) {
                    plan.setName("EduNav: " + plan.getName());
                    plans.add(plan);
                }
                if (!activeOnly && dgwPlans != null && !dgwPlans.isEmpty()) {
                    if (plans.size() == 1 && this.isMarkEduNavPlanActive()) {
                        ((DegreePlanInterface)plans.get(0)).setActive(true);
                    }
                    if (plans.size() > 1 && this.isMarkAllEduNavPlansActive()) {
                        for (DegreePlanInterface plan : plans) {
                            plan.setActive(true);
                        }
                    }
                }
            }
            if (dgwPlans != null) {
                for (DegreePlanInterface plan : dgwPlans) {
                    plan.setName("DegreeWorks: " + plan.getName());
                    if (activeOnly) {
                        plan.setActive(false);
                    }
                    plans.add(plan);
                }
            }
            if (!plans.isEmpty()) {
                return plans;
            }
            if (eduNavErr != null) {
                throw eduNavErr;
            }
            if (dgwErr != null) {
                throw dgwErr;
            }
            return plans;
        }
        return this.iFallback.getDegreePlans(server, helper, student, matcher);
    }

    @Override
    public void dispose() {
        this.iEduNav.dispose();
        this.iDGW.dispose();
    }
}

