/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;
import org.unitime.timetable.onlinesectioning.custom.CustomClassAttendanceProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationDashboardUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;
import org.unitime.timetable.util.Formats;

public class GetAssignment
extends WaitlistedOnlineSectioningAction<ClassAssignmentInterface> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    private Long iStudentId;
    private List<StudentEnrollmentProvider.EnrollmentFailure> iMessages;
    private Set<ClassAssignmentInterface.ErrorMessage> iErrors;
    private boolean iIncludeRequest = false;
    private boolean iCustomCheck = false;
    private boolean iWaitListCheck = false;
    private boolean iIncludeAdvisorRequest = false;
    private boolean iCheckHolds = false;
    private boolean iGetSpecRegs = false;
    private OnlineSectioningInterface.WaitListMode iWaitListMode = null;
    private boolean iIncludeWaitListPosition = false;

    public GetAssignment forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public GetAssignment withMessages(List<StudentEnrollmentProvider.EnrollmentFailure> messages) {
        this.iMessages = messages;
        return this;
    }

    public GetAssignment withErrors(Set<ClassAssignmentInterface.ErrorMessage> errors) {
        this.iErrors = errors;
        return this;
    }

    public GetAssignment withRequest(boolean includeRequest) {
        this.iIncludeRequest = includeRequest;
        return this;
    }

    public GetAssignment withWaitListPosition(boolean includeWaitListPosition) {
        this.iIncludeWaitListPosition = includeWaitListPosition;
        return this;
    }

    public GetAssignment withAdvisorRequest(boolean includeRequest) {
        this.iIncludeAdvisorRequest = includeRequest;
        return this;
    }

    public GetAssignment withCustomCheck(boolean customCheck) {
        this.iCustomCheck = customCheck;
        return this;
    }

    public GetAssignment withWaitListCheck(boolean waitListCheck) {
        this.iWaitListCheck = waitListCheck;
        return this;
    }

    public GetAssignment checkHolds(boolean check) {
        this.iCheckHolds = check;
        return this;
    }

    public GetAssignment withSpecialRegistrations(boolean specReg) {
        this.iGetSpecRegs = specReg;
        return this;
    }

    public GetAssignment withWaitListMode(OnlineSectioningInterface.WaitListMode wlMode) {
        this.iWaitListMode = wlMode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Object provider2;
        XStudent student = null;
        ClassAssignmentInterface ret = null;
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            student = server.getStudent(this.iStudentId);
            if (student == null) {
                ClassAssignmentInterface classAssignmentInterface = null;
                return classAssignmentInterface;
            }
            if (this.iWaitListMode == null) {
                this.iWaitListMode = student.getWaitListMode(helper);
            }
            ret = this.computeAssignment(server, helper, student, student.getRequests(), this.iMessages, this.iErrors, this.iIncludeRequest, this.iWaitListMode);
            if (this.iIncludeAdvisorRequest) {
                ret.setAdvisorRequest(AdvisorGetCourseRequests.getRequest(student, server, helper));
                ret.setAdvisorWaitListedCourseIds(student.getAdvisorWaitListedCourseIds(server));
                if (ret.hasAdvisorRequest()) {
                    for (OnlineSectioningLog.Request log : OnlineSectioningHelper.toProto(ret.getAdvisorRequest())) {
                        helper.getAction().addRecommendation(log);
                    }
                }
            }
        }
        finally {
            lock.release();
        }
        if (ret.hasRequest() && this.iCustomCheck && CustomCourseRequestsValidationHolder.hasProvider()) {
            CustomCourseRequestsValidationHolder.getProvider().check(server, helper, ret.getRequest());
        }
        if (ret.hasRequest() && this.iWaitListCheck && this.iWaitListMode == OnlineSectioningInterface.WaitListMode.WaitList && Customization.WaitListValidationProvider.hasProvider()) {
            WaitListValidationProvider wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
            wp.check(server, helper, ret.getRequest());
        }
        if (this.iCheckHolds && ret.hasRequest() && Customization.StudentHoldsCheckProvider.hasProvider()) {
            try {
                provider2 = (StudentHoldsCheckProvider)Customization.StudentHoldsCheckProvider.getProvider();
                ret.getRequest().setErrorMessage(provider2.getStudentHoldError(server, helper, student));
            }
            catch (Exception provider2) {
                // empty catch block
            }
        }
        if (this.iCheckHolds && ret.hasRequest() && Customization.SpecialRegistrationDashboardUrlProvider.hasProvider()) {
            try {
                provider2 = (SpecialRegistrationDashboardUrlProvider)Customization.SpecialRegistrationDashboardUrlProvider.getProvider();
                ret.getRequest().setSpecRegDashboardUrl(provider2.getDashboardUrl(server, helper, student));
            }
            catch (Exception provider3) {
                // empty catch block
            }
        }
        if (this.iGetSpecRegs && Customization.SpecialRegistrationProvider.hasProvider()) {
            try {
                SpecialRegistrationProvider sp = (SpecialRegistrationProvider)Customization.SpecialRegistrationProvider.getProvider();
                ret.setSpecialRegistrations(sp.retrieveAllRegistrations(server, helper, student));
            }
            catch (Exception e) {
                helper.warn("Failed to retrieve special registrations: " + e.getMessage(), e);
            }
        }
        return ret;
    }

    public static List<CourseSection> fillUnavailabilitiesIn(ClassAssignmentInterface ret, XStudent student, OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningLog.Enrollment.Builder eb) {
        if (student.getExternalId() == null || student.getExternalId().isEmpty()) {
            return null;
        }
        ArrayList<CourseSection> sections = new ArrayList<CourseSection>();
        Collection<Long> offeringIds = server.getInstructedOfferings(student.getExternalId());
        if (offeringIds != null && !offeringIds.isEmpty()) {
            TreeSet<XOffering> offerings = new TreeSet<XOffering>(new Comparator<XOffering>(){

                @Override
                public int compare(XOffering o1, XOffering o2) {
                    int cmp = o1.getName().compareTo(o2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return o1.getOfferingId().compareTo(o2.getOfferingId());
                }
            });
            for (Long offeringId : offeringIds) {
                XOffering offering = server.getOffering(offeringId);
                if (offering == null) continue;
                offerings.add(offering);
            }
            for (XOffering offering : offerings) {
                ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
                XCourse course = offering.getControllingCourse();
                XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                if (server.isOfferingLocked(course.getOfferingId())) {
                    ca.setLocked(true);
                }
                ca.setCanWaitList(offering.isWaitList());
                ca.setAssigned(true);
                ca.setCourseId(course.getCourseId());
                ca.setSubject(course.getSubjectArea());
                ca.setCourseNbr(course.getCourseNumber());
                ca.setTitle(course.getTitle());
                ca.setTeachingAssignment(true);
                ca.setHasCrossList(offering.hasCrossList());
                ca.setCanWaitList(offering.isWaitList());
                HashSet<Long> added = new HashSet<Long>();
                for (XConfig config : offering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            if (section.isCancelled()) continue;
                            for (XInstructor instructor : section.getAllInstructors()) {
                                if (!student.getExternalId().equals(instructor.getExternalId()) || !added.add(section.getSectionId())) continue;
                                if (eb != null) {
                                    eb.addSection(OnlineSectioningHelper.toProto(section, null));
                                }
                                ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                                a.setAlternative(false);
                                a.setClassId(section.getSectionId());
                                a.setSubpart(subpart.getName());
                                a.setClassNumber(section.getName(-1L));
                                a.setSection(section.getName(course.getCourseId()));
                                a.setExternalId(section.getExternalId(course.getCourseId()));
                                a.setCancelled(section.isCancelled());
                                a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                                if (section.getTime() != null) {
                                    for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                        a.addDay(d.getIndex());
                                    }
                                    a.setStart(section.getTime().getSlot());
                                    a.setLength(section.getTime().getLength());
                                    a.setBreakTime(section.getTime().getBreakTime());
                                    a.setDatePattern(section.getTime().getDatePatternName());
                                }
                                if (section.getRooms() != null) {
                                    for (XRoom room : section.getRooms()) {
                                        a.addRoom(room.getUniqueId(), room.getName());
                                    }
                                }
                                for (XInstructor instr : section.getInstructors()) {
                                    a.addInstructor(instr.getName());
                                    a.addInstructoEmail(instr.getEmail() == null ? "" : instr.getEmail());
                                }
                                if (section.getParentId() != null) {
                                    a.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                                }
                                a.setSubpartId(section.getSubpartId());
                                a.setHasAlternatives(false);
                                a.addNote(course.getNote());
                                a.addNote(section.getNote());
                                a.setCredit(subpart.getCredit(course.getCourseId()));
                                a.setCreditRange(Float.valueOf(subpart.getCreditMin(course.getCourseId())), Float.valueOf(subpart.getCreditMax(course.getCourseId())));
                                Float creditOverride = section.getCreditOverride(course.getCourseId());
                                if (creditOverride != null) {
                                    a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                                }
                                a.setTeachingAssignment(true);
                                a.setInstructing(instructor.isInstructing());
                                sections.add(new CourseSection(course, section));
                            }
                        }
                    }
                }
                ret.add(ca);
            }
        }
        return sections;
    }

    /*
     * WARNING - void declaration
     */
    public ClassAssignmentInterface computeAssignment(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XRequest> studentRequests, List<StudentEnrollmentProvider.EnrollmentFailure> messages, Set<ClassAssignmentInterface.ErrorMessage> errors, boolean includeRequest, OnlineSectioningInterface.WaitListMode wlMode) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
        DistanceMetric m = server.getDistanceMetric();
        OverExpectedCriterion overExp = server.getOverExpectedCriterion();
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()));
        action.getStudentBuilder().setExternalId(student.getExternalId());
        action.getStudentBuilder().setName(student.getName());
        ClassAssignmentInterface ret = new ClassAssignmentInterface();
        int nrUnassignedCourses = 0;
        int nrAssignedAlt = 0;
        OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
        stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
        boolean setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue();
        if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER) {
            setReadOnly = ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue();
        }
        boolean showWaitListPosition = this.iIncludeWaitListPosition || ApplicationProperty.OnlineSchedulingShowWaitListPosition.isTrue();
        List<CourseSection> unavailabilities = GetAssignment.fillUnavailabilitiesIn(ret, student, server, helper, stored);
        CustomClassAttendanceProvider provider = (CustomClassAttendanceProvider)Customization.CustomClassAttendanceProvider.getProvider();
        CustomClassAttendanceProvider.StudentClassAttendance attendance = provider == null ? null : provider.getCustomClassAttendanceForStudent((Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession()), helper, null);
        HashMap wlOverlaps = null;
        float credit = 0.0f;
        if (student.getMaxCredit() != null) {
            for (XRequest xRequest : studentRequests) {
                Float c;
                XOffering offering;
                XCourse xCourse;
                XCourseRequest r;
                XEnrollment enrollment;
                if (!(xRequest instanceof XCourseRequest) || (enrollment = (r = (XCourseRequest)xRequest).getEnrollment()) == null || (xCourse = (offering = server.getOffering(enrollment.getOfferingId())).getCourse(enrollment)) == null || (c = xCourse.getMinCredit()) == null) continue;
                credit += c.floatValue();
            }
        }
        for (XRequest xRequest : studentRequests) {
            XRequest r;
            action.addRequest(OnlineSectioningHelper.toProto(xRequest));
            ClassAssignmentInterface.CourseAssignment ca = new ClassAssignmentInterface.CourseAssignment();
            if (xRequest instanceof XCourseRequest) {
                r = (XCourseRequest)xRequest;
                XEnrollment enrollment = ((XCourseRequest)r).getEnrollment();
                XEnrollment xEnrollment = enrollment == null ? ((XCourseRequest)r).getCourseIds().get(0) : enrollment;
                XOffering offering = server.getOffering(xEnrollment.getOfferingId());
                XExpectations expectations = server.getExpectations(xEnrollment.getOfferingId());
                Iterator<DayCode> course = offering.getCourse(xEnrollment);
                if (xRequest.isAlternative() && nrAssignedAlt >= nrUnassignedCourses && enrollment == null) continue;
                if (xRequest.isAlternative() && enrollment != null) {
                    ++nrAssignedAlt;
                }
                if (server.isOfferingLocked(((XCourseId)((Object)course)).getOfferingId())) {
                    ca.setLocked(true);
                }
                ca.setCanWaitList(offering.isWaitList());
                ca.setAssigned(enrollment != null);
                ca.setCourseId(((XCourseId)((Object)course)).getCourseId());
                ca.setSubject(((XCourseId)((Object)course)).getSubjectArea());
                ca.setCourseNbr(((XCourseId)((Object)course)).getCourseNumber());
                ca.setTitle(((XCourseId)((Object)course)).getTitle());
                ca.setEnrollmentMessage(((XCourseRequest)r).getEnrollmentMessage());
                ca.setRequestedDate(((XCourseRequest)r).getTimeStamp());
                if (offering.isWaitList() && ((XCourseRequest)r).isWaitlist(wlMode)) {
                    ca.setWaitListedDate(((XCourseRequest)r).getWaitListedTimeStamp());
                }
                ca.setHasCrossList(offering.hasCrossList());
                if (enrollment == null) {
                    if (((XCourseRequest)r).isWaitlist() && offering.isWaitList()) {
                        AssignmentMap assignment = new AssignmentMap();
                        CourseRequest courseRequest = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, (XCourseRequest)r, server, wlMode);
                        List list = courseRequest.getEnrollmentsSkipSameTime((Assignment)assignment);
                        for (Course course2 : courseRequest.getCourses()) {
                            Object enrl22;
                            XOffering off = course2.getId() == xEnrollment.getCourseId().longValue() ? offering : server.getOffering(course2.getOffering().getId());
                            if (off == null || !off.isWaitList()) continue;
                            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                                @Override
                                public int compare(Enrollment o1, Enrollment o2) {
                                    return o1.getRequest().compareTo(o2.getRequest());
                                }
                            });
                            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                            Object noConfEnrl = null;
                            int nbrEnrl = 0;
                            for (Object enrl22 : list) {
                                if (!course2.equals((Object)enrl22.getCourse())) continue;
                                ++nbrEnrl;
                                boolean overlaps = false;
                                for (Request q : enrl22.getStudent().getRequests()) {
                                    if (q.equals((Object)enrl22.getRequest())) continue;
                                    Enrollment x = (Enrollment)assignment.getValue((Variable)q);
                                    if (q instanceof FreeTimeRequest) {
                                        if (!GetAssignment.isFreeTimeOverlapping((FreeTimeRequest)q, (Enrollment)enrl22)) continue;
                                        overlaps = true;
                                        overlap.add(((FreeTimeRequest)q).createEnrollment());
                                        continue;
                                    }
                                    if (x == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                    for (SctAssignment a2 : x.getAssignments()) {
                                        if (!a2.isOverlapping(enrl22.getAssignments())) continue;
                                        overlaps = true;
                                        overlap.add(x);
                                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                                        CourseRequest cr = (CourseRequest)x.getRequest();
                                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                        if (ss == null) {
                                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                                            overlapingSections.put(cr, ss);
                                        }
                                        ss.add((Section)a2);
                                    }
                                }
                                if (overlaps || noConfEnrl != null) continue;
                                noConfEnrl = enrl22;
                            }
                            if (noConfEnrl != null) continue;
                            if (wlOverlaps == null) {
                                wlOverlaps = new HashMap();
                            }
                            TreeSet<String> overlaps = new TreeSet<String>();
                            wlOverlaps.put(course2.getId(), overlaps);
                            enrl22 = overlap.iterator();
                            while (enrl22.hasNext()) {
                                Enrollment q = (Enrollment)enrl22.next();
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    String ov = OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest());
                                    overlaps.add(ov);
                                    if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue;
                                    ca.addOverlap(ov);
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = ov + ",";
                                    }
                                }
                                overlaps.add(ov);
                                if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue;
                                ca.addOverlap(ov);
                            }
                            if (nbrEnrl != 0) continue;
                            enrl22 = courseRequest.getStudent().getUnavailabilities().iterator();
                            block8: while (enrl22.hasNext()) {
                                Unavailability unavailability = (Unavailability)enrl22.next();
                                for (Config config : course2.getOffering().getConfigs()) {
                                    for (Subpart subpart : config.getSubparts()) {
                                        for (Section section : subpart.getSections()) {
                                            if (!unavailability.isOverlapping((SctAssignment)section)) continue;
                                            String ov = MSG.teachingAssignment(unavailability.getSection().getName());
                                            overlaps.add(ov);
                                            if (course2.getId() != ((XCourseId)((Object)course)).getCourseId().longValue()) continue block8;
                                            ca.addOverlap(ov);
                                            continue block8;
                                        }
                                    }
                                }
                            }
                        }
                        if (student.getMaxCredit() != null) {
                            Float minCred = ((XCourse)((Object)course)).getMinCredit();
                            for (XCourseId altCourseId : ((XCourseRequest)r).getCourseIds()) {
                                XOffering altOffering;
                                XCourse altCourse;
                                Float altMinCred;
                                if (altCourseId.equals(xEnrollment) || (altMinCred = (altCourse = (altOffering = server.getOffering(altCourseId.getOfferingId())).getCourse(altCourseId)).getMinCredit()) == null || minCred != null && !(minCred.floatValue() > altMinCred.floatValue())) continue;
                                minCred = altMinCred;
                            }
                            if (minCred != null && credit + minCred.floatValue() > student.getMaxCredit().floatValue()) {
                                ca.setOverMaxCredit(student.getMaxCredit());
                            }
                        }
                    } else {
                        TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                            @Override
                            public int compare(Enrollment o1, Enrollment o2) {
                                return o1.getRequest().compareTo(o2.getRequest());
                            }
                        });
                        Hashtable overlapingSections = new Hashtable();
                        AssignmentMap assignmentMap = new AssignmentMap();
                        CourseRequest crq = SectioningRequest.convert((Assignment<Request, Enrollment>)assignmentMap, (XCourseRequest)r, server, wlMode);
                        List list = crq.getAvaiableEnrollmentsSkipSameTime((Assignment)assignmentMap);
                        for (Enrollment enrl : list) {
                            for (Request q : enrl.getStudent().getRequests()) {
                                Enrollment x;
                                if (q.equals((Object)enrl.getRequest()) || (x = (Enrollment)assignmentMap.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                for (SctAssignment a3 : x.getAssignments()) {
                                    if (!a3.isOverlapping(enrl.getAssignments())) continue;
                                    overlap.add(x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    CourseRequest cr = (CourseRequest)x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignmentMap));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a3);
                                }
                            }
                        }
                        for (Enrollment q : overlap) {
                            if (q.getRequest() instanceof FreeTimeRequest) {
                                ca.addOverlap(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                continue;
                            }
                            CourseRequest cr = (CourseRequest)q.getRequest();
                            Course o = q.getCourse();
                            String ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                            if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                while (i.hasNext()) {
                                    Section s = (Section)i.next();
                                    ov = ov + " " + s.getSubpart().getName();
                                    if (!i.hasNext()) continue;
                                    ov = ov + ",";
                                }
                            }
                            ca.addOverlap(ov);
                        }
                        if (list.isEmpty()) {
                            ca.setNotAvailable(true);
                            if (((XCourse)((Object)course)).getLimit() >= 0) {
                                Collection<XCourseRequest> requests = server.getRequests(((XCourseId)((Object)course)).getOfferingId());
                                int enrl = 0;
                                if (requests != null) {
                                    for (XCourseRequest x : requests) {
                                        if (x.getEnrollment() == null || !x.getEnrollment().getCourseId().equals(((XCourseId)((Object)course)).getCourseId())) continue;
                                        ++enrl;
                                    }
                                }
                                ca.setFull(enrl >= ((XCourse)((Object)course)).getLimit());
                            }
                            ca.setHasIncompReqs(SectioningRequest.hasInconsistentRequirements(crq, ((XCourseId)((Object)course)).getCourseId()));
                        }
                        if (student.getMaxCredit() != null) {
                            Float minCred = ((XCourse)((Object)course)).getMinCredit();
                            for (XCourseId altCourseId : ((XCourseRequest)r).getCourseIds()) {
                                XOffering altOffering;
                                XCourse altCourse;
                                Float altMinCred;
                                if (altCourseId.equals(xEnrollment) || (altMinCred = (altCourse = (altOffering = server.getOffering(altCourseId.getOfferingId())).getCourse(altCourseId)).getMinCredit()) == null || minCred != null && !(minCred.floatValue() > altMinCred.floatValue())) continue;
                                minCred = altMinCred;
                            }
                            if (minCred != null && credit + minCred.floatValue() > student.getMaxCredit().floatValue()) {
                                ca.setOverMaxCredit(student.getMaxCredit());
                            }
                        }
                    }
                    if (!((XCourseRequest)r).isWaitListOrNoSub(wlMode)) {
                        // empty if block
                    }
                    int alt = ++nrUnassignedCourses;
                    for (XRequest xRequest2 : studentRequests) {
                        XEnrollment otherEnrollment;
                        if (!(xRequest2 instanceof XCourseRequest) || xRequest2.equals(xRequest) || (otherEnrollment = ((XCourseRequest)xRequest2).getEnrollment()) == null || !xRequest2.isAlternative() || --alt != 0) continue;
                        XOffering xOffering = server.getOffering(otherEnrollment.getOfferingId());
                        XCourse otherCourse = xOffering.getCourse(otherEnrollment.getCourseId());
                        ca.setInstead(MSG.course(otherCourse.getSubjectArea(), otherCourse.getCourseNumber()));
                        break;
                    }
                } else {
                    Object subpart2;
                    List<XSection> sections = offering.getSections(enrollment);
                    boolean hasAlt = false;
                    if (((XCourseRequest)r).getCourseIds().size() > 1) {
                        hasAlt = true;
                    } else if (offering.getConfigs().size() > 1) {
                        hasAlt = true;
                    } else {
                        for (Object subpart2 : offering.getConfigs().get(0).getSubparts()) {
                            if (((XSubpart)subpart2).getSections().size() <= 1) continue;
                            hasAlt = true;
                            break;
                        }
                    }
                    XEnrollments xEnrollments = server.getEnrollments(offering.getOfferingId());
                    subpart2 = sections.iterator();
                    while (subpart2.hasNext()) {
                        String consent;
                        XSection xSection = subpart2.next();
                        stored.addSection(OnlineSectioningHelper.toProto(xSection, enrollment));
                        ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                        a.setAlternative(r.isAlternative());
                        a.setClassId(xSection.getSectionId());
                        XSubpart subpart3 = offering.getSubpart(xSection.getSubpartId());
                        a.setSubpart(subpart3.getName());
                        a.setClassNumber(xSection.getName(-1L));
                        a.setSection(xSection.getName(((XCourseId)((Object)course)).getCourseId()));
                        a.setExternalId(xSection.getExternalId(((XCourseId)((Object)course)).getCourseId()));
                        a.setCancelled(xSection.isCancelled());
                        a.setLimit(new int[]{xEnrollments.countEnrollmentsForSection(xSection.getSectionId()), xSection.getLimit()});
                        if (xSection.getTime() != null) {
                            for (DayCode d : DayCode.toDayCodes(xSection.getTime().getDays())) {
                                a.addDay(d.getIndex());
                            }
                            a.setStart(xSection.getTime().getSlot());
                            a.setLength(xSection.getTime().getLength());
                            a.setBreakTime(xSection.getTime().getBreakTime());
                            a.setDatePattern(xSection.getTime().getDatePatternName());
                        }
                        if (xSection.getRooms() != null) {
                            for (XRoom room : xSection.getRooms()) {
                                a.addRoom(room.getUniqueId(), room.getName());
                            }
                        }
                        for (XInstructor instructor : xSection.getInstructors()) {
                            a.addInstructor(instructor.getName());
                            a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                        }
                        if (xSection.getParentId() != null) {
                            a.setParentSection(offering.getSection(xSection.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                        }
                        a.setSubpartId(xSection.getSubpartId());
                        a.setHasAlternatives(hasAlt);
                        a.addNote(((XCourse)((Object)course)).getNote());
                        a.addNote(xSection.getNote());
                        if (attendance != null) {
                            a.addNote(attendance.getClassNote(xSection.getExternalId(((XCourseId)((Object)course)).getCourseId())));
                        }
                        a.setCredit(subpart3.getCredit(((XCourseId)((Object)course)).getCourseId()));
                        a.setCreditRange(Float.valueOf(subpart3.getCreditMin(((XCourseId)((Object)course)).getCourseId())), Float.valueOf(subpart3.getCreditMax(((XCourseId)((Object)course)).getCourseId())));
                        Float creditOverride = xSection.getCreditOverride(((XCourseId)((Object)course)).getCourseId());
                        if (creditOverride != null) {
                            a.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                        }
                        a.setEnrolledDate(enrollment.getTimeStamp());
                        int dist = 0;
                        String from = null;
                        TreeSet<String> overlap = new TreeSet<String>();
                        for (XRequest q : studentRequests) {
                            XEnrollment otherEnrollment;
                            if (!(q instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)q).getEnrollment()) == null) continue;
                            XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                            for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                                if (otherSection.equals(xSection) || otherSection.getTime() == null) continue;
                                int d = otherSection.getDistanceInMinutes(xSection, m);
                                if (d > dist) {
                                    dist = d;
                                    from = "";
                                    Iterator<XRoom> k = otherSection.getRooms().iterator();
                                    while (k.hasNext()) {
                                        from = from + k.next().getName() + (k.hasNext() ? ", " : "");
                                    }
                                }
                                if (otherSection.isDistanceConflict(student, xSection, m)) {
                                    a.setDistanceConflict(true);
                                }
                                if (xSection.getTime() == null || !xSection.getTime().hasIntersection(otherSection.getTime()) || xSection.isToIgnoreStudentConflictsWith(offering.getDistributions(), otherSection.getSectionId())) continue;
                                XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                                XSubpart otherSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                                overlap.add(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), otherSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                            }
                        }
                        if (unavailabilities != null) {
                            for (CourseSection cs : unavailabilities) {
                                if (xSection.getTime() == null || !xSection.getTime().hasIntersection(cs.getSection().getTime())) continue;
                                overlap.add(MSG.teachingAssignment(MSG.clazz(cs.getCourse().getSubjectArea(), cs.getCourse().getCourseNumber(), cs.getSection().getSubpartName(), cs.getSection().getName(cs.getCourse().getCourseId()))));
                            }
                        }
                        if (!overlap.isEmpty()) {
                            String note = null;
                            Iterator j = overlap.iterator();
                            while (j.hasNext()) {
                                String n = (String)j.next();
                                if (note == null) {
                                    note = MSG.noteAllowedOverlapFirst(n);
                                    continue;
                                }
                                if (j.hasNext()) {
                                    note = note + MSG.noteAllowedOverlapMiddle(n);
                                    continue;
                                }
                                note = note + MSG.noteAllowedOverlapLast(n);
                            }
                            a.setOverlapNote(note);
                        }
                        a.setBackToBackDistance(dist);
                        a.setBackToBackRooms(from);
                        a.setSaved(true);
                        if (a.getParentSection() == null && (consent = server.getCourse(((XCourseId)((Object)course)).getCourseId()).getConsentLabel()) != null) {
                            if (enrollment.getApproval() != null) {
                                a.setParentSection(MSG.consentApproved(df.format(enrollment.getApproval().getTimeStamp())));
                            } else {
                                a.setParentSection(MSG.consentWaiting(consent.toLowerCase()));
                            }
                        }
                        a.setExpected(overExp.getExpected(xSection.getLimit(), expectations.getExpectedSpace(xSection.getSectionId()).doubleValue()));
                    }
                }
                if (messages != null) {
                    XEnrollments enrollments = server.getEnrollments(offering.getOfferingId());
                    block31: for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : messages) {
                        XSection section2 = enrollmentFailure.getSection();
                        if (!enrollmentFailure.getCourse().getCourseId().equals(ca.getCourseId())) continue;
                        for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                            if (!enrollmentFailure.getSection().getSectionId().equals(a.getClassId())) continue;
                            if (enrollmentFailure.isError()) {
                                a.addError(enrollmentFailure.getMessage());
                                continue block31;
                            }
                            if (enrollmentFailure.isWarning()) {
                                a.addWarn(enrollmentFailure.getMessage());
                                continue block31;
                            }
                            a.addInfo(enrollmentFailure.getMessage());
                            continue block31;
                        }
                        ca.setAssigned(true);
                        ClassAssignmentInterface.ClassAssignment classAssignment = ca.addClassAssignment();
                        classAssignment.setAlternative(r.isAlternative());
                        classAssignment.setClassId(section2.getSectionId());
                        XSubpart subpart = offering.getSubpart(section2.getSubpartId());
                        classAssignment.setSubpart(subpart.getName());
                        classAssignment.setClassNumber(section2.getName(-1L));
                        classAssignment.setSection(section2.getName(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setExternalId(section2.getExternalId(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setCancelled(section2.isCancelled());
                        classAssignment.setLimit(new int[]{enrollments.countEnrollmentsForSection(section2.getSectionId()), section2.getLimit()});
                        if (section2.getTime() != null) {
                            for (DayCode d : DayCode.toDayCodes(section2.getTime().getDays())) {
                                classAssignment.addDay(d.getIndex());
                            }
                            classAssignment.setStart(section2.getTime().getSlot());
                            classAssignment.setLength(section2.getTime().getLength());
                            classAssignment.setBreakTime(section2.getTime().getBreakTime());
                            classAssignment.setDatePattern(section2.getTime().getDatePatternName());
                        }
                        if (section2.getRooms() != null) {
                            for (XRoom room : section2.getRooms()) {
                                classAssignment.addRoom(room.getUniqueId(), room.getName());
                            }
                        }
                        for (XInstructor instructor : section2.getInstructors()) {
                            classAssignment.addInstructor(instructor.getName());
                            classAssignment.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                        }
                        if (section2.getParentId() != null) {
                            classAssignment.setParentSection(offering.getSection(section2.getParentId()).getName(((XCourseId)((Object)course)).getCourseId()));
                        }
                        classAssignment.setSubpartId(section2.getSubpartId());
                        classAssignment.addNote(((XCourse)((Object)course)).getNote());
                        classAssignment.addNote(section2.getNote());
                        if (attendance != null) {
                            classAssignment.addNote(attendance.getClassNote(section2.getExternalId(((XCourseId)((Object)course)).getCourseId())));
                        }
                        classAssignment.setCredit(subpart.getCredit(((XCourseId)((Object)course)).getCourseId()));
                        classAssignment.setCreditRange(Float.valueOf(subpart.getCreditMin(((XCourseId)((Object)course)).getCourseId())), Float.valueOf(subpart.getCreditMax(((XCourseId)((Object)course)).getCourseId())));
                        Float creditOverride = section2.getCreditOverride(((XCourseId)((Object)course)).getCourseId());
                        if (creditOverride != null) {
                            classAssignment.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                        }
                        int dist = 0;
                        String from = null;
                        classAssignment.setBackToBackDistance(dist);
                        classAssignment.setBackToBackRooms(from);
                        classAssignment.setSaved(false);
                        classAssignment.setDummy(true);
                        if (enrollmentFailure.isError()) {
                            classAssignment.setError(enrollmentFailure.getMessage());
                        } else if (enrollmentFailure.isWarning()) {
                            classAssignment.setWarn(enrollmentFailure.getMessage());
                        } else {
                            classAssignment.setInfo(enrollmentFailure.getMessage());
                        }
                        classAssignment.setExpected(overExp.getExpected(section2.getLimit(), expectations.getExpectedSpace(section2.getSectionId()).doubleValue()));
                    }
                }
                if (errors != null) {
                    for (ClassAssignmentInterface.ErrorMessage f : errors) {
                        if (!ca.getCourseName().equals(f.getCourse())) continue;
                        for (ClassAssignmentInterface.ClassAssignment a5 : ca.getClassAssignments()) {
                            if (!a5.getExternalId().equals(f.getSection())) continue;
                            a5.addError(f.getMessage());
                        }
                    }
                }
            } else if (xRequest instanceof XFreeTimeRequest) {
                r = (XFreeTimeRequest)xRequest;
                ca.setCourseId(null);
                for (XRequest xRequest3 : studentRequests) {
                    XEnrollment otherEnrollment;
                    if (!(xRequest3 instanceof XCourseRequest) || (otherEnrollment = ((XCourseRequest)xRequest3).getEnrollment()) == null) continue;
                    XOffering otherOffering = server.getOffering(otherEnrollment.getOfferingId());
                    for (XSection otherSection : otherOffering.getSections(otherEnrollment)) {
                        if (otherSection.getTime() == null || !otherSection.getTime().hasIntersection(((XFreeTimeRequest)r).getTime())) continue;
                        XCourse otherCourse = otherOffering.getCourse(otherEnrollment.getCourseId());
                        XSubpart xSubpart = otherOffering.getSubpart(otherSection.getSubpartId());
                        ca.addOverlap(MSG.clazz(otherCourse.getSubjectArea(), otherCourse.getCourseNumber(), xSubpart.getName(), otherSection.getName(otherCourse.getCourseId())));
                    }
                }
                ca.setAssigned(ca.getOverlaps() == null);
                ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
                a.setAlternative(r.isAlternative());
                for (DayCode d : DayCode.toDayCodes(((XFreeTimeRequest)r).getTime().getDays())) {
                    a.addDay(d.getIndex());
                }
                a.setStart(((XFreeTimeRequest)r).getTime().getSlot());
                a.setLength(((XFreeTimeRequest)r).getTime().getLength());
            }
            ret.add(ca);
        }
        action.addEnrollment(stored);
        if (errors != null) {
            for (ClassAssignmentInterface.ErrorMessage errorMessage : errors) {
                ret.addError(errorMessage);
            }
        }
        if (messages != null) {
            HashSet<String> added = new HashSet<String>();
            for (StudentEnrollmentProvider.EnrollmentFailure f : messages) {
                if (f.hasErrors()) {
                    for (StudentEnrollmentProvider.EnrollmentError err : f.getErrors()) {
                        ret.addError(new ClassAssignmentInterface.ErrorMessage(f.getCourse().getCourseName(), f.getSection().getExternalId(f.getCourse().getCourseId()), err.getCode(), err.getMessage()));
                    }
                }
                for (String fm : f.getMessage().split("\n")) {
                    String message = MSG.clazz(f.getCourse().getSubjectArea(), f.getCourse().getCourseNumber(), f.getSection().getSubpartName(), f.getSection().getName(f.getCourse().getCourseId())) + ": " + fm;
                    if (!added.add(message)) continue;
                    ret.addMessage(message);
                }
            }
        }
        if (includeRequest) {
            CourseRequestInterface request = new CourseRequestInterface();
            request.setStudentId(student.getStudentId());
            request.setSaved(true);
            request.setAcademicSessionId(server.getAcademicSession().getUniqueId());
            request.setMaxCredit(student.getMaxCredit());
            request.setWaitListMode(wlMode);
            if (student.getMaxCreditOverride() != null) {
                request.setMaxCreditOverride(student.getMaxCreditOverride().getValue());
                request.setMaxCreditOverrideExternalId(student.getMaxCreditOverride().getExternalId());
                request.setMaxCreditOverrideTimeStamp(student.getMaxCreditOverride().getTimeStamp());
                Integer n = student.getMaxCreditOverride().getStatus();
                if (n == null) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                } else {
                    request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                }
            }
            Object var25_34 = null;
            int lastRequestPriority = -1;
            for (XRequest cd : studentRequests) {
                XEnrollment enrollment;
                Object var29_52 = null;
                if (cd instanceof XFreeTimeRequest) {
                    void var25_35;
                    Iterator<CourseRequestInterface.RequestedCourse> ftr = (XFreeTimeRequest)cd;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setStart(((XFreeTimeRequest)((Object)ftr)).getTime().getSlot());
                    ft.setLength(((XFreeTimeRequest)((Object)ftr)).getTime().getLength());
                    for (DayCode day : DayCode.toDayCodes(((XFreeTimeRequest)((Object)ftr)).getTime().getDays())) {
                        ft.addDay(day.getIndex());
                    }
                    if (var25_35 != null && lastRequestPriority == cd.getPriority() && var25_35.hasRequestedCourse() && var25_35.getRequestedCourse(0).isFreeTime()) {
                        var25_35.getRequestedCourse(0).addFreeTime(ft);
                        continue;
                    }
                    CourseRequestInterface.Request request2 = new CourseRequestInterface.Request();
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    request2.addRequestedCourse(rc);
                    rc.addFreeTime(ft);
                    if (cd.isAlternative()) {
                        request.getAlternatives().add(request2);
                    } else {
                        request.getCourses().add(request2);
                    }
                    CourseRequestInterface.Request request3 = request2;
                    lastRequestPriority = cd.getPriority();
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                    continue;
                }
                if (!(cd instanceof XCourseRequest)) continue;
                CourseRequestInterface.Request request4 = new CourseRequestInterface.Request();
                for (XCourseId courseId : ((XCourseRequest)cd).getCourseIds()) {
                    boolean isEnrolled;
                    XCourse c = server.getCourse(courseId.getCourseId());
                    if (c == null) continue;
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseId(c.getCourseId());
                    rc.setCourseName(c.getSubjectArea() + " " + c.getCourseNumber() + (c.hasUniqueName() && !CONSTANTS.showCourseTitle() ? "" : " - " + c.getTitle()));
                    rc.setCourseTitle(c.getTitle());
                    rc.setCredit(c.getMinCredit(), c.getMaxCredit());
                    boolean bl = isEnrolled = ((XCourseRequest)cd).getEnrollment() != null && c.getCourseId().equals(((XCourseRequest)cd).getEnrollment().getCourseId());
                    if (setReadOnly && isEnrolled) {
                        rc.setReadOnly(true);
                    }
                    if (isEnrolled) {
                        rc.setStatus(CourseRequestInterface.RequestedCourseStatus.ENROLLED);
                    } else {
                        Integer n = ((XCourseRequest)cd).getOverrideStatus(courseId);
                        if (n == null) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.APPROVED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.REJECTED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.CANCELLED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED);
                        } else if (n.intValue() == CourseRequest.CourseRequestOverrideStatus.NOT_NEEDED.ordinal()) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NOT_NEEDED);
                        } else {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING);
                        }
                    }
                    XOffering xOffering = server.getOffering(c.getOfferingId());
                    rc.setCanWaitList(xOffering != null && xOffering.isWaitList());
                    rc.setOverrideExternalId(((XCourseRequest)cd).getOverrideExternalId(courseId));
                    rc.setOverrideTimeStamp(((XCourseRequest)cd).getOverrideTimeStamp(courseId));
                    ((XCourseRequest)cd).fillPreferencesIn(rc, courseId);
                    request4.addRequestedCourse(rc);
                    if (!showWaitListPosition || !rc.isCanWaitList() || !((XCourseRequest)cd).isWaitlist()) continue;
                    rc.setWaitListPosition(this.getWaitListPosition(xOffering, student, (XCourseRequest)cd, courseId, server, helper));
                }
                request4.setWaitList(((XCourseRequest)cd).isWaitlist(wlMode));
                request4.setNoSub(((XCourseRequest)cd).isNoSub(wlMode));
                request4.setCritical(((XCourseRequest)cd).getCritical());
                request4.setTimeStamp(((XCourseRequest)cd).getTimeStamp());
                if (request4.isWaitList()) {
                    request4.setWaitListedTimeStamp(((XCourseRequest)cd).getWaitListedTimeStamp());
                }
                request4.setWaitListSwapWithCourseOfferingId(((XCourseRequest)cd).getWaitListSwapWithCourseOffering() == null ? null : ((XCourseRequest)cd).getWaitListSwapWithCourseOffering().getCourseId());
                if (request4.hasRequestedCourse()) {
                    if (cd.isAlternative()) {
                        request.getAlternatives().add(request4);
                    } else {
                        request.getCourses().add(request4);
                    }
                }
                CourseRequestInterface.Request request5 = request4;
                lastRequestPriority = cd.getPriority();
                if (!request4.isWaitList()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    Set overlaps = wlOverlaps == null || rc.getCourseId() == null ? null : (Set)wlOverlaps.get(rc.getCourseId());
                    if (overlaps == null || overlaps.isEmpty()) continue;
                    String message = null;
                    Iterator i = overlaps.iterator();
                    while (i.hasNext()) {
                        String string = (String)i.next();
                        if (message == null) {
                            message = MSG.conflictWithFirst(string);
                            continue;
                        }
                        if (i.hasNext()) {
                            message = message + MSG.conflictWithMiddle(string);
                            continue;
                        }
                        message = message + MSG.conflictWithLast(string);
                    }
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-OVERLAP", message + ".", 0);
                }
                if (!request4.isWaitList() || request4.getWaitListSwapWithCourseOfferingId() == null || !request4.hasRequestedCourse() || (enrollment = ((XCourseRequest)cd).getEnrollment()) == null || !enrollment.getCourseId().equals(request4.getWaitListSwapWithCourseOfferingId())) continue;
                boolean before = true;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    if (request4.getWaitListSwapWithCourseOfferingId().equals(rc.getCourseId())) {
                        if (((XCourseRequest)cd).isRequired(enrollment, server.getOffering(enrollment.getOfferingId()))) {
                            rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListRequirementsMet(), 0);
                        }
                        before = false;
                        continue;
                    }
                    if (before) continue;
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.WAITLIST_INACTIVE);
                    request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "WL-INACTIVE", MSG.waitListLowPriority(), 0);
                }
            }
            ret.setRequest(request);
        }
        return ret;
    }

    @Override
    public String name() {
        return "get-assignment";
    }

    public static boolean isFreeTimeOverlapping(FreeTimeRequest r, Enrollment e) {
        if (r.isAlternative() || r.getPriority() >= e.getRequest().getPriority()) {
            return false;
        }
        if (r.getTime() == null) {
            return false;
        }
        for (SctAssignment assignment : e.getAssignments()) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null) continue;
            if (assignment instanceof FreeTimeRequest) {
                return false;
            }
            if (!r.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    public static class CourseSection {
        XCourse iCourse;
        XSection iSection;

        CourseSection(XCourse course, XSection section) {
            this.iCourse = course;
            this.iSection = section;
        }

        public XCourse getCourse() {
            return this.iCourse;
        }

        public XSection getSection() {
            return this.iSection;
        }
    }
}

