/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class CheckEligibility
implements OnlineSectioningAction<OnlineSectioningInterface.EligibilityCheck> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Long iStudentId;
    protected OnlineSectioningInterface.EligibilityCheck iCheck;
    protected boolean iCustomCheck = true;
    protected Boolean iPermissionCanEnroll;
    protected Boolean iPermissionCanRequirePreferences;

    public CheckEligibility forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public CheckEligibility withCheck(OnlineSectioningInterface.EligibilityCheck check) {
        this.iCheck = check;
        return this;
    }

    public CheckEligibility includeCustomCheck(boolean customCheck) {
        this.iCustomCheck = customCheck;
        return this;
    }

    public CheckEligibility withPermission(boolean canEnroll, boolean canRequire) {
        this.iPermissionCanEnroll = canEnroll;
        this.iPermissionCanRequirePreferences = canRequire;
        return this;
    }

    protected void logCheck(OnlineSectioningLog.Action.Builder action, OnlineSectioningInterface.EligibilityCheck check) {
        for (OnlineSectioningInterface.EligibilityCheck.EligibilityFlag f : OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.values()) {
            if (!check.hasFlag(f)) continue;
            action.addOptionBuilder().setKey(f.name().replace('_', ' ')).setValue("true");
        }
        if (check.hasMessage()) {
            action.addMessageBuilder().setText(check.getMessage()).setLevel(OnlineSectioningLog.Message.Level.WARN);
        }
        if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
        } else {
            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OnlineSectioningInterface.EligibilityCheck execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iCheck == null) {
            this.iCheck = new OnlineSectioningInterface.EligibilityCheck();
        }
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        OnlineSectioningServer.Lock lock = this.iStudentId == null || server.getStudent(this.iStudentId) == null ? null : server.lockStudent(this.iStudentId, null, this.name());
        try {
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, true);
            if (this.iStudentId != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.iStudentId));
            }
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, server.getAcademicSession().isSectioningEnabled() && CustomStudentEnrollmentHolder.isAllowWaitListing());
            XStudent xstudent = null;
            try (Session hibSession = StudentDAO.getInstance().createNewSession();){
                StudentSectioningStatus s;
                boolean disabled;
                Student student;
                Student student2 = student = this.iStudentId == null ? null : (Student)StudentDAO.getInstance().get(this.iStudentId, hibSession);
                if (student == null) {
                    if (!this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) && !this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) && !this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_GUEST) && server.getAcademicSession().isSectioningEnabled()) {
                        this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                        if (CustomStudentEnrollmentHolder.hasProvider() && CustomStudentEnrollmentHolder.getProvider().isCanRequestUpdates()) {
                            hibSession.close();
                            hibSession = null;
                            CustomStudentEnrollmentHolder.getProvider().checkEligibility(server, helper, this.iCheck, new XStudent(null, helper.getUser().getExternalId(), helper.getUser().getName()));
                        }
                    }
                    this.logCheck(action, this.iCheck);
                    action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                    OnlineSectioningInterface.EligibilityCheck eligibilityCheck = this.iCheck;
                    return eligibilityCheck;
                }
                if (this.iStudentId != null) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.HAS_ADVISOR_REQUESTS, student.getAdvisorCourseRequests() != null && !student.getAdvisorCourseRequests().isEmpty());
                }
                this.iCheck.setMaxCredit(student.getMaxCredit());
                action.getStudentBuilder().setExternalId(student.getExternalUniqueId());
                action.getStudentBuilder().setName(helper.getStudentNameFormat().format(student));
                StudentSectioningStatus status = student.getEffectiveStatus();
                boolean bl = disabled = status != null && !status.hasOption(StudentSectioningStatus.Option.enabled);
                if (disabled && status != null && status.hasOption(StudentSectioningStatus.Option.admin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                    disabled = false;
                }
                if (disabled && status != null && status.hasOption(StudentSectioningStatus.Option.advisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                    disabled = false;
                }
                boolean noenrl = false;
                if (this.iPermissionCanEnroll != null) {
                    noenrl = this.iPermissionCanEnroll == false;
                } else {
                    boolean bl2 = noenrl = status != null && !status.hasOption(StudentSectioningStatus.Option.enrollment);
                    if (noenrl && status.hasOption(StudentSectioningStatus.Option.admin) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN)) {
                        noenrl = false;
                    }
                    if (noenrl && status.hasOption(StudentSectioningStatus.Option.advisor) && this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR)) {
                        noenrl = false;
                    }
                }
                if (status != null && !status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST, false);
                }
                if (status == null || status.hasOption(StudentSectioningStatus.Option.nosubs)) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_NO_SUBS, true);
                }
                if (this.iPermissionCanRequirePreferences != null) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.iPermissionCanRequirePreferences);
                } else {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE, this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADMIN) || this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.IS_ADVISOR) || status == null || status.hasOption(StudentSectioningStatus.Option.canreq));
                }
                if (disabled) {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT, false);
                }
                if (server.getAcademicSession().isSectioningEnabled()) {
                    if (!noenrl) {
                        this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, true);
                    }
                } else {
                    this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                }
                if ((s = StudentSectioningStatus.getPresentStatus(student.getSectioningStatus() != null ? student.getSectioningStatus() : student.getSession().getDefaultSectioningStatus())) != null && s.getMessage() != null) {
                    this.iCheck.setMessage(s.getMessage());
                } else if (status != null && status.getMessage() != null) {
                    this.iCheck.setMessage(status.getMessage());
                } else if (disabled) {
                    this.iCheck.setMessage(MSG.exceptionAccessDisabled());
                } else if (noenrl) {
                    this.iCheck.setMessage(MSG.exceptionEnrollmentDisabled());
                }
                if (ApplicationProperty.StudentStatusEffectivePeriodMessage.isTrue()) {
                    String effectivePeriod;
                    String string = s != null ? s.getEffectivePeriod() : (effectivePeriod = status != null ? status.getEffectivePeriod() : null);
                    if (effectivePeriod != null) {
                        this.iCheck.setMessage((this.iCheck.hasMessage() ? this.iCheck.getMessage() + "\n" : "") + MSG.messageTimeWindow(effectivePeriod));
                    }
                }
                xstudent = server.getStudent(this.iStudentId);
            }
            if (xstudent == null && this.iStudentId != null) {
                server.createAction(ReloadStudent.class).forStudents(this.iStudentId).execute(server, helper);
                xstudent = server.getStudent(this.iStudentId);
            }
            if (xstudent == null) {
                if (!this.iCheck.hasMessage()) {
                    this.iCheck.setMessage(MSG.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
                }
                this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
            } else if (this.iCustomCheck) {
                WaitListValidationProvider wp;
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    CustomStudentEnrollmentHolder.getProvider().checkEligibility(server, helper, this.iCheck, xstudent);
                }
                if (CustomSpecialRegistrationHolder.hasProvider()) {
                    CustomSpecialRegistrationHolder.getProvider().checkEligibility(server, helper, this.iCheck, xstudent);
                }
                if (this.iCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST) && (wp = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider()) != null) {
                    wp.checkEligibility(server, helper, this.iCheck, xstudent);
                }
            }
            if (xstudent != null) {
                this.iCheck.setAdvisorWaitListedCourseIds(xstudent.getAdvisorWaitListedCourseIds(server));
            }
            this.logCheck(action, this.iCheck);
            OnlineSectioningInterface.EligibilityCheck eligibilityCheck = this.iCheck;
            return eligibilityCheck;
        }
        catch (SectioningException e) {
            this.iCheck.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
            this.iCheck.setMessage(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
            helper.info(MSG.exceptionFailedEligibilityCheck(e.getMessage()));
            this.logCheck(action, this.iCheck);
            action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            OnlineSectioningInterface.EligibilityCheck eligibilityCheck = this.iCheck;
            return eligibilityCheck;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    @Override
    public String name() {
        return "eligibility";
    }
}

